/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.file.imageio;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.file.imageio.ImageIOFileSystemServerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProviderFactory;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderFactory;

public class ImageIOFileSystemServerProviderFactory
extends AbstractFilesystemServerExplorerProviderFactory {
    protected String[] fileExtensions;
    protected boolean canCreate;

    public ImageIOFileSystemServerProviderFactory(String name, String description, String[] fileExtensions) {
        this(name, description, fileExtensions, false);
    }

    public ImageIOFileSystemServerProviderFactory(String name, String description, String[] fileExtensions, boolean canCreate) {
        super(name, description);
        this.fileExtensions = fileExtensions;
        this.canCreate = canCreate;
    }

    public FilesystemServerExplorerProvider createProvider() {
        return new ImageIOFileSystemServerProvider((FilesystemServerExplorerProviderFactory)this, this.getName(), this.getDescription(), this.fileExtensions, this.canCreate);
    }

    public boolean accept(File pathname) {
        return FilenameUtils.isExtension((String)pathname.getName().toLowerCase(), (String[])this.fileExtensions);
    }

    public int getMode() {
        return 4;
    }

    public boolean isHidden() {
        return DALLocator.getDataManager().isTheOldRasterRegistered();
    }
}

