/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.point;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class PointEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingProviderServices editingProviderServices = this.getProviderServices();
    private final EditingServiceParameter point;
    private Point valuePoint;
    private final FeatureStore featureStore;

    public PointEditingProvider(ProviderServices services, DynObject parameters) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.point = new DefaultEditingServiceParameter("insert_point", "indicate_new_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
    }

    public DefaultDrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        this.valuePoint = null;
    }

    private boolean isValidValue(EditingServiceParameter param, Object value) {
        return value instanceof Point;
    }

    public EditingServiceParameter next() {
        if (this.valuePoint == null) {
            return this.point;
        }
        return null;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.point);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (!this.isValidValue(parameter, value)) {
            throw new InvalidEntryException(null);
        }
        this.valuePoint = (Point)value;
    }

    public void finishAndStore() throws FinishServiceException {
        try {
            Geometry geometry = this.finish();
            this.editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
        }
        catch (Exception e) {
            throw new FinishServiceException("Can't finalize " + this.getName() + "with X=" + this.valuePoint.getX() + " Y= " + this.valuePoint.getY(), (Throwable)e);
        }
    }

    public void start() throws StartServiceException {
        this.valuePoint = null;
    }

    public String getName() {
        return "insert-point";
    }

    public Geometry finish() throws FinishServiceException {
        Point geometry = null;
        try {
            int subtype = this.editingProviderServices.getSubType(this.featureStore);
            GeometryType geomType = this.editingProviderServices.getGeomType(this.featureStore);
            geometry = this.editingProviderServices.createPoint(this.valuePoint.getX(), this.valuePoint.getY(), subtype);
            if (geomType.isTypeOf(7)) {
                MultiPoint multiPoint = GeometryLocator.getGeometryManager().createMultiPoint(subtype);
                multiPoint.addPoint(geometry);
                return multiPoint;
            }
        }
        catch (Exception e) {
            throw new FinishServiceException("Can't finalize " + this.getName() + "with X=" + this.valuePoint.getX() + " Y= " + this.valuePoint.getY(), (Throwable)e);
        }
        return geometry;
    }

    public Object getValue(EditingServiceParameter parameter) {
        if (parameter == this.point) {
            return this.valuePoint;
        }
        return null;
    }
}

