/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.gml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestXML {
    private static final String XMLFILE1 = "/home/jjdelcerro/datos/geodata/vector/sigpac/2018/Declaracion.xml";
    private static final String XMLFILE2 = "/home/jjdelcerro/datos/geodata/vector/ARENA2/quincenas-0/TV_03_2019_01_Q1/victimas.xml";
    private static final String XMLFILE_BIG = "/home/jjdelcerro/datos/geodata/vector/RSUPAC/2020/BDA_RSU_PAC20_1713052020_001.XML";

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Exception {
        String tableName;
        TestXML t = new TestXML();
        ArrayList<String> tags = new ArrayList<String>(t.extractTags(XMLFILE_BIG));
        Collections.sort(tags);
        LinkedHashMap tables = new LinkedHashMap();
        LinkedHashMap tables_tmp = new LinkedHashMap();
        Iterator iterator = tags.iterator();
        while (iterator.hasNext()) {
            String string;
            String tableName2 = string = (String)iterator.next();
            HashSet<String> fields = new HashSet<String>();
            for (String tag2 : tags) {
                String fieldName;
                if (tableName2.equals(tag2) || !tag2.startsWith(tableName2) || (fieldName = tag2.substring(tableName2.length() + 1)).contains("/")) continue;
                fields.add(fieldName);
            }
            if (fields.isEmpty()) continue;
            tables_tmp.put(tableName2, fields);
        }
        HashMap<String, String> tableNames = new HashMap<String, String>();
        for (Map.Entry entry : tables_tmp.entrySet()) {
            String fullTableName = (String)entry.getKey();
            tableName = FilenameUtils.getBaseName((String)fullTableName);
            tableNames.put(fullTableName, tableName);
        }
        for (Map.Entry entry : tables_tmp.entrySet()) {
            String tableName3 = (String)entry.getKey();
            ArrayList<String> fields = new ArrayList<String>();
            String[] fieldkeys = tableName3.split("/");
            for (int i = 0; i < fieldkeys.length; ++i) {
                String fieldkey = fieldkeys[i];
                if (i == fieldkeys.length - 1) {
                    fields.add("$ID_" + fieldkey + ", PK");
                    continue;
                }
                fields.add("$ID_" + fieldkey + ", FK");
            }
            for (String fieldName : (Set)entry.getValue()) {
                if (tables_tmp.containsKey(tableName3 + "/" + fieldName)) {
                    fields.add("$ID_" + fieldName + " FK");
                    continue;
                }
                fields.add(fieldName);
            }
            Collections.sort(fields);
            tables.put(tableName3, fields);
        }
        boolean bl = true;
        for (Map.Entry entry : tables.entrySet()) {
            void var6_10;
            tableName = (String)entry.getKey();
            List fields = (List)entry.getValue();
            System.out.println("TABLE " + (String)tableNames.get(tableName) + " (" + (int)var6_10 + ", " + tableName + ")");
            for (String field : fields) {
                System.out.println("    " + field);
            }
            ++var6_10;
        }
    }

    private Reader openFileReader(File xmlfile) throws Exception {
        FileInputStream fis = new FileInputStream(xmlfile);
        Charset encoding = StandardCharsets.UTF_8;
        InputStreamReader reader = new InputStreamReader((InputStream)fis, encoding);
        return reader;
    }

    private Set<String> extractTags(String xmlfile) throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        Reader reader = this.openFileReader(new File(xmlfile));
        InputSource is = new InputSource(reader);
        final ArrayList path = new ArrayList();
        final LinkedHashSet<String> tags = new LinkedHashSet<String>();
        saxParser.parse(is, new DefaultHandler(){
            private Locator locator;

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                path.add(localName);
                int line = this.locator.getLineNumber();
                int column = this.locator.getColumnNumber() - 2 - localName.length();
                String path_s = StringUtils.join((Iterable)path, (String)"/");
                tags.add(path_s);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getLocalName(i);
                    tags.add(path_s + "/#" + name);
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                path.remove(path.size() - 1);
            }
        });
        return tags;
    }

    private List<List<String>> getRecords1(String xmlfile, final String recordPath, final List<String> fieldPaths) throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        Reader reader = this.openFileReader(new File(xmlfile));
        InputSource is = new InputSource(reader);
        class ParseRecordsHandler
        extends DefaultHandler {
            Locator locator;
            List<String> path = new ArrayList<String>();
            List<List<String>> records = new ArrayList<List<String>>();
            Map<String, String> record = new HashMap<String, String>();
            StringBuilder value = new StringBuilder();

            ParseRecordsHandler() {
            }

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.path.add(localName);
                int line = this.locator.getLineNumber();
                int column = this.locator.getColumnNumber() - 2 - localName.length();
                String path_s = StringUtils.join(this.path, (String)"/");
                if (StringUtils.equalsIgnoreCase((CharSequence)path_s, (CharSequence)recordPath)) {
                    return;
                }
                this.value.setLength(0);
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                this.value.append(new String(ch, start, length));
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                int line = this.locator.getLineNumber();
                int column = this.locator.getColumnNumber() - 2 - localName.length();
                String path_s = StringUtils.join(this.path, (String)"/");
                if (StringUtils.equalsIgnoreCase((CharSequence)path_s, (CharSequence)recordPath)) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String fieldPath : fieldPaths) {
                        values.add(this.record.get(fieldPath));
                    }
                    this.records.add(values);
                    this.record.clear();
                } else {
                    for (String fieldPath : fieldPaths) {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)path_s, (CharSequence)fieldPath)) continue;
                        this.record.put(fieldPath, this.value.toString());
                    }
                }
                this.path.remove(this.path.size() - 1);
            }
        }
        ParseRecordsHandler handler = new ParseRecordsHandler();
        System.out.println("Parse (getRecords): -------------------------");
        saxParser.parse(is, (DefaultHandler)handler);
        return handler.records;
    }

    private long getRecordCount(String xmlfile, final String recordPath) throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        Reader reader = this.openFileReader(new File(xmlfile));
        InputSource is = new InputSource(reader);
        final ArrayList path = new ArrayList();
        final MutableLong numRecords = new MutableLong(0L);
        System.out.println("Parse (countRecords)");
        saxParser.parse(is, new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                path.add(localName);
                String path_s = StringUtils.join((Iterable)path, (String)"/");
                if (StringUtils.equalsIgnoreCase((CharSequence)path_s, (CharSequence)recordPath)) {
                    numRecords.increment();
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                path.remove(path.size() - 1);
            }
        });
        return numRecords.longValue();
    }

    private void test() {
    }
}

