/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.gml.virtualrows;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldReader;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.store.gml.virtualrows.GfsFile;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderUtils;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.LimitedReader;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileReader;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RecordsFile;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RecordsFileImpl;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.UserCancelTaskException;
import org.gvsig.tools.util.GetItemWithSize64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLFileAsList
extends AbstractList<List<String>>
implements Closeable,
GetItemWithSize64<List<String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLFileAsList.class);
    public static final int COMBINE_NONE = 0;
    public static final int COMBINE_FIRST_NOT_NULL = 1;
    private static final int IDXFIELD_BEGINLINE = 0;
    private static final int IDXFIELD_BEGINCOLUMN = 1;
    private static final int IDXFIELD_BEGINRECORDPOS = 2;
    private static final int IDXFIELD_ENDLINE = 3;
    private static final int IDXFIELD_ENDCOLUMN = 4;
    private static final int IDXFIELD_BEGINGEOMLINE = 5;
    private static final int IDXFIELD_BEGINGEOMCOLUMN = 6;
    private static final int IDXFIELD_BEGINGEOMPOS = 7;
    private static final int IDXFIELD_ENDGEOMLINE = 8;
    private static final int IDXFIELD_ENDGEOMCOLUMN = 9;
    private static final int IDXFIELD_ENDGEOMPOS = 10;
    private final RandomAccessFileReader reader;
    private final String recordPath;
    private RecordsFile index;
    private List<String> fieldPaths;
    private final List<String> geomPaths;
    private int combineMode;
    private long lastModified;

    public XMLFileAsList(File text, Charset charset, String recordPath, List<String> geomPath, List<String> fieldPaths) throws IOException {
        this.reader = new RandomAccessFileReader(text, charset);
        this.index = null;
        this.recordPath = recordPath;
        this.geomPaths = geomPath;
        this.fieldPaths = fieldPaths;
        this.lastModified = text.lastModified();
    }

    public XMLFileAsList(RandomAccessFileReader reader, RecordsFile index, String recordPath, List<String> geomPath, List<String> fieldPaths) throws IOException {
        this.reader = reader;
        this.index = index;
        this.recordPath = recordPath;
        this.geomPaths = geomPath;
        this.fieldPaths = fieldPaths;
        this.lastModified = -1L;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Reader)this.reader);
        IOUtils.closeQuietly((Closeable)this.index);
    }

    private synchronized List<String> getRecord(long position, final List<String> fieldPaths) {
        class ParseRecordsHandler
        extends DefaultHandler {
            Locator locator;
            List<String> path = new ArrayList<String>();
            Map<String, String> record = new HashMap<String, String>();
            StringBuilder value = new StringBuilder();
            List<String> values = new ArrayList<String>();
            private int endLineNumber;
            private int endColumnNumber;

            ParseRecordsHandler() {
            }

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                localName = this.removeNamespace(qName);
                this.path.add(localName);
                String path_s = StringUtils.join(this.path, (String)"/");
                if (StringUtils.equalsIgnoreCase((CharSequence)path_s, (CharSequence)XMLFileAsList.this.recordPath)) {
                    return;
                }
                this.value.setLength(0);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attrPath = path_s + "/" + this.removeNamespace(attributes.getQName(i));
                    for (String fieldPath : fieldPaths) {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)attrPath, (CharSequence)fieldPath)) continue;
                        this.record.put(fieldPath, attributes.getValue(i));
                    }
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                this.value.append(new String(ch, start, length));
            }

            private String removeNamespace(String s) {
                if (s.indexOf(58) < 0) {
                    return s;
                }
                String[] ss = s.split(":");
                return ss[1];
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                localName = this.removeNamespace(qName);
                String path_s = StringUtils.join(this.path, (String)"/");
                for (String fieldPath : fieldPaths) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)path_s, (CharSequence)fieldPath)) continue;
                    this.record.put(fieldPath, this.value.toString());
                }
                if (this.locator.getLineNumber() >= this.endLineNumber && this.locator.getColumnNumber() >= this.endColumnNumber) {
                    for (String fieldPath : fieldPaths) {
                        this.values.add(this.record.get(fieldPath));
                    }
                    class StopParserSAXException
                    extends SAXException {
                        StopParserSAXException() {
                        }
                    }
                    throw new StopParserSAXException();
                }
                this.path.remove(this.path.size() - 1);
            }
        }
        ParseRecordsHandler handler;
        block13: {
            handler = null;
            RecordsFile.Record record = (RecordsFile.Record)this.index.get64(position);
            int recordLine = record.getInt(0);
            int recordColumn = record.getInt(1);
            long recordPosition = record.getLong(2);
            try {
                this.reader.seek(recordPosition);
                int bufferSize = 8192;
                BufferedReader breader = new BufferedReader((Reader)this.reader, bufferSize);
                InputSource is = new InputSource((Reader)CloseShieldReader.wrap((Reader)breader));
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(false);
                SAXParser saxParser = spf.newSAXParser();
                handler = new ParseRecordsHandler();
                handler.endLineNumber = record.getInt(3) - record.getInt(0) + 1;
                handler.endColumnNumber = record.getInt(4);
                saxParser.parse(is, (DefaultHandler)handler);
            }
            catch (StopParserSAXException bufferSize) {
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't parse record " + position + " recordPosition " + recordPosition + " line " + recordLine + " column " + recordColumn, ex);
            }
            if (handler == null) {
                return null;
            }
            try {
                Geometry geom = null;
                if (!CollectionUtils.isNotEmpty(this.geomPaths)) break block13;
                for (int i = 0; i < this.geomPaths.size(); ++i) {
                    LimitedReader limitedReader = null;
                    BufferedReader breader = null;
                    try {
                        geom = null;
                        long geomPosition = record.getLong(7 + i * 6);
                        long endGeomPosition = record.getLong(10 + i * 6);
                        if (geomPosition == 0L || endGeomPosition == 0L) {
                            if (this.combineMode == 1) continue;
                            handler.values.add(null);
                            continue;
                        }
                        this.reader.seek(geomPosition);
                        if (position == 0L) {
                            char[] cbuff = new char[(int)(endGeomPosition - geomPosition)];
                            this.reader.read(cbuff);
                            this.reader.seek(geomPosition);
                        }
                        limitedReader = new LimitedReader((Reader)this.reader, (int)(endGeomPosition - geomPosition));
                        int bufferSize = 8192;
                        breader = new BufferedReader((Reader)limitedReader, bufferSize);
                        geom = GeometryLocator.getGeometryManager().createFrom((Reader)breader, null);
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Can't load geometry", t);
                    }
                    if (this.combineMode == 1) {
                        if (geom == null) continue;
                        handler.values.add(geom.convertToHexWKB());
                        break;
                    }
                    handler.values.add(geom == null ? null : geom.convertToHexWKB());
                }
                if (this.combineMode == 1 && geom == null) {
                    handler.values.add(null);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't parse record " + position, ex);
            }
        }
        return handler.values;
    }

    @Override
    public List<String> get(int index) {
        return this.getRecord(index, this.fieldPaths);
    }

    public List<String> get64(long position) {
        return this.getRecord(position, this.fieldPaths);
    }

    @Override
    public int size() {
        return this.index.size();
    }

    public long size64() {
        return this.index.size64();
    }

    public int getCombineMode() {
        return this.combineMode;
    }

    public void setCombineMode(int combineMode) {
        this.combineMode = combineMode;
    }

    public boolean loadIndex(File fileIndex, SimpleTaskStatus status) throws IOException {
        if (!fileIndex.exists()) {
            return false;
        }
        if (this.lastModified > 0L && SimpleReaderUtils.isFileNewer((File)fileIndex, (long)this.lastModified)) {
            this.index = new RecordsFileImpl(fileIndex);
            return true;
        }
        return false;
    }

    public final synchronized void createIndex(File indexFile, final SimpleTaskStatus status) throws IOException {
        try {
            RecordsFile.RecordTypeBuilder builder = RecordsFile.RecordTypeBuilder.recordTypeBuilder().addInteger().addInteger().addLong().addInteger().addInteger();
            if (CollectionUtils.isNotEmpty(this.geomPaths)) {
                for (int i = 0; i < this.geomPaths.size(); ++i) {
                    builder.addInteger().addInteger().addLong().addInteger().addInteger().addLong();
                }
            }
            RecordsFile.RecordType recordType = builder.build();
            final RecordsFile.Record record = recordType.createRecord();
            RecordsFileImpl theIndex = new RecordsFileImpl();
            theIndex.create(indexFile, recordType);
            this.reader.rewind();
            InputSource is = new InputSource((Reader)CloseShieldReader.wrap((Reader)this.reader));
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            if (status != null) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                status.push();
                status.message(i18n.getTranslation("_Creating_record_index"));
                status.setIndeterminate();
            }
            final ArrayList path = new ArrayList();
            saxParser.parse(is, new DefaultHandler((RecordsFile)theIndex){
                Locator locator;
                private int beginLineNumber;
                private int beginColumnNumber;
                private int lastTagLineNumber;
                private int lastTagColumnNumber;
                final /* synthetic */ RecordsFile val$theIndex;
                {
                    this.val$theIndex = recordsFile;
                }

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    int i;
                    path.add(localName);
                    String path_s = StringUtils.join((Iterable)path, (String)"/");
                    if (StringUtils.equalsIgnoreCase((CharSequence)path_s, (CharSequence)XMLFileAsList.this.recordPath)) {
                        record.setInt(0, this.locator.getLineNumber());
                        record.setInt(1, this.locator.getColumnNumber());
                        record.setInt(3, 0);
                        record.setInt(4, 0);
                        if (CollectionUtils.isNotEmpty((Collection)XMLFileAsList.this.geomPaths)) {
                            for (i = 0; i < XMLFileAsList.this.geomPaths.size(); ++i) {
                                record.setInt(5 + 6 * i, 0);
                                record.setInt(6 + 6 * i, 0);
                                record.setLong(7 + 6 * i, 0L);
                                record.setInt(8 + 6 * i, 0);
                                record.setInt(9 + 6 * i, 0);
                                record.setLong(10 + 6 * i, 0L);
                            }
                        }
                        this.beginLineNumber = this.locator.getLineNumber();
                        this.beginColumnNumber = this.locator.getColumnNumber();
                    }
                    if (CollectionUtils.isNotEmpty((Collection)XMLFileAsList.this.geomPaths)) {
                        for (i = 0; i < XMLFileAsList.this.geomPaths.size(); ++i) {
                            String geomPath = (String)XMLFileAsList.this.geomPaths.get(i);
                            if (!StringUtils.equalsIgnoreCase((CharSequence)path_s, (CharSequence)(XMLFileAsList.this.recordPath + "/" + geomPath))) continue;
                            record.setInt(5 + 6 * i, this.locator.getLineNumber());
                            record.setInt(6 + 6 * i, this.locator.getColumnNumber());
                            record.setLong(7 + 6 * i, 0L);
                            break;
                        }
                    }
                    if (status != null && status.isCancellationRequested()) {
                        throw new UserCancelTaskException();
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    String path_s = StringUtils.join((Iterable)path, (String)"/");
                    if (StringUtils.equalsIgnoreCase((CharSequence)path_s, (CharSequence)XMLFileAsList.this.recordPath)) {
                        int line = this.lastTagLineNumber;
                        int column = this.lastTagColumnNumber;
                        if (line == 0) {
                            column -= this.beginColumnNumber;
                        }
                        record.setInt(3, line);
                        record.setInt(4, column);
                        this.val$theIndex.add((Object)record);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)XMLFileAsList.this.geomPaths)) {
                        for (int i = 0; i < XMLFileAsList.this.geomPaths.size(); ++i) {
                            String geomPath = (String)XMLFileAsList.this.geomPaths.get(i);
                            if (!StringUtils.equalsIgnoreCase((CharSequence)path_s, (CharSequence)(XMLFileAsList.this.recordPath + "/" + geomPath))) continue;
                            record.setInt(8 + 6 * i, this.lastTagLineNumber);
                            record.setInt(9 + 6 * i, this.lastTagColumnNumber);
                            break;
                        }
                    }
                    this.lastTagLineNumber = this.locator.getLineNumber();
                    this.lastTagColumnNumber = this.locator.getColumnNumber();
                    path.remove(path.size() - 1);
                    if (status != null && status.isCancellationRequested()) {
                        throw new UserCancelTaskException();
                    }
                }
            });
            if (status != null) {
                status.setRangeOfValues(0L, theIndex.size64());
                status.setCurValue(0L);
            }
            this.reader.rewind();
            PositionCalculator positionCalculator = new PositionCalculator(this.reader);
            for (int j = 0; j < theIndex.size(); ++j) {
                RecordsFile.Record r = (RecordsFile.Record)theIndex.get(j);
                positionCalculator.next(r.getInt(0), r.getInt(1));
                r.setLong(2, positionCalculator.getColumnPosition());
                if (CollectionUtils.isNotEmpty(this.geomPaths)) {
                    int i;
                    class Element
                    implements Comparable<Element> {
                        final int index;
                        final long beginGeomLine;
                        final long endGeomLine;
                        final long beginGeomColumn;
                        final long endGeomColumn;
                        long beginGeomPos;
                        long endGeomPos;

                        Element(int index, long beginGeomLine, long endGeomLine, long beginGeomColumn, long endGeomColumn) {
                            this.index = index;
                            this.beginGeomLine = beginGeomLine;
                            this.endGeomLine = endGeomLine;
                            this.beginGeomColumn = beginGeomColumn;
                            this.endGeomColumn = endGeomColumn;
                        }

                        @Override
                        public int compareTo(Element o) {
                            return Long.compare(this.beginGeomLine, o.beginGeomLine);
                        }
                    }
                    Object[] elements = new Element[this.geomPaths.size()];
                    for (i = 0; i < elements.length; ++i) {
                        long beginGeomLine = r.getInt(5 + i * 6);
                        long endGeomLine = r.getInt(8 + i * 6);
                        elements[i] = new Element(i, beginGeomLine, endGeomLine, r.getInt(6 + i * 6), r.getInt(9 + i * 6));
                    }
                    Arrays.sort(elements);
                    for (i = 0; i < elements.length; ++i) {
                        Object e = elements[i];
                        if (((Element)e).beginGeomLine == 0L || ((Element)e).endGeomLine == 0L) continue;
                        positionCalculator.next(((Element)e).beginGeomLine, ((Element)e).beginGeomColumn);
                        ((Element)e).beginGeomPos = positionCalculator.getColumnPosition();
                        positionCalculator.next(((Element)e).endGeomLine, ((Element)e).endGeomColumn);
                        ((Element)e).endGeomPos = positionCalculator.getColumnPosition();
                    }
                    for (i = 0; i < elements.length; ++i) {
                        Object e = elements[i];
                        r.setLong(7 + ((Element)e).index * 6, ((Element)e).beginGeomPos);
                        r.setLong(10 + ((Element)e).index * 6, ((Element)e).endGeomPos);
                    }
                }
                theIndex.set(j, (Object)r);
                if (status == null) continue;
                if (status.isCancellationRequested()) {
                    status.cancel();
                    this.removeIndex(indexFile);
                    return;
                }
                status.incrementCurrentValue();
            }
            this.index = new RecordsFileImpl(indexFile);
            if (status != null) {
                status.terminate();
            }
        }
        catch (UserCancelTaskException ex) {
            if (status != null && status.isCancellationRequested()) {
                status.cancel();
            }
            this.removeIndex(indexFile);
            throw ex;
        }
        catch (Exception ex) {
            if (status != null) {
                status.abort();
            }
            this.removeIndex(indexFile);
            throw new IOException("Can't create index " + Objects.toString(indexFile), ex);
        }
        finally {
            if (status != null) {
                status.pop();
            }
        }
    }

    private void removeIndex(File indexFile) {
        indexFile.delete();
    }

    public static void main(String[] args) throws Exception {
        File gfsFile;
        new DefaultLibrariesInitializer().fullInitialize();
        String XMLFILE1 = "/home/fdiaz/projects/GMLS/sk/RoadArea.gml";
        String gmlfile = "/home/fdiaz/projects/GMLS/sk/RoadArea.gml";
        File idxFile = new File(FilenameUtils.removeExtension((String)gmlfile) + ".gmlidx");
        if (idxFile.exists()) {
            idxFile.delete();
        }
        if ((gfsFile = new File(FilenameUtils.removeExtension((String)gmlfile) + ".gfs")).exists()) {
            gfsFile.delete();
        }
        GfsFile gfs = new GfsFile();
        gfs.fetch(new File(gmlfile));
        gfs.save(gfsFile);
        XMLFileAsList gml = new XMLFileAsList(new File(gmlfile), StandardCharsets.UTF_8, gfs.getBaseElementPath(), gfs.getGeometryElementPaths(), gfs.getPropertiesPaths());
        gml.createIndex(new File(FilenameUtils.removeExtension((String)gmlfile) + ".gmlidx"), SimpleTaskStatus.FAKE_STATUS);
        System.out.println("File: " + gmlfile);
        for (int i = 0; i < gml.size(); ++i) {
            Object item = gml.get(i);
            System.out.println("RECORD " + i + ":" + item);
        }
        System.out.println(StringUtils.join(gfs.getPropertiesPaths(), (String)"\n"));
        System.out.println("Geometries:\n" + StringUtils.join(gfs.getGeometryElementPaths(), (String)"\n"));
    }

    private static class PositionCalculator {
        private final RandomAccessFileReader reader;
        private final BufferedReader breader;
        private long currentPosition;
        private long currentColumn;
        private long currentLine;
        private long currentColumnPosition;
        private long currentLinePosition;
        private final char[] ch;
        private final CharacterSize characterSize;

        public PositionCalculator(RandomAccessFileReader reader) {
            this.reader = reader;
            this.breader = new BufferedReader((Reader)this.reader, 8192);
            this.currentPosition = this.reader.getCurrentPosition();
            this.currentLine = 1L;
            this.currentColumn = 1L;
            this.ch = new char[1];
            this.characterSize = new CharacterSize(this.reader.getCharset());
        }

        public boolean next(long line, long column) throws IOException {
            block6: {
                char c;
                if (this.currentLine > line) {
                    throw new IOException("Illegal column number " + column + " (" + this.currentColumn + ") for line " + line + " (" + this.currentLine + ")");
                }
                if (this.currentLine == line && this.currentColumn > column) {
                    throw new IOException("Illegal column number " + column + " (" + this.currentColumn + ") for line " + line);
                }
                while (this.currentLine < line) {
                    if (this.breader.read(this.ch, 0, 1) < 1) {
                        return false;
                    }
                    c = this.ch[0];
                    this.currentPosition += (long)this.characterSize.size(c);
                    if (c != '\n') continue;
                    ++this.currentLine;
                    this.currentColumn = 1L;
                }
                this.currentLinePosition = this.currentPosition;
                do {
                    if (this.breader.read(this.ch, 0, 1) < 1) {
                        return false;
                    }
                    c = this.ch[0];
                    ++this.currentColumn;
                    this.currentPosition += (long)this.characterSize.size(c);
                    if (this.currentColumn >= column) break block6;
                } while (c != '\n');
                throw new IOException("Illegal column number " + column + " (" + this.currentColumn + ") for line " + line + " (" + this.currentLine + ")");
            }
            this.currentColumnPosition = this.currentPosition;
            return true;
        }

        public long getLinePosition() {
            return this.currentLinePosition;
        }

        public long getColumnPosition() {
            return this.currentColumnPosition;
        }
    }

    private static class CharacterSize {
        private final Charset charset;
        private final CharBuffer charBuffer;

        public CharacterSize(Charset charset) {
            this.charset = charset;
            this.charBuffer = CharBuffer.allocate(1);
        }

        public int size(char ch) {
            this.charBuffer.put(0, ch);
            this.charBuffer.position(0);
            ByteBuffer buffer = this.charset.encode(this.charBuffer);
            return buffer.limit();
        }

        public int size(char[] cbuf, int off, int len) {
            CharBuffer cb = CharBuffer.wrap(cbuf, off, len);
            ByteBuffer byteBuffer = this.charset.encode(cb);
            return byteBuffer.limit();
        }

        public int size(char[] cbuf) {
            CharBuffer cb = CharBuffer.wrap(cbuf, 0, cbuf.length);
            ByteBuffer byteBuffer = this.charset.encode(cb);
            return byteBuffer.limit();
        }

        public int size(String s) {
            CharBuffer cb = CharBuffer.wrap(s);
            ByteBuffer byteBuffer = this.charset.encode(cb);
            return byteBuffer.limit();
        }
    }
}

