/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.hyperlink.app.extension;

import java.util.Map;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.app.project.documents.view.legend.gui.ThemeManagerWindow;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayersIterator;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.hyperlink.app.extension.LinkListener;
import org.gvsig.hyperlink.app.extension.actions.ExternTxtFormat;
import org.gvsig.hyperlink.app.extension.actions.FolderFormat;
import org.gvsig.hyperlink.app.extension.actions.ImgFormat;
import org.gvsig.hyperlink.app.extension.actions.PdfFormat;
import org.gvsig.hyperlink.app.extension.actions.SvgFormat;
import org.gvsig.hyperlink.app.extension.actions.TxtFormat;
import org.gvsig.hyperlink.app.extension.config.LayerLinkConfig;
import org.gvsig.hyperlink.app.extension.config.LinkConfig;
import org.gvsig.hyperlink.app.extension.config.gui.ConfigTab;
import org.gvsig.hyperlink.app.extension.layers.ManagerRegistry;
import org.gvsig.hyperlink.app.extension.layers.VectLayerManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.library.LibraryException;
import org.gvsig.tools.util.Callable;
import org.gvsig.tools.util.impl.DefaultCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperlinkExtension
extends Extension {
    private static final Logger LOG = LoggerFactory.getLogger(HyperlinkExtension.class);
    ManagerRegistry layerManager;
    public static final String LAYERPROPERTYNAME = "org.gvsig.hyperlink.config";
    public static final String TOOLNAME = "org.gvsig.hyperlink.tool";
    public static final String ACTIONSEXTENSIONPOINT = "HyperLinkAction";
    private static final int LEGACY_IMAGE_TYPE = 0;
    private static final int LEGACY_HTML_TYPE = 1;
    private static final int LEGACY_PDF_TYPE = 2;
    private static final int LEGACY_SVG_TYPE = 3;

    public void execute(String s) {
        IView view = (IView)PluginServices.getMDIManager().getActiveWindow();
        MapControl mapCtrl = view.getMapControl();
        LOG.debug("Comand : " + s);
        if (s.compareTo("view-show-hyperlink") == 0) {
            this.initTool(view);
            mapCtrl.setTool(TOOLNAME);
        }
    }

    public void initTool(IView view) {
        MapControl mapCtrl = view.getMapControl();
        if (view.getMapControl().getNamesMapTools().get(TOOLNAME) == null) {
            mapCtrl.addBehavior(TOOLNAME, (Behavior)new PointBehavior((PointListener)new LinkListener(mapCtrl, this.layerManager)));
            this.loadLegacyConfig(view);
        }
    }

    public void loadLegacyConfig(IView view) {
        LayersIterator iterator = new LayersIterator((FLayer)view.getMapControl().getMapContext().getLayers());
        while (iterator.hasNext()) {
            FLayer layer = iterator.nextLayer();
            this.loadLegacyConfig(layer);
        }
    }

    public LayerLinkConfig loadLegacyConfig(FLayer layer) {
        LayerLinkConfig layerConfig = (LayerLinkConfig)layer.getProperty((Object)LAYERPROPERTYNAME);
        if (layerConfig != null) {
            return layerConfig;
        }
        Object fName = layer.getProperty((Object)"legacy.hyperlink.selectedField");
        if (fName != null && fName instanceof String) {
            Map properties = layer.getExtendedProperties();
            properties.remove("legacy.hyperlink.selectedField");
            String fieldName = (String)fName;
            Object extObj = layer.getProperty((Object)"legacy.hyperlink.extension");
            String extension = null;
            if (extObj != null && extObj instanceof String) {
                properties.remove("legacy.hyperlink.extension");
                extension = (String)extObj;
            }
            Object typeObj = layer.getProperty((Object)"legacy.hyperlink.type");
            int type = -1;
            if (typeObj != null && typeObj instanceof Integer) {
                properties.remove("legacy.hyperlink.type");
                type = (Integer)typeObj;
            }
            LayerLinkConfig config = new LayerLinkConfig();
            config.setEnabled(true);
            config.addLink(this.getLegacyActionCode(type), fieldName, extension);
            layer.setProperty((Object)LAYERPROPERTYNAME, (Object)config);
            return config;
        }
        return null;
    }

    private String getLegacyActionCode(int type) {
        switch (type) {
            case 0: {
                return "Image_format";
            }
            case 2: {
                return "PDF_format";
            }
            case 3: {
                return "SVG_format";
            }
        }
        return "Txt_format";
    }

    public boolean isVisible() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null) {
            return false;
        }
        if (f instanceof IView) {
            MapContext mapa = ((IView)f).getViewDocument().getMapContext();
            return mapa.getLayers().getLayersCount() > 0;
        }
        return false;
    }

    public boolean isEnabled() {
        IView view;
        ViewDocument viewDocument;
        IWindow window = PluginServices.getMDIManager().getActiveWindow();
        if (window == null) {
            return false;
        }
        if (window instanceof IView && (viewDocument = (view = (IView)window).getViewDocument()) != null && viewDocument.getMapContext() != null && viewDocument.getMapContext().getLayers().getVisibles().length > 0) {
            FLayers lyrs = viewDocument.getMapContext().getLayers();
            FLayer[] lyrsSelected = lyrs.getActives();
            for (int i = 0; i < lyrsSelected.length; ++i) {
                Object obj = lyrsSelected[i].getProperty((Object)LAYERPROPERTYNAME);
                if (obj == null) continue;
                return true;
            }
        }
        return false;
    }

    public void postInitialize() {
        DefaultCaller caller = new DefaultCaller();
        caller.add((Callable)new LinkConfig.RegisterPersistence());
        caller.add((Callable)new LayerLinkConfig.RegisterPersistence());
        if (!caller.call()) {
            throw new LibraryException(HyperlinkExtension.class, caller.getExceptions());
        }
        this.registerLayers();
        this.registerActions();
        this.registerConfigPanel();
    }

    private void registerLayers() {
        this.layerManager = new ManagerRegistry();
        this.layerManager.put(FLyrVect.class, VectLayerManager.class);
    }

    public ManagerRegistry getLayerManager() {
        return this.layerManager;
    }

    private void registerActions() {
        ExtensionPointManager epm = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = epm.add(ACTIONSEXTENSIONPOINT, "Registers Actions that are able to manage specific format types.");
        ep.append("Txt_format", "", TxtFormat.class);
        ep.append("TxtExtern_format", "", ExternTxtFormat.class);
        ep.append("Image_format", "", ImgFormat.class);
        ep.append("PDF_format", "", PdfFormat.class);
        ep.append("SVG_format", "", SvgFormat.class);
        ep.append("Folder_format", "", FolderFormat.class);
    }

    private void registerConfigPanel() {
        ThemeManagerWindow.addPage(ConfigTab.class);
        ThemeManagerWindow.setTabEnabledForLayer(ConfigTab.class, FLyrVect.class, (boolean)true);
    }

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"view-show-hyperlink", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-view-show-hyperlink", (Object)((Object)this));
    }
}

