/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.hyperlink.app.extension.actions;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.gvsig.hyperlink.app.extension.AbstractActionManager;
import org.gvsig.hyperlink.app.extension.LinkTarget;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFLocator;
import org.gvsig.pdf.swing.api.PDFSwingLocator;
import org.gvsig.pdf.swing.api.PDFViewer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class PdfFormat
extends AbstractActionManager
implements Serializable {
    public static final String ACTION_CODE = "PDF_format";

    public PdfFormat() {
        super(ACTION_CODE, ACTION_CODE, "Shows_PDF_files_in_gvSIG");
    }

    @Override
    public void showDocument(LinkTarget document) {
        try {
            PDFDocument pdfdoc = PDFLocator.getPDFManager().createPDFDocument();
            String title = "PDF";
            if (document.getURL() != null) {
                title = document.getURL().toString();
                pdfdoc.setSource((Object)document.getURL());
            } else if (document.getFromProfile() != null) {
                try {
                    Object profileContent = document.getFromProfile();
                    if (!(profileContent instanceof PDFDocument)) {
                        LOGGER.warn("Not able to convert content from field into pdf");
                    }
                    pdfdoc = (PDFDocument)profileContent;
                }
                catch (Exception ex) {
                    LOGGER.warn("Not able to get PDF from document");
                }
            }
            PDFViewer viewer = PDFSwingLocator.getPDFSwingManager().createPDFViewer();
            viewer.put(pdfdoc);
            ToolsSwingUtils.ensureRowsCols((JComponent)viewer.asJComponent(), (int)20, (int)100, (int)40, (int)150);
            WindowManager windowManager = ToolsSwingLocator.getWindowManager();
            windowManager.showWindow(viewer.asJComponent(), "Hyperlink: " + title, WindowManager.MODE.WINDOW);
        }
        catch (IOException ex) {
            Logger.getLogger(PdfFormat.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

