/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.hyperlink.app.extension.actions;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.hyperlink.app.extension.AbstractHyperLinkPanel;
import org.gvsig.hyperlink.app.extension.LinkTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SvgPanel
extends AbstractHyperLinkPanel {
    private static final long serialVersionUID = -5200841105188251551L;
    private GVTBuilder gvtBuilder = new GVTBuilder();
    private GraphicsNode gvtRoot = null;
    private BridgeContext ctx = null;
    private StaticRenderer renderer = new StaticRenderer();
    private Element elt;
    protected static RenderingHints defaultRenderingHints = new RenderingHints(null);

    public SvgPanel(LinkTarget doc) {
        super(doc);
        this.initialize();
    }

    void initialize() {
        this.setLayout(new BorderLayout());
        this.showDocument();
    }

    protected void showDocument() {
        if (!this.checkAndNormalizeURI()) {
            return;
        }
        ImageIcon image = new ImageIcon(this.getSvgAsImage(this.document.getURL()));
        if (image == null) {
            // empty if block
        }
        this.setPreferredSize(new Dimension(image.getIconWidth(), image.getIconHeight()));
        this.setSize(new Dimension(image.getIconWidth(), image.getIconHeight()));
        JLabel label = new JLabel(image);
        this.add(label);
    }

    private Image getSvgAsImage(URL url) {
        BufferedImage img = new BufferedImage(400, 400, 2);
        Graphics2D g = img.createGraphics();
        Rectangle2D.Double rect = new Rectangle2D.Double();
        rect.setFrame(0.0, 0.0, 400.0, 400.0);
        this.obtainStaticRenderer(url);
        this.drawSVG(g, rect, null);
        return img;
    }

    private void obtainStaticRenderer(URL url) {
        try {
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            this.ctx = new BridgeContext((UserAgent)userAgent, loader);
            Document svgDoc = loader.loadDocument(url.toString());
            this.gvtRoot = this.gvtBuilder.build(this.ctx, svgDoc);
            this.renderer.setTree(this.gvtRoot);
            this.elt = ((SVGDocument)svgDoc).getRootElement();
        }
        catch (Exception ex) {
            NotificationManager.addWarning((String)PluginServices.getText((Object)this, (String)"Hyperlink_linked_field_doesnot_exist"), (Throwable)ex);
        }
    }

    private void drawSVG(Graphics2D g, Rectangle2D rect, Rectangle2D rv) {
        AffineTransform ataux;
        if (rv == null || rv.contains(rect)) {
            ataux = new AffineTransform();
            ataux.translate(rect.getX(), rect.getY());
            try {
                ataux.concatenate(ViewBox.getViewTransform(null, (Element)this.elt, (float)((float)rect.getWidth()), (float)((float)rect.getHeight()), (BridgeContext)this.ctx));
                this.gvtRoot.setTransform(ataux);
            }
            catch (Exception exception) {}
        } else {
            ataux = new AffineTransform();
            ataux.translate(rect.getX(), rect.getY());
            ataux.concatenate(ViewBox.getViewTransform(null, (Element)this.elt, (float)((float)rect.getWidth()), (float)((float)rect.getHeight()), (BridgeContext)this.ctx));
            this.gvtRoot.setTransform(ataux);
        }
        RenderingHints renderingHints = defaultRenderingHints;
        g.setRenderingHints(renderingHints);
        if (this.gvtRoot != null) {
            this.gvtRoot.paint(g);
        }
    }

    static {
        defaultRenderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        defaultRenderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }
}

