/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.legend.impl.colortable.create;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.InvalidParameterException;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.lib.legend.api.colortable.MakeColorTable;
import org.gvsig.raster.swing.legend.colortable.create.CreateColorTablePanel;
import org.gvsig.raster.swing.legend.impl.colortable.create.CreateColorTablePanelView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class CreateColorTablePanelController
extends CreateColorTablePanelView
implements CreateColorTablePanel {
    private static final long serialVersionUID = 9004095796574698464L;
    private Color fromColor;
    private Color toColor;

    public CreateColorTablePanelController() {
        this.translate();
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.btnFromColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateColorTablePanelController.this.doSelectFromColor();
            }
        });
        this.btnToColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateColorTablePanelController.this.doSelectToColor();
            }
        });
        this.rdbIntervalSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateColorTablePanelController.this.updateModeComponents();
            }
        });
        this.rdbIntervalNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateColorTablePanelController.this.updateModeComponents();
            }
        });
    }

    protected void updateModeComponents() {
        this.txtIntervalSize.setEnabled(this.rdbIntervalSize.isSelected());
        this.txtIntervals.setEnabled(this.rdbIntervalNumber.isSelected());
    }

    protected void doSelectToColor() {
        Color ret = JColorChooser.showDialog(this, Messages.getText((String)"_to_color"), this.toColor);
        if (ret != null) {
            this.toColor = ret;
            this.lblToColorPreviewer.setBackground(this.toColor);
        } else {
            this.lblToColorPreviewer.setBackground(Color.WHITE);
        }
    }

    protected void doSelectFromColor() {
        Color ret = JColorChooser.showDialog(this, Messages.getText((String)"_from_color"), this.fromColor);
        if (ret != null) {
            this.fromColor = ret;
            this.lblFromColorPreviewer.setBackground(this.fromColor);
        } else {
            this.lblFromColorPreviewer.setBackground(Color.BLACK);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public void fetch(MakeColorTable makeColorTable) {
        makeColorTable.setName(this.txtName.getText());
        makeColorTable.setMinimum(((Number)this.txtMinimum.getValue()).doubleValue());
        makeColorTable.setMaximum(((Number)this.txtMaximum.getValue()).doubleValue());
        if (this.rdbIntervalNumber.isSelected()) {
            makeColorTable.setMode(1);
            makeColorTable.setIntervals(((Number)this.txtIntervals.getValue()).intValue());
        } else {
            makeColorTable.setMode(0);
            makeColorTable.setIntervalSize(((Number)this.txtIntervalSize.getValue()).doubleValue());
        }
        makeColorTable.setFromColor(this.fromColor);
        makeColorTable.setToColor(this.toColor);
        makeColorTable.setInterpolated(this.chkInterpolated.isSelected());
    }

    public void setMinimum(double minimum) {
        this.txtMinimum.setValue(minimum);
    }

    public void setMaximum(double maximum) {
        this.txtMaximum.setValue(maximum);
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblName.setText(i18nManager.getTranslation(this.lblName.getText()));
        this.lblMinimum.setText(i18nManager.getTranslation(this.lblMinimum.getText()));
        this.lblMaximum.setText(i18nManager.getTranslation(this.lblMaximum.getText()));
        this.rdbIntervalSize.setText(i18nManager.getTranslation(this.rdbIntervalSize.getText()));
        this.rdbIntervalNumber.setText(i18nManager.getTranslation(this.rdbIntervalNumber.getText()));
        this.lblFromColor.setText(i18nManager.getTranslation(this.lblFromColor.getText()));
        this.lblToColor.setText(i18nManager.getTranslation(this.lblToColor.getText()));
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setGroupingUsed(false);
        numberInstance.setMaximumFractionDigits(Integer.MAX_VALUE);
        NumberFormatter numberFormatter = new NumberFormatter(numberInstance);
        DefaultFormatterFactory tf = new DefaultFormatterFactory(numberFormatter, numberFormatter, numberFormatter, numberFormatter);
        this.txtMinimum.setFormatterFactory(tf);
        this.txtMaximum.setFormatterFactory(tf);
        this.txtIntervalSize.setFormatterFactory(tf);
        NumberFormat integerInstance = NumberFormat.getIntegerInstance();
        integerInstance.setGroupingUsed(false);
        numberFormatter = new NumberFormatter(integerInstance);
        numberFormatter.setMinimum(Integer.valueOf(1));
        numberFormatter.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        tf = new DefaultFormatterFactory(numberFormatter, numberFormatter, numberFormatter, numberFormatter);
        this.txtIntervals.setFormatterFactory(tf);
    }

    public void setMode(int mode) {
        switch (mode) {
            case 0: {
                this.rdbIntervalSize.setSelected(true);
                this.rdbIntervalNumber.setSelected(false);
                break;
            }
            case 1: {
                this.rdbIntervalSize.setSelected(false);
                this.rdbIntervalNumber.setSelected(true);
                break;
            }
            default: {
                throw new InvalidParameterException("Creation mode of color table must be 0 or 1.");
            }
        }
    }

    public void setIntervals(int intervals) {
        this.txtIntervals.setValue(intervals);
    }

    public void setIntervalSize(double intervalSize) {
        this.txtIntervalSize.setValue(intervalSize);
    }

    public void setFromColor(Color fromColor) {
        this.fromColor = fromColor;
        this.lblFromColorPreviewer.setBackground(this.fromColor);
    }

    public void setToColor(Color toColor) {
        this.toColor = toColor;
        this.lblToColorPreviewer.setBackground(this.toColor);
    }

    public void setLocate(Locale locale) {
        Locale l = super.getLocale();
        if (!l.equals(locale)) {
            this.translate();
        }
        super.setLocale(locale);
    }
}

