/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.legend.impl.colortable.editor;

import java.awt.Color;
import javax.swing.table.AbstractTableModel;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClass;
import org.gvsig.raster.swing.legend.colortable.editor.ColorTableClassesTableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class DefaultColorTableClassesTableModel
extends AbstractTableModel
implements ColorTableClassesTableModel {
    private static final long serialVersionUID = -456045233313370454L;
    private ColorTable colorTable;
    private static final int COLUMNS = 4;
    public static final int COLUMN_COLOR = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_VALUE = 2;
    public static final int COLUMN_INTERPOLATED = 3;

    public DefaultColorTableClassesTableModel(ColorTable colorTable) {
        this.colorTable = colorTable;
    }

    @Override
    public int getRowCount() {
        if (this.colorTable == null) {
            return 0;
        }
        return this.colorTable.getClasses().size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((ColorTableClass)this.colorTable.getClasses().get(rowIndex)).getColor();
            }
            case 1: {
                return ((ColorTableClass)this.colorTable.getClasses().get(rowIndex)).getName();
            }
            case 2: {
                return ((ColorTableClass)this.colorTable.getClasses().get(rowIndex)).getValue();
            }
            case 3: {
                return ((ColorTableClass)this.colorTable.getClasses().get(rowIndex)).getInterpolated();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        switch (column) {
            case 0: {
                return i18nManager.getTranslation("_color");
            }
            case 1: {
                return i18nManager.getTranslation("_name");
            }
            case 2: {
                return i18nManager.getTranslation("_value");
            }
            case 3: {
                return i18nManager.getTranslation("_interpolation_percent");
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Color.class;
            }
            case 2: {
                return Double.class;
            }
            case 3: {
                return Double.class;
            }
        }
        return super.getColumnClass(col);
    }

    public void addColorTableClass(ColorTableClass colorTableClass) {
        this.colorTable.getClasses().add(colorTableClass);
        this.fireTableDataChanged();
    }

    public ColorTableClass getColorTableClass(int index) {
        return (ColorTableClass)this.colorTable.getClasses().get(index);
    }

    public void removeColorTableClass(int index) {
        this.colorTable.getClasses().remove(index);
        this.fireTableDataChanged();
    }

    public void removeAllColorTableClasses() {
        this.colorTable.getClasses().clear();
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                ((ColorTableClass)this.colorTable.getClasses().get(rowIndex)).setColor((Color)aValue);
                break;
            }
            case 1: {
                ((ColorTableClass)this.colorTable.getClasses().get(rowIndex)).setName((String)aValue);
                break;
            }
            case 2: {
                ((ColorTableClass)this.colorTable.getClasses().get(rowIndex)).setValue(((Number)aValue).doubleValue());
                break;
            }
            case 3: {
                ((ColorTableClass)this.colorTable.getClasses().get(rowIndex)).setInterpolated(((Number)aValue).doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal column index: " + columnIndex + ".");
            }
        }
        this.fireTableDataChanged();
    }

    public void setColorTable(ColorTable colorTable) {
        this.colorTable = colorTable;
        this.fireTableDataChanged();
    }
}

