/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.legend.impl.colortable.selector;

import java.io.File;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.swing.legend.colortable.selector.ColorTablesTableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class DefaultColorTablesTableModel
extends AbstractTableModel
implements ColorTablesTableModel {
    private static final long serialVersionUID = -6739781555636046945L;
    private List<Pair<File, ColorTable>> colorTables;
    private static final int COLUMNS = 4;
    public static final int COLUMN_PREVIEW = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_CLASSES = 2;
    public static final int COLUMN_INTERPOLATED = 3;

    public DefaultColorTablesTableModel(List<Pair<File, ColorTable>> colorTables) {
        this.colorTables = colorTables;
    }

    @Override
    public int getRowCount() {
        return this.colorTables.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.colorTables.get(rowIndex).getValue();
            }
            case 1: {
                return ((ColorTable)this.colorTables.get(rowIndex).getValue()).getName();
            }
            case 2: {
                return ((ColorTable)this.colorTables.get(rowIndex).getValue()).getClasses().size();
            }
            case 3: {
                return ((ColorTable)this.colorTables.get(rowIndex).getValue()).isInterpolated();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        switch (column) {
            case 0: {
                return i18nManager.getTranslation("_preview");
            }
            case 1: {
                return i18nManager.getTranslation("_name");
            }
            case 2: {
                return i18nManager.getTranslation("_classes");
            }
            case 3: {
                return i18nManager.getTranslation("_interpolated");
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 0) {
            return ColorTable.class;
        }
        if (col == 3) {
            return Boolean.class;
        }
        return super.getColumnClass(col);
    }

    public void addColorTable(Pair<File, ColorTable> colorTable) {
        this.colorTables.add(colorTable);
        this.fireTableDataChanged();
    }

    public void removeColorTable(int index) {
        this.colorTables.remove(index);
        this.fireTableDataChanged();
    }

    public Pair<File, ColorTable> getColorTable(int index) {
        return this.colorTables.get(index);
    }

    public void setColorTable(int index, ColorTable colorTableEdited) {
        ((ColorTable)this.colorTables.get(index).getValue()).copyFrom(colorTableEdited);
        this.fireTableDataChanged();
    }

    public List<Pair<File, ColorTable>> getColorTables() {
        return this.colorTables;
    }
}

