/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.gui.beans.wizard.panel.NotContinueWizardException;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.newlayer.NewLayerProviderFactory;
import org.gvsig.newlayer.NewLayerService;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.utils.DefaultListModel;

public class TypeSelectorPanel
extends JPanel
implements OptionPanel {
    private static final long serialVersionUID = 419873365484240927L;
    private NewLayerWizard wizard;
    private NewLayerProviderFactory currentType;

    public TypeSelectorPanel(NewLayerWizard wizard) {
        this.wizard = wizard;
        this.initializeComponents();
    }

    public String getPanelTitle() {
        return Messages.getText((String)"_Output_format");
    }

    public void nextPanel() throws NotContinueWizardException {
        if (this.currentType != null) {
            this.wizard.setType(this.currentType);
            return;
        }
        throw new NotContinueWizardException("", null, false);
    }

    public void lastPanel() {
    }

    public void updatePanel() {
        this.initializeComponents();
    }

    public JPanel getJPanel() {
        return this;
    }

    private void initializeComponents() {
        this.setLayout(new BorderLayout());
        JList types = new JList();
        DefaultListModel model = new DefaultListModel((Collection)this.getService().getProviderFactories());
        types.setModel(model);
        types.setSelectionMode(0);
        types.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JList list = (JList)e.getSource();
                    if (list.getSelectedIndex() > -1) {
                        TypeSelectorPanel.this.currentType = (NewLayerProviderFactory)list.getSelectedValue();
                        TypeSelectorPanel.this.wizard.setNextButtonEnabled(true);
                    } else {
                        TypeSelectorPanel.this.wizard.setNextButtonEnabled(false);
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(types);
        this.add((Component)scrollPane, "Center");
    }

    private NewLayerService getService() {
        return this.wizard.getService();
    }
}

