/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.impl.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.newlayer.NewLayerLocator;
import org.gvsig.newlayer.NewLayerProviderFactory;
import org.gvsig.newlayer.preferences.NewLayerPreferencesComponent;

public class DefaultNewLayerPreferencesComponent
extends JPanel
implements NewLayerPreferencesComponent,
ChangeListener {
    private static final long serialVersionUID = -4392838062470171181L;
    private JCheckBox[] providerChecks;
    private List<NewLayerProviderFactory> providers;
    private boolean valueChanged = false;

    public DefaultNewLayerPreferencesComponent() {
        this(true);
    }

    public DefaultNewLayerPreferencesComponent(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 0, 1, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.providers = new ArrayList<NewLayerProviderFactory>(NewLayerLocator.getManager().getProviders());
        this.providerChecks = new JCheckBox[this.providers.size()];
        for (int i = 0; i < this.providers.size(); ++i) {
            NewLayerProviderFactory factory = this.providers.get(i);
            this.providerChecks[i] = new JCheckBox(factory.getLabel(), factory.isEnabled());
            this.providerChecks[i].addChangeListener(this);
            this.providerChecks[i].setToolTipText(factory.getDescription());
            this.add((Component)this.providerChecks[i], gbc);
            ++gbc.gridy;
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public void initializeDefaults() {
        for (int i = 0; i < this.providers.size(); ++i) {
            NewLayerProviderFactory factory = this.providers.get(i);
            this.providerChecks[i].setSelected(factory.isEnabled());
        }
        this.valueChanged = false;
        this.validate();
    }

    public Set<NewLayerProviderFactory> getDisabledProviders() {
        HashSet<NewLayerProviderFactory> disabledFactories = new HashSet<NewLayerProviderFactory>();
        for (int i = 0; i < this.providerChecks.length; ++i) {
            if (this.providerChecks[i].isSelected()) continue;
            disabledFactories.add(this.providers.get(i));
        }
        return disabledFactories;
    }

    public boolean isValueChanged() {
        return this.valueChanged;
    }

    public void setChangesApplied() {
        this.valueChanged = false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.valueChanged = true;
    }
}

