/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.IOExceptionWithStatus;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.json.Json;
import org.gvsig.json.SupportFromJson;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineManager;
import org.gvsig.online.lib.api.OnlineProject;
import org.gvsig.online.lib.api.OnlineSite;
import org.gvsig.online.lib.impl.OnlineProjectImpl;
import org.gvsig.online.lib.impl.OnlineSiteImpl;
import org.gvsig.online.lib.impl.TilesCalculator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OnlineLayerImpl
implements OnlineLayer,
SupportFromJson {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineLayerImpl.class);
    private JsonObject data;
    private OnlineSiteImpl site;
    private FeatureType featureType;
    private OnlineProjectImpl project;
    private Envelope envelope;
    private IProjection projection;
    private List<String> readOnlyFieldNamesForInsert;
    private List<String> readOnlyFieldNamesForUpdate;
    private JsonObject layerConf;

    public OnlineLayerImpl() {
    }

    public OnlineLayerImpl(OnlineSite site, JsonObject data) {
        this.setSite(site);
        this.fromJson(data);
    }

    public OnlineLayerImpl(OnlineProject project, JsonObject data, JsonObject layerConf) {
        this.setProject(project);
        this.fromJson(data);
        this.layerConf = layerConf;
    }

    public final OnlineLayerImpl setSite(OnlineSite site) {
        this.site = (OnlineSiteImpl)site;
        return this;
    }

    public final OnlineLayerImpl setProject(OnlineProject project) {
        this.project = (OnlineProjectImpl)project;
        this.site = this.project.getSite();
        return this;
    }

    public OnlineSiteImpl getSite() {
        return this.site;
    }

    public OnlineProjectImpl getProject() {
        return this.project;
    }

    public boolean isHidden() {
        String name = this.getName();
        if (this.project == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)this.project.getConfigTableName()) || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)this.project.getResourcesTablaName()) || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)this.project.getRepositoryTableName());
    }

    public int getId() {
        return this.data.getInt("id", -1);
    }

    public String getName() {
        return this.data.getString("name", null);
    }

    public String getTitle() {
        return this.data.getString("title", null);
    }

    public String getWorkspace() {
        return this.data.getString("workspace", null);
    }

    public String getLabel() {
        if (StringUtils.isNotBlank((CharSequence)this.getTitle())) {
            return this.getTitle();
        }
        if (StringUtils.isNotBlank((CharSequence)this.getName())) {
            return this.getName();
        }
        return String.valueOf(this.getId());
    }

    public String getAbstract() {
        return this.data.getString("abstract", null);
    }

    public String getType() {
        return this.data.getString("type", null);
    }

    public int getlayerGroupId() {
        return this.data.getInt("layer_group_id", -1);
    }

    public void fromJson(JsonObject json) {
        this.data = json;
    }

    public String getSRS() {
        return this.data.getString("native_srs", null);
    }

    public int getSRSCode() {
        try {
            String srs = this.getSRS();
            if (StringUtils.isBlank((CharSequence)srs)) {
                return 0;
            }
            return Integer.parseInt(StringUtils.split((String)srs, (char)':')[1]);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getPkName() {
        FeatureType ft = this.getFeatureType();
        FeatureAttributeDescriptor[] pk = ft.getPrimaryKey();
        if (pk == null) {
            return null;
        }
        return pk[0].getName();
    }

    public FeatureType getFeatureType() {
        OnlineManager online;
        EditableFeatureType ftype2;
        if (this.featureType != null) {
            return this.featureType;
        }
        int tableId = -1;
        String tableName = "unknown";
        String fieldName = "unknown";
        EditableFeatureType ftype = null;
        JsonObject item = null;
        GeometryType geomtype = null;
        int type = 0;
        int size = 0;
        int precision = 0;
        int scale = 0;
        JsonArray onlineSchemaDescription = null;
        try {
            tableId = this.getId();
            tableName = this.getName();
            ftype = DALLocator.getDataManager().createFeatureType();
            DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            onlineSchemaDescription = this.getDescription();
            block14: for (JsonValue item0 : onlineSchemaDescription) {
                item = (JsonObject)item0;
                fieldName = item.getString("name", null);
                JsonObject itemConf = this.getAttributeConf(fieldName);
                if (itemConf != null) {
                    item = itemConf;
                }
                String type_online = StringUtils.lowerCase((String)item.getString("type", null));
                type = 0;
                size = 0;
                geomtype = null;
                DynObjectValueItem[] availableValues = null;
                if (type_online != null) {
                    DataType dt;
                    if (StringUtils.equalsIgnoreCase((CharSequence)type_online, (CharSequence)"enumeration")) {
                        dt = dataTypesManager.get(8);
                        JsonArray values = item.getJsonArray("values");
                        availableValues = new DynObjectValueItem[values.size()];
                        int n = 0;
                        for (JsonValue value : values) {
                            String s = (String)Json.toObject((JsonValue)value);
                            availableValues[n++] = new DynObjectValueItem((Object)s, s);
                        }
                    } else {
                        dt = dataTypesManager.get(type_online);
                        if (dt == null && "timestamp without time zone".equalsIgnoreCase(type_online)) {
                            dt = dataTypesManager.get("Timestamp");
                        }
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"text", (CharSequence)type_online)) {
                        dt = dataTypesManager.get(8);
                    }
                    if (dt == null) {
                        GeometryType gt = geometryManager.getGeometryType(type_online);
                        if (gt == null) {
                            throw new RuntimeException("Can't get feature type for table '" + tableName + "' (id=" + tableId + "), data type '" + type_online + "' of field '" + fieldName + "' not supported.");
                        }
                        type = 66;
                        geomtype = gt;
                    } else {
                        type = dt.getType();
                        if (type == 8) {
                            size = item.getInt("length", 0) > 0 ? item.getInt("length", 0) : 4096;
                        }
                    }
                }
                boolean nullable = BooleanUtils.toBoolean((String)item.getString("nullable", null));
                boolean pk = BooleanUtils.toBoolean((String)item.getString("pk", null));
                boolean mandatory = item.getBoolean("mandatory", false);
                String translate = item.getString("translate", null);
                EditableFeatureAttributeDescriptor fattr = ftype.add(fieldName, type, size);
                fattr.setIsPrimaryKey(pk);
                fattr.setLabel(translate);
                if (availableValues != null) {
                    fattr.setAvailableValues(availableValues);
                }
                if (geomtype != null) {
                    fattr.setGeometryType(geomtype);
                    fattr.setSRS(this.getProjection());
                    fattr.setHidden(true);
                } else {
                    fattr.setReadOnly(!item.getBoolean("editable", true));
                    if (fattr.isReadOnly()) {
                        fattr.setAllowNull(true);
                    } else {
                        fattr.setAllowNull(nullable);
                    }
                }
                if (type == 19) {
                    fattr.setPrecision(precision);
                    fattr.setScale(scale);
                }
                switch (fattr.getName().toLowerCase()) {
                    case "last_modification": 
                    case "modified_by": {
                        fattr.setHidden(true);
                        continue block14;
                    }
                    case "feat_date_gvol": 
                    case "feat_version_gvol": {
                        fattr.setHidden(true);
                        fattr.setReadOnly(false);
                        continue block14;
                    }
                }
                if (fattr.allowNull()) {
                    fattr.setHidden(!item.getBoolean("visible", true));
                    continue;
                }
                fattr.setHidden(false);
            }
        }
        catch (Exception ex) {
            String s;
            try {
                s = Objects.toString(onlineSchemaDescription);
            }
            catch (Throwable t) {
                s = "(" + t.getMessage() + ")";
            }
            throw new RuntimeException("Can't get feature type for table '" + tableName + "' (id=" + tableId + ", lastField=" + fieldName + ")\n" + s, ex);
        }
        FeatureAttributeDescriptor[] attrsPk = ftype.getPrimaryKey();
        if (attrsPk == null || attrsPk.length < 1) {
            throw new RuntimeException("There aren't primary key in table " + tableName);
        }
        if (attrsPk.length > 1) {
            throw new RuntimeException("Too many fields in primary key in table " + tableName);
        }
        if (attrsPk[0].getType() != 5 && attrsPk[0].getType() != 4) {
            if (attrsPk[0].getType() == 19) {
                LOGGER.info("La pk de la tabla " + tableName + " es de tipo DECIMAL");
            } else {
                throw new RuntimeException("Illegal primary key datatype (" + attrsPk[0].getType() + ") in table " + tableName);
            }
        }
        this.featureType = (ftype2 = (online = OnlineLocator.getOnlineManager()).configureFeatureType((OnlineLayer)this, ftype)) == ftype ? ((ftype2 = this.downloadFeatureType((FeatureType)ftype)) != null ? ftype2 : ftype) : ftype2;
        return this.featureType;
    }

    private EditableFeatureType downloadFeatureType(FeatureType online_ftype) {
        String tableName = this.getName();
        String projectName = this.getProject().getName();
        try {
            File f;
            URL url;
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            try {
                URL urlRootSite = this.getSite().getURL("/");
                String userId = downloader.getAuthenticatedUser(urlRootSite);
                url = this.getSite().getURL("/fileserver/filemanager/api/v1/download/ROLE_UG_" + userId.toUpperCase() + "/" + projectName + ".config/" + tableName + ".config");
                f = downloader.downloadFile(url, "GET", null, null, "online-layer-filemanager-download-" + projectName + "-" + tableName + ".config.json", ICancellable.DUMB, -1, false, false);
            }
            catch (IOExceptionWithStatus ex) {
                int status = ex.getStatus();
                if (status == 404 || status == 403) {
                    url = this.getSite().getURL("/fileserver/filemanager/api/v1/download/" + projectName + ".config/" + tableName + ".config");
                    try {
                        f = downloader.downloadFile(url, "GET", null, null, "online-layer-filemanager-download-" + projectName + "-" + tableName + ".config.json", ICancellable.DUMB, -1, false, false);
                    }
                    catch (IOExceptionWithStatus ex2) {
                        status = ex2.getStatus();
                        if (status == 404 || status == 403) {
                            LOGGER.info("There is no configuration for layer on the file-manager of server (" + projectName + ".config/" + tableName + ".config)");
                            return null;
                        }
                        LOGGER.warn("Can't download layer config", (Throwable)ex2);
                        return null;
                    }
                }
                LOGGER.warn("Can't download layer config", (Throwable)ex);
                return null;
            }
            String ftype_s = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isBlank((CharSequence)ftype_s)) {
                LOGGER.warn("Layer configuration on the server missmatch, file is empty (" + projectName + ".config/" + tableName + ".config)");
                return null;
            }
            JsonObject ftype_json = Json.createObject((String)ftype_s);
            if (ftype_json == null) {
                LOGGER.warn("Layer configuration on the server missmatch, bad json format (" + projectName + ".config/" + tableName + ".config)");
                return null;
            }
            DataManager dataManager = DALLocator.getDataManager();
            EditableFeatureType ftype2 = dataManager.createFeatureType(ftype_json);
            int real_fields_number = 0;
            for (FeatureAttributeDescriptor attr : ftype2) {
                if (attr.isComputed()) continue;
                ++real_fields_number;
                FeatureAttributeDescriptor online_attr = online_ftype.getAttributeDescriptor(attr.getName());
                if (online_attr == null) {
                    LOGGER.warn("The layer configuration on the server is outdated, field '" + attr.getName() + "' missmatch (" + projectName + ".config/" + tableName + ".config)");
                    return null;
                }
                if (attr.getType() == online_attr.getType()) continue;
                LOGGER.warn("The layer configuration on the server is outdated, field '" + attr.getName() + "' missmatch (" + projectName + ".config/" + tableName + ".config)");
                return null;
            }
            if (online_ftype.size() != real_fields_number) {
                LOGGER.warn("The layer configuration on the server is outdated, number of fields missmatch (" + projectName + ".config/" + tableName + ".config)");
                return null;
            }
            for (FeatureAttributeDescriptor attr : online_ftype) {
                if (attr.isComputed() || ftype2.get(attr.getName()) != null) continue;
                LOGGER.warn("The layer configuration on the server is outdated, field '" + attr.getName() + "' missmatch (" + projectName + ".config/" + tableName + ".config)");
                return null;
            }
            return ftype2;
        }
        catch (Exception ex) {
            LOGGER.warn("The layer configuration on the server is wrong (" + projectName + ".config/" + tableName + ".config)", (Throwable)ex);
            return null;
        }
    }

    private JsonArray getDescription() {
        int tableId = -1;
        String tableName = "unknown";
        File f = null;
        URL url = null;
        try {
            tableId = this.getId();
            tableName = this.getName();
            if (this.layerConf != null) {
                try {
                    JsonArray fields;
                    JsonObject desc = this.layerConf.getJsonObject("description");
                    if (desc != null && (fields = desc.getJsonArray("fields")) != null) {
                        return fields;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Can't get description from project-conf for table '" + tableName + "' (id=" + tableId + ").");
                }
            }
            url = this.getURL("/layers/" + tableId + "/description/");
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            f = downloader.downloadFile(url, "GET", null, null, "online-layers-" + tableId + "-description.json", ICancellable.DUMB, -1, false);
            String description_s = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
            JsonObject description_json = Json.createObject((String)description_s);
            return description_json.getJsonArray("content");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get description for table '" + tableName + "' (id=" + tableId + ") from " + Objects.toString(url) + ".");
            return null;
        }
    }

    private JsonObject getAttributeConf(String name) {
        if (this.layerConf == null) {
            return null;
        }
        JsonObject desc = this.layerConf.getJsonObject("description");
        if (desc == null) {
            return null;
        }
        JsonArray fields = desc.getJsonArray("fields");
        if (fields == null) {
            return null;
        }
        for (JsonValue field0 : fields) {
            JsonObject field = (JsonObject)field0;
            if (!StringUtils.equals((CharSequence)name, (CharSequence)field.getString("name", null))) continue;
            return field;
        }
        return null;
    }

    public boolean isReadOnly() {
        boolean readOnly = false;
        if (this.layerConf != null) {
            boolean bl = readOnly = !this.layerConf.getBoolean("writable", true);
        }
        if (readOnly) {
            return true;
        }
        FeatureType ft = this.getFeatureType();
        Tags tags = ft.getTags();
        if (tags.getBoolean("online.readonly", false)) {
            return true;
        }
        return ft.getAttributeDescriptor("feat_date_gvol") == null || ft.getAttributeDescriptor("feat_version_gvol") == null;
    }

    private long getCountElements(Envelope env) {
        OnlineLayer.LayerData layerData = this.getDataPage(env, 1, 0);
        return layerData.getTotalElemens();
    }

    public long getCountElements(Expression exp) {
        OnlineLayer.LayerData layerData = this.getDataPage(exp, 1, 0);
        return layerData.getTotalElemens();
    }

    public Iterator<JsonObject> getData(Envelope env, int pageSize, SimpleTaskStatus status) {
        return new LayerDataEnvelopeIterator(this, env, pageSize, status);
    }

    public Iterator<JsonObject> getData(Expression exp, int pageSize, SimpleTaskStatus status) {
        return new LayerDataExpressionIterator(this, exp, pageSize, status);
    }

    private OnlineLayer.LayerData getDataPage(Expression exp, int pageSize, int page) {
        Code op2;
        Code op1;
        Code code = exp.getCode();
        String filterOperator = null;
        org.gvsig.json.JsonArrayBuilder filterQueries = Json.createArrayBuilder();
        int id = 0;
        if (Code.isFunction((Code)code, (String)"OR")) {
            filterOperator = "OR";
            while (Code.isFunction((Code)code, (String)"OR")) {
                op1 = (Code)((Code.Callable)code).parameters().get(0);
                op2 = (Code)((Code.Callable)code).parameters().get(1);
                filterQueries.add((JsonObjectBuilder)this.getFilterQuery(op2, id++));
                code = op1;
            }
            filterQueries.add((JsonObjectBuilder)this.getFilterQuery(code, id++));
        } else if (Code.isFunction((Code)code, (String)"AND")) {
            filterOperator = "AND";
            while (Code.isFunction((Code)code, (String)"AND")) {
                op1 = (Code)((Code.Callable)code).parameters().get(0);
                op2 = (Code)((Code.Callable)code).parameters().get(1);
                filterQueries.add((JsonObjectBuilder)this.getFilterQuery(op2, id++));
                code = op1;
            }
            filterQueries.add((JsonObjectBuilder)this.getFilterQuery(code, id++));
        } else {
            filterQueries.add((JsonObjectBuilder)this.getFilterQuery(code, id++));
        }
        org.gvsig.json.JsonObjectBuilder filter = Json.createObjectBuilder();
        filter.add("filterQueries", (JsonArrayBuilder)filterQueries);
        filter.add("filterOperator", " " + filterOperator + " ");
        FileInputStream fis = null;
        try {
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            URL url = this.getURL("/layers/" + this.getId() + "/features?" + "filter=" + new URLCodec().encode(filter.toString(), StandardCharsets.UTF_8.name()) + "&max=" + pageSize + "&page=" + page + "&epsg=" + this.getSRSCode());
            File f = downloader.downloadFile(url, "GET", null, null, "online-layers-" + this.getId() + "-features.json", ICancellable.DUMB, -1, false);
            if (f == null) {
                return null;
            }
            fis = new FileInputStream(f);
            JsonObject json = Json.createObject((InputStream)fis);
            if (json.containsKey((Object)"content")) {
                json = json.getJsonObject("content");
            }
            int totalfeatures = json.getInt("totalfeatures", -1);
            int lendata = json.getInt("lendata", -1);
            JsonArray features = json.getJsonArray("features");
            return new LayerDataImpl(lendata, totalfeatures, page, (List<JsonValue>)features);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't download data", (Throwable)ex);
            IOUtils.closeQuietly(fis);
            return null;
        }
    }

    private org.gvsig.json.JsonObjectBuilder getFilterQuery(Code code, int id) throws IllegalArgumentException {
        boolean notOp = false;
        if (Code.isFunction((Code)code, (String)"NOT")) {
            code = (Code)((Code.Callable)code).parameters().get(0);
            notOp = true;
        }
        if (Code.isFunction((Code)code, (String)"=")) {
            org.gvsig.json.JsonObjectBuilder filter = Json.createObjectBuilder();
            Code op1 = (Code)((Code.Callable)code).parameters().get(0);
            Code op2 = (Code)((Code.Callable)code).parameters().get(1);
            String fieldName = this.getFieldNameFromCode(op1, "=");
            filter.add("field", fieldName);
            filter.add("id", id);
            filter.add("notop", notOp);
            filter.add("operator", " =");
            filter.add("type", "query");
            filter.add("value", this.getValueOfFromCode(op2, fieldName));
            return filter;
        }
        if (Code.isFunction((Code)code, (String)"<>")) {
            org.gvsig.json.JsonObjectBuilder filter = Json.createObjectBuilder();
            Code op1 = (Code)((Code.Callable)code).parameters().get(0);
            Code op2 = (Code)((Code.Callable)code).parameters().get(1);
            String fieldName = this.getFieldNameFromCode(op1, "<>");
            filter.add("field", fieldName);
            filter.add("id", id);
            filter.add("notop", notOp);
            filter.add("operator", " <>");
            filter.add("type", "query");
            filter.add("value", this.getValueOfFromCode(op2, fieldName));
            return filter;
        }
        if (Code.isFunction((Code)code, (String)"LIKE")) {
            org.gvsig.json.JsonObjectBuilder filter = Json.createObjectBuilder();
            Code op1 = (Code)((Code.Callable)code).parameters().get(0);
            Code op2 = (Code)((Code.Callable)code).parameters().get(1);
            String fieldName = this.getFieldNameFromCode(op1, "LIKE");
            filter.add("field", fieldName);
            filter.add("id", id);
            filter.add("notop", notOp);
            filter.add("operator", " LIKE");
            filter.add("type", "query");
            filter.add("value", this.getValueOfFromCode(op2, fieldName));
            return filter;
        }
        if (Code.isFunction((Code)code, (String)"ILIKE")) {
            org.gvsig.json.JsonObjectBuilder filter = Json.createObjectBuilder();
            Code op1 = (Code)((Code.Callable)code).parameters().get(0);
            Code op2 = (Code)((Code.Callable)code).parameters().get(1);
            String fieldName = this.getFieldNameFromCode(op1, "ILIKE");
            filter.add("field", fieldName);
            filter.add("id", id);
            filter.add("notop", notOp);
            filter.add("operator", " ILIKE");
            filter.add("type", "query");
            filter.add("value", this.getValueOfFromCode(op2, fieldName));
            return filter;
        }
        if (Code.isFunction((Code)code, (String)">=")) {
            org.gvsig.json.JsonObjectBuilder filter = Json.createObjectBuilder();
            Code op1 = (Code)((Code.Callable)code).parameters().get(0);
            Code op2 = (Code)((Code.Callable)code).parameters().get(1);
            String fieldName = this.getFieldNameFromCode(op1, ">=");
            filter.add("field", fieldName);
            filter.add("id", id);
            filter.add("notop", notOp);
            filter.add("operator", " >=");
            filter.add("type", "query");
            filter.add("value", this.getValueOfFromCode(op2, fieldName));
            return filter;
        }
        if (Code.isFunction((Code)code, (String)">")) {
            org.gvsig.json.JsonObjectBuilder filter = Json.createObjectBuilder();
            Code op1 = (Code)((Code.Callable)code).parameters().get(0);
            Code op2 = (Code)((Code.Callable)code).parameters().get(1);
            String fieldName = this.getFieldNameFromCode(op1, ">");
            filter.add("field", fieldName);
            filter.add("id", id);
            filter.add("notop", notOp);
            filter.add("operator", " >");
            filter.add("type", "query");
            filter.add("value", this.getValueOfFromCode(op2, fieldName));
            return filter;
        }
        if (Code.isFunction((Code)code, (String)"<=")) {
            org.gvsig.json.JsonObjectBuilder filter = Json.createObjectBuilder();
            Code op1 = (Code)((Code.Callable)code).parameters().get(0);
            Code op2 = (Code)((Code.Callable)code).parameters().get(1);
            String fieldName = this.getFieldNameFromCode(op1, "<=");
            filter.add("field", fieldName);
            filter.add("id", id);
            filter.add("notop", notOp);
            filter.add("operator", " <=");
            filter.add("type", "query");
            filter.add("value", this.getValueOfFromCode(op2, fieldName));
            return filter;
        }
        if (Code.isFunction((Code)code, (String)"<")) {
            org.gvsig.json.JsonObjectBuilder filter = Json.createObjectBuilder();
            Code op1 = (Code)((Code.Callable)code).parameters().get(0);
            Code op2 = (Code)((Code.Callable)code).parameters().get(1);
            String fieldName = this.getFieldNameFromCode(op1, "<");
            filter.add("field", fieldName);
            filter.add("id", id);
            filter.add("notop", notOp);
            filter.add("operator", " <");
            filter.add("type", "query");
            filter.add("value", this.getValueOfFromCode(op2, fieldName));
            return filter;
        }
        throw new IllegalArgumentException("Expression not supported.'" + code.toString() + "'");
    }

    String getFieldNameFromCode(Code code, String operator) {
        if (code.code() != 1) {
            throw new IllegalArgumentException("Expression not supported.'" + code.toString() + "'");
        }
        String fieldName = ((Code.Identifier)code).name();
        FeatureType ft = this.getFeatureType();
        FeatureAttributeDescriptor attr = ft.getAttributeDescriptor(fieldName);
        if (attr == null) {
            throw new IllegalArgumentException("Field not found '" + fieldName + "' in '" + code.toString() + "'");
        }
        return fieldName;
    }

    Object getValueOfFromCode(Code code, String fieldName) {
        if (code.code() != 0) {
            throw new IllegalArgumentException("Expression not supported.'" + code.toString() + "'");
        }
        Object value = ((Code.Constant)code).value();
        FeatureType ft = this.getFeatureType();
        FeatureAttributeDescriptor attr = ft.getAttributeDescriptor(fieldName);
        if (attr == null) {
            throw new IllegalArgumentException("Field not found '" + fieldName + "' in '" + code.toString() + "'");
        }
        return value;
    }

    private OnlineLayer.LayerData getDataPage(Envelope env, int pageSize, int page) {
        FileInputStream fis = null;
        try {
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            URL url = this.getURL("/layers/" + this.getId() + "/featurelist?" + "minlat=" + String.format(Locale.ENGLISH, "%f", env.getMinimum(1)) + "&minlon=" + String.format(Locale.ENGLISH, "%f", env.getMinimum(0)) + "&maxlat=" + String.format(Locale.ENGLISH, "%f", env.getMaximum(1)) + "&maxlon=" + String.format(Locale.ENGLISH, "%f", env.getMaximum(0)) + "&epsg=" + this.getSRSCode() + "&max=" + pageSize + "&page=" + page);
            File f = downloader.downloadFile(url, "GET", null, null, "online-layers-" + this.getId() + "-featurelist.json", ICancellable.DUMB, -1, false);
            if (f == null) {
                return null;
            }
            fis = new FileInputStream(f);
            JsonObject json = Json.createObject((InputStream)fis);
            if (json.containsKey((Object)"content")) {
                json = json.getJsonObject("content");
            }
            int totalfeatures = json.getInt("totalfeatures", -1);
            int lendata = json.getInt("lendata", -1);
            JsonArray features = json.getJsonArray("features");
            return new LayerDataImpl(lendata, totalfeatures, page, (List<JsonValue>)features);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't download data", (Throwable)ex);
            IOUtils.closeQuietly(fis);
            return null;
        }
    }

    public List getValues(String attrName) {
        FileInputStream fis = null;
        try {
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            URL url = this.getURL("/layers/" + this.getId() + "/fieldoptions/?fieldselected=" + attrName);
            File f = downloader.downloadFile(url, "GET", null, null, "online-layers-" + this.getId() + "-fieldoptions.json", ICancellable.DUMB, -1, false);
            if (f == null) {
                return null;
            }
            fis = new FileInputStream(f);
            final JsonArray jsonArray = Json.createArray((InputStream)fis);
            return new AbstractList(){

                @Override
                public Object get(int index) {
                    return Json.toObject((JsonArray)jsonArray, (int)index);
                }

                @Override
                public int size() {
                    return jsonArray.size();
                }
            };
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get values of field '" + attrName + "'", (Throwable)ex);
            IOUtils.closeQuietly(fis);
            return null;
        }
    }

    public IProjection getProjection() {
        if (this.projection == null) {
            String srs = "unknown";
            try {
                srs = this.getSRS();
                this.projection = CRSFactory.getCRS((String)srs);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't create projection from '" + srs + ".", (Throwable)ex);
            }
        }
        return this.projection;
    }

    public Envelope getEnvelope() {
        if (this.envelope == null) {
            String s = this.data.getString("native_extent", null);
            if (s == null) {
                return null;
            }
            String[] ss = StringUtils.split((String)s, (char)',');
            this.envelope = GeometryUtils.createEnvelope((double)Double.parseDouble(ss[0]), (double)Double.parseDouble(ss[1]), (double)Double.parseDouble(ss[2]), (double)Double.parseDouble(ss[3]), (int)0);
        }
        return this.envelope;
    }

    public int calculateTileSize(long maxElementsInTile, SimpleTaskStatus status) {
        final OnlineLayerImpl layer = this;
        TilesCalculator.CalculatorData tileData = new TilesCalculator.CalculatorData(){

            @Override
            public Envelope getEnvelope() {
                return layer.getEnvelope();
            }

            @Override
            public double getWidth() {
                Envelope env = layer.getEnvelope();
                double w = env.getLength(0);
                return w;
            }

            @Override
            public double getHeight() {
                Envelope env = layer.getEnvelope();
                double h = env.getLength(1);
                return h;
            }

            @Override
            public long getElements(Envelope envelope) {
                return layer.getCountElements(envelope);
            }
        };
        TilesCalculator tiles = new TilesCalculator();
        Dimension n = tiles.calculateCellSize(tileData, maxElementsInTile, status);
        return n.width;
    }

    public JsonObject send_update(Feature feature) throws IOException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("format", "geojson");
        props.put("encodecrs", true);
        props.put("skipfields", this.getSkipFieldNamesForUpdate());
        org.gvsig.json.JsonObjectBuilder builder = feature.toJsonBuilder(props);
        return this.send_update(builder.build());
    }

    public JsonObject send_update(JsonObject feature) throws IOException {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        URL url = this.getURL("/layers/" + this.getId() + "/features/?epsg=" + this.getSRSCode());
        File f = null;
        org.gvsig.json.JsonObjectBuilder resp = Json.createObjectBuilder();
        try {
            f = downloader.downloadFile(url, "PUT", ContentType.APPLICATION_JSON, feature.toString(), "online-layers-" + this.getId() + "-features-put.json", ICancellable.DUMB, -1, false);
            String resp_s = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
            JsonObject featureResp = Json.createObject((String)resp_s);
            if (!StringUtils.equalsIgnoreCase((CharSequence)featureResp.getString("type"), (CharSequence)"Feature")) {
                int pkValue = feature.getJsonObject("properties").getInt(this.getPkName());
                featureResp = this.send_get(pkValue).getJsonObject("feature");
            } else {
                featureResp = this.patchGeometry(featureResp);
            }
            resp.add("status", 0);
            resp.add("feature", (JsonValue)featureResp);
        }
        catch (IOExceptionWithStatus ex) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            if (ex.getStatus() == 409) {
                resp.add("status", 11000);
                resp.add("message", i18n.getTranslation("_Conflict"));
                resp.add("feature", (JsonValue)Json.createObject((String)FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8)));
            } else {
                this.fillErrorResponse(resp, 510, "_Cant_send_feature_to_server", ex.getResponseData());
            }
        }
        catch (Exception e) {
            this.fillErrorResponse(resp, 510, "_Cant_send_feature_to_server", f);
        }
        return resp.build();
    }

    protected void fillErrorResponse(org.gvsig.json.JsonObjectBuilder resp, int status, String msg, File f) {
        String message;
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            String resp_s = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
            try {
                JsonObject resp_json = Json.createObject((String)resp_s);
                message = resp_json.getString("message");
            }
            catch (Exception e2) {
                message = resp_s;
            }
        }
        catch (Exception e1) {
            message = i18n.getTranslation("_Cant_send_feature_to_server");
        }
        resp.add("status", 510);
        resp.add("message", message);
        resp.addNull("feature");
    }

    public JsonObject send_insert(Feature feature) throws IOException {
        EditableFeature editableFeat = feature.getCopy().getEditable();
        editableFeat.setUpdatable(false);
        Geometry geom = editableFeat.getDefaultGeometry();
        if (geom != null) {
            geom.setProjection(this.getProjection());
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("format", "geojson");
        props.put("encodecrs", true);
        props.put("skipnulls", false);
        props.put("skipfields", this.getSkipFieldNamesForInsert(feature));
        org.gvsig.json.JsonObjectBuilder builder = editableFeat.toJsonBuilder(props);
        return this.send_insert(builder.build());
    }

    public JsonObject send_insert(JsonObject feature) throws IOException {
        org.gvsig.json.JsonObjectBuilder resp = Json.createObjectBuilder();
        File f = null;
        try {
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            URL url = this.getURL("/layers/" + this.getId() + "/features/?epsg=" + this.getSRSCode());
            f = downloader.downloadFile(url, "POST", ContentType.APPLICATION_JSON, feature.toString(), "online-layers-" + this.getId() + "-features-post.json", ICancellable.DUMB, -1, false);
            JsonObject featureResp = Json.createObject((String)FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8));
            featureResp = this.patchGeometry(featureResp);
            resp.add("status", 0);
            resp.add("feature", (JsonValue)featureResp);
        }
        catch (IOExceptionWithStatus e) {
            this.fillErrorResponse(resp, 510, "_Cant_send_feature_to_server", e.getResponseData());
        }
        catch (Exception e) {
            this.fillErrorResponse(resp, 510, "_Cant_send_feature_to_server", f);
        }
        return resp.build();
    }

    protected JsonObject patchGeometry(JsonObject featureResp) {
        try {
            Geometry geom;
            JsonObject props = featureResp.getJsonObject("properties");
            JsonObject geometry_json = featureResp.getJsonObject("geometry");
            if (props != null && geometry_json != null && (geom = GeometryUtils.createFrom((Object)geometry_json)) != null) {
                IProjection geomProj = geom.getProjection();
                IProjection layerProj = this.getProjection();
                if (geomProj != null && !layerProj.equals(geomProj)) {
                    ICoordTrans ct = geomProj.getCT(layerProj);
                    geom.reProject(ct);
                    String x = geom.convertToGeoJson((Map)props, true);
                    featureResp = Json.createObject((String)x);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Can't parse and reproject geometry", (Throwable)ex);
        }
        return featureResp;
    }

    public JsonObject send_get(long featureCode) throws IOException {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        URL url = this.getURL("/layers/" + this.getId() + "/" + featureCode + "/?epsg=" + this.getSRSCode());
        File f = null;
        org.gvsig.json.JsonObjectBuilder resp = Json.createObjectBuilder();
        try {
            f = downloader.downloadFile(url, "GET", ContentType.APPLICATION_JSON, null, "online-layers-" + this.getId() + "-" + featureCode + "-get.json", ICancellable.DUMB, -1, false);
            resp.add("status", 0);
            JsonObject featureResp = Json.createObject((String)FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8));
            featureResp = this.patchGeometry(featureResp.getJsonObject("content"));
            resp.add("feature", (JsonValue)featureResp);
        }
        catch (Exception ex) {
            this.fillErrorResponse(resp, 600, "_Cant_retrieve_feature_from_server", f);
        }
        return resp.build();
    }

    public int send_delete(long featureCode) throws IOException {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        URL url = this.getURL("/layers/" + this.getId() + "/" + featureCode + "/");
        try {
            File f = downloader.downloadFile(url, "DELETE", null, null, "online-layers-" + this.getId() + "-features-del.json", ICancellable.DUMB, -1, false);
            return 0;
        }
        catch (Exception e) {
            return 520;
        }
    }

    private URL getURL(String s) {
        if (this.layerConf == null) {
            URL url = this.getSite().getURL("/api/v1" + s);
            return url;
        }
        String featureapi_endpoint = this.layerConf.getString("featureapi_endpoint", null);
        if (StringUtils.isBlank((CharSequence)featureapi_endpoint)) {
            URL url = this.getSite().getURL("/api/v1" + s);
            return url;
        }
        URL url = this.getSite().getURL(featureapi_endpoint + s);
        return url;
    }

    public String getFeatureCodeFieldName() {
        return this.getPkName();
    }

    public int getFeatureCodeType() {
        return 5;
    }

    public boolean isVectorial() {
        return StringUtils.containsIgnoreCase((CharSequence)this.getType(), (CharSequence)"PostGIS") && this.getDescription() != null;
    }

    private String[] getSkipFieldNamesForInsert(Feature feature) {
        String[] skipNames = new String[]{this.getPkName(), "feat_date_gvol", "last_modification"};
        if (this.readOnlyFieldNamesForInsert == null) {
            ArrayList<String> l = new ArrayList<String>();
            for (FeatureAttributeDescriptor attr : this.getFeatureType()) {
                if (!attr.isReadOnly()) continue;
                l.add(attr.getName());
            }
            this.readOnlyFieldNamesForInsert = l;
        }
        HashSet<String> names = new HashSet<String>(this.readOnlyFieldNamesForInsert);
        names.addAll(Arrays.asList(skipNames));
        if (feature != null) {
            for (FeatureAttributeDescriptor attr : this.getFeatureType()) {
                if (feature.get(attr.getName()) != null) continue;
                names.add(attr.getName());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] getSkipFieldNamesForUpdate() {
        String[] skipNames = new String[]{"feat_date_gvol"};
        if (this.readOnlyFieldNamesForUpdate == null) {
            Object[] includeNames = new String[]{this.getPkName(), "feat_version_gvol"};
            ArrayList<String> l = new ArrayList<String>();
            for (FeatureAttributeDescriptor attr : this.getFeatureType()) {
                if (ArrayUtils.contains((Object[])includeNames, (Object)attr.getName()) || !attr.isReadOnly()) continue;
                l.add(attr.getName());
            }
            this.readOnlyFieldNamesForUpdate = l;
        }
        HashSet<String> names = new HashSet<String>(this.readOnlyFieldNamesForUpdate);
        names.addAll(Arrays.asList(skipNames));
        return names.toArray(new String[names.size()]);
    }

    public URL getWMSUrl() {
        try {
            if (this.layerConf == null) {
                return null;
            }
            String wms_url = this.layerConf.getString("wms_url", null);
            if (StringUtils.isBlank((CharSequence)wms_url)) {
                return null;
            }
            URL siteurl = this.site.getBaseUrl();
            URL u = new URL(siteurl.getProtocol(), siteurl.getHost(), wms_url);
            return u;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static abstract class AbstractLayerDataIterator
    implements Iterator<JsonObject> {
        protected final int pageSize;
        protected final OnlineLayerImpl layer;
        private int page;
        private OnlineLayer.LayerData theData;
        private Iterator<JsonObject> it;
        protected final SimpleTaskStatus status;

        public AbstractLayerDataIterator(OnlineLayerImpl layer, int pageSize, SimpleTaskStatus status) {
            this.layer = layer;
            this.pageSize = pageSize;
            this.page = 0;
            this.theData = null;
            this.it = null;
            this.status = status;
            if (status != null) {
                this.status.setCurValue(0L);
            }
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.theData != null) {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (this.theData.getPageElements() < this.pageSize) {
                        return false;
                    }
                }
                this.theData = this.getDataPage(this.page++);
                if (this.theData == null) {
                    return false;
                }
                if (this.status != null) {
                    this.status.setRangeOfValues(0L, (long)this.theData.getTotalElemens());
                }
                this.it = this.theData.iterator();
            }
        }

        protected abstract OnlineLayer.LayerData getDataPage(int var1);

        @Override
        public JsonObject next() {
            if (this.theData == null || this.it == null) {
                if (this.hasNext()) {
                    if (this.status != null) {
                        this.status.incrementCurrentValue();
                    }
                    return this.it.next();
                }
                throw new NoSuchElementException();
            }
            if (this.it.hasNext()) {
                if (this.status != null) {
                    this.status.incrementCurrentValue();
                }
                return this.it.next();
            }
            if (this.hasNext()) {
                if (this.status != null) {
                    this.status.incrementCurrentValue();
                }
                return this.it.next();
            }
            throw new NoSuchElementException();
        }
    }

    private static class LayerDataEnvelopeIterator
    extends AbstractLayerDataIterator {
        private final Envelope area;

        public LayerDataEnvelopeIterator(OnlineLayerImpl layer, Envelope area, int pageSize, SimpleTaskStatus status) {
            super(layer, pageSize, status);
            this.area = area;
        }

        @Override
        protected OnlineLayer.LayerData getDataPage(int page) {
            return this.layer.getDataPage(this.area, this.pageSize, page);
        }
    }

    private static class LayerDataExpressionIterator
    extends AbstractLayerDataIterator {
        private final Expression expression;

        public LayerDataExpressionIterator(OnlineLayerImpl layer, Expression expression, int pageSize, SimpleTaskStatus status) {
            super(layer, pageSize, status);
            this.expression = expression;
        }

        @Override
        protected OnlineLayer.LayerData getDataPage(int page) {
            return this.layer.getDataPage(this.expression, this.pageSize, page);
        }
    }

    private static class LayerDataImpl
    implements OnlineLayer.LayerData {
        private final int totalsize;
        private final int pagesize;
        private final int page;
        private final List<JsonValue> elements;

        public LayerDataImpl(int totalsize, int pagesize, int page, List<JsonValue> elements) {
            this.elements = elements;
            this.totalsize = totalsize;
            this.pagesize = pagesize;
            this.page = page;
        }

        public int getPageElements() {
            return this.pagesize;
        }

        public int getPage() {
            return this.page;
        }

        public int getTotalElemens() {
            return this.totalsize;
        }

        public Iterator<JsonObject> iterator() {
            final Iterator<JsonValue> it = this.elements.iterator();
            return new Iterator<JsonObject>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public JsonObject next() {
                    return (JsonObject)it.next();
                }
            };
        }
    }
}

