/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.json.Json;
import org.gvsig.online.lib.api.OnlineCodeGenerator;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineManager;
import org.gvsig.online.lib.api.OnlineProject;
import org.gvsig.online.lib.api.OnlineSite;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopyDescriptor;
import org.gvsig.online.lib.api.workingcopy.WorkingArea;
import org.gvsig.online.lib.impl.OnlineSiteImpl;
import org.gvsig.online.lib.impl.OnlineUtils;
import org.gvsig.online.lib.impl.RandomCodeGenerator;
import org.gvsig.online.lib.impl.workspace.OnlineWorkingcopyDescriptorImpl;
import org.gvsig.online.lib.impl.workspace.OnlineWorkspaceImpl;
import org.gvsig.online.lib.impl.workspace.StoreProperties;
import org.gvsig.online.lib.impl.workspace.WorkingAreaImpl;
import org.gvsig.online.lib.impl.workspace.tables.EntitiesTable;
import org.gvsig.online.lib.impl.workspace.tables.RemoteChangesTable;
import org.gvsig.online.lib.impl.workspace.tables.VarsTable;
import org.gvsig.online.lib.impl.workspace.tables.WorkspaceChangesTable;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.UserCancelTaskException;
import org.gvsig.tools.util.HasAFile;
import org.gvsig.tools.util.ListBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineManagerImpl
implements OnlineManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineManagerImpl.class);
    public static final List<String> INTERNAL_WORKSPACE_TABLES = ListBuilder.create((Object[])new Object[]{"ONLINE_ENTITIES", "ONLINE_CONFIG", "ONLINE_REMOTECHANGES", "ONLINE_WSCHANGES", "GVSIGD_RESOURCES", "GVSIGD_CONFIG", "GVSIGD_REPOSITORY"});
    private Map<String, OnlineWorkingcopyDescriptor> workspaces;
    private int remoteEntityFeatureTypeEditorMode = 0;
    private int maxFeaturesPerTile = 5000;
    private boolean continueWhenUploadFails = true;
    private final Map<String, OnlineManager.FeatureTypeCreationListener> featureTypeCreationListeners = new HashMap<String, OnlineManager.FeatureTypeCreationListener>();

    public OnlineManagerImpl() {
        this.workspaces = new HashMap<String, OnlineWorkingcopyDescriptor>();
    }

    public String getErrorMessage(int errcode) {
        return OnlineUtils.getErrorMessage(errcode);
    }

    public OnlineWorkingcopyDescriptor getWorkingcopyDescriptor(String code) {
        OnlineWorkingcopyDescriptor descriptor = this.workspaces.get(code);
        if (descriptor != null) {
            DisposeUtils.bind((Disposable)descriptor);
            return descriptor;
        }
        for (OnlineWorkingcopyDescriptor descriptor2 : this.workspaces.values()) {
            if (descriptor2 == null || !StringUtils.equalsIgnoreCase((CharSequence)descriptor2.getLabel(), (CharSequence)code)) continue;
            DisposeUtils.bind((Disposable)descriptor2);
            return descriptor2;
        }
        return null;
    }

    public synchronized void clean() {
        for (OnlineWorkingcopyDescriptor workspace : this.workspaces.values()) {
            DisposeUtils.disposeQuietly((Disposable)workspace);
        }
        this.workspaces = new HashMap<String, OnlineWorkingcopyDescriptor>();
    }

    public OnlineWorkingcopy openWorkingcopy(JDBCServerExplorer wsexplorer, String label) {
        if (wsexplorer == null) {
            return null;
        }
        JDBCServerExplorerParameters params = null;
        try {
            params = wsexplorer.getParameters();
            OnlineWorkspaceImpl workspace = new OnlineWorkspaceImpl(wsexplorer, this.getCodeGenerator(), label);
            this.registerWorkingcopy(workspace);
            this.dropExpiredCaches();
            return workspace;
        }
        catch (Exception ex) {
            LOGGER.debug("Can't get workspace from " + Objects.toString(params) + ".", (Throwable)ex);
            return null;
        }
    }

    public void registerWorkingcopy(OnlineWorkingcopy workspace) {
        OnlineWorkingcopyDescriptor descriptor = this.workspaces.get(workspace.getCode());
        if (descriptor == null) {
            descriptor = new OnlineWorkingcopyDescriptorImpl(workspace);
            this.workspaces.put(workspace.getCode(), descriptor);
        } else {
            ((OnlineWorkingcopyDescriptorImpl)descriptor).setWorkspace(workspace);
        }
    }

    public void deregisterWorkingcopy(File dbfile) {
        Path dbpath = dbfile.toPath();
        ArrayList<String> wscodes = new ArrayList<String>();
        for (OnlineWorkingcopyDescriptorImpl onlineWorkingcopyDescriptorImpl : this.workspaces.values()) {
            JDBCServerExplorerParameters explorerParams = onlineWorkingcopyDescriptorImpl.getExplorerParameters();
            if (!(explorerParams instanceof HasAFile)) continue;
            Path p = ((HasAFile)explorerParams).getFile().toPath();
            try {
                if (!Files.isSameFile(dbpath, p)) continue;
                wscodes.add(onlineWorkingcopyDescriptorImpl.getCode());
            }
            catch (IOException ex) {
                LOGGER.debug("Can't deregister workspace '" + dbfile.getAbsolutePath() + "'.", (Throwable)ex);
            }
        }
        for (String string : wscodes) {
            this.deregisterWorkingcopy(string);
        }
    }

    public void deregisterWorkingcopy(OnlineWorkingcopy workspace) {
        this.deregisterWorkingcopy(workspace.getCode());
    }

    public void deregisterWorkingcopy(String workspaceCode) {
        DisposeUtils.disposeQuietly((Disposable)((Disposable)this.workspaces.get(workspaceCode)));
        this.workspaces.remove(workspaceCode);
        this.dropExpiredCaches();
    }

    private void dropExpiredCaches() {
        Iterator<OnlineWorkingcopyDescriptor> iterator = this.workspaces.values().iterator();
        while (iterator.hasNext()) {
            OnlineWorkingcopyDescriptorImpl value = (OnlineWorkingcopyDescriptorImpl)iterator.next();
            if (DisposeUtils.getReferences((Disposable)value) <= 0) {
                iterator.remove();
                continue;
            }
            value.dropExpiredCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OnlineWorkingcopy getWorkingcopy(FeatureStore store) {
        if (this.workspaces == null) {
            return null;
        }
        try {
            OnlineWorkspaceImpl workspace;
            switch (StoreProperties.getOnlineMode(store)) {
                case 2: {
                    return null;
                }
                case 1: {
                    String workspace_code = StoreProperties.getWorkspaceCode(store);
                    OnlineWorkingcopyDescriptor workspaceDescriptor = this.workspaces.get(workspace_code);
                    if (workspaceDescriptor == null || (workspace = (OnlineWorkspaceImpl)workspaceDescriptor.getWorkspace()) == null) break;
                    if (workspace.isInStoreIgnoreChanges(store)) {
                        return workspace;
                    }
                    String entity_name = StoreProperties.getEntityName(store);
                    EntitiesTable.EntityRow entity = workspace.getWorkspaceEntityByName(entity_name);
                    if (entity == null) {
                        StoreProperties.setNotOnlineMode(store);
                        DisposeUtils.dispose((Disposable)workspace);
                        return null;
                    }
                    if (!workspace.isCorrupt((OnlineEntity)entity, store, 0)) return workspace;
                    return workspace;
                }
            }
            DataStoreParameters params = store.getParameters();
            if (!(params instanceof JDBCStoreParameters)) {
                StoreProperties.setNotOnlineMode(store);
                return null;
            }
            String entity_name = ((JDBCStoreParameters)params).getTable();
            if (INTERNAL_WORKSPACE_TABLES.contains(entity_name)) {
                StoreProperties.setNotOnlineMode(store);
                return null;
            }
            String storeUrl = ((JDBCStoreParameters)params).getUrl();
            ArrayList<OnlineWorkingcopyDescriptor> descriptors = new ArrayList<OnlineWorkingcopyDescriptor>(this.workspaces.values());
            for (OnlineWorkingcopyDescriptor value : descriptors) {
                JDBCServerExplorerParameters explorerParams;
                if (value == null || (explorerParams = value.getExplorerParameters()) == null || !StringUtils.equals((CharSequence)storeUrl, (CharSequence)explorerParams.getUrl()) || (workspace = (OnlineWorkspaceImpl)value.getWorkspace()) == null) continue;
                EntitiesTable.EntityRow entity = workspace.getWorkspaceEntityByName(entity_name);
                if (entity == null) {
                    StoreProperties.setNotOnlineMode(store);
                    DisposeUtils.dispose((Disposable)workspace);
                    return null;
                }
                StoreProperties.set(store, workspace, entity_name);
                if (!workspace.isCorrupt((OnlineEntity)entity, store, 0)) return workspace;
                return workspace;
            }
            JDBCServerExplorer explorer = null;
            try {
                explorer = (JDBCServerExplorer)store.getExplorer();
                if (!this.isWorkingcopy(explorer.getParameters())) {
                    OnlineWorkingcopyDescriptor value;
                    StoreProperties.setNotOnlineMode(store);
                    value = null;
                    return value;
                }
                workspace = (OnlineWorkspaceImpl)this.openWorkingcopy(explorer);
            }
            catch (Exception e) {
                workspace = null;
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)explorer);
            }
            if (workspace == null) {
                StoreProperties.setNotOnlineMode(store);
                return null;
            }
            this.registerWorkingcopy(workspace);
            EntitiesTable.EntityRow entity = workspace.getWorkspaceEntityByName(entity_name);
            if (entity == null) {
                StoreProperties.setNotOnlineMode(store);
                return null;
            }
            StoreProperties.set(store, workspace, entity_name);
            return workspace;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get '" + store.getName() + "'store's workspace ", (Throwable)ex);
            StoreProperties.setUnknownOnlineMode(store);
            throw new RuntimeException("Can't get '" + store.getName() + "'store's workspace ", ex);
        }
    }

    public Map<String, OnlineWorkingcopyDescriptor> getWorkingcopy() {
        return Collections.unmodifiableMap(this.workspaces);
    }

    public synchronized void restoreWorkingcopy(Map<String, OnlineWorkingcopyDescriptor> descriptors) {
        this.workspaces = new HashMap<String, OnlineWorkingcopyDescriptor>();
        if (descriptors != null) {
            this.workspaces.putAll(descriptors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorkingcopy(JDBCServerExplorerParameters params) {
        boolean bl;
        DataServerExplorer explorer = null;
        try {
            DataManager dataManager = DALLocator.getDataManager();
            explorer = dataManager.openServerExplorer(params.getProviderName(), (DataServerExplorerParameters)params);
            DataStoreParameters x = explorer.get("ONLINE_CONFIG");
            if (x == null) {
                boolean bl2 = false;
                DisposeUtils.disposeQuietly((Disposable)explorer);
                return bl2;
            }
            bl = explorer.exists(x);
            DisposeUtils.disposeQuietly((Disposable)explorer);
        }
        catch (Exception ex) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            DisposeUtils.disposeQuietly(explorer);
        }
        return bl;
    }

    public boolean isWorkingcopy(File dbfile) {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorerParameters params = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters("H2Spatial");
            ((HasAFile)params).setFile(dbfile);
            return this.isWorkingcopy(params);
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initWorkingcopy(File wsfile, OnlineProject project, String label, SimpleTaskStatus status) {
        int n;
        int err = 0;
        if (wsfile == null) {
            return 1;
        }
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Online init_workingcopy");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        DataManager dataManager = DALLocator.getDataManager();
        JDBCServerExplorer explorer = null;
        try {
            wsfile = new File(H2SpatialUtils.removeH2FileNameExtension((String)wsfile.getAbsolutePath()));
            if (StringUtils.isBlank((CharSequence)label)) {
                label = wsfile.getName();
            }
            err = 4;
            JDBCServerExplorerParameters explorerParams = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters("H2Spatial");
            ((HasAFile)explorerParams).setFile(wsfile);
            explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParams.getProviderName(), (DataServerExplorerParameters)explorerParams);
            n = this.initWorkingcopy(explorer, project, label, status);
        }
        catch (Exception ex) {
            int n2;
            try {
                status.abort();
                LOGGER.warn("Can't init workspace in '" + wsfile.getAbsolutePath() + "'.", (Throwable)ex);
                status.message(ex.getMessage());
                n2 = err;
            }
            catch (Throwable throwable) {
                status.pop();
                DisposeUtils.disposeQuietly(explorer);
                throw throwable;
            }
            status.pop();
            DisposeUtils.disposeQuietly((Disposable)explorer);
            return n2;
        }
        status.pop();
        DisposeUtils.disposeQuietly((Disposable)explorer);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int initWorkingcopy(JDBCServerExplorer wsexplorer, OnlineProject project, String label, SimpleTaskStatus status) {
        int n;
        int err = 0;
        if (wsexplorer == null) {
            return 2;
        }
        if (StringUtils.isBlank((CharSequence)label)) {
            return 6;
        }
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Online init_workingcopy");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        LOGGER.info("Initializing workspace " + Objects.toString(wsexplorer.getParameters().toJson()).replace('\n', ' ').replaceAll("\"password\":\"[^\"]*\"", "\"password\":\"****\""));
        DataManager dataManager = DALLocator.getDataManager();
        OnlineWorkspaceImpl workspace = null;
        try {
            status.setTitle("Online init_workingcopy");
            DatabaseWorkspaceManager databaseWorkspaceManager = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)wsexplorer.getParameters());
            if (!databaseWorkspaceManager.existsTable(2)) {
                databaseWorkspaceManager.createTable(2);
            }
            if (!databaseWorkspaceManager.existsTable(0)) {
                databaseWorkspaceManager.createTable(0);
            }
            if (!databaseWorkspaceManager.existsTable(1)) {
                databaseWorkspaceManager.createTable(1);
                databaseWorkspaceManager.set("StoresRepository.id", "Online");
            }
            databaseWorkspaceManager.connect();
            FeatureType[] tables = new FeatureType[]{VarsTable.featureType(), EntitiesTable.featureType(), WorkspaceChangesTable.featureType(), RemoteChangesTable.featureType()};
            status.setRangeOfValues(0L, (long)tables.length);
            int step = 1;
            for (FeatureType table : tables) {
                status.message(table.getLabel());
                status.setCurValue((long)step++);
                err = 100 + step;
                JDBCNewStoreParameters table_params = wsexplorer.getAddParameters();
                table_params.setDefaultFeatureType((FeatureType)table.getEditable());
                String tableName = table.getTags().getString("ID");
                table_params.setTable(tableName);
                wsexplorer.add(wsexplorer.getProviderName(), (NewDataStoreParameters)table_params, false);
                JDBCStoreParameters openParams = wsexplorer.get(tableName);
                databaseWorkspaceManager.writeStoresRepositoryEntry(tableName, (DataStoreParameters)openParams);
            }
            status.setTitle("retrieving online entities");
            workspace = new OnlineWorkspaceImpl(wsexplorer, this.getCodeGenerator(), project, label);
            workspace.initialize();
            LOGGER.info("Workspace initialized " + workspace.getCode());
            this.registerWorkingcopy(workspace);
            status.terminate();
            n = 0;
            status.pop();
        }
        catch (UserCancelTaskException ex) {
            status.cancel();
            LOGGER.warn("Cancelled by user (" + this.getMessageLabel(wsexplorer) + ").", (Throwable)ex);
            status.message("Cancelled by user.");
            throw ex;
            catch (Exception ex2) {
                status.abort();
                LOGGER.warn("Can't init workspace in '" + this.getMessageLabel(wsexplorer) + "'.", (Throwable)ex2);
                status.message(ex2.getMessage());
                int n2 = err;
                return n2;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)workspace);
        return n;
        finally {
            status.pop();
            DisposeUtils.disposeQuietly(workspace);
        }
    }

    private String getMessageLabel(JDBCServerExplorer explorer) {
        return explorer.getParameters().getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnlineWorkingcopy openWorkingcopy(File wsfile) {
        if (wsfile == null) {
            return null;
        }
        JDBCServerExplorer explorer = null;
        try {
            OnlineWorkingcopy workspace;
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorerParameters explorerParams = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters("H2Spatial");
            ((HasAFile)explorerParams).setFile(wsfile);
            explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParams.getProviderName(), (DataServerExplorerParameters)explorerParams);
            OnlineWorkingcopy onlineWorkingcopy = workspace = this.openWorkingcopy(explorer);
            DisposeUtils.disposeQuietly((Disposable)explorer);
            return onlineWorkingcopy;
        }
        catch (Exception ex) {
            OnlineWorkingcopy onlineWorkingcopy = null;
            return onlineWorkingcopy;
        }
        finally {
            DisposeUtils.disposeQuietly(explorer);
        }
    }

    public OnlineWorkingcopy openWorkingcopy(JDBCServerExplorer wsexplorer) {
        if (wsexplorer == null) {
            return null;
        }
        JDBCServerExplorerParameters params = null;
        try {
            params = wsexplorer.getParameters();
            String url = params.getUrl();
            Iterator<OnlineWorkingcopyDescriptor> iterator = this.workspaces.values().iterator();
            while (iterator.hasNext()) {
                OnlineWorkingcopyDescriptorImpl value = (OnlineWorkingcopyDescriptorImpl)iterator.next();
                if (DisposeUtils.getReferences((Disposable)value) <= 0) {
                    iterator.remove();
                    continue;
                }
                if (!value.isWorkspaceInitialized() || !StringUtils.equals((CharSequence)url, (CharSequence)value.getExplorerParameters().getUrl())) continue;
                OnlineWorkingcopy workspace = value.getWorkspace();
                this.dropExpiredCaches();
                return workspace;
            }
            OnlineWorkspaceImpl workspace = new OnlineWorkspaceImpl(wsexplorer, this.getCodeGenerator(), null);
            this.registerWorkingcopy(workspace);
            this.dropExpiredCaches();
            return workspace;
        }
        catch (Exception ex) {
            LOGGER.debug("Can't get workspace from " + Objects.toString(params) + ".", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnlineWorkingcopy openWorkingcopy(File wsfile, String label) {
        if (wsfile == null) {
            return null;
        }
        JDBCServerExplorer explorer = null;
        try {
            OnlineWorkingcopy workspace;
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorerParameters explorerParams = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters("H2Spatial");
            ((HasAFile)explorerParams).setFile(wsfile);
            explorer = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParams.getProviderName(), (DataServerExplorerParameters)explorerParams);
            OnlineWorkingcopy onlineWorkingcopy = workspace = this.openWorkingcopy(explorer, label);
            DisposeUtils.disposeQuietly((Disposable)explorer);
            return onlineWorkingcopy;
        }
        catch (Exception ex) {
            OnlineWorkingcopy onlineWorkingcopy = null;
            return onlineWorkingcopy;
        }
        finally {
            DisposeUtils.disposeQuietly(explorer);
        }
    }

    public OnlineSite connectSite(URL siteurl) throws IOException {
        OnlineSiteImpl site = new OnlineSiteImpl();
        if (siteurl != null) {
            site.connect(siteurl);
        }
        return site;
    }

    public String authenticate(String urlbase, String userId, String password) {
        try {
            final MutableInt statusCode = new MutableInt();
            MutableObject token = new MutableObject();
            if (!StringUtils.endsWith((CharSequence)"/", (CharSequence)urlbase)) {
                urlbase = urlbase + "/";
            }
            URI uri = new URI(urlbase + "auth/api-token-auth/");
            int numretries = 3;
            for (int retries = 0; retries < numretries; ++retries) {
                HttpPost request = new HttpPost(uri);
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("username", userId));
                params.add(new BasicNameValuePair("password", password));
                UrlEncodedFormEntity formdata = new UrlEncodedFormEntity(params);
                request.setEntity((HttpEntity)formdata);
                request.setHeader("Content-type", "application/x-www-form-urlencoded");
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                ResponseHandler responseHandler = new ResponseHandler((Mutable)token){
                    final /* synthetic */ Mutable val$token;
                    {
                        this.val$token = mutable;
                    }

                    public Object handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                        statusCode.setValue(response.getStatusLine().getStatusCode());
                        InputStream content = response.getEntity().getContent();
                        JsonObject resp = Json.createObject((InputStream)content);
                        this.val$token.setValue((Object)resp.getString("token", null));
                        return null;
                    }
                };
                httpClient.execute((HttpUriRequest)request, responseHandler);
                if (statusCode.getValue() == 200) break;
            }
            if (statusCode.getValue() != 200) {
                LOGGER.warn("Toomany retries for authenticate (HTTP status " + statusCode.toString() + ")");
                return null;
            }
            String authorization = "JWT " + (String)token.getValue();
            return authorization;
        }
        catch (Exception ex) {
            LOGGER.warn("", (Throwable)ex);
            throw new RuntimeException("Can't get authorization from '" + urlbase + "' for user '" + userId + "'.", ex);
        }
    }

    public WorkingArea createWorkingArea() {
        return new WorkingAreaImpl();
    }

    private OnlineCodeGenerator getCodeGenerator() {
        return new RandomCodeGenerator();
    }

    public void setRemoteEntityFeatureTypeEditorMode(int value) {
        this.remoteEntityFeatureTypeEditorMode = value;
    }

    public int getRemoteEntityFeatureTypeEditorMode() {
        return this.remoteEntityFeatureTypeEditorMode;
    }

    public OnlineWorkingcopy getWorkingcopy(String code) {
        OnlineWorkingcopyDescriptor wcd = this.workspaces.get(code);
        if (wcd == null) {
            return null;
        }
        return wcd.getWorkspace();
    }

    public void registerFeatureTypeCreationListener(OnlineManager.FeatureTypeCreationListener listener) {
        this.featureTypeCreationListeners.put(listener.getName(), listener);
    }

    public EditableFeatureType configureFeatureType(OnlineLayer layer, EditableFeatureType ftype) {
        for (OnlineManager.FeatureTypeCreationListener listener : this.featureTypeCreationListeners.values()) {
            ftype = listener.configure(layer, ftype);
        }
        return ftype;
    }

    public int getMaxFeaturesPerTile() {
        return this.maxFeaturesPerTile;
    }

    public void setMaxFeaturesPerTile(int maxFeaturesPerTile) {
        this.maxFeaturesPerTile = maxFeaturesPerTile;
    }

    public boolean getContinueWhenUploadFails() {
        return this.continueWhenUploadFails;
    }

    public void setContinueWhenUploadFails(boolean continueWhenUploadFails) {
        this.continueWhenUploadFails = continueWhenUploadFails;
    }
}

