/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.json.Json;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineProject;
import org.gvsig.online.lib.impl.OnlineLayerImpl;
import org.gvsig.online.lib.impl.OnlineSiteImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;

public class OnlineProjectImpl
implements OnlineProject {
    private JsonObject data;
    private Envelope envelope = null;
    private OnlineSiteImpl site;
    private JsonObject entities_json;
    private List<OnlineLayerImpl> layers = null;
    private JsonObject projectConf;

    OnlineProjectImpl setSite(OnlineSiteImpl site) {
        this.site = site;
        return this;
    }

    public void fromJson(JsonObject data) {
        JsonObject theSite_json = data.getJsonObject("site");
        if (theSite_json != null) {
            OnlineSiteImpl theSite = new OnlineSiteImpl();
            theSite.fromJson(theSite_json);
            this.data = data.getJsonObject("project");
            this.projectConf = data.getJsonObject("projectConf");
            this.entities_json = data.getJsonObject("entities_json");
            this.site = theSite;
        } else {
            this.data = data;
        }
    }

    private JsonObject getProjectConf(SimpleTaskStatus status) {
        if (this.projectConf != null) {
            return this.projectConf;
        }
        if (status == null) {
            status = SimpleTaskStatus.FAKE_STATUS;
        }
        FileInputStream fis = null;
        try {
            I18nManager i18n = ToolsLocator.getI18nManager();
            SimpleTaskStatus.push((SimpleTaskStatus)status);
            SimpleTaskStatus.setIndeterminate((SimpleTaskStatus)status);
            SimpleTaskStatus.message((SimpleTaskStatus)status, (String)i18n.getTranslation("_Download_project_configuration"));
            URL url = this.site.getURL("api/v1/projectconf/?lang=es&projectid=" + this.getId());
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            File f = downloader.downloadFile(url, "GET", null, null, "online-project-conf.json", ICancellable.DUMB, -1, false);
            fis = new FileInputStream(f);
            JsonObject json = Json.createObject((InputStream)fis);
            this.projectConf = json.getJsonArray("projects").getJsonObject(0);
            SimpleTaskStatus.terminate((SimpleTaskStatus)status);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't download project configuration", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                SimpleTaskStatus.pop((SimpleTaskStatus)status);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        SimpleTaskStatus.pop((SimpleTaskStatus)status);
        return this.projectConf;
    }

    public org.gvsig.json.JsonObjectBuilder toJsonBuilder() {
        org.gvsig.json.JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.add("site", (JsonObjectBuilder)this.site.toJsonBuilder());
        builder.add("project", (JsonValue)this.data);
        builder.add("projectConf", (JsonValue)this.getProjectConf(SimpleTaskStatus.FAKE_STATUS));
        builder.add("entities_json", (JsonValue)this.getLayersAsJson(SimpleTaskStatus.FAKE_STATUS));
        return builder;
    }

    public int getId() {
        return this.data.getInt("id", -1);
    }

    public String getName() {
        return this.data.getString("name", null);
    }

    public String getTitle() {
        return this.data.getString("title", null);
    }

    public String getLabel() {
        if (StringUtils.isNotBlank((CharSequence)this.getTitle())) {
            return this.getTitle();
        }
        if (StringUtils.isNotBlank((CharSequence)this.getName())) {
            return this.getName();
        }
        return String.valueOf(this.getId());
    }

    public String getDescription() {
        return this.data.getString("description", null);
    }

    public Envelope getEnvelope() {
        if (this.envelope == null) {
            JsonNumber extent4326_minx = this.data.getJsonNumber("extent4326_minx");
            JsonNumber extent4326_miny = this.data.getJsonNumber("extent4326_miny");
            JsonNumber extent4326_maxx = this.data.getJsonNumber("extent4326_maxx");
            JsonNumber extent4326_maxy = this.data.getJsonNumber("extent4326_maxy");
            if (extent4326_minx == null || extent4326_miny == null || extent4326_maxx == null || extent4326_maxy == null) {
                return null;
            }
            this.envelope = GeometryUtils.createEnvelope((double)extent4326_minx.doubleValue(), (double)extent4326_miny.doubleValue(), (double)extent4326_maxx.doubleValue(), (double)extent4326_maxy.doubleValue(), (int)0);
        }
        return this.envelope;
    }

    private JsonObject getLayersAsJson(SimpleTaskStatus status) {
        if (this.entities_json == null) {
            if (this.site == null) {
                return null;
            }
            FileInputStream fis = null;
            try {
                JsonObject json;
                I18nManager i18n = ToolsLocator.getI18nManager();
                SimpleTaskStatus.push((SimpleTaskStatus)status);
                SimpleTaskStatus.setIndeterminate((SimpleTaskStatus)status);
                SimpleTaskStatus.message((SimpleTaskStatus)status, (String)i18n.getTranslation("_Download_project_layers_information"));
                URL url = this.site.getURL("/api/v1/projects/" + this.getId() + "/layers");
                DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
                File f = downloader.downloadFile(url, "GET", null, null, "online-project-layers.json", ICancellable.DUMB, -1, false);
                fis = new FileInputStream(f);
                this.entities_json = json = Json.createObject((InputStream)fis);
                SimpleTaskStatus.terminate((SimpleTaskStatus)status);
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("Can't download layers", ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    SimpleTaskStatus.pop((SimpleTaskStatus)status);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
            SimpleTaskStatus.pop((SimpleTaskStatus)status);
        }
        return this.entities_json;
    }

    public Iterable<OnlineLayer> layers() {
        return this.layers(null);
    }

    public Iterable<OnlineLayer> layers(final SimpleTaskStatus status) {
        final OnlineProjectImpl theProject = this;
        Iterable<OnlineLayer> iterable = new Iterable<OnlineLayer>(){

            @Override
            public Iterator<OnlineLayer> iterator() {
                JsonArray layers = OnlineProjectImpl.this.getLayersAsJson(status).getJsonArray("content");
                final Iterator it = layers.iterator();
                return new Iterator<OnlineLayer>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public OnlineLayer next() {
                        JsonObject layer_json = (JsonObject)it.next();
                        JsonObject layerConf = OnlineProjectImpl.this.getLayerConf(layer_json.getInt("id", -1));
                        return new OnlineLayerImpl(theProject, layer_json, layerConf);
                    }
                };
            }
        };
        return iterable;
    }

    public OnlineLayerImpl getLayer(Predicate<OnlineLayer> filter, SimpleTaskStatus status) {
        for (OnlineLayerImpl layer : this.getLayers(status)) {
            if (!filter.test(layer)) continue;
            return layer;
        }
        return null;
    }

    private List<OnlineLayerImpl> getLayers(SimpleTaskStatus status) {
        if (this.layers == null) {
            ArrayList<OnlineLayerImpl> l = new ArrayList<OnlineLayerImpl>();
            JsonArray jsonLayers = this.getLayersAsJson(status).getJsonArray("content");
            for (JsonValue layer0 : jsonLayers) {
                JsonObject layer1 = (JsonObject)layer0;
                JsonObject layerConf = this.getLayerConf(layer1.getInt("id", -1));
                OnlineLayerImpl layer = new OnlineLayerImpl(this, layer1, layerConf);
                l.add(layer);
            }
            this.layers = l;
        }
        return this.layers;
    }

    private JsonObject getLayerConf(int layerId) {
        JsonArray groups = this.getProjectConf(null).getJsonArray("layer_groups");
        for (JsonValue group0 : groups) {
            JsonObject group = (JsonObject)group0;
            JsonArray layers = group.getJsonArray("layers");
            for (JsonValue layer0 : layers) {
                JsonObject layer = (JsonObject)layer0;
                if (layer.getInt("id", -1) != layerId) continue;
                return layer;
            }
        }
        return null;
    }

    public OnlineSiteImpl getSite() {
        return this.site;
    }

    public String getConfigTableName() {
        return "GVSIGD_CONFIG_" + this.getId();
    }

    public String getResourcesTablaName() {
        return "GVSIGD_RESOURCES_" + this.getId();
    }

    public String getRepositoryTableName() {
        return "GVSIGD_REPOSITORY_" + this.getId();
    }

    public OnlineLayer getConfigTable(SimpleTaskStatus status) {
        return this.getLayer(t -> StringUtils.equalsIgnoreCase((CharSequence)t.getName(), (CharSequence)this.getConfigTableName()), status);
    }

    public OnlineLayer getResourcesTable(SimpleTaskStatus status) {
        return this.getLayer(t -> StringUtils.equalsIgnoreCase((CharSequence)t.getName(), (CharSequence)this.getResourcesTablaName()), status);
    }

    public OnlineLayer getRepositoryTable(SimpleTaskStatus status) {
        return this.getLayer(t -> StringUtils.equalsIgnoreCase((CharSequence)t.getName(), (CharSequence)this.getRepositoryTableName()), status);
    }

    public static void selfRegister() {
        Json.registerSerializer(OnlineProjectImpl.class);
    }
}

