/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderAuthenticationRequester;
import org.gvsig.downloader.DownloaderCredentials;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineProject;
import org.gvsig.online.lib.api.OnlineSite;
import org.gvsig.online.lib.impl.OnlineLayerImpl;
import org.gvsig.online.lib.impl.OnlineProjectImpl;
import org.gvsig.online.lib.impl.OnlineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineSiteImpl
implements OnlineSite {
    private static Logger LOGGER = LoggerFactory.getLogger(OnlineSiteImpl.class);
    private List<JsonValue> projects_json;
    private JsonObject platforminfo;
    private Map<String, OnlineLayer> publicLayers;
    private URL urlbase;

    public OnlineSiteImpl() {
        this.clear();
    }

    public OnlineSiteImpl(URL url) {
        this();
        this.urlbase = url;
    }

    public final void clear() {
        this.urlbase = null;
        this.projects_json = null;
        this.publicLayers = null;
    }

    public void connect() throws IOException {
        this.connect(this.urlbase);
    }

    public void connect(URL url) throws IOException {
        InputStream fis = null;
        try {
            this.urlbase = url;
            this.projects_json = null;
            this.publicLayers = null;
            this.projects_json = this.getProjects();
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
    }

    public URL getBaseUrl() {
        return this.urlbase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JsonValue> getProjects() {
        if (this.projects_json != null) {
            return this.projects_json;
        }
        FileInputStream fis = null;
        try {
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            File f = downloader.downloadFile(this.getURL("/api/v1/projects/"), "GET", null, null, "online-site-projects.json", ICancellable.DUMB, -1, false);
            fis = new FileInputStream(f);
            JsonObject json = Json.createObject((InputStream)fis);
            this.projects_json = json.getJsonArray("content");
            List<JsonValue> list = this.projects_json;
            IOUtils.closeQuietly((InputStream)fis);
            return list;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve project list.", (Throwable)ex);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
    }

    public Iterable<OnlineProject> projects() {
        final OnlineSiteImpl site = this;
        return new Iterable<OnlineProject>(){

            @Override
            public Iterator<OnlineProject> iterator() {
                Iterator<OnlineProject> it = new Iterator<OnlineProject>(){
                    Iterator<JsonValue> jsonit;
                    {
                        this.jsonit = OnlineSiteImpl.this.getProjects().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.jsonit.hasNext();
                    }

                    @Override
                    public OnlineProjectImpl next() {
                        JsonObject jsonproject = (JsonObject)this.jsonit.next();
                        OnlineProjectImpl project = new OnlineProjectImpl().setSite(site);
                        project.fromJson(jsonproject);
                        return project;
                    }
                };
                return it;
            }
        };
    }

    public OnlineProjectImpl getProject(String name) {
        for (JsonValue project0 : this.getProjects()) {
            JsonObject project = (JsonObject)project0;
            if (!StringUtils.equals((CharSequence)project.getString("name", null), (CharSequence)name)) continue;
            OnlineProjectImpl p = new OnlineProjectImpl().setSite(this);
            p.fromJson(project);
            return p;
        }
        return null;
    }

    public OnlineProjectImpl getProject(int id) {
        for (JsonValue project0 : this.getProjects()) {
            JsonObject project = (JsonObject)project0;
            if (project.getInt("id", -1) != id) continue;
            OnlineProjectImpl p = new OnlineProjectImpl().setSite(this);
            p.fromJson(project);
            return p;
        }
        return null;
    }

    public Map<String, OnlineLayer> getPublicLayers() {
        if (this.publicLayers == null) {
            FileInputStream fis = null;
            try {
                DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
                File f = downloader.downloadFile(new URL(this.urlbase.toString() + "/api/v1/layers/"), "GET", null, null, "online-site-layers", ICancellable.DUMB, -1, false);
                fis = new FileInputStream(f);
                JsonObject json = Json.createObject((InputStream)fis);
                this.publicLayers = new HashMap<String, OnlineLayer>();
                for (JsonValue layer_json : json.getJsonArray("content")) {
                    OnlineLayerImpl layer = new OnlineLayerImpl(this, (JsonObject)layer_json);
                    this.publicLayers.put(String.valueOf(layer.getId()), layer);
                }
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("Can't download layers from " + this.urlbase, ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        return this.publicLayers;
    }

    public boolean isPublicLayer(OnlineLayer layer) {
        return this.getPublicLayers().containsKey(String.valueOf(layer.getId()));
    }

    public void fromJson(JsonObject json) {
        try {
            URL url;
            this.clear();
            this.urlbase = url = (URL)Json.toObject((JsonObject)json, (String)"url");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("url is required", ex);
        }
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("url", (Object)this.urlbase);
        return builder;
    }

    public URL getURL(String s) {
        return OnlineUtils.getURL(this.urlbase, s);
    }

    public URL getGeoserverURL(String s) {
        try {
            String base_s = StringUtils.removeEnd((String)this.urlbase.toString(), (String)"/");
            base_s = StringUtils.left((String)base_s, (int)StringUtils.lastIndexOf((CharSequence)base_s, (int)47));
            if (StringUtils.startsWith((CharSequence)s, (CharSequence)"/")) {
                return new URL(base_s + "/geoserver" + s);
            }
            return new URL(base_s + "/geoserver/" + s);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't get geoserver URL", ex);
        }
    }

    public void logout() {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        downloader.removeCredentials(this.getBaseUrl().toExternalForm());
    }

    public DownloaderCredentials getCredentials() {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        DownloaderCredentials credentials = downloader.getCredentials(this.urlbase);
        if (credentials != null) {
            return credentials;
        }
        DownloaderAuthenticationConfig config = downloader.getAuthenticationConfigurationService(this.urlbase.toExternalForm());
        if (config == null) {
            return null;
        }
        DownloaderAuthenticationRequester requester = config.create();
        if (!requester.requestAuthorization()) {
            return null;
        }
        return requester.getCredentials();
    }
}

