/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.json.JsonObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineManager;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineEntityEditable;
import org.gvsig.online.lib.impl.workspace.OnlineWorkspaceImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.MapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineUtils.class);
    public static final String ENTITY_CODE = "EntityCode";
    public static final String ENTITY_NAME = "EntityName";
    public static final String ENTITY_DESCRIPTION = "Description";
    public static final String ENTITY_FEATUREIDFIELDNAME = "FeatureIdFieldName";
    public static final String ENTITY_FEATURETYPEASJSON = "FeatureTypeAsJson";
    public static final String ENTITY_FIELDFORLABEL = "FieldForLabel";
    public static final String ENTITY_GEOMETRYFIELDNAME = "GeometryFieldName";
    public static final String ENTITY_LABEL = "Label";
    public static final String ENTITY_DATA_MODELS = "DataModels";
    public static final String ENTITY_CRS = "CRS";
    public static final String ENTITY_CUSTOMDATA = "customdata";
    private static final Map<Integer, String> ERRMSGS = new MapBuilder().add((Object)19, (Object)"_Cant_authenticate_user").add((Object)20, (Object)"_Invalid_authentication_token").add((Object)21, (Object)"_User_not_authorized").add((Object)22, (Object)"_Authentication_expired").add((Object)23, (Object)"_Invalid_user_code").build();
    private static final Map<Integer, String> OPERATION_LABELS = new MapBuilder().add((Object)0, (Object)"Delete").add((Object)1, (Object)"Update").add((Object)2, (Object)"Insert").build();
    private static final Map<Integer, String> STATE_LABELS = new MapBuilder().add((Object)1, (Object)"Unmodified").add((Object)2, (Object)"New").add((Object)4, (Object)"Modified").add((Object)6, (Object)"Outdated").add((Object)8, (Object)"Outdated and modified").add((Object)16, (Object)"Conflict").add((Object)128, (Object)"Disconnected").build();
    private static final Map<String, Map<String, Template>> SQL_TEMPLATES_BY_PROVIDER = new HashMap<String, Map<String, Template>>();

    public static String getErrorMessage(int errcode) {
        String msg = ERRMSGS.get(errcode);
        msg = ToolsLocator.getI18nManager().getTranslation(msg);
        return msg;
    }

    public static void copy(OnlineEntity source, OnlineEntityEditable target, Predicate<String> excludes) {
        if (excludes == null || !excludes.test(ENTITY_DESCRIPTION)) {
            target.setDescription(source.getDescription());
        }
        if (excludes == null || !excludes.test(ENTITY_CODE)) {
            target.setEntityCode(source.getEntityCode());
        }
        if (excludes == null || !excludes.test(ENTITY_NAME)) {
            target.setEntityName(source.getEntityName());
        }
        if (excludes == null || !excludes.test(ENTITY_FEATUREIDFIELDNAME)) {
            target.setFeatureIdFieldName(source.getFeatureIdFieldName());
        }
        if (excludes == null || !excludes.test(ENTITY_FEATURETYPEASJSON)) {
            target.setFeatureTypeAsJson(source.getFeatureTypeAsJson());
        }
        if (excludes == null || !excludes.test(ENTITY_FIELDFORLABEL)) {
            target.setFieldForLabel(source.getFieldForLabel());
        }
        if (excludes == null || !excludes.test(ENTITY_GEOMETRYFIELDNAME)) {
            target.setGeometryFieldName(source.getGeometryFieldName());
        }
        if (excludes == null || !excludes.test(ENTITY_LABEL)) {
            target.setLabel(source.getLabel());
        }
        if (excludes == null || !excludes.test(ENTITY_DATA_MODELS)) {
            target.setDataModels(source.getDataModels());
        }
        if (excludes == null || !excludes.test(ENTITY_CRS)) {
            target.setCRS(source.getCRS());
        }
    }

    public static JsonObjectBuilder toJsonBuilder(OnlineEntity entity, Predicate<String> excludes) {
        JsonObjectBuilder jsonEntity = Json.createObjectBuilder();
        if (excludes == null || !excludes.test(ENTITY_DESCRIPTION)) {
            jsonEntity.add(ENTITY_DESCRIPTION, entity.getDescription());
        }
        if (excludes == null || !excludes.test(ENTITY_CODE)) {
            jsonEntity.add(ENTITY_CODE, entity.getEntityCode());
        }
        if (excludes == null || !excludes.test(ENTITY_NAME)) {
            jsonEntity.add(ENTITY_NAME, entity.getEntityName());
        }
        if (excludes == null || !excludes.test(ENTITY_FEATUREIDFIELDNAME)) {
            jsonEntity.add(ENTITY_FEATUREIDFIELDNAME, entity.getFeatureIdFieldName());
        }
        if (excludes == null || !excludes.test(ENTITY_FEATURETYPEASJSON)) {
            jsonEntity.add(ENTITY_FEATURETYPEASJSON, entity.getFeatureTypeAsJson());
        }
        if (excludes == null || !excludes.test(ENTITY_FIELDFORLABEL)) {
            jsonEntity.add(ENTITY_FIELDFORLABEL, entity.getFieldForLabel());
        }
        if (excludes == null || !excludes.test(ENTITY_GEOMETRYFIELDNAME)) {
            jsonEntity.add(ENTITY_GEOMETRYFIELDNAME, entity.getGeometryFieldName());
        }
        if (excludes == null || !excludes.test(ENTITY_LABEL)) {
            jsonEntity.add(ENTITY_LABEL, entity.getLabel());
        }
        if (excludes == null || !excludes.test(ENTITY_DATA_MODELS)) {
            jsonEntity.add(ENTITY_DATA_MODELS, entity.getDataModels());
        }
        if (!(excludes != null && excludes.test(ENTITY_CRS) || entity.getCRS() == null)) {
            jsonEntity.add(ENTITY_CRS, entity.getCRS());
        }
        if ((excludes == null || !excludes.test(ENTITY_CUSTOMDATA)) && StringUtils.isNotBlank((CharSequence)entity.getCustomData())) {
            jsonEntity.add(ENTITY_CUSTOMDATA, entity.getCustomData());
        }
        return jsonEntity;
    }

    public static void fromJson(OnlineEntityEditable entity, JsonObject jsonEntity) {
        if (jsonEntity.containsKey((Object)ENTITY_DESCRIPTION)) {
            entity.setDescription(jsonEntity.getString(ENTITY_DESCRIPTION, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_CODE)) {
            entity.setEntityCode(jsonEntity.getString(ENTITY_CODE, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_NAME)) {
            entity.setEntityName(jsonEntity.getString(ENTITY_NAME, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_FEATUREIDFIELDNAME)) {
            entity.setFeatureIdFieldName(jsonEntity.getString(ENTITY_FEATUREIDFIELDNAME, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_FEATURETYPEASJSON)) {
            entity.setFeatureTypeAsJson(jsonEntity.getString(ENTITY_FEATURETYPEASJSON, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_FIELDFORLABEL)) {
            entity.setFieldForLabel(jsonEntity.getString(ENTITY_FIELDFORLABEL, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_GEOMETRYFIELDNAME)) {
            entity.setGeometryFieldName(jsonEntity.getString(ENTITY_GEOMETRYFIELDNAME, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_LABEL)) {
            entity.setLabel(jsonEntity.getString(ENTITY_LABEL, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_DATA_MODELS)) {
            entity.setDataModels(jsonEntity.getString(ENTITY_DATA_MODELS, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_CRS)) {
            entity.setCRS(jsonEntity.getString(ENTITY_CRS, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_CUSTOMDATA)) {
            entity.setCustomData(jsonEntity.getString(ENTITY_CUSTOMDATA, null));
        }
    }

    public static String getOperationLabel(int operation) {
        return OPERATION_LABELS.getOrDefault(operation, "unknown");
    }

    public static String getStateLabel(int state) {
        return STATE_LABELS.getOrDefault(state, "unknown");
    }

    private static Map<String, Template> getSqlTemplates(String name) {
        List lines;
        boolean SEARCHING_ITEM = false;
        boolean READING_ITEM = true;
        InputStream sqls = OnlineUtils.class.getResourceAsStream("/org/gvsig/online/lib/" + name + ".sql");
        HashMap<String, Template> expecteds = new HashMap<String, Template>();
        try {
            lines = IOUtils.readLines((InputStream)sqls);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't read sql templates for provider " + name, ex);
        }
        StringBuilder sb = null;
        Template currentItem = null;
        int lineno = 1;
        int state = 0;
        for (String line : lines) {
            line = line + "\n";
            switch (state) {
                case 0: {
                    if (line.toLowerCase().startsWith("@begin ")) {
                        currentItem = new Template(line.substring(7).trim());
                        sb = new StringBuilder();
                        state = 1;
                        break;
                    }
                    if (line.toLowerCase().startsWith("-- ") || line.toLowerCase().startsWith("@rem") || StringUtils.isBlank((CharSequence)line)) break;
                    throw new IllegalStateException("Syntax error at '" + name + "', line " + lineno + ".");
                }
                case 1: {
                    if (line.toLowerCase().startsWith("@end ")) {
                        String found = line.substring(5).trim();
                        if (!StringUtils.equals((CharSequence)currentItem.getName(), (CharSequence)found)) {
                            throw new IllegalStateException("Syntax error at '" + name + "', line " + lineno + ", expected @end " + currentItem.getName() + ", and found " + line + ".");
                        }
                        String s = sb.toString();
                        if (s.endsWith("\n")) {
                            s = s.substring(0, s.length() - 1);
                        }
                        currentItem.setCode(s);
                        expecteds.put(currentItem.getName(), currentItem);
                        state = 0;
                        break;
                    }
                    if (line.toLowerCase().startsWith("-- ") || line.toLowerCase().startsWith("@rem")) break;
                    if (line.toLowerCase().startsWith("@param ")) {
                        currentItem.addParameter(line.substring(7).trim());
                        break;
                    }
                    if (line.toLowerCase().startsWith("@const ")) {
                        String s = line.substring(7).trim();
                        String[] ss = StringUtils.split((String)s, (String)"=");
                        currentItem.addConstant(ss[0].trim(), ss[1].trim());
                        break;
                    }
                    sb.append(line);
                }
            }
            ++lineno;
        }
        if (state != 0) {
            throw new IllegalStateException("Syntax error at '" + name + "', expected @end " + currentItem.getName() + " and found EOF .");
        }
        return expecteds;
    }

    public static String getSqlTemplate(String providerName, String sqlId, Object ... args) {
        Template template;
        if (SQL_TEMPLATES_BY_PROVIDER.get(providerName) == null) {
            SQL_TEMPLATES_BY_PROVIDER.put(providerName, OnlineUtils.getSqlTemplates(providerName));
        }
        if ((template = SQL_TEMPLATES_BY_PROVIDER.get(providerName).get(sqlId)) == null) {
            return null;
        }
        return template.getCode(args);
    }

    public static void updateMessageDigest(MessageDigest md, Feature f, String fieldName) {
        String s = f.getString(fieldName);
        if (s != null) {
            md.update(s.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static String getFirst(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            String[] ss = StringUtils.split((String)s, (String)",");
            if (ss.length < 1) {
                return null;
            }
            return ss[0];
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<String> getAsList(String s) {
        return OnlineUtils.getAsList(s, true);
    }

    public static List<String> getAsList(String s, boolean toLowerCase) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return Collections.EMPTY_LIST;
        }
        try {
            String[] ss;
            ArrayList<String> l = new ArrayList<String>();
            for (String s1 : ss = StringUtils.split((String)s, (String)",")) {
                if (StringUtils.isBlank((CharSequence)s1)) continue;
                if (toLowerCase) {
                    l.add(s1.trim().toLowerCase());
                    continue;
                }
                l.add(s1.trim());
            }
            return l;
        }
        catch (Exception ex) {
            return Collections.EMPTY_LIST;
        }
    }

    public static String getLabelOrName(OnlineEntity entity) {
        String label = entity.getLabel();
        if (StringUtils.isBlank((CharSequence)label)) {
            label = entity.getEntityName();
        }
        return label;
    }

    public static String getFormatedLabel(final OnlineEntity entity, String template) {
        try {
            StringSubstitutor sub = new StringSubstitutor(new StringLookup(){

                public String lookup(String key) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)"label", (CharSequence)key)) {
                        return entity.getLabel();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)key)) {
                        return entity.getEntityName();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"code", (CharSequence)key)) {
                        return entity.getEntityCode();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"datamodels", (CharSequence)key)) {
                        return entity.getDataModels();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"description", (CharSequence)key)) {
                        return entity.getDescription();
                    }
                    return "";
                }
            });
            String s = sub.replace(template);
            if (StringUtils.isBlank((CharSequence)s)) {
                s = OnlineUtils.getLabelOrName(entity);
            }
            return s;
        }
        catch (Throwable th) {
            return OnlineUtils.getLabelOrName(entity);
        }
    }

    public static URL getURL(URL base, String s) {
        return OnlineUtils.getURL(base.toString(), s);
    }

    public static URL getURL(String base, String s) {
        try {
            String base_s = StringUtils.removeEnd((String)base.toString(), (String)"/");
            if (StringUtils.startsWith((CharSequence)s, (CharSequence)"/")) {
                return new URL(base_s + s);
            }
            return new URL(base_s + "/" + s);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Can't get URL", ex);
        }
    }

    public static OnlineLayer getOnlineLayer(FeatureStore store) {
        OnlineManager manager = OnlineLocator.getOnlineManager();
        OnlineWorkspaceImpl wc = (OnlineWorkspaceImpl)manager.getWorkingcopy(store);
        return OnlineUtils.getOnlineLayer(wc, store);
    }

    public static OnlineLayer getOnlineLayer(OnlineWorkspaceImpl workspace, FeatureStore store) {
        OnlineEntity entity = workspace.getEntity(store.getName());
        return workspace.getLayer(entity, SimpleTaskStatus.FAKE_STATUS);
    }

    private static class Template {
        List<String> parameters;
        Map<String, String> constants;
        String code;
        String name;

        public Template(String name) {
            this.name = name;
            this.parameters = new ArrayList<String>();
            this.constants = new HashMap<String, String>();
            this.code = null;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void addParameter(String parameter) {
            this.parameters.add(parameter);
        }

        public void addConstant(String name, String value) {
            this.constants.put(name, value);
        }

        public String getName() {
            return this.name;
        }

        public String getCode(Object ... params) {
            if (this.parameters.isEmpty()) {
                return String.format(this.code, params);
            }
            String s = this.code;
            for (int i = 0; i < this.parameters.size(); ++i) {
                s = s.replace("%" + this.parameters.get(i) + "$", "%" + (i + 1) + "$");
            }
            for (Map.Entry<String, String> entry : this.constants.entrySet()) {
                String cname = entry.getKey();
                String cvalue = entry.getValue();
                s = s.replace("%" + cname + "$s", cvalue);
            }
            if (ArrayUtils.isEmpty((Object[])params)) {
                return s;
            }
            s = String.format(s, params);
            return s;
        }

        public String toString() {
            return this.name;
        }
    }
}

