/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.UserCancelTaskException;

public class TilesCalculator {
    private GeometryManager geometryManager;

    private double getArea(Envelope env) throws GeometryOperationNotSupportedException, GeometryOperationException {
        return env.getGeometry().area();
    }

    private GeometryManager getGeometryManager() {
        if (this.geometryManager == null) {
            this.geometryManager = GeometryLocator.getGeometryManager();
        }
        return this.geometryManager;
    }

    private Envelope[] getNextLevel(Envelope env) throws CreateEnvelopeException {
        double with = env.getLength(0) / 2.0;
        double height = env.getLength(1) / 2.0;
        Envelope[] envs = new Envelope[]{this.getGeometryManager().createEnvelope(env.getMinimum(0), env.getMinimum(1), env.getMinimum(0) + with, env.getMinimum(1) + height, 0), this.getGeometryManager().createEnvelope(env.getMinimum(0), env.getMinimum(1) + height, env.getMinimum(0) + with, env.getMaximum(1), 0), this.getGeometryManager().createEnvelope(env.getMinimum(0) + with, env.getMinimum(1), env.getMaximum(0), env.getMinimum(1) + height, 0), this.getGeometryManager().createEnvelope(env.getMinimum(0) + with, env.getMinimum(1) + height, env.getMaximum(0), env.getMaximum(1), 0)};
        return envs;
    }

    private Dimension getDimension(Envelope env) throws GeometryOperationNotSupportedException, GeometryOperationException {
        double area = this.getArea(env);
        int cellSize = (int)Math.sqrt(area);
        return new Dimension(cellSize, cellSize);
    }

    public Dimension calculateCellSize(CalculatorData data) {
        return this.calculateCellSize(data, 1000L, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Dimension calculateCellSize(CalculatorData data, long maxElementsByCell, SimpleTaskStatus status) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Calculating_cell_size"));
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        try {
            status.setIndeterminate();
            status.setCurValue(0L);
            Envelope curEnvelope = data.getEnvelope();
            long totalElements = data.getElements(curEnvelope);
            if (totalElements <= 0L) {
                Dimension dimension = new Dimension(-1, -1);
                return dimension;
            }
            if (totalElements < maxElementsByCell) {
                int n;
                status.terminate();
                Dimension dim = this.getDimension(curEnvelope);
                double tileArea = Math.pow(dim.height, 2.0) * (double)maxElementsByCell;
                dim.height = n = (int)Math.sqrt(tileArea);
                dim.width = n;
                Dimension dimension = dim;
                return dimension;
            }
            while (true) {
                if (status.isCancellationRequested()) {
                    status.cancel();
                    throw new UserCancelTaskException();
                }
                long maxElements = 0L;
                Envelope maxElementsEnvelope = null;
                for (Envelope envelope : this.getNextLevel(curEnvelope)) {
                    long numElements = data.getElements(envelope);
                    if (maxElements >= numElements) continue;
                    maxElements = numElements;
                    maxElementsEnvelope = envelope;
                }
                if (maxElements > 0L && maxElements <= maxElementsByCell) {
                    status.terminate();
                    Dimension dimension = this.getDimension(maxElementsEnvelope);
                    return dimension;
                }
                curEnvelope = maxElementsEnvelope;
                continue;
                break;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Can't calculate grid cell size", t);
        }
        finally {
            status.pop();
        }
    }

    private Cell calculateCell(int cellSize, double x, double y) {
        int cellx = (int)(x / (double)cellSize);
        int celly = (int)(y / (double)cellSize);
        return new Cell(cellx, celly);
    }

    private List<Cell> calculateCell(int cellSize, Geometry geom) {
        Envelope geomenv = geom.getEnvelope();
        Cell upperLeftCell = this.calculateCell(cellSize, geomenv.getMinimum(0), geomenv.getMinimum(1));
        Cell bottomRightCell = this.calculateCell(cellSize, geomenv.getMaximum(0), geomenv.getMaximum(1));
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int i = upperLeftCell.col; i <= bottomRightCell.col; ++i) {
            for (int j = upperLeftCell.row; j <= bottomRightCell.row; ++j) {
                cells.add(new Cell(i, j));
            }
        }
        return cells;
    }

    private List<Cell> calculateCells(int cellSize, Iterator<Geometry> geoms) {
        HashSet<Cell> cells = new HashSet<Cell>();
        while (geoms.hasNext()) {
            Geometry g = geoms.next();
            if (g == null) continue;
            cells.addAll(this.calculateCell(cellSize, g));
        }
        ArrayList<Cell> orderedCells = new ArrayList<Cell>(cells);
        Collections.sort(orderedCells);
        return orderedCells;
    }

    private void joinCells(List<Cell> orderedCells) {
        for (Cell cell1 : orderedCells) {
            if (cell1.removed) continue;
            for (Cell cell2 : orderedCells) {
                if (cell2.removed || !cell1.canSpanCol(cell2)) continue;
                ++cell1.colspan;
                cell2.removed = true;
            }
        }
        for (Cell cell1 : orderedCells) {
            if (cell1.removed) continue;
            for (Cell cell2 : orderedCells) {
                if (cell2.removed || !cell1.canSpanRow(cell2)) continue;
                ++cell1.rowspan;
                cell2.removed = true;
            }
        }
    }

    public List<Envelope> calculateEnvelopes(int cellSize, List<Geometry> geoms) {
        if (cellSize <= 0) {
            return Collections.EMPTY_LIST;
        }
        return this.calculateEnvelopes(cellSize, geoms.iterator());
    }

    public List<Envelope> calculateEnvelopes(int cellSize, Iterator<Geometry> geoms) {
        if (cellSize <= 0) {
            return Collections.EMPTY_LIST;
        }
        try {
            List<Cell> orderedCells = this.calculateCells(cellSize, geoms);
            this.joinCells(orderedCells);
            ArrayList<Envelope> envs = new ArrayList<Envelope>();
            for (Cell cell : orderedCells) {
                if (cell.removed) continue;
                envs.add(cell.getEnvelope(cellSize));
            }
            return envs;
        }
        catch (Throwable t) {
            throw new RuntimeException("Can't calculate envelops of geometries", t);
        }
    }

    public static void main(String[] args) {
        new DefaultLibrariesInitializer().fullInitialize();
        final Geometry[] elements = new Geometry[]{GeometryUtils.createFrom((String)"LINESTRING (720 120, 760 150)"), GeometryUtils.createFrom((String)"LINESTRING (820 120, 860 150)"), GeometryUtils.createFrom((String)"LINESTRING (820 220, 860 250)"), GeometryUtils.createFrom((String)"LINESTRING (720 320, 760 350)"), GeometryUtils.createFrom((String)"LINESTRING ( 50 650, 250 650)"), GeometryUtils.createFrom((String)"LINESTRING (450 650, 650 650)"), GeometryUtils.createFrom((String)"LINESTRING ( 50 750, 250 750)")};
        CalculatorData data = new CalculatorData(){

            @Override
            public Envelope getEnvelope() {
                return GeometryUtils.createEnvelope((double)0.0, (double)0.0, (double)1000.0, (double)1000.0, (int)0);
            }

            @Override
            public double getWidth() {
                return 1000.0;
            }

            @Override
            public double getHeight() {
                return 1000.0;
            }

            @Override
            public long getElements(Envelope envelope) {
                int n = 0;
                for (Geometry geom : elements) {
                    if (!envelope.intersects(geom)) continue;
                    ++n;
                }
                return n;
            }
        };
        TilesCalculator calculator = new TilesCalculator();
        Dimension dim = calculator.calculateCellSize(data, 1L, null);
        System.out.println(dim.width + ", " + dim.height);
        System.out.println("Celdas con elementos:");
        List<Cell> cells = calculator.calculateCells(100, Arrays.asList(elements).iterator());
        for (Cell cell : cells) {
            System.out.println(cell);
        }
        System.out.println("Celdas con elementos conm los join:");
        calculator.joinCells(cells);
        for (Cell cell : cells) {
            System.out.println(cell);
        }
    }

    private class Cell
    implements Comparable<Cell> {
        int col;
        int row;
        int colspan;
        int rowspan;
        boolean removed;

        public Cell(int col, int row) {
            this.col = col;
            this.row = row;
            this.removed = false;
        }

        public boolean canSpanCol(Cell other) {
            return this.row == other.row && this.col + this.colspan + 1 == other.col && this.rowspan == other.rowspan;
        }

        public boolean canSpanRow(Cell other) {
            return this.col == other.col && this.row + this.rowspan + 1 == other.row && this.colspan == other.colspan;
        }

        @Override
        public int compareTo(Cell other) {
            int r = Integer.compare(this.row, other.row);
            if (r == 0) {
                r = Integer.compare(this.col, other.col);
            }
            return r;
        }

        public Envelope getEnvelope(int cellsize) throws CreateEnvelopeException {
            Envelope env = TilesCalculator.this.getGeometryManager().createEnvelope((double)(cellsize * this.col), (double)(cellsize * this.row), (double)(cellsize * (this.col + this.colspan + 1)), (double)(cellsize * (this.row + this.rowspan + 1)), 0);
            return env;
        }

        public String toString() {
            return "row:" + this.row + ",col:" + this.col + ",colspan:" + this.colspan + ",rowspan:" + this.rowspan + ",removed:" + this.removed;
        }

        public boolean equals(Object other0) {
            if (!(other0 instanceof Cell)) {
                return false;
            }
            Cell other = (Cell)other0;
            return this.col == other.col && this.row == other.row && this.colspan == other.colspan && this.rowspan == other.rowspan;
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            return builder.append(this.getClass().hashCode()).append(this.col).append(this.row).append(this.colspan).append(this.rowspan).toHashCode();
        }
    }

    public static interface CalculatorData {
        public Envelope getEnvelope();

        public double getWidth();

        public double getHeight();

        public long getElements(Envelope var1);
    }
}

