/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl.workspace;

import java.lang.ref.WeakReference;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.downloader.DownloaderCredentials;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineManager;
import org.gvsig.online.lib.impl.OnlineUtils;
import org.gvsig.online.lib.impl.workspace.OnlineWorkspaceImpl;
import org.gvsig.online.lib.impl.workspace.tables.EntitiesTable;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableInfo;
import org.gvsig.tools.dispose.DisposableManager;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureStoreObserver
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureStoreObserver.class);
    private OnlineManager manager = null;
    private static final List<Pair<WeakReference<FeatureStore>, Integer>> inediting_list = new ArrayList<Pair<WeakReference<FeatureStore>, Integer>>();

    private OnlineManager getManager() {
        if (this.manager == null) {
            this.manager = OnlineLocator.getOnlineManager();
        }
        return this.manager;
    }

    private OnlineWorkspaceImpl getWorkspace(FeatureStore store) {
        return (OnlineWorkspaceImpl)this.getManager().getWorkingcopy(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(Observable observable, Object notification) {
        FeatureStoreNotification n;
        OnlineWorkspaceImpl workspace;
        block47: {
            block45: {
                block46: {
                    workspace = null;
                    try {
                        FeatureStore store;
                        if (!(notification instanceof EditingNotification)) break block45;
                        EditingNotification n2 = (EditingNotification)notification;
                        if (!n2.getType().equals("BEFORE_INSERT_FEATURE") || (workspace = this.getWorkspace(store = n2.getFeatureStore())) == null) break block46;
                        OnlineLayer layer = OnlineUtils.getOnlineLayer(workspace, store);
                        Feature feature = n2.getFeature();
                        if (!StringUtils.isBlank((CharSequence)feature.getString(layer.getFeatureCodeFieldName())) || !(feature instanceof EditableFeature)) break block46;
                        FeatureType featType = store.getDefaultFeatureTypeQuietly();
                        ((EditableFeature)feature).set(layer.getFeatureCodeFieldName(), workspace.createUniqueCode(store.getName(), layer.getFeatureCodeType()));
                        FeatureAttributeDescriptor attr = featType.getAttributeDescriptor("feat_date_gvol");
                        if (attr != null && !attr.allowNull()) {
                            ((EditableFeature)feature).set("feat_date_gvol", (Object)new Timestamp(System.currentTimeMillis()));
                        }
                        if ((attr = featType.getAttributeDescriptor("feat_version_gvol")) != null && !attr.allowNull()) {
                            ((EditableFeature)feature).set("feat_version_gvol", (Object)1);
                        }
                        if ((attr = featType.getAttributeDescriptor("modified_by")) != null && !attr.allowNull()) {
                            DownloaderCredentials credentials = workspace.getSite().getCredentials();
                            ((EditableFeature)feature).set("modified_by", (Object)(credentials == null ? null : credentials.getUserid()));
                        }
                        if ((attr = featType.getAttributeDescriptor("last_modification")) == null || attr.allowNull()) break block46;
                        ((EditableFeature)feature).set("last_modification", (Object)new Timestamp(System.currentTimeMillis()));
                    }
                    catch (Throwable throwable) {
                        DisposeUtils.disposeQuietly(workspace);
                        throw throwable;
                    }
                }
                DisposeUtils.disposeQuietly(workspace);
                return;
            }
            n = (FeatureStoreNotification)notification;
            if (n != null) break block47;
            DisposeUtils.disposeQuietly(workspace);
            return;
        }
        FeatureStore store = (FeatureStore)n.getSource();
        switch (n.getType()) {
            case "after_Open_DataStore": {
                workspace = this.getWorkspace(store);
                if (workspace == null) break;
                int featureEditMode = this.getManager().getRemoteEntityFeatureTypeEditorMode();
                switch (featureEditMode) {
                    case 1: {
                        store.setProperty("DAL.featureTypeEditMode.msg", (Object)"_The_table_is_a_remote_gvSIG_Online_table_The_changes_you_make_will_be_lost_next_download_it");
                        break;
                    }
                    case 0: {
                        store.setProperty("DAL.featureTypeEditMode.msg", (Object)"_The_table_is_a_remote_gvSIG_Online_table_You_can_make_only_changes_in_metadata");
                        break;
                    }
                    default: {
                        featureEditMode = 2;
                    }
                    case 2: {
                        store.setProperty("DAL.featureTypeEditMode.msg", (Object)"_The_table_is_a_remote_gvSIG_Online_table_You_cant_make_changes");
                    }
                }
                store.setProperty("DAL.featureTypeEditMode", (Object)featureEditMode);
                FeatureType ft = store.getDefaultFeatureTypeQuietly();
                if (ft == null) break;
                Tags tags = ft.getTags();
                tags.set("online.storename", (Object)store.getName());
                EntitiesTable.EntityRow entity = workspace.getWorkspaceEntityByName(store.getName());
                if (entity == null) break;
                if (!tags.has("online.label")) {
                    tags.set("online.label", (Object)entity.getLabel());
                }
                if (!tags.has("online.readonly")) {
                    tags.set("online.readonly", (Object)false);
                }
                if (!tags.has("online.fieldforlabel")) {
                    tags.set("online.fieldforlabel", (Object)entity.getFieldForLabel());
                }
                if (StringUtils.isBlank((CharSequence)ft.getLabel())) {
                    ft.setLabel(entity.getLabel());
                }
                if (!StringUtils.isBlank((CharSequence)ft.getDescription())) break;
                ft.setDescription(entity.getDescription());
                break;
            }
            case "before_Insert_Feature": {
                workspace = this.getWorkspace(store);
                if (workspace == null) break;
                OnlineLayer layer = OnlineUtils.getOnlineLayer(workspace, store);
                EditableFeature feature = (EditableFeature)n.getFeature();
                if (StringUtils.isBlank((CharSequence)feature.getString(layer.getFeatureCodeFieldName()))) {
                    FeatureType featType = store.getDefaultFeatureTypeQuietly();
                    feature.set(layer.getFeatureCodeFieldName(), workspace.createUniqueCode(store.getName(), layer.getFeatureCodeType()));
                    if (featType.get("feat_date_gvol") != null) {
                        feature.set("feat_date_gvol", (Object)new Timestamp(System.currentTimeMillis()));
                    }
                    if (featType.get("feat_version_gvol") != null) {
                        feature.set("feat_version_gvol", (Object)1);
                    }
                }
                if (!store.isAppending() && store.getMode() != 3) break;
                workspace.addChange(n.getEditingSession(), 2, store, (Feature)feature);
                break;
            }
            case "before_Update_Feature": {
                if (!store.isAppending() && store.getMode() != 3 || (workspace = this.getWorkspace(store)) == null) break;
                workspace.addChange(n.getEditingSession(), 1, store, n.getFeature());
                break;
            }
            case "before_Delete_Feature": {
                if (store.isAppending()) {
                    workspace = this.getWorkspace(store);
                    if (workspace == null) break;
                    workspace.addChange(n.getEditingSession(), 0, store, n.getFeature());
                    break;
                }
                if (store.getMode() != 3 || (workspace = this.getWorkspace(store)) == null) break;
                Feature f = n.getFeature();
                if (f == null) {
                    workspace.addDeleteChanges(n.getEditingSession(), store, n.getExpression());
                    break;
                }
                workspace.addChange(n.getEditingSession(), 0, store, n.getFeature());
                break;
            }
            case "after_Update_Type": {
                if (!store.isAppending()) break;
                break;
            }
            case "before_FinishEditing_DataStore": {
                int stat;
                if (!store.isEditing() || (workspace = this.getWorkspace(store)) == null || (stat = workspace.addChanges(store, n.getEditingSession(), n.getInsertedsFeatures(), n.getUpdatedsFeatures(), n.getDeletedsFeatures(), n.getChangedsFeatureTypes())) == 0) break;
                n.cancel();
                break;
            }
            case "failed_FinishEditing_DataStore": {
                if (!store.isEditing() || (workspace = this.getWorkspace(store)) == null) break;
                workspace.cancelChanges(store, n.getEditingSession());
                break;
            }
            case "after_FinishEditing_DataStore": {
                this.remove_from_inediting_list(store);
                workspace = this.getWorkspace(store);
                if (workspace == null) break;
                workspace.acceptChanges(store, n.getEditingSession());
                if (!workspace.isAResourceTable(store.getName())) break;
                DALLocator.getDataManager().clearAllCachedResources();
                break;
            }
            case "after_StartEditing_DataStore": {
                this.add_to_inediting_list(store, n.getEditMode());
                break;
            }
            case "after_CancelEditing_DataStore": {
                this.remove_from_inediting_list(store);
                workspace = this.getWorkspace(store);
                if (workspace == null) break;
                workspace.cancelChanges(store, n.getEditingSession());
                break;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)workspace);
    }

    public static void install() {
        DataManager dataManager = DALLocator.getDataManager();
        FeatureStoreObserver obs = new FeatureStoreObserver();
        dataManager.addStoreObserver((Observer)obs);
        EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
        editingNotificationManager.addObserver((Observer)obs);
    }

    static int getEditMode(FeatureStore store) {
        if (store == null) {
            return -1;
        }
        for (int i = 0; i < inediting_list.size(); ++i) {
            WeakReference ref;
            Pair<WeakReference<FeatureStore>, Integer> pair = inediting_list.get(i);
            if (pair == null || (ref = (WeakReference)pair.getLeft()) == null) continue;
            FeatureStore currentStore = (FeatureStore)ref.get();
            if (currentStore == null) {
                inediting_list.set(i, null);
                break;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)store.getFullName(), (CharSequence)currentStore.getFullName())) continue;
            return (Integer)pair.getRight();
        }
        return 0;
    }

    public static boolean isEditing(FeatureStore store) {
        int editMode = FeatureStoreObserver.getEditMode(store);
        return editMode != 0;
    }

    private void remove_from_inediting_list(FeatureStore store) {
        boolean found = false;
        for (int i = 0; i < inediting_list.size(); ++i) {
            Pair<WeakReference<FeatureStore>, Integer> pair = inediting_list.get(i);
            if (pair == null) continue;
            WeakReference ref = (WeakReference)pair.getLeft();
            if (ref == null) {
                inediting_list.set(i, null);
                continue;
            }
            FeatureStore currentStore = (FeatureStore)ref.get();
            if (currentStore == null) {
                inediting_list.set(i, null);
                continue;
            }
            if (currentStore == store) {
                LOGGER.trace("Terminate editing " + store.getFullName());
                inediting_list.set(i, null);
                found = true;
                continue;
            }
            if (currentStore.getMode() != 0) continue;
            inediting_list.set(i, null);
        }
        if (!found) {
            LOGGER.warn("Terminate editing of non editing store " + store.getFullName());
        }
    }

    private void add_to_inediting_list(FeatureStore store, int editMode) {
        if (store == null) {
            return;
        }
        LOGGER.trace("Start editing " + store.getFullName());
        WeakReference<FeatureStore> newref = new WeakReference<FeatureStore>(store);
        for (int i = 0; i < inediting_list.size(); ++i) {
            Pair<WeakReference<FeatureStore>, Integer> pair = inediting_list.get(i);
            if (pair != null && pair.getLeft() != null && ((WeakReference)pair.getLeft()).get() != null) continue;
            if (newref == null) {
                inediting_list.set(i, null);
                continue;
            }
            inediting_list.set(i, (Pair<WeakReference<FeatureStore>, Integer>)new ImmutablePair(newref, (Object)editMode));
            newref = null;
        }
        if (newref != null) {
            inediting_list.add((Pair<WeakReference<FeatureStore>, Integer>)new ImmutablePair(newref, (Object)editMode));
        }
    }

    public static List<Pair<WeakReference<FeatureStore>, Integer>> getInEditingList() {
        return inediting_list;
    }

    public static boolean isThereAnyStoreInEditing() {
        for (int i = 0; i < inediting_list.size(); ++i) {
            WeakReference ref;
            Pair<WeakReference<FeatureStore>, Integer> pair = inediting_list.get(i);
            if (pair == null || (ref = (WeakReference)pair.getLeft()) == null) continue;
            FeatureStore currentStore = (FeatureStore)ref.get();
            if (currentStore == null) {
                inediting_list.set(i, null);
                break;
            }
            if ((Integer)pair.getRight() == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean IsThereConflictingStoresInEdition() {
        for (int i = 0; i < inediting_list.size(); ++i) {
            WeakReference ref;
            Pair<WeakReference<FeatureStore>, Integer> pair = inediting_list.get(i);
            if (pair == null || (ref = (WeakReference)pair.getLeft()) == null) continue;
            FeatureStore currentStore = (FeatureStore)ref.get();
            if (currentStore == null) {
                inediting_list.set(i, null);
                break;
            }
            if (!(currentStore.getParameters() instanceof JDBCStoreParameters) || (Integer)pair.getRight() == 0) continue;
            return true;
        }
        return false;
    }

    public static int getReferencesCount() {
        DisposableManager disposableManager = ToolsLocator.getDisposableManager();
        int count = 0;
        for (DisposableInfo boundDisposable : disposableManager.getBoundDisposables()) {
            count += boundDisposable.getReferencesCount();
        }
        return count;
    }

    public static Object getReferences() {
        HashMap<Integer, Integer> references = new HashMap<Integer, Integer>();
        DisposableManager disposableManager = ToolsLocator.getDisposableManager();
        for (DisposableInfo boundDisposable : disposableManager.getBoundDisposables()) {
            references.put(boundDisposable.getDisposable().hashCode(), boundDisposable.getReferencesCount());
        }
        return references;
    }

    public static void dumpDisposables(Object references) {
        DisposableManager disposableManager = ToolsLocator.getDisposableManager();
        for (DisposableInfo boundDisposable : disposableManager.getBoundDisposables()) {
            Disposable d = boundDisposable.getDisposable();
            Integer x = (Integer)((Map)references).get(d.hashCode());
            if (x != null && boundDisposable.getReferencesCount() <= x) continue;
            String s = "";
            try {
                s = Objects.toString(d);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOGGER.info(String.format("%x", d.hashCode()) + " " + (boundDisposable.getReferencesCount() - (x == null ? 0 : x)) + " " + d.getClass().getSimpleName() + " " + s);
        }
    }
}

