/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl.workspace;

import java.util.ConcurrentModificationException;
import java.util.Date;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineManager;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopyDescriptor;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class OnlineWorkingcopyDescriptorImpl
extends AbstractDisposable
implements OnlineWorkingcopyDescriptor {
    private String label;
    private String code;
    private JDBCServerExplorerParameters explorerParameters;
    private JDBCServerExplorer explorer;
    private OnlineWorkingcopy workspace;
    private long lastUse;

    public OnlineWorkingcopyDescriptorImpl() {
    }

    public OnlineWorkingcopyDescriptorImpl(OnlineWorkingcopy workspace) {
        this.setWorkspace(workspace);
    }

    public String getCode() {
        return this.code;
    }

    public boolean isWorkspaceInitialized() {
        return this.workspace != null && this.workspace.getExplorer() != null;
    }

    public OnlineWorkingcopy getWorkspace() {
        OnlineManager manager;
        OnlineWorkingcopy theWorkspace;
        if ((this.workspace == null || this.workspace.getExplorer() == null) && this.workspace != (theWorkspace = (manager = OnlineLocator.getOnlineManager()).openWorkingcopy(this.getExplorer()))) {
            throw new ConcurrentModificationException("The workspace has ben modified");
        }
        this.lastUse = new Date().getTime();
        DisposeUtils.bind((Disposable)this.workspace);
        return this.workspace;
    }

    public String getLabel() {
        return this.label;
    }

    public OnlineWorkingcopyDescriptor getValue() {
        return this;
    }

    public JDBCServerExplorer getExplorer() {
        if (this.explorer == null) {
            if (this.workspace == null) {
                try {
                    DataManager manager = DALLocator.getDataManager();
                    this.explorer = (JDBCServerExplorer)manager.openServerExplorer(this.explorerParameters.getProviderName(), (DataServerExplorerParameters)this.explorerParameters);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                this.explorer = this.workspace.getExplorer();
            }
        }
        DisposeUtils.bind((Disposable)this.explorer);
        return this.explorer;
    }

    public JDBCServerExplorerParameters getExplorerParameters() {
        return this.explorerParameters;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("label", this.label);
        state.set("code", this.code);
        state.set("explorerParameters", (Persistent)this.explorerParameters);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.code = state.getString("code");
        this.label = state.getString("label");
        this.explorerParameters = (JDBCServerExplorerParameters)state.get("explorerParameters");
    }

    public static void selfRegister() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("OnlineWorkingcopyDescriptor") == null) {
            DynStruct definition = manager.addDefinition(OnlineWorkingcopyDescriptorImpl.class, "OnlineWorkingcopyDescriptor", "OnlineWorkingcopyDescriptor persistent definition", null, null);
            definition.addDynFieldString("code");
            definition.addDynFieldString("label");
            definition.addDynFieldObject("explorerParameters").setClassOfValue(JDBCServerExplorerParameters.class).setMandatory(true);
        }
    }

    public String toString() {
        return this.getLabel();
    }

    public void setWorkspace(OnlineWorkingcopy workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("workspace can't be null.");
        }
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
        DisposeUtils.disposeQuietly((Disposable)this.explorer);
        this.workspace = workspace;
        DisposeUtils.bind((Disposable)this.workspace);
        this.explorerParameters = workspace.getExplorerParameters();
        this.explorer = null;
        this.label = workspace.getLabel();
        this.code = workspace.getCode();
        this.lastUse = new Date().getTime();
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
        DisposeUtils.disposeQuietly((Disposable)this.explorer);
        this.explorerParameters = null;
        this.explorer = null;
        this.workspace = null;
        this.code = null;
    }

    public void dropExpiredCaches() {
        long now = new Date().getTime();
        if (now > this.lastUse + 60000L) {
            this.dropCaches();
        }
    }

    public void dropCaches() {
        DisposeUtils.disposeQuietly((Disposable)this.workspace);
        DisposeUtils.disposeQuietly((Disposable)this.explorer);
        this.workspace = null;
        this.explorer = null;
    }
}

