/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl.workspace;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cresques.cts.IProjection;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureRules;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.paging.FeaturePagingHelper;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportJson;
import org.gvsig.online.lib.api.OnlineCodeGenerator;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineProject;
import org.gvsig.online.lib.api.OnlineRuntimeException;
import org.gvsig.online.lib.api.OnlineSite;
import org.gvsig.online.lib.api.workingcopy.OnlineChanges;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineRemoteChange;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopyChange;
import org.gvsig.online.lib.api.workingcopy.WorkingArea;
import org.gvsig.online.lib.impl.OnlineLayerImpl;
import org.gvsig.online.lib.impl.OnlineManagerImpl;
import org.gvsig.online.lib.impl.OnlineProjectImpl;
import org.gvsig.online.lib.impl.OnlineSiteImpl;
import org.gvsig.online.lib.impl.OnlineUtils;
import org.gvsig.online.lib.impl.TilesCalculator;
import org.gvsig.online.lib.impl.workspace.ChangesImpl;
import org.gvsig.online.lib.impl.workspace.FeatureStoreObserver;
import org.gvsig.online.lib.impl.workspace.StoreProperties;
import org.gvsig.online.lib.impl.workspace.WorkingAreaImpl;
import org.gvsig.online.lib.impl.workspace.tables.EntitiesTable;
import org.gvsig.online.lib.impl.workspace.tables.RemoteChangesTable;
import org.gvsig.online.lib.impl.workspace.tables.VarsTable;
import org.gvsig.online.lib.impl.workspace.tables.WorkspaceChangesTable;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.patch.PatchGenerator;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.UserCancelTaskException;
import org.gvsig.tools.util.ChainedIterator;
import org.gvsig.tools.util.ContainerUtils;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.tools.util.HasAFile;
import org.gvsig.tools.util.Rewind;
import org.gvsig.tools.util.Size64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineWorkspaceImpl
extends AbstractDisposable
implements OnlineWorkingcopy {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineWorkspaceImpl.class);
    public static final String CONFIG_WORKSPACE_CODE_NAME = "WORKSPACE_CODE";
    public static final String CONFIG_WORKSPACE_CODE_CHANGE_ON_FIRST_USE = "CHANGE_ON_FIRST_USE";
    public static final String CONFIG_WORKSPACE_LABEL_NAME = "WORKSPACE_LABEL";
    public static final String CONFIG_PROJECT_NAME = "PROJECT";
    public static final String CONFIG_AUTHENTICATIONTOKEN_NAME = "AUTHENTICATIONTOKEN";
    public static final String CONFIG_OFFLINE = "OFFLINE";
    public static final String CONFIG_ENTITY_LABEL_TEMPLATE = "ENTITY_LABEL_TEMPLATE";
    public static final String CONFIG_CURRENT_WORKINGAREA = "CURRENT_WORKINGAREA";
    public static final String CONFIG_SYNC_EXPIRATION_TIME_IN_MINUTES = "SYNC_EXPIRATION_TIME_IN_MINUTES";
    public static final String CONFIG_MIN_RESULTS_FOR_ALERT = "MIN_RESULTS_FOR_ALERT";
    public static final String CONFIG_SHOW_HIDDEN_TABLES = "SHOW_HIDDEN_TABLES";
    private static final int MILLISECONDS_PER_MINUTE = 60000;
    private final Map<String, FeatureStore> storesCache;
    private Map<String, EntitiesTable.EntityRow> workspaceEntitiesByName;
    private Map<String, EntitiesTable.EntityRow> workspaceEntitiesByCode;
    private Set<FeatureStore> storeIgnoreChanges;
    private JDBCServerExplorer wsexplorer;
    private String code;
    private OnlineProjectImpl project;
    private String label;
    private final FilteredLogger logger = new FilteredLogger(LOGGER, "OnlineWorkspace", 10000L);
    private final OnlineCodeGenerator codeGenerator;
    private final ChangeListenerHelper workspaceEntitiesChangeListeners;
    private boolean offline;
    private String entityLabelTemplate;
    private boolean disposed = false;
    private WorkingArea currentWorkingArea;
    private Map<String, Long> synchTimes;
    private int syncExpirationTimeInMinutes;
    private int minResultsForAlert;
    private boolean showHiddenTables;

    public OnlineWorkspaceImpl(JDBCServerExplorer wsexplorer, OnlineCodeGenerator codeGenerator, OnlineProject project, String label) {
        this.codeGenerator = codeGenerator;
        this.storesCache = new HashMap<String, FeatureStore>();
        this.code = this.createUniqueCode();
        this.wsexplorer = wsexplorer;
        DisposeUtils.bind((Disposable)wsexplorer);
        this.project = (OnlineProjectImpl)project;
        DisposeUtils.bind((Object)this.project);
        this.label = label;
        this.workspaceEntitiesChangeListeners = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
        this.offline = false;
        this.entityLabelTemplate = "${label}";
        this.synchTimes = new HashMap<String, Long>();
        this.syncExpirationTimeInMinutes = 2;
    }

    public OnlineWorkspaceImpl(JDBCServerExplorer wsexplorer, OnlineCodeGenerator codeGenerator, String newLabel) {
        this(wsexplorer, codeGenerator, null, newLabel);
        VarsTable varsTable = new VarsTable();
        if (StringUtils.isNotBlank((CharSequence)newLabel)) {
            varsTable.set(this, CONFIG_WORKSPACE_LABEL_NAME, newLabel);
        }
        Map<String, String> vars = varsTable.getVars(this, CONFIG_PROJECT_NAME, CONFIG_WORKSPACE_CODE_NAME, CONFIG_AUTHENTICATIONTOKEN_NAME, CONFIG_WORKSPACE_LABEL_NAME, CONFIG_OFFLINE, CONFIG_ENTITY_LABEL_TEMPLATE, CONFIG_CURRENT_WORKINGAREA, CONFIG_SYNC_EXPIRATION_TIME_IN_MINUTES, CONFIG_MIN_RESULTS_FOR_ALERT, CONFIG_SHOW_HIDDEN_TABLES);
        this.code = vars.get(CONFIG_WORKSPACE_CODE_NAME);
        if (this.code == null) {
            throw new RuntimeException("Can't retrieve code from workspace '" + this.getMessageLabel() + "'");
        }
        if (this.code.equalsIgnoreCase(CONFIG_WORKSPACE_CODE_CHANGE_ON_FIRST_USE)) {
            this.code = this.createUniqueCode();
            varsTable.set(this, CONFIG_WORKSPACE_CODE_NAME, this.code);
        }
        this.offline = DataTypeUtils.toBoolean((Object)vars.get(CONFIG_OFFLINE), (boolean)false);
        this.entityLabelTemplate = vars.getOrDefault(CONFIG_ENTITY_LABEL_TEMPLATE, "${label}");
        this.syncExpirationTimeInMinutes = NumberUtils.toInt((String)vars.get(CONFIG_SYNC_EXPIRATION_TIME_IN_MINUTES), (int)2);
        this.minResultsForAlert = NumberUtils.toInt((String)vars.get(CONFIG_MIN_RESULTS_FOR_ALERT), (int)1000);
        this.reloadWorkspaceEntities();
        this.project = (OnlineProjectImpl)Json.toObject((String)vars.get(CONFIG_PROJECT_NAME));
        if (this.project == null) {
            throw new RuntimeException("Can't retrieve repository from workspace '" + this.getMessageLabel() + "'");
        }
        this.currentWorkingArea = (WorkingAreaImpl)Json.toObject((String)vars.get(CONFIG_CURRENT_WORKINGAREA));
        this.label = vars.get(CONFIG_WORKSPACE_LABEL_NAME);
        this.showHiddenTables = DataTypeUtils.toBoolean((Object)vars.get(CONFIG_SHOW_HIDDEN_TABLES), (boolean)false);
    }

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        if (this.disposed) {
            return "BROKEN (" + this.label + ")";
        }
        return this.label;
    }

    public final String createUniqueCode() {
        return this.codeGenerator.generateCodeString();
    }

    public final Object createUniqueCode(String entityName, int type) {
        switch (type) {
            case 4: 
            case 5: 
            case 19: {
                return this.createUniqueCodeLong(entityName);
            }
            case 8: {
                return this.createUniqueCode();
            }
        }
        throw new IllegalArgumentException("Data type " + type + " not supported for create unique codes");
    }

    public boolean isNewCode(Object code) {
        if (code instanceof Number) {
            return ((Number)code).longValue() < 0L;
        }
        if (code instanceof String) {
            // empty if block
        }
        throw new IllegalArgumentException("Wrong value of code '" + Objects.toString(code) + "'");
    }

    public final long createUniqueCodeLong(String entityName) {
        if (!this.codeGenerator.isInitialized(entityName)) {
            this.refreshCodeGeneratorSequence(entityName);
        }
        return this.codeGenerator.generateCodelong(entityName);
    }

    public String getErrorMessage(int errcode) {
        return OnlineUtils.getErrorMessage(errcode);
    }

    public JDBCServerExplorer getExplorer() {
        return this.wsexplorer;
    }

    public JDBCServerExplorerParameters getExplorerParameters() {
        return this.wsexplorer.getParameters();
    }

    private String getMessageLabel() {
        try {
            return this.wsexplorer.getParameters().getUrl();
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    private String getProviderName() {
        return this.wsexplorer.getProviderName();
    }

    public FeatureType getFeatureType(String tableName) {
        if (!OnlineManagerImpl.INTERNAL_WORKSPACE_TABLES.contains(tableName)) {
            EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(tableName);
            if (entity == null) {
                return null;
            }
            return entity.getFeatureType();
        }
        try {
            FeatureType ft;
            FeatureStore store = this.storesCache.get(tableName);
            if (store != null) {
                ft = store.getDefaultFeatureType();
            } else {
                DataManager dataManager = DALLocator.getDataManager();
                JDBCStoreParameters params = this.wsexplorer.get(tableName);
                store = (FeatureStore)dataManager.openStore(this.getProviderName(), (DataStoreParameters)params);
                this.storesCache.put(tableName, store);
                ft = store.getDefaultFeatureType();
            }
            return ft;
        }
        catch (Exception ex) {
            String msg = "Can't get feature type of table '" + tableName + "' from '" + this.getMessageLabel() + "'.";
            throw new RuntimeException(msg, ex);
        }
    }

    public JDBCStoreParameters getFeatureStoreParameters(String tableName) {
        try {
            JDBCStoreParameters params = this.wsexplorer.get(tableName);
            return params;
        }
        catch (Exception ex) {
            LOGGER.trace("Can't get store parameters of table '" + tableName + "' from '" + this.getMessageLabel() + "'.", (Throwable)ex);
            return null;
        }
    }

    public FeatureStore getFeatureStore(String tableName) {
        if (!OnlineManagerImpl.INTERNAL_WORKSPACE_TABLES.contains(tableName)) {
            EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(tableName);
            if (entity == null) {
                return null;
            }
            return this.getFeatureStore((OnlineEntity)entity);
        }
        FeatureStore store = this.storesCache.get(tableName);
        if (store != null) {
            DisposeUtils.bind((Disposable)store);
            return store;
        }
        DataManager dataManager = DALLocator.getDataManager();
        try {
            JDBCStoreParameters params = this.wsexplorer.get(tableName);
            store = (FeatureStore)dataManager.openStore(this.getProviderName(), (DataStoreParameters)params, true);
            this.storesCache.put(tableName, store);
            DisposeUtils.bind((Disposable)store);
            return store;
        }
        catch (Exception ex) {
            LOGGER.trace("can't open store of table '" + tableName + "' from '" + this.getMessageLabel() + "'.", (Throwable)ex);
            return null;
        }
    }

    private FeatureStore getFeatureStore(OnlineEntity entity) {
        FeatureStore store = this.storesCache.get(entity.getEntityName());
        if (store != null) {
            DisposeUtils.bind((Disposable)store);
            return store;
        }
        DataManager dataManager = DALLocator.getDataManager();
        try {
            JDBCStoreParameters params = this.wsexplorer.get(entity.getEntityName());
            store = (FeatureStore)dataManager.openStore(this.getProviderName(), (DataStoreParameters)params);
            StoreProperties.set(store, this, entity.getEntityName());
            this.storesCache.put(entity.getEntityName(), store);
            DisposeUtils.bind((Disposable)store);
            return store;
        }
        catch (Exception ex) {
            LOGGER.trace("can't open store of table '" + entity.getEntityName() + "' from '" + this.getMessageLabel() + "'.", (Throwable)ex);
            return null;
        }
    }

    public FeatureStore openFeatureStore(OnlineEntity entity) {
        DataManager dataManager = DALLocator.getDataManager();
        try {
            JDBCStoreParameters params = this.wsexplorer.get(entity.getEntityName());
            FeatureStore store = (FeatureStore)dataManager.openStore(this.getProviderName(), (DataStoreParameters)params);
            return store;
        }
        catch (Exception ex) {
            LOGGER.trace("can't open store of table '" + entity.getEntityName() + "' from '" + this.getMessageLabel() + "'.", (Throwable)ex);
            return null;
        }
    }

    public FeatureStore openFeatureStore(String tableName, boolean ignoreDALResource) {
        DataManager dataManager = DALLocator.getDataManager();
        try {
            JDBCStoreParameters params = this.wsexplorer.get(tableName);
            FeatureStore store = (FeatureStore)dataManager.openStore(this.getProviderName(), (DataStoreParameters)params, ignoreDALResource);
            return store;
        }
        catch (Exception ex) {
            LOGGER.trace("can't open store of table '" + tableName + "' from '" + this.getMessageLabel() + "'.", (Throwable)ex);
            return null;
        }
    }

    public void forceReloadWorkspaceEntities() {
        this.workspaceEntitiesByCode = null;
        this.workspaceEntitiesByName = null;
    }

    public void reloadWorkspaceEntities() {
        HashMap<String, EntitiesTable.EntityRow> localEntities = new HashMap<String, EntitiesTable.EntityRow>();
        EntitiesTable entitiesTable = new EntitiesTable();
        DisposableFeatureSetIterable allLocalEntities = null;
        try {
            allLocalEntities = entitiesTable.getAll(this);
            for (Feature lentity_f : allLocalEntities) {
                EntitiesTable.EntityRow entityRow = new EntitiesTable.EntityRow(this, lentity_f);
                localEntities.put(entityRow.getEntityName(), entityRow);
            }
        }
        catch (Exception ex) {
            throw new OnlineRuntimeException(250, OnlineUtils.getErrorMessage(250));
        }
        finally {
            DisposeUtils.dispose((Disposable)allLocalEntities);
        }
        this.reloadWorkspaceEntities(localEntities);
    }

    public final void reloadWorkspaceEntities(Map<String, EntitiesTable.EntityRow> localEntities) {
        Disposable store = null;
        Disposable featureSet = null;
        try {
            HashMap<String, EntitiesTable.EntityRow> theEntitiesByName = new HashMap<String, EntitiesTable.EntityRow>();
            HashMap<String, EntitiesTable.EntityRow> theEntitiesByCode = new HashMap<String, EntitiesTable.EntityRow>();
            for (EntitiesTable.EntityRow entity : localEntities.values()) {
                theEntitiesByName.put(entity.getEntityName(), entity);
                theEntitiesByCode.put(entity.getCode(), entity);
            }
            this.workspaceEntitiesByName = theEntitiesByName;
            this.workspaceEntitiesByCode = theEntitiesByCode;
            this.workspaceEntitiesChangeListeners.fireEvent();
        }
        catch (Exception ex) {
            throw new OnlineRuntimeException(250, OnlineUtils.getErrorMessage(250));
        }
        finally {
            DisposeUtils.disposeQuietly(featureSet);
            DisposeUtils.disposeQuietly(store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEntity(FeatureType featureType, String name, String description, String fieldForLabel, String label, String pkName, int tileSize) {
        Disposable store = null;
        int err = 0;
        try {
            IProjection crs;
            FeatureAttributeDescriptor[] pk;
            LOGGER.debug("===: ADD_ENTITY " + this.getCode() + ", '" + this.getLabel() + "', " + name);
            EditableFeatureType ft = featureType.getCopy().getEditable();
            for (FeatureAttributeDescriptor attr : ft.getPrimaryKey()) {
                EditableFeatureAttributeDescriptor editAttr = (EditableFeatureAttributeDescriptor)attr;
                editAttr.setIsPrimaryKey(false);
                editAttr.setAllowNull(false);
                editAttr.setIsIndexed(true);
                editAttr.setAllowIndexDuplicateds(false);
            }
            EditableFeatureAttributeDescriptor attr = (EditableFeatureAttributeDescriptor)ft.getAttributeDescriptor(pkName);
            if (attr == null) {
                LOGGER.warn("Table '" + name + "' not has required attribute '" + pkName + "' for primary key");
                attr = (EditableFeatureAttributeDescriptor)ft.add(pkName, 5).setIsPrimaryKey(true).setIsIndexed(true).setAllowIndexDuplicateds(false).setLabel("Online Code");
                ft.setHasOID(false);
            } else if (!attr.isPrimaryKey()) {
                attr.setIsPrimaryKey(true);
                ft.setHasOID(false);
            }
            attr.getTags().set("dynform.readonly", (Object)true);
            EditableFeatureAttributeDescriptor geomattr = (EditableFeatureAttributeDescriptor)ft.getDefaultGeometryAttribute();
            if (geomattr != null) {
                geomattr.setIsIndexed(true);
            }
            String defaultFieldForLabel = (pk = (featureType = ft.getNotEditableCopy()).getPrimaryKey()) == null || pk.length < 1 ? featureType.getAttributeName(0) : pk[0].getName();
            err = 220;
            Tags tags = featureType.getTags();
            EntitiesTable.EntityRow entity = new EntitiesTable.EntityRow(this);
            entity.newCode();
            entity.setEntityName(name);
            entity.setFeatureIdFieldName(pkName);
            entity.setGeometryFieldName(featureType.getDefaultGeometryAttributeName());
            entity.setDescription(description);
            entity.setFieldForLabel(StringUtils.equalsIgnoreCase((CharSequence)fieldForLabel, (CharSequence)"@AUTODETECT") ? tags.getString("online.fieldforlabel", defaultFieldForLabel) : fieldForLabel);
            entity.setFeatureTypeAsJson(featureType.toJsonBuilder().toString());
            entity.setDataModels(tags.getString("online.datamodel", null));
            entity.setLabel(StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"@AUTODETECT") ? tags.getString("online.label", null) : label);
            entity.setTileSize(tileSize);
            if (geomattr != null && (crs = geomattr.getSRS()) != null) {
                entity.setCRS(crs);
            }
            entity.setState(1);
            entity.insert();
            this.addWorkspaceEntity(entity);
            this.forceReloadWorkspaceEntities();
            err = 310;
            this.create_table((OnlineEntity)entity);
        }
        catch (OnlineRuntimeException ex) {
            LOGGER.warn("can't add entity '" + name + "'.", (Throwable)ex);
            if (store != null) {
                store.cancelEditingQuietly();
            }
            int n = ex.getErrnum();
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("can't add entity '" + name + "'.", (Throwable)ex);
            if (store != null) {
                store.cancelEditingQuietly();
            }
            int n = err;
            return n;
        }
        finally {
            DisposeUtils.disposeQuietly(store);
        }
        return 0;
    }

    public void create_table(String name) {
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(name);
        if (entity == null) {
            throw new IllegalArgumentException("Can't locate informacion of table '" + name + "'.");
        }
        this.create_table((OnlineEntity)entity);
    }

    public void create_table(OnlineEntity entity) {
        this.create_table(entity, entity.getEntityName());
    }

    public void create_table(OnlineEntity entity, String tableName) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity is null.");
        }
        try {
            JDBCNewStoreParameters addparams = (JDBCNewStoreParameters)this.wsexplorer.getAddParameters(tableName);
            addparams.setDefaultFeatureType(entity.getFeatureType());
            this.wsexplorer.add(this.getProviderName(), (NewDataStoreParameters)addparams, true);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create table '" + entity.getEntityName() + "'.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addChanges(FeatureStore store, String editingSession, Iterator<Feature> insertedsFeatures, Iterator<Feature> updatedsFeatures, Iterator<FeatureReference> deletedsFeatures, Iterator<FeatureType.FeatureTypeChanged> changedsFeatureTypes) {
        String entityName = StoreProperties.getEntityName(store);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return 5;
        }
        if (this.isInStoreIgnoreChanges(store)) {
            LOGGER.debug("===: ADD_CHANGE: Skip (" + store.getName() + ")");
            return 0;
        }
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(entityName);
        if (entity == null) {
            return 5;
        }
        if (entity.getState() == 128) {
            return 0;
        }
        if (this.isCorrupt((OnlineEntity)entity, store, 0)) {
            return 0;
        }
        FeatureStore workspaceChangesStore = null;
        int err = 300;
        try {
            Feature f;
            workspaceChangesStore = this.openFeatureStore("ONLINE_WSCHANGES", false);
            err = 310;
            Map<Long, Integer> previousOperations = null;
            if (updatedsFeatures instanceof Rewind && insertedsFeatures instanceof Rewind) {
                previousOperations = this.calculatePreviousOperations(entity, workspaceChangesStore, insertedsFeatures, updatedsFeatures);
                workspaceChangesStore.edit(2);
            } else {
                workspaceChangesStore.edit(3);
            }
            if (insertedsFeatures != null) {
                while (insertedsFeatures.hasNext()) {
                    f = insertedsFeatures.next();
                    if (f == null) continue;
                    this.addChange(editingSession, entity, 2, workspaceChangesStore, f, null, previousOperations);
                }
            }
            if (updatedsFeatures != null) {
                while (updatedsFeatures.hasNext()) {
                    f = updatedsFeatures.next();
                    if (f == null) continue;
                    Feature originalFeature = store.getOriginalFeature(f);
                    this.addChange(editingSession, entity, 1, workspaceChangesStore, f, originalFeature, previousOperations);
                }
            }
            if (previousOperations != null) {
                workspaceChangesStore.finishEditing();
                workspaceChangesStore.edit(3);
            }
            if (deletedsFeatures != null) {
                while (deletedsFeatures.hasNext()) {
                    Feature f2;
                    FeatureReference fr = deletedsFeatures.next();
                    if (fr == null || (f2 = fr.getFeatureQuietly()) == null) continue;
                    Feature originalFeature = store.getOriginalFeature(fr);
                    this.addDeleteChange(editingSession, entity, workspaceChangesStore, f2.getLong(entity.getFeatureIdFieldName()), f2.getString(entity.getFieldForLabel()), originalFeature);
                }
            }
            workspaceChangesStore.finishEditing();
            if (changedsFeatureTypes != null && changedsFeatureTypes.hasNext()) {
                try {
                    entity.setState(128);
                    entity.update();
                }
                catch (Throwable t) {
                    LOGGER.warn("Can't update entity state");
                }
            }
            err = 0;
        }
        catch (Exception ex) {
            block21: {
                try {
                    LOGGER.warn("Can't add changes.", (Throwable)ex);
                    if (workspaceChangesStore == null) break block21;
                    workspaceChangesStore.cancelEditingQuietly();
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(workspaceChangesStore);
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)workspaceChangesStore);
        }
        DisposeUtils.disposeQuietly((Disposable)workspaceChangesStore);
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addChange(String editingSession, int operation, FeatureStore userStore, Feature feature) {
        String entityName = StoreProperties.getEntityName(userStore);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return 5;
        }
        if (this.isInStoreIgnoreChanges(userStore)) {
            LOGGER.debug("===: ADD_CHANGE: Skip (" + userStore.getName() + ")");
            return 0;
        }
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(entityName);
        if (entity.getState() == 128) {
            return 0;
        }
        FeatureStore changesStore = this.openFeatureStore("ONLINE_WSCHANGES", false);
        try {
            changesStore.edit(3);
            long featureCode = feature.getLong(entity.getFeatureIdFieldName());
            switch (operation) {
                case 0: {
                    String theLabel = feature.getString(entity.getFieldForLabel());
                    int n = this.addDeleteChange(editingSession, entity, changesStore, featureCode, theLabel, userStore.getOriginalFeature(feature));
                    return n;
                }
                case 2: {
                    int n = this.addChange(editingSession, entity, operation, changesStore, feature, userStore.getOriginalFeature(feature), null);
                    return n;
                }
                case 1: {
                    int n = this.addChange(editingSession, entity, operation, changesStore, feature, userStore.getOriginalFeature(feature), null);
                    return n;
                }
            }
            LOGGER.warn("Unsupported operation " + operation + ".");
            int n = this.addChange(editingSession, entity, operation, changesStore, feature, userStore.getOriginalFeature(feature), null);
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add change (op " + OnlineUtils.getOperationLabel(operation) + ", " + entity.getEntityName() + ")", (Throwable)ex);
            changesStore.cancelEditingQuietly();
            int n = 320;
            return n;
        }
        finally {
            changesStore.finishEditingQuietly();
            DisposeUtils.dispose((Disposable)changesStore);
        }
    }

    private int addChange(String editingSession, EntitiesTable.EntityRow entity, int operation, FeatureStore changesStore, Feature feature, Feature oldFeature, Map<Long, Integer> previousOperations) {
        if (entity.getState() == 128) {
            return 0;
        }
        if (operation == 0) {
            long featureCode = feature.getLong(entity.getFeatureIdFieldName());
            String theLabel = feature.getString(entity.getFieldForLabel());
            return this.addDeleteChange(editingSession, entity, changesStore, featureCode, theLabel, oldFeature);
        }
        if (oldFeature == null && feature instanceof EditableFeature) {
            oldFeature = ((EditableFeature)feature).getSource();
        }
        try {
            WorkspaceChangesTable.WorkspaceChangeRow change;
            Feature previousChange = null;
            long featureCode = feature.getLong(entity.getFeatureIdFieldName());
            Integer previousOperation = null;
            if (previousOperations != null) {
                previousOperation = previousOperations.get(featureCode);
            } else {
                ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column("WSCH_FEATURECODE"), (ExpressionBuilder.Value)builder.constant((Object)featureCode)), (ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column("COD_ENTITY"), (ExpressionBuilder.Value)builder.constant((Object)entity.getEntityCode())));
                String filter = builder.build();
                previousChange = changesStore.findFirst(filter);
                if (previousChange != null) {
                    previousOperation = previousChange.getInt("WSCH_OPERATION");
                }
            }
            if (previousOperation != null) {
                switch (operation) {
                    case 2: {
                        LOGGER.warn("A insert change cannot be added as there is a previous change with operation " + previousOperation + " (featureCode=" + featureCode + ")");
                        return 320;
                    }
                    case 1: {
                        switch (previousOperation) {
                            case 1: 
                            case 2: {
                                if (previousChange != null && (change = new WorkspaceChangesTable.WorkspaceChangeRow(this, previousChange)).getStatus() == 16) {
                                    change.setStatus(4);
                                    change.update(changesStore);
                                }
                                return 0;
                            }
                            case 0: {
                                LOGGER.warn("A update change cannot be added as there is a previous change with operation delete (featureCode=" + featureCode + ")");
                                return 320;
                            }
                        }
                        LOGGER.warn("A update change cannot be added as there is a previous change with operation " + previousOperation + " (featureCode=" + featureCode + ")");
                        return 0;
                    }
                    case 0: {
                        return 320;
                    }
                }
                return 0;
            }
            change = new WorkspaceChangesTable.WorkspaceChangeRow(this, (Feature)changesStore.createNewFeature());
            change.newCode();
            change.setEditingSession(editingSession);
            change.setEntityCode(entity.getEntityCode());
            change.setFeatureCode(featureCode);
            change.setOperation(operation);
            change.setLabel(feature.getString(entity.getFieldForLabel()));
            if (oldFeature != null) {
                change.setData(oldFeature.toJson().toString());
            }
            change.setSelected(true);
            switch (operation) {
                case 2: {
                    change.setStatus(2);
                    break;
                }
                case 1: {
                    change.setStatus(4);
                }
            }
            change.insert(changesStore);
            if (previousOperations != null) {
                previousOperations.put(featureCode, change.getOperation());
            }
            this.updateEntityState(entity, change.getOperation());
            return 0;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add change (op " + OnlineUtils.getOperationLabel(operation) + ", " + entity.getEntityName() + ")", (Throwable)ex);
            return 320;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDeleteChanges(String editingSession, FeatureStore userStore, Expression exp) {
        String entityName = StoreProperties.getEntityName(userStore);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return 5;
        }
        if (this.isInStoreIgnoreChanges(userStore)) {
            return 0;
        }
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(entityName);
        if (entity == null) {
            return 5;
        }
        if (entity.getState() == 128) {
            return 0;
        }
        FeatureStore workspaceChangesStore = null;
        int err = 300;
        try {
            workspaceChangesStore = this.openFeatureStore("ONLINE_WSCHANGES", false);
            workspaceChangesStore.edit(3);
            FeatureSet deletedsFeatures = userStore.getFeatureSet(exp);
            err = 310;
            for (Feature f : deletedsFeatures) {
                this.addDeleteChange(editingSession, entity, workspaceChangesStore, f.getLong(entity.getFeatureIdFieldName()), f.getString(entity.getFieldForLabel()), f);
            }
            workspaceChangesStore.finishEditing();
            err = 0;
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't add  delete changes.", (Throwable)ex);
                FeatureStore.cancelEditingQuietly((FeatureStore)workspaceChangesStore);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(workspaceChangesStore);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)workspaceChangesStore);
        }
        DisposeUtils.disposeQuietly((Disposable)workspaceChangesStore);
        return err;
    }

    private int addDeleteChange(String editingSession, EntitiesTable.EntityRow entity, FeatureStore changesStore, long featureCode, String label, Feature oldFeature) {
        if (entity.getState() == 128) {
            return 0;
        }
        try {
            WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
            WorkspaceChangesTable.WorkspaceChangeRow previousChange = changesTable.find(this, changesStore, entity.getEntityCode(), featureCode);
            if (previousChange != null) {
                switch (previousChange.getOperation()) {
                    case 2: {
                        previousChange.setOperation(4);
                        previousChange.setSelected(true);
                        previousChange.setPreviousOperation(2);
                        previousChange.setEditingSession(editingSession);
                        previousChange.update(changesStore);
                        this.updateEntityState(entity, previousChange.getOperation());
                        return 0;
                    }
                    case 1: {
                        previousChange.setOperation(0);
                        previousChange.setSelected(true);
                        previousChange.setPreviousOperation(previousChange.getOperation());
                        previousChange.setEditingSession(editingSession);
                        previousChange.update(changesStore);
                        this.updateEntityState(entity, previousChange.getOperation());
                        return 0;
                    }
                    case 0: {
                        LOGGER.warn("A delete change cannot be added as there is a previous change with operation delete (featureCode=" + featureCode + ")");
                        return 320;
                    }
                    case 4: {
                        LOGGER.warn("A delete change cannot be added as there is a previous change with operation ignore (featureCode=" + featureCode + ")");
                        return 320;
                    }
                }
                LOGGER.warn("A delete change cannot be added as there is a previous change with operation " + previousChange.getOperation() + " (featureCode=" + featureCode + ")");
            }
            WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, (Feature)changesStore.createNewFeature());
            change.newCode();
            change.setPreviousOperation(-1);
            change.setEditingSession(editingSession);
            change.setEntityCode(entity.getEntityCode());
            change.setFeatureCode(featureCode);
            change.setOperation(0);
            change.setLabel(label);
            if (oldFeature != null) {
                change.setData(oldFeature.toJson().toString());
            }
            change.setSelected(true);
            change.setStatus(4);
            change.insert(changesStore);
            this.updateEntityState(entity, change.getOperation());
            return 0;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add delete change (" + entity.getEntityName() + ")", (Throwable)ex);
            return 320;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntityState(EntitiesTable.EntityRow entity, int operation) throws DataException {
        if (entity.getState() == 128) {
            return;
        }
        boolean save = false;
        block1 : switch (operation) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                switch (entity.getState()) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: {
                        break block1;
                    }
                    case 1: {
                        entity.setState(4);
                        save = true;
                        break block1;
                    }
                    case 6: {
                        entity.setState(8);
                        save = true;
                        break block1;
                    }
                }
            }
        }
        if (save) {
            FeatureStore entitiesStore = null;
            try {
                entitiesStore = this.openFeatureStore("ONLINE_ENTITIES", true);
                entitiesStore.edit(1);
                entity.update(entitiesStore);
                entitiesStore.finishEditing();
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(entitiesStore);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)entitiesStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntityState(EntitiesTable.EntityRow entity, boolean save) throws DataException {
        block4: {
            block3: {
                if (entity.getState() == 128) {
                    return;
                }
                if (!save) break block3;
                FeatureStore entitiesStore = null;
                try {
                    entitiesStore = this.openFeatureStore("ONLINE_ENTITIES", true);
                    entitiesStore.edit(1);
                    entity.updateState();
                    entity.update(entitiesStore);
                    entitiesStore.finishEditing();
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(entitiesStore);
                    throw throwable;
                }
                DisposeUtils.disposeQuietly((Disposable)entitiesStore);
                break block4;
            }
            entity.updateState();
        }
    }

    private Map<Long, Integer> calculatePreviousOperations(EntitiesTable.EntityRow entity, FeatureStore changesStore, Iterator<Feature> insertedsFeatures, Iterator<Feature> updatedsFeatures) {
        try {
            HashMap<Long, Integer> previousOperations = new HashMap<Long, Integer>();
            ChainedIterator it = new ChainedIterator(new Iterator[]{insertedsFeatures, updatedsFeatures});
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            int count = 0;
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                String featureCode = feature.getString(entity.getFeatureIdFieldName());
                builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column("WSCH_FEATURECODE"), (ExpressionBuilder.Value)builder.constant((Object)featureCode)));
                builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column("COD_ENTITY"), (ExpressionBuilder.Value)builder.constant((Object)entity.getEntityCode())));
                String filter = builder.build();
                if (it.hasNext() && ++count != 200) continue;
                if (filter != null) {
                    FeatureSet set = changesStore.getFeatureSet(filter);
                    for (Feature previousChange : set) {
                        if (previousChange == null) continue;
                        long featureCode2 = previousChange.getLong("WSCH_FEATURECODE");
                        int previousOperation = previousChange.getInt("WSCH_OPERATION");
                        previousOperations.put(featureCode2, previousOperation);
                    }
                    DisposeUtils.disposeQuietly((Disposable)set);
                }
                builder = ExpressionUtils.createExpressionBuilder();
                count = 0;
            }
            ((Rewind)insertedsFeatures).rewind();
            ((Rewind)updatedsFeatures).rewind();
            return previousOperations;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't calculate previus operations.", (Throwable)ex);
            return null;
        }
    }

    public int cancelChanges(FeatureStore store, String editingSession) {
        String entityName = StoreProperties.getEntityName(store);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return 5;
        }
        if (this.isInStoreIgnoreChanges(store)) {
            LOGGER.debug("===: CANCEL_CHANGES: Skip (" + store.getName() + ")");
            return 0;
        }
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(entityName);
        if (entity == null) {
            return 5;
        }
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        changesTable.revertChangedLocalChanges(this, (OnlineEntity)entity, editingSession);
        changesTable.removeLocalChanges(this, (OnlineEntity)entity, editingSession);
        return 0;
    }

    public int acceptChanges(FeatureStore store, String editingSession) {
        String entityName = StoreProperties.getEntityName(store);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return 5;
        }
        if (this.isInStoreIgnoreChanges(store)) {
            LOGGER.debug("===: CANCEL_CHANGES: Skip (" + store.getName() + ")");
            return 0;
        }
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(entityName);
        if (entity == null) {
            return 5;
        }
        if (entity.getState() == 128) {
            return 0;
        }
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        changesTable.removeIgnoredLocalChanges(this, (OnlineEntity)entity, editingSession);
        return 0;
    }

    public OnlineChanges<OnlineWorkingcopyChange> getLocalChanges() {
        return this.getLocalChanges(null);
    }

    public OnlineChanges<OnlineWorkingcopyChange> getLocalChanges(List<OnlineEntity> entities) {
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        ChangesImpl<WorkspaceChangesTable.WorkspaceChangeRow> changes = new ChangesImpl<WorkspaceChangesTable.WorkspaceChangeRow>(changesTable.getByEntityCode(this, entities), "WSCH_SELECTED"){

            @Override
            protected WorkspaceChangesTable.WorkspaceChangeRow createChange(Feature f) {
                return new WorkspaceChangesTable.WorkspaceChangeRow(OnlineWorkspaceImpl.this, f);
            }

            @Override
            protected void updateChange(FeatureStore store, WorkspaceChangesTable.WorkspaceChangeRow change) {
                change.update(store);
            }
        };
        return changes;
    }

    public boolean hasLocalChanges(List<OnlineEntity> entities) {
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        boolean hasChanges = changesTable.hasLocalChangesByEntityCode(this, entities);
        return hasChanges;
    }

    public List<OnlineEntity> getWorkspaceEntities() {
        if (this.disposed) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<OnlineEntity> entities = new ArrayList<OnlineEntity>();
        entities.addAll(this.getEntitiesAsEntityRow());
        return entities;
    }

    private Collection<EntitiesTable.EntityRow> getEntitiesAsEntityRow() {
        if (this.workspaceEntitiesByName == null) {
            this.reloadWorkspaceEntities();
        }
        return this.workspaceEntitiesByName.values();
    }

    public EntitiesTable.EntityRow getWorkspaceEntityByName(String name) {
        if (this.workspaceEntitiesByName == null) {
            this.reloadWorkspaceEntities();
        }
        return this.workspaceEntitiesByName.get(name);
    }

    public EntitiesTable.EntityRow getWorkspaceEntityByCode(String code) {
        if (this.workspaceEntitiesByCode == null) {
            this.reloadWorkspaceEntities();
        }
        return this.workspaceEntitiesByCode.get(code);
    }

    private void addWorkspaceEntity(EntitiesTable.EntityRow entity) {
        if (this.workspaceEntitiesByCode == null) {
            this.reloadWorkspaceEntities();
        }
        this.workspaceEntitiesByCode.put(entity.getEntityCode(), entity);
        this.workspaceEntitiesByName.put(entity.getEntityName(), entity);
    }

    private boolean existsInWorkspace(String entity) {
        EntitiesTable.EntityRow lentity = this.getWorkspaceEntity(entity);
        return lentity != null;
    }

    public boolean existsInWorkspace(OpenFeatureStoreParameters parameters) {
        if (!this.isInMyDatabase(parameters)) {
            return false;
        }
        JDBCStoreParameters params = (JDBCStoreParameters)parameters;
        return this.existsInWorkspace(params.getTable());
    }

    public boolean existsInWorkspace(OnlineEntity entity) {
        if (entity == null) {
            return false;
        }
        if (this.existsInWorkspace(entity.getEntityName())) {
            return true;
        }
        return this.existsInWorkspace(entity.getEntityCode());
    }

    public EntitiesTable.EntityRow getWorkspaceEntity(String entity) {
        EntitiesTable.EntityRow wsentity = this.getWorkspaceEntityByCode(entity);
        if (wsentity == null) {
            wsentity = this.getWorkspaceEntityByName(entity);
        }
        return wsentity;
    }

    public OnlineSite getSite() {
        return this.project.getSite();
    }

    public OnlineProjectImpl getProject() {
        return this.project;
    }

    public List<OnlineEntity> getEntitiesOfRemoteChanges() {
        ArrayList<OnlineEntity> res = new ArrayList<OnlineEntity>();
        RemoteChangesTable changesTable = new RemoteChangesTable();
        DisposableFeatureSetIterable features = changesTable.getGroupedByEntity(this);
        EntitiesTable entitiesTable = new EntitiesTable();
        for (Feature feature : features) {
            EntitiesTable.EntityRow entity = entitiesTable.getByEntityCode(this, feature.getString("COD_ENTITY"));
            res.add((OnlineEntity)entity);
        }
        DisposeUtils.disposeQuietly((Disposable)features);
        return res;
    }

    public List<OnlineEntity> getEntitiesOfLocalChanges() {
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        ArrayList<OnlineEntity> entities = new ArrayList<OnlineEntity>();
        DisposableFeatureSetIterable changesGroupedByEntity = changesTable.getGroupedByEntity(this);
        for (Feature fchange : changesGroupedByEntity) {
            WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, fchange);
            OnlineEntity localEntity = change.getEntity();
            if (!change.isSelected()) continue;
            entities.add(localEntity);
        }
        return entities;
    }

    public void addToConnectionPool() {
        JDBCServerExplorerParameters params = this.getExplorerParameters();
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.getDataServerExplorerPool().add(this.getLabel(), (DataServerExplorerParameters)params);
    }

    public boolean isInMyDatabase(FeatureStore store) {
        if (!(store.getParameters() instanceof JDBCStoreParameters)) {
            return false;
        }
        JDBCStoreParameters storeParams = (JDBCStoreParameters)store.getParameters();
        JDBCServerExplorerParameters explorerParams = this.getExplorerParameters();
        if (!StringUtils.equalsIgnoreCase((CharSequence)storeParams.getProviderName(), (CharSequence)explorerParams.getProviderName())) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)storeParams.getUrl(), (CharSequence)explorerParams.getUrl());
    }

    public boolean isInMyDatabase(OpenFeatureStoreParameters parameters) {
        if (!(parameters instanceof JDBCStoreParameters)) {
            return false;
        }
        JDBCStoreParameters storeParams = (JDBCStoreParameters)parameters;
        JDBCServerExplorerParameters explorerParams = this.getExplorerParameters();
        if (!StringUtils.equalsIgnoreCase((CharSequence)storeParams.getProviderName(), (CharSequence)explorerParams.getProviderName())) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)storeParams.getUrl(), (CharSequence)explorerParams.getUrl());
    }

    public boolean isInMyDatabase(String tableName) {
        try {
            File f;
            if (StringUtils.isBlank((CharSequence)tableName)) {
                return false;
            }
            JDBCServerExplorer explorer = this.getExplorer();
            JDBCServerExplorerParameters explorerParams = explorer.getParameters();
            if (explorerParams instanceof HasAFile && !(f = ((HasAFile)explorerParams).getFile()).exists()) {
                return false;
            }
            JDBCStoreParameters parameters = explorer.get(tableName);
            return explorer.exists((DataStoreParameters)parameters);
        }
        catch (DataException ex) {
            return false;
        }
    }

    public Feature getRelatedFeature(OnlineEntity entity, long featureCode) {
        Feature feature;
        FeatureStore store = null;
        try {
            Feature f;
            store = this.getFeatureStore(entity.getEntityName());
            feature = f = store.findFirst("\"" + entity.getFeatureIdFieldName() + "\"=" + featureCode);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve feature '" + entity.getEntityName() + "/" + this.code + "'.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return feature;
    }

    private Feature getRelatedFeature(FeatureStore store, OnlineEntity entity, long featureCode) {
        try {
            Feature f = store.findFirst("\"" + entity.getFeatureIdFieldName() + "\"=" + featureCode);
            return f;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve feature '" + entity.getEntityName() + "/" + this.code + "'.", ex);
        }
    }

    public Feature getRelatedFeature(OnlineRemoteChange change) {
        EntitiesTable.EntityRow entity = this.getWorkspaceEntity(change.getEntityCode());
        return this.getRelatedFeature((OnlineEntity)entity, change.getRelatedFeatureCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeEntity(OnlineEntity entity) {
        if (entity == null) {
            return 36;
        }
        int err = 0;
        DataTransaction transaction = DALLocator.getDataManager().createTransaction();
        try {
            transaction.begin();
            EntitiesTable.EntityRow entity1 = this.getWorkspaceEntityByCode(entity.getEntityCode());
            EntitiesTable.EntityRow entity2 = this.getWorkspaceEntityByName(entity.getEntityName());
            err = entity1 != null && entity2 != null && StringUtils.equalsIgnoreCase((CharSequence)entity1.getEntityName(), (CharSequence)entity2.getEntityName()) && StringUtils.equalsIgnoreCase((CharSequence)entity1.getEntityCode(), (CharSequence)entity2.getEntityCode()) ? this.doRemoveEntity((OnlineEntity)entity1, transaction) : (entity1 != null ? this.doRemoveEntity((OnlineEntity)entity1, transaction) : (entity2 != null ? this.doRemoveEntity((OnlineEntity)entity2, transaction) : this.doRemoveEntity(entity, transaction)));
            transaction.commit();
            this.forceReloadWorkspaceEntities();
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't remove entity.", (Throwable)ex);
            transaction.rollbackQuietly();
            int n = err;
            return n;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeEntities(List<String> namesOrCodes) {
        int err = 0;
        DataTransaction transaction = DALLocator.getDataManager().createTransaction();
        try {
            transaction.begin();
            for (String nameOrCode : namesOrCodes) {
                EntitiesTable.EntityRow entity = this.getWorkspaceEntity(nameOrCode);
                if (entity == null) {
                    int n = err = 240;
                    return n;
                }
                this.doRemoveEntity((OnlineEntity)entity, transaction);
            }
            transaction.commit();
            this.forceReloadWorkspaceEntities();
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't remove entity.", (Throwable)ex);
            transaction.rollbackQuietly();
            int n = err;
            return n;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)transaction);
        }
    }

    private int doRemoveEntity(OnlineEntity entity, DataTransaction transaction) throws DataException {
        LOGGER.debug("===: REMOVE ENTITY " + entity.getEntityName());
        int err = 330;
        FeatureStore changesStore = this.openFeatureStore("ONLINE_WSCHANGES", true);
        transaction.add((DataStore)changesStore);
        changesStore.edit(1);
        changesStore.delete("\"COD_ENTITY\"='" + entity.getEntityCode() + "'");
        changesStore.finishEditing();
        FeatureStore remoteChangesStore = this.openFeatureStore("ONLINE_REMOTECHANGES", true);
        transaction.add((DataStore)remoteChangesStore);
        remoteChangesStore.edit(1);
        remoteChangesStore.delete("\"COD_ENTITY\"='" + entity.getEntityCode() + "'");
        remoteChangesStore.finishEditing();
        err = 280;
        FeatureStore entitiesStore = this.openFeatureStore("ONLINE_ENTITIES", true);
        transaction.add((DataStore)entitiesStore);
        entitiesStore.edit(1);
        entitiesStore.delete("\"COD_ENTITY\"='" + entity.getEntityCode() + "'");
        entitiesStore.finishEditing();
        err = 280;
        FeatureStore store = this.openFeatureStore(entity);
        if (store != null) {
            ResourcesStorage.Resource resource;
            transaction.add((DataStore)store);
            ResourcesStorage resourcesStorage = store.getResourcesStorage();
            if (resourcesStorage != null && (resource = resourcesStorage.getResource("dal")) != null) {
                resourcesStorage.remove(resource.getName());
            }
            transaction.add((DataServerExplorer)this.wsexplorer, false);
            this.wsexplorer.remove(store.getParameters());
        }
        return err;
    }

    public boolean isInStoreIgnoreChanges(FeatureStore store) {
        if (this.storeIgnoreChanges == null) {
            return false;
        }
        return this.storeIgnoreChanges.contains(store);
    }

    private void addStoreIgnoreChanges(FeatureStore store) {
        if (this.storeIgnoreChanges == null) {
            this.storeIgnoreChanges = new HashSet<FeatureStore>();
        }
        this.storeIgnoreChanges.add(store);
    }

    private void removeStoreIgnoreChanges(FeatureStore store) {
        if (store == null) {
            return;
        }
        if (this.storeIgnoreChanges == null) {
            this.storeIgnoreChanges = new HashSet<FeatureStore>();
        }
        this.storeIgnoreChanges.remove(store);
    }

    public boolean isCorrupt(OnlineEntity entity, FeatureStore store, int level) {
        return this.isCorrupt(entity, store, level, true);
    }

    public boolean isCorrupt(OnlineEntity lentity, FeatureStore store, int level, boolean saveToDisk) {
        int stateMask = lentity.getState();
        if ((stateMask & 0x100) == 256) {
            return true;
        }
        if ((stateMask & 0x80) == 128) {
            return false;
        }
        boolean corrupt = false;
        FeatureType storeft = store.getDefaultFeatureTypeQuietly();
        if (storeft.get(lentity.getFeatureIdFieldName()) == null) {
            corrupt = true;
        }
        if (corrupt) {
            LOGGER.warn("The table or entity '" + lentity.getEntityName() + "' is corrupt. Missing requiered field '" + lentity.getFeatureIdFieldName() + "'.");
            if (lentity instanceof EntitiesTable.EntityRow) {
                EntitiesTable.EntityRow rowEntity = (EntitiesTable.EntityRow)lentity;
                try {
                    if ((stateMask & 0x180) != 384) {
                        rowEntity.setState(384);
                        if (saveToDisk) {
                            rowEntity.update();
                        }
                    }
                }
                catch (Throwable t) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Can't mark as disconected the entity '" + lentity.getEntityName() + "'.", t);
                    }
                    LOGGER.warn("Can't mark as disconected the entity '" + lentity.getEntityName() + "'.");
                }
            }
        }
        return corrupt;
    }

    public void initialize() {
        VarsTable varsTable = new VarsTable();
        varsTable.set(this, CONFIG_WORKSPACE_CODE_NAME, this.code);
        varsTable.set(this, CONFIG_WORKSPACE_LABEL_NAME, this.label);
        varsTable.set(this, CONFIG_PROJECT_NAME, this.project.toJson().toString());
        varsTable.set(this, CONFIG_OFFLINE, BooleanUtils.toStringTrueFalse((boolean)this.offline));
        varsTable.set(this, CONFIG_ENTITY_LABEL_TEMPLATE, this.entityLabelTemplate);
        varsTable.set(this, CONFIG_SYNC_EXPIRATION_TIME_IN_MINUTES, String.valueOf(2));
        varsTable.set(this, CONFIG_MIN_RESULTS_FOR_ALERT, String.valueOf(1000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OnlineEntity> getEntitiesWithSelectedChanges() {
        ArrayList<OnlineEntity> entities = new ArrayList<OnlineEntity>();
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        DisposableFeatureSetIterable changesGroupedByEntity = null;
        try {
            changesGroupedByEntity = changesTable.getGroupedByEntity(this);
            for (Feature fchange : changesGroupedByEntity) {
                WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, fchange);
                OnlineEntity entity = change.getEntity();
                if (!change.isSelected()) continue;
                entities.add(entity);
            }
            ArrayList<OnlineEntity> arrayList = entities;
            return arrayList;
        }
        catch (Exception ex) {
            List<OnlineEntity> list = null;
            return list;
        }
        finally {
            DisposeUtils.dispose((Disposable)changesGroupedByEntity);
        }
    }

    public List<String> getDataModels() {
        List<OnlineEntity> entities = this.getWorkspaceEntities();
        HashSet dataModels = new HashSet();
        for (OnlineEntity entity : entities) {
            List dataModelsEntity = entity.getDataModelsAsList();
            dataModels.addAll(dataModelsEntity);
        }
        ArrayList<String> list = new ArrayList<String>(dataModels);
        Collections.sort(list);
        return list;
    }

    public void logout() {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        downloader.removeCredentials(this.getSite().getBaseUrl().toExternalForm());
    }

    public void registerDataModelRepository(String modelName) {
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public String getEntityLabelTemplate() {
        return this.entityLabelTemplate;
    }

    public String formatEntityLabel(OnlineEntity entity) {
        String s = OnlineUtils.getFormatedLabel(entity, this.entityLabelTemplate);
        if (s == null) {
            s = entity.getLabelOrName();
        }
        return s;
    }

    public void setConfigValue(String name, String value) {
        VarsTable varsTable = new VarsTable();
        varsTable.set(this, name, value);
    }

    public OnlineChanges<OnlineRemoteChange> getRemoteChanges() {
        return this.getRemoteChangesByEntity(new String[]{null});
    }

    public OnlineChanges<OnlineRemoteChange> getRemoteChangesByEntity(String ... entityNames) {
        String[] entityCodes = null;
        if (ArrayUtils.isNotEmpty((Object[])entityNames)) {
            entityCodes = new String[entityNames.length];
            for (int i = 0; i < entityNames.length; ++i) {
                String entityName = entityNames[i];
                if (StringUtils.isBlank((CharSequence)entityName)) {
                    entityCodes[i] = null;
                    continue;
                }
                EntitiesTable.EntityRow entity = this.getWorkspaceEntity(entityName);
                if (entity == null) {
                    return null;
                }
                entityCodes[i] = entity.getEntityCode();
            }
        }
        RemoteChangesTable changesTable = new RemoteChangesTable();
        GetItemWithSize64<Feature> changesByEntity = changesTable.getByEntityCode(this, entityCodes);
        ChangesImpl<RemoteChangesTable.RemoteChangeRow> changes = new ChangesImpl<RemoteChangesTable.RemoteChangeRow>(changesByEntity, "RCH_SELECTED"){

            @Override
            protected RemoteChangesTable.RemoteChangeRow createChange(Feature f) {
                return new RemoteChangesTable.RemoteChangeRow(OnlineWorkspaceImpl.this, f);
            }

            @Override
            protected void updateChange(FeatureStore store, RemoteChangesTable.RemoteChangeRow change) {
                change.update(store);
            }
        };
        DisposeUtils.disposeQuietly(changesByEntity);
        return changes;
    }

    public OnlineEntity getEntity(String entityName) {
        EntitiesTable.EntityRow entity = this.getWorkspaceEntity(entityName);
        return entity;
    }

    public OpenDataStoreParameters createOpenStoreParameters(String tableName) {
        try {
            JDBCStoreParameters params = this.wsexplorer.get(tableName);
            return params;
        }
        catch (Exception ex) {
            LOGGER.trace("can't create open store parameters from '" + this.getMessageLabel() + "'.", (Throwable)ex);
            return null;
        }
    }

    protected void doDispose() {
        this.disposed = true;
        for (Map.Entry<String, FeatureStore> entry : this.storesCache.entrySet()) {
            FeatureStore store = entry.getValue();
            if (store == null) continue;
            DisposeUtils.disposeQuietly((Disposable)store);
        }
        this.storesCache.clear();
        DisposeUtils.dispose((Disposable)this.wsexplorer);
        this.wsexplorer = null;
        this.code = null;
        DisposeUtils.disposeQuietly((Object)this.project);
    }

    public int revert(String nameOrCode) {
        return this.revert(nameOrCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int revert(String nameOrCode, SimpleTaskStatus status) {
        int n;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Upload");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        FeatureStore entitiesStore = null;
        FeatureStore userStore = null;
        DataTransaction transaction = null;
        try {
            LOGGER.debug("===: REVERT " + this.getCode() + ", " + this.getLabel() + ", " + nameOrCode);
            transaction = DALLocator.getDataManager().createTransaction();
            transaction.begin();
            status.message("Reverting");
            EntitiesTable.EntityRow entity = this.getWorkspaceEntity(nameOrCode);
            WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
            FeatureStore changesStore = null;
            DisposableFeatureSetIterable changes = changesTable.getSelectedsByEntityCodeAsIterator(this, entity.getEntityCode());
            transaction.add((Disposable)changes);
            if (!changes.isEmpty()) {
                userStore = this.openFeatureStore((OnlineEntity)entity);
                this.addStoreIgnoreChanges(userStore);
                transaction.add((DataStore)userStore, userStore.getName(), true);
                userStore.edit(3);
                changesStore = this.openFeatureStore("ONLINE_WSCHANGES", true);
                transaction.add((DataStore)changesStore, "ONLINE_WSCHANGES", true);
                changesStore.edit(3);
                status.setCurValue(0L);
                status.setRangeOfValues(0L, changes.size64());
                for (Feature feature : changes) {
                    WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, feature);
                    change.revert(userStore, changesStore);
                    status.incrementCurrentValue();
                }
                userStore.finishEditing();
                changesStore.finishEditing();
            }
            entitiesStore = this.openFeatureStore("ONLINE_ENTITIES", true);
            transaction.add((DataStore)entitiesStore, "ONLINE_ENTITIES");
            entitiesStore.edit(1);
            entity.updateState(transaction);
            entity.update(entitiesStore);
            entitiesStore.finishEditing();
            transaction.commit();
            this.forceReloadWorkspaceEntities();
            status.message("Revert completed");
            status.terminate();
            n = 0;
            this.removeStoreIgnoreChanges(userStore);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't revert changes.", (Throwable)ex);
            status.message("Can't revert changes");
            status.abort();
            int n2 = 700;
            return n2;
        }
        finally {
            this.removeStoreIgnoreChanges(userStore);
            DisposeUtils.disposeQuietly(transaction);
            status.pop();
        }
        DisposeUtils.disposeQuietly((Disposable)transaction);
        status.pop();
        return n;
    }

    public void download_config(boolean overwrite, SimpleTaskStatus status) {
        OnlineLayer config = this.project.getConfigTable(status);
        if (config == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Download_configuration_data"));
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        FileInputStream fis = null;
        FeatureStore store = null;
        try {
            status.message(i18n.getTranslation("_Downloading_configuration_data"));
            status.setIndeterminate();
            OnlineSiteImpl site = this.project.getSite();
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            File f = downloader.downloadFile(site.getURL("/api/v1/layers/" + config.getId() + "/featurelist?max=1000"), "GET", null, null, "online-layers-" + config.getId() + "-featurelist", ICancellable.DUMB);
            if (f == null) {
                return;
            }
            fis = new FileInputStream(f);
            JsonObject json = Json.createObject((InputStream)fis);
            if (json.containsKey((Object)"content")) {
                json = json.getJsonObject("content");
            }
            JsonArray features = json.getJsonArray("features");
            DataManager dataManager = DALLocator.getDataManager();
            DatabaseWorkspaceManager dbworkspace = dataManager.getDatabaseWorkspace((DataServerExplorerParameters)this.wsexplorer.getParameters());
            store = dbworkspace.getTable(2);
            store.edit(1);
            status.setRangeOfValues(0L, (long)features.size());
            status.setCurValue(0L);
            for (JsonValue feature0_json : features) {
                EditableFeature efeature;
                status.incrementCurrentValue();
                JsonObject feature_json = (JsonObject)feature0_json;
                ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                String filter = builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)feature_json.getString("name", ""))).toString();
                Feature feature = store.findFirst(filter);
                if (feature == null) {
                    efeature = store.createNewFeature(feature_json);
                    store.insert(efeature);
                    continue;
                }
                if (!overwrite) continue;
                efeature = feature.getEditable();
                efeature.set("value", (Object)feature_json.getString("value", ""));
                store.update(efeature);
            }
            status.setIndeterminate();
            status.message(i18n.getTranslation("_Writing_data"));
            store.finishEditing();
            status.terminate();
            IOUtils.closeQuietly((InputStream)fis);
        }
        catch (Exception ex) {
            LOGGER.warn("", (Throwable)ex);
            status.abort();
            throw new RuntimeException("", ex);
        }
        finally {
            IOUtils.closeQuietly(fis);
            FeatureStore.cancelEditingQuietly(store);
            DisposeUtils.disposeQuietly(store);
            status.pop();
        }
        FeatureStore.cancelEditingQuietly((FeatureStore)store);
        DisposeUtils.disposeQuietly((Disposable)store);
        status.pop();
    }

    public void download_resources(boolean overwrite, SimpleTaskStatus status) {
        OnlineLayer resources = this.project.getResourcesTable(status);
        if (resources == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Download_project_resources"));
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        FileInputStream fis = null;
        FeatureStore store = null;
        try {
            status.message(i18n.getTranslation("_Downloading_project_resources"));
            status.setIndeterminate();
            OnlineSiteImpl site = this.project.getSite();
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            File f = downloader.downloadFile(site.getURL("/api/v1/layers/" + resources.getId() + "/featurelist?max=1000"), "GET", null, null, "online-layers-" + resources.getId() + "-featurelist", ICancellable.DUMB);
            if (f == null) {
                return;
            }
            fis = new FileInputStream(f);
            JsonObject json = Json.createObject((InputStream)fis);
            if (json.containsKey((Object)"content")) {
                json = json.getJsonObject("content");
            }
            JsonArray features = json.getJsonArray("features");
            DataManager dataManager = DALLocator.getDataManager();
            DatabaseWorkspaceManager dbworkspace = dataManager.getDatabaseWorkspace((DataServerExplorerParameters)this.wsexplorer.getParameters());
            store = dbworkspace.getTable(0);
            store.edit(1);
            status.setRangeOfValues(0L, (long)features.size());
            status.setCurValue(0L);
            for (JsonValue feature0_json : features) {
                EditableFeature efeature;
                status.incrementCurrentValue();
                JsonObject feature_json = (JsonObject)feature0_json;
                ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                String filter = builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)feature_json.getString("name", ""))).toString();
                Feature feature = store.findFirst(filter);
                if (feature == null) {
                    efeature = store.createNewFeature(feature_json);
                    store.insert(efeature);
                    continue;
                }
                if (!overwrite) continue;
                efeature = feature.getEditable();
                efeature.set("resource", (Object)feature_json.getString("resource", ""));
                store.update(efeature);
            }
            status.setIndeterminate();
            status.message(i18n.getTranslation("_Writing_data"));
            store.finishEditing();
            status.terminate();
            IOUtils.closeQuietly((InputStream)fis);
        }
        catch (Exception ex) {
            LOGGER.warn("", (Throwable)ex);
            status.abort();
            throw new RuntimeException("", ex);
        }
        finally {
            IOUtils.closeQuietly(fis);
            FeatureStore.cancelEditingQuietly(store);
            DisposeUtils.disposeQuietly(store);
            status.pop();
        }
        FeatureStore.cancelEditingQuietly((FeatureStore)store);
        DisposeUtils.disposeQuietly((Disposable)store);
        status.pop();
    }

    public int download(String name, Envelope workingArea, SimpleTaskStatus status) {
        return this.download(name, Collections.singletonList(workingArea.getGeometry()).iterator(), status);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int download(String name, Iterator<Geometry> geoms, SimpleTaskStatus status) {
        int n;
        FeatureStore store;
        block14: {
            if (!this.canDownload(null, Collections.singletonList(name))) {
                return 600;
            }
            I18nManager i18n = ToolsLocator.getI18nManager();
            if (status == null) {
                status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Downloading_data"));
                status.setAutoremove(true);
                status.add();
            } else {
                status.push();
            }
            int maxFeaturesPerTile = OnlineLocator.getOnlineManager().getMaxFeaturesPerTile();
            store = null;
            FeatureRules rules = null;
            JsonObject rulesJson = null;
            try {
                status.message(i18n.getTranslation("_Downloading_data"));
                status.setIndeterminate();
                EntitiesTable.EntityRow entity = this.getWorkspaceEntity(name);
                OnlineLayerImpl layer = this.getLayer((OnlineEntity)entity, status);
                int tileSize = layer.calculateTileSize(maxFeaturesPerTile, status);
                if (tileSize != entity.getTileSize()) {
                    entity.setTileSize(tileSize);
                    entity.update();
                    this.reloadWorkspaceEntities();
                }
                TilesCalculator tiles = new TilesCalculator();
                List<Envelope> envs = tiles.calculateEnvelopes(entity.getTileSize(), geoms);
                store = this.openFeatureStore((OnlineEntity)entity);
                this.addStoreIgnoreChanges(store);
                rules = store.getDefaultFeatureType().getRules();
                rulesJson = ((SupportJson)rules).toJson();
                rules.clear();
                store.edit(2, 2);
                GeometryManager geomManager = GeometryLocator.getGeometryManager();
                IProjection layerProjection = layer.getProjection();
                String geometryName = store.getDefaultFeatureTypeQuietly().getDefaultGeometryAttributeName();
                int nenv = 0;
                for (Envelope env : envs) {
                    status.message(i18n.getTranslation("_Downloading_data_of_layer_XlayernameX_from_area_XareaX", new String[]{layer.getName(), ++nenv + "/" + envs.size()}));
                    Iterator it = layer.getData(env, maxFeaturesPerTile, status);
                    while (it.hasNext()) {
                        if (status.isCancellationRequested()) {
                            throw new UserCancelTaskException();
                        }
                        JsonObject feature_online_json = (JsonObject)it.next();
                        JsonObject feature_desktop_json = this.convertOnlineToDesktopFeature(feature_online_json, geometryName, geomManager, layerProjection);
                        if (feature_desktop_json == null) continue;
                        EditableFeature feature = store.createNewFeature(feature_desktop_json);
                        store.insert(feature);
                    }
                }
                if (layer.isReadOnly()) {
                    entity.setState(entity.getState() | 0x80);
                    entity.update();
                    this.forceReloadWorkspaceEntities();
                }
                status.setIndeterminate();
                status.message(i18n.getTranslation("_Writing_data"));
                store.finishEditing();
                status.terminate();
                n = 0;
                this.removeStoreIgnoreChanges(store);
                if (store == null || rules == null || rulesJson == null) break block14;
            }
            catch (UserCancelTaskException ex) {
                try {
                    status.cancel();
                    FeatureStore.finishEditingQuietly(store);
                    throw ex;
                    catch (Exception ex2) {
                        LOGGER.warn("", (Throwable)ex2);
                        status.abort();
                        FeatureStore.cancelEditingQuietly(store);
                        throw new RuntimeException("", ex2);
                    }
                }
                catch (Throwable throwable) {
                    this.removeStoreIgnoreChanges(store);
                    if (store != null && rules != null && rulesJson != null) {
                        ((SupportJson)rules).fromJson(rulesJson);
                    }
                    DisposeUtils.disposeQuietly(store);
                    status.pop();
                    throw throwable;
                }
            }
            ((SupportJson)rules).fromJson(rulesJson);
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        status.pop();
        return n;
    }

    private JsonObject convertOnlineToDesktopFeature(JsonObject online_json, String geometryName, GeometryManager geomManager, IProjection proj) {
        Geometry geom = null;
        JsonObject properties = online_json.getJsonObject("properties");
        JsonObject geom_json = online_json.getJsonObject("geometry");
        if (geom_json != null) {
            try {
                geom = geomManager.createFrom((Object)geom_json);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (geom != null && geom.getProjection() == null) {
                geom.setProjection(proj);
            }
        }
        if (properties == null) {
            if (geom == null) {
                return null;
            }
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add(geometryName, geom.convertToHexWKBQuietly());
            return builder.build();
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (geom == null) {
            builder.addNull(geometryName);
        } else {
            builder.add(geometryName, geom.convertToHexWKBQuietly());
        }
        builder.addAll(properties);
        return builder.build();
    }

    public boolean isAResourceTable(String entityName) {
        return false;
    }

    public boolean canDownload(MutableObject<String> message, List<String> entityCodes) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (entityCodes == null) {
            LOGGER.warn("entityCodes is null");
            if (message != null) {
                String msg = i18n.getTranslation("_It_is_mandatory_to_indicate_the_tables_on_which_you_want_to_download");
                message.setValue((Object)msg);
            }
            return false;
        }
        try {
            List<OnlineEntity> entitiesOfLocalChanges = this.getEntitiesOfLocalChanges();
            for (String entityCode : entityCodes) {
                OnlineEntity entity = this.getEntity(entityCode);
                if (entity == null || this.canDownload(message, entity, entitiesOfLocalChanges)) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.warn("It is not possible to verify that the upload can be made", (Throwable)ex);
            if (message != null) {
                String msg = i18n.getTranslation("_It_is_not_possible_to_verify_that_the_upload_can_be_made");
                message.setValue((Object)msg);
            }
            return false;
        }
    }

    public boolean canDownloadEntities(MutableObject<String> message, List<OnlineEntity> entities) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (entities == null) {
            LOGGER.warn("entities is null");
            if (message != null) {
                String msg = i18n.getTranslation("_It_is_mandatory_to_indicate_the_tables_on_which_you_want_to_download");
                message.setValue((Object)msg);
            }
            return false;
        }
        try {
            List<OnlineEntity> entitiesOfLocalChanges = this.getEntitiesOfLocalChanges();
            for (OnlineEntity entity : entities) {
                if (entity == null || this.canDownload(message, entity, entitiesOfLocalChanges)) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.warn("It is not possible to verify that the upload can be made", (Throwable)ex);
            if (message != null) {
                String msg = i18n.getTranslation("_It_is_not_possible_to_verify_that_the_upload_can_be_made");
                message.setValue((Object)msg);
            }
            return false;
        }
    }

    private boolean canDownload(MutableObject<String> message, OnlineEntity entity, List<OnlineEntity> entitiesOfLocalChanges) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            if (entity == null) {
                if (message != null) {
                    String msg = i18n.getTranslation("_It_is_mandatory_to_indicate_the_tables_on_which_you_want_to_download");
                    message.setValue((Object)msg);
                }
                return false;
            }
            if (!this.canUploadAndDownload(message, entity)) {
                return false;
            }
            if (entitiesOfLocalChanges == null) {
                entitiesOfLocalChanges = this.getEntitiesOfLocalChanges();
            }
            if (entitiesOfLocalChanges.contains(entity)) {
                if (message != null) {
                    String msg = i18n.getTranslation("_Some_of_the_selected_tables_have_changes_please_upload_or_revert_them_to_be_able_to_download_new_data");
                    message.setValue((Object)msg);
                }
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.warn("It is not possible to verify that the upload can be made", (Throwable)ex);
            if (message != null) {
                String msg = i18n.getTranslation("_It_is_not_possible_to_verify_that_the_upload_can_be_made");
                message.setValue((Object)msg);
            }
            return false;
        }
    }

    public boolean canUpload(MutableObject<String> message, List<String> entityCodes) {
        if (this.isOffline()) {
            return false;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (entityCodes == null) {
            LOGGER.warn("entityCodes is null");
            if (message != null) {
                String msg = i18n.getTranslation("_It_is_mandatory_to_indicate_the_tables_on_which_you_want_to_upload");
                message.setValue((Object)msg);
            }
            return false;
        }
        try {
            RemoteChangesTable changesTable = new RemoteChangesTable();
            for (String entityCode : entityCodes) {
                OnlineEntity entity = this.getEntity(entityCode);
                if (entity == null) continue;
                if (!this.canUploadAndDownload(message, entity)) {
                    return false;
                }
                if (!changesTable.hasEntityChanges(this, entityCode)) continue;
                if (message != null) {
                    String msg = i18n.getTranslation("_Some_of_the_selected_tables_have_remote_changes") + ". (" + entity.getEntityName() + ")";
                    message.setValue((Object)msg);
                }
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.warn("It is not possible to verify that the upload can be made", (Throwable)ex);
            if (message != null) {
                String msg = i18n.getTranslation("_It_is_not_possible_to_verify_that_the_upload_can_be_made");
                message.setValue((Object)msg);
            }
            return false;
        }
    }

    private boolean canUploadAndDownload(MutableObject<String> message, OnlineEntity entity) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (entity == null) {
            if (message != null) {
                String msg = i18n.getTranslation("_It_is_mandatory_to_indicate_the_tables_on_which_you_want_to_download");
                message.setValue((Object)msg);
            }
            return false;
        }
        switch (this.getEditMode(entity)) {
            case -1: {
                LOGGER.info("Can access to '" + entity.getEntityName() + "'.");
                if (message != null) {
                    String msg = i18n.getTranslation("_Some_of_the_selected_tables_are_damaged") + ". (" + entity.getEntityName() + ")";
                    message.setValue((Object)msg);
                }
                return false;
            }
            case 1: 
            case 2: 
            case 3: {
                LOGGER.info("Table '" + entity.getEntityName() + "' is editing.");
                if (message != null) {
                    String msg = i18n.getTranslation("_Some_of_the_selected_tables_are_being_edited") + ". (" + entity.getEntityName() + ")";
                    message.setValue((Object)msg);
                }
                return false;
            }
        }
        return true;
    }

    public int removeRemoteChanges(String entityCode) {
        return this.removeRemoteChanges(entityCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeRemoteChanges(String entityCode, SimpleTaskStatus status) {
        int n;
        OnlineEntity entity = this.getEntity(entityCode);
        if (entity == null) {
            return 240;
        }
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Update-clean " + entity.getEntityName());
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        FeatureStore remoteChangesStore = null;
        FeatureStore localChangesStore = null;
        FeatureStore entitiesStore = null;
        try {
            status.message("Deleting temporary remote changes (" + entity.getEntityName() + ")");
            remoteChangesStore = this.openFeatureStore("ONLINE_REMOTECHANGES", false);
            localChangesStore = this.openFeatureStore("ONLINE_WSCHANGES", false);
            entitiesStore = this.openFeatureStore("ONLINE_ENTITIES", false);
            this.removeRemoteChanges(remoteChangesStore, localChangesStore, entitiesStore, (EntitiesTable.EntityRow)entity);
            status.message("Delete temporary remote changes completed");
            status.terminate();
            n = 0;
        }
        catch (Exception ex) {
            int n2;
            try {
                LOGGER.warn("Can't deleting temporary remote changes of " + entity.getEntityName() + ".", (Throwable)ex);
                status.message("Can't deleting temporary remote changes of " + entity.getEntityName() + ".");
                status.abort();
                n2 = 83;
            }
            catch (Throwable throwable) {
                status.pop();
                DisposeUtils.dispose(remoteChangesStore);
                DisposeUtils.dispose(localChangesStore);
                DisposeUtils.dispose(entitiesStore);
                throw throwable;
            }
            status.pop();
            DisposeUtils.dispose((Disposable)remoteChangesStore);
            DisposeUtils.dispose((Disposable)localChangesStore);
            DisposeUtils.dispose((Disposable)entitiesStore);
            return n2;
        }
        status.pop();
        DisposeUtils.dispose((Disposable)remoteChangesStore);
        DisposeUtils.dispose((Disposable)localChangesStore);
        DisposeUtils.dispose((Disposable)entitiesStore);
        return n;
    }

    private void removeRemoteChanges(FeatureStore remoteChangesStore, FeatureStore localChangesStore, FeatureStore entitiesStore, EntitiesTable.EntityRow entity) throws DataException {
        RemoteChangesTable remoteChangesTable = new RemoteChangesTable();
        remoteChangesTable.delete(remoteChangesStore, entity.getEntityCode());
        WorkspaceChangesTable localChangesTable = new WorkspaceChangesTable();
        localChangesTable.changeState(localChangesStore, entity.getEntityCode(), 16, 1);
        if (entity.getState() == 16) {
            entity.setState(4);
            boolean needFinish = false;
            if (entitiesStore.getMode() == 0) {
                entitiesStore.edit(3);
                needFinish = true;
            }
            entity.update(entitiesStore);
            if (needFinish) {
                entitiesStore.finishEditing();
            }
        }
    }

    public boolean canUpdate(MutableObject<String> message, String tableName) {
        if (this.isOffline()) {
            return false;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        EntitiesTable.EntityRow lentity = this.getWorkspaceEntityByName(tableName);
        if (lentity == null) {
            if (message != null) {
                String msg = i18n.getTranslation("_Cant_update_table_XtablaX_dont_exists", new String[]{tableName});
                message.setValue((Object)msg);
            }
            return false;
        }
        switch (this.getEditMode((OnlineEntity)lentity)) {
            case -1: {
                if (message != null) {
                    String msg = i18n.getTranslation("_Cant_update_table_XtablaX_dont_exists", new String[]{tableName});
                    message.setValue((Object)msg);
                }
                return false;
            }
            case 1: 
            case 2: 
            case 3: {
                LOGGER.info("Table '" + lentity.getEntityName() + "' is editing.");
                if (message != null) {
                    String msg = i18n.getTranslation("_Cant_update_table_XtablaX_are_in_edition", new String[]{tableName});
                    message.setValue((Object)msg);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEditMode(OnlineEntity entity) {
        FeatureStore userStore = null;
        try {
            userStore = this.openFeatureStore(entity);
            if (userStore == null) {
                int n = -1;
                return n;
            }
            int n = FeatureStoreObserver.getEditMode(userStore);
            return n;
        }
        finally {
            DisposeUtils.dispose((Disposable)userStore);
        }
    }

    public boolean updateNeedMerge(String entityName) {
        if (this.isOffline()) {
            return false;
        }
        RemoteChangesTable remoteChangesTable = new RemoteChangesTable();
        EntitiesTable.EntityRow entity = this.getWorkspaceEntity(entityName);
        return remoteChangesTable.updateNeedMerge(this, entity.getEntityCode());
    }

    public int update(String tableName, SimpleTaskStatus status) {
        return this.update(tableName, false, status);
    }

    public int update(String tableName, boolean merge, SimpleTaskStatus status) {
        return this.update(tableName, merge, null, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int update(String tableName, boolean merge, MutableLong localChangesModifieds, SimpleTaskStatus status) {
        int n;
        DataTransaction transaction;
        block53: {
            if (this.isOffline()) {
                return 10001;
            }
            I18nManager i18n = ToolsLocator.getI18nManager();
            if (localChangesModifieds == null) {
                localChangesModifieds = new MutableLong(0L);
            }
            boolean errcode = false;
            if (status == null) {
                status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Updating") + " " + tableName);
                status.setAutoremove(true);
                status.add();
            } else {
                status.push();
                status.setTitle(i18n.getTranslation("_Updating") + " " + tableName);
            }
            LOGGER.debug("===: UPDATE " + this.getCode() + ", '" + this.getLabel() + "', " + tableName);
            RemoteChangesTable remoteChangesTable = new RemoteChangesTable();
            WorkspaceChangesTable localChangesTable = new WorkspaceChangesTable();
            DisposableFeatureSetIterable remoteChanges = null;
            FeatureStore workspaceChangesStore = null;
            FeatureStore remoteChangesStore = null;
            FeatureStore userStore = null;
            FeatureStore entitiesStore = null;
            FeatureRules rules = null;
            JsonObject rulesJson = null;
            transaction = null;
            try {
                EditableFeature ef;
                if (status.isCancellationRequested()) {
                    throw new UserCancelTaskException();
                }
                transaction = DALLocator.getDataManager().createTransaction();
                transaction.begin();
                entitiesStore = this.openFeatureStore("ONLINE_ENTITIES", true);
                transaction.add((DataStore)entitiesStore);
                entitiesStore.edit(3);
                EntitiesTable.EntityRow lentity = this.getWorkspaceEntityByName(tableName);
                if (!merge) {
                    status.message("Checking the need to merge");
                    if (remoteChangesTable.updateNeedMerge(this, lentity.getEntityCode())) {
                        status.message("Can't update without merge.");
                        status.abort();
                        int n2 = 82;
                        return n2;
                    }
                }
                String dataCodeFieldName = lentity.getFeatureIdFieldName();
                status.message("Searching remote changes (" + lentity.getEntityName() + ")");
                userStore = this.openFeatureStore((OnlineEntity)lentity);
                if (userStore == null) {
                    this.create_table((OnlineEntity)lentity);
                    userStore = this.openFeatureStore((OnlineEntity)lentity);
                }
                rules = userStore.getDefaultFeatureType().getRules();
                rulesJson = ((SupportJson)rules).toJson();
                rules.clear();
                transaction.add((DataStore)userStore);
                userStore.edit(3);
                workspaceChangesStore = this.openFeatureStore("ONLINE_WSCHANGES", true);
                transaction.add((DataStore)workspaceChangesStore);
                workspaceChangesStore.edit(3);
                remoteChangesStore = this.openFeatureStore("ONLINE_REMOTECHANGES", true);
                transaction.add((DataStore)remoteChangesStore);
                remoteChangesStore.edit(3);
                remoteChanges = remoteChangesTable.getSelectedsByEntityCodeAsIterator(this, lentity.getCode());
                transaction.add((Disposable)remoteChanges);
                long sz = ContainerUtils.size64((Size64)remoteChanges);
                status.setRangeOfValues(0L, sz);
                status.setCurValue(0L);
                if (!remoteChanges.isEmpty()) {
                    this.addStoreIgnoreChanges(userStore);
                    status.message("Updating table (" + lentity.getEntityName() + ")");
                    FeatureType type = userStore.getDefaultFeatureTypeQuietly();
                    ExpressionEvaluatorManager expManager = ExpressionEvaluatorLocator.getManager();
                    ExpressionBuilder builder = expManager.createExpressionBuilder();
                    FilteredLogger log = new FilteredLogger(LOGGER, "update", 100);
                    for (Feature feature : remoteChanges) {
                        if (status.isCancellationRequested()) {
                            throw new UserCancelTaskException();
                        }
                        RemoteChangesTable.RemoteChangeRow remoteChangeRow = new RemoteChangesTable.RemoteChangeRow(this, feature);
                        switch (remoteChangeRow.getOperation()) {
                            case 2: {
                                FeatureAttributeDescriptor[] feats;
                                LOGGER.debug("===: UPDATE: insert");
                                switch (remoteChangeRow.getStatus()) {
                                    case 16: {
                                        feats = this.getUserFeaturesConflictWithRemoteChange((OnlineEntity)lentity, remoteChangeRow, userStore);
                                        if (feats == null) break;
                                        for (Feature feature2 : feats) {
                                            if (feature2 == null) continue;
                                            feats.getFeatureSet().delete(feature2);
                                            workspaceChangesStore.delete("\"WSCH_FEATURECODE\" = '" + feature2.getString(lentity.getFeatureIdFieldName()) + "'");
                                        }
                                        DisposeUtils.disposeQuietly((Disposable)feats);
                                    }
                                }
                                JsonObject dataJson = remoteChangeRow.getRelatedFeatureDataAsJson();
                                if (dataJson == null) {
                                    log.warn("A feature (CODE=" + remoteChangeRow.getRelatedFeatureCode() + ") has been retrieved with the DAT_DATA field set to null.");
                                    break;
                                }
                                ef = userStore.createNewFeature(dataJson);
                                userStore.insert(ef);
                                break;
                            }
                            case 1: {
                                void var32_43;
                                LOGGER.debug("===: UPDATE: update");
                                JsonObject dataJson = remoteChangeRow.getRelatedFeatureDataAsJson();
                                if (dataJson == null) {
                                    log.warn("A feature (CODE=" + remoteChangeRow.getRelatedFeatureCode() + ") has been retrieved with the DAT_DATA field set to null.");
                                    break;
                                }
                                builder.set(null);
                                FeatureAttributeDescriptor[] feats = type.getPrimaryKey();
                                int n2 = feats.length;
                                boolean bl = false;
                                while (var32_43 < n2) {
                                    FeatureAttributeDescriptor attr = feats[var32_43];
                                    builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attr.getName()), (ExpressionBuilder.Value)builder.constant(Json.toObject((JsonValue)((JsonValue)dataJson.get((Object)attr.getName()))))));
                                    ++var32_43;
                                }
                                Feature f = userStore.findFirst(builder.toString());
                                if (f == null) {
                                    WorkspaceChangesTable.WorkspaceChangeRow localChange = localChangesTable.find(this, workspaceChangesStore, lentity.getEntityCode(), remoteChangeRow.getRelatedFeatureCode());
                                    if (localChange != null) {
                                        if (localChange.getOperation() == 0) {
                                            ef = userStore.createNewFeature(dataJson);
                                            userStore.insert(ef);
                                            break;
                                        }
                                        throw new NullPointerException("Can't update null feature (" + builder.toString() + ").");
                                    }
                                    ef = userStore.createNewFeature(dataJson);
                                    userStore.insert(ef);
                                    break;
                                }
                                ef = f.getEditable();
                                ef.copyFrom(dataJson);
                                if (this.removeMissingValues(ef, dataJson)) {
                                    log.warn("Missing attributes in the json (kill the admin?)");
                                }
                                userStore.update(ef);
                                break;
                            }
                            case 0: {
                                LOGGER.debug("===: UPDATE: delete");
                                userStore.delete("\"" + dataCodeFieldName + "\"='" + remoteChangeRow.getRelatedFeatureCode() + "'");
                            }
                        }
                        status.incrementCurrentValue();
                    }
                }
                if (merge) {
                    status.message("Searching local changes to merge (" + lentity.getEntityName() + ")");
                    DisposeUtils.disposeQuietly((Disposable)remoteChanges);
                    remoteChanges = remoteChangesTable.getNotSelectedsByEntityCodeAsIterator(this, lentity.getCode());
                    transaction.add((Disposable)remoteChanges);
                    sz = ContainerUtils.size64((Size64)remoteChanges);
                    status.setRangeOfValues(0L, sz);
                    status.setCurValue(0L);
                    if (!remoteChanges.isEmpty()) {
                        this.addStoreIgnoreChanges(userStore);
                        status.message("Adding to local changes (" + lentity.getEntityName() + ")");
                        for (Feature feature : remoteChanges) {
                            if (status.isCancellationRequested()) {
                                throw new UserCancelTaskException();
                            }
                            RemoteChangesTable.RemoteChangeRow remoteChangeRow = new RemoteChangesTable.RemoteChangeRow(this, feature);
                            Feature f = userStore.findFirst("\"" + lentity.getFeatureIdFieldName() + "\" = " + remoteChangeRow.getRelatedFeatureCode());
                            switch (remoteChangeRow.getOperation()) {
                                case 2: {
                                    LOGGER.debug("===: UPDATE: insert");
                                    if (f == null) {
                                        LOGGER.debug("===: UPDATE: add delete operation to RelatedFeatureCode " + remoteChangeRow.getRelatedFeatureCode());
                                        this.addDeleteChange(null, lentity, workspaceChangesStore, remoteChangeRow.getRelatedFeatureCode(), null, null);
                                    } else {
                                        LOGGER.debug("===: UPDATE: add update operation to RelatedFeatureCode " + remoteChangeRow.getRelatedFeatureCode());
                                        this.addChange(null, lentity, 1, workspaceChangesStore, f, feature, null);
                                    }
                                    localChangesModifieds.increment();
                                    break;
                                }
                                case 1: {
                                    LOGGER.debug("===: UPDATE: update");
                                    if (f == null) {
                                        LOGGER.debug("===: UPDATE: add delete operation to RelatedFeatureCode " + remoteChangeRow.getRelatedFeatureCode());
                                        this.addDeleteChange(null, lentity, workspaceChangesStore, remoteChangeRow.getRelatedFeatureCode(), null, null);
                                    } else {
                                        LOGGER.debug("===: UPDATE: add update operation to RelatedFeatureCode " + remoteChangeRow.getRelatedFeatureCode());
                                        long revNumber = remoteChangeRow.getRevisionNumber();
                                        ef = f.getEditable();
                                        ef.setLong("feat_version_gvol", revNumber);
                                        userStore.update(ef);
                                        this.addChange(null, lentity, 1, workspaceChangesStore, f, feature, null);
                                    }
                                    localChangesModifieds.increment();
                                    break;
                                }
                                case 0: {
                                    LOGGER.debug("===: UPDATE: delete");
                                    if (f != null) {
                                        userStore.delete("\"" + dataCodeFieldName + "\"=" + remoteChangeRow.getRelatedFeatureCode());
                                        ef = userStore.createNewFeature(f);
                                        String localEntityName = lentity.getEntityName();
                                        long newRelatedFeatureCode = this.createUniqueCodeLong(localEntityName);
                                        ef.setLong(lentity.getFeatureIdFieldName(), newRelatedFeatureCode);
                                        userStore.insert(ef);
                                        workspaceChangesStore.delete("\"WSCH_FEATURECODE\"=" + remoteChangeRow.getRelatedFeatureCode());
                                        LOGGER.debug("===: UPDATE: add insert operation to RelatedFeatureCode " + newRelatedFeatureCode);
                                        this.addChange(null, lentity, 2, workspaceChangesStore, (Feature)ef, null, null);
                                        localChangesModifieds.increment();
                                        break;
                                    }
                                    this.removeLocalDeleteIfExists(remoteChangeRow.getRelatedFeatureCode(), workspaceChangesStore);
                                    localChangesModifieds.increment();
                                }
                            }
                            status.incrementCurrentValue();
                        }
                    }
                }
                localChangesTable.removeLocalChangesRelatedToSelectedRemoteChanges(this, (OnlineEntity)lentity);
                remoteChangesTable.delete(remoteChangesStore, lentity.getEntityCode());
                status.message("Updating metadata tables");
                if (!this.isCorrupt((OnlineEntity)lentity, userStore, 0, false)) {
                    lentity.updateState(transaction);
                }
                lentity.update(entitiesStore);
                transaction.commit();
                this.forceReloadWorkspaceEntities();
                status.message("Update completed");
                status.terminate();
                n = 0;
                this.removeStoreIgnoreChanges(userStore);
                if (userStore == null || rules == null || rulesJson == null) break block53;
            }
            catch (UserCancelTaskException ex) {
                LOGGER.warn("User cancelled.", (Throwable)ex);
                status.message("User cancelled");
                status.cancel();
                if (transaction != null) {
                    try {
                        transaction.commit();
                    }
                    catch (DataException ex1) {
                        DataTransaction.rollbackQuietly((DataTransaction)transaction);
                    }
                }
                throw new UserCancelTaskException();
            }
            catch (Exception ex) {
                LOGGER.warn("Can't update.", (Throwable)ex);
                status.message("Can't update");
                status.abort();
                int n3 = 80;
                return n3;
            }
            finally {
                this.removeStoreIgnoreChanges(userStore);
                if (userStore != null && rules != null && rulesJson != null) {
                    ((SupportJson)rules).fromJson(rulesJson);
                }
                DisposeUtils.disposeQuietly((Disposable)transaction);
                status.pop();
            }
            ((SupportJson)rules).fromJson(rulesJson);
        }
        DisposeUtils.disposeQuietly((Disposable)transaction);
        status.pop();
        return n;
    }

    private DisposableFeatureSetIterable getUserFeaturesConflictWithRemoteChange(OnlineEntity lentity, RemoteChangesTable.RemoteChangeRow remoteChange, FeatureStore store) throws DataException {
        if (store == null) {
            return null;
        }
        FeatureType featType = lentity.getFeatureType();
        JsonObject data = remoteChange.getRelatedFeatureDataAsJson();
        ExpressionEvaluatorManager expManager = ExpressionEvaluatorLocator.getManager();
        ExpressionBuilder builder = expManager.createExpressionBuilder();
        builder.set(null);
        for (FeatureAttributeDescriptor attr : featType) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)lentity.getFeatureIdFieldName(), (CharSequence[])new CharSequence[]{attr.getName()}) || !attr.isIndexed() || attr.allowIndexDuplicateds()) continue;
            Object value = Json.toObject((JsonObject)data, (String)attr.getName());
            builder.or((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attr.getName()), (ExpressionBuilder.Value)builder.constant(value)));
        }
        ExpressionBuilder.Value value = builder.value();
        if (value == null) {
            return null;
        }
        ExpressionBuilder.BinaryOperator filter = builder.and((ExpressionBuilder.Value)builder.not((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(lentity.getFeatureIdFieldName()), (ExpressionBuilder.Value)builder.constant((Object)remoteChange.getRelatedFeatureCode()))), value);
        FeatureSet feats = store.getFeatureSet(filter.toString());
        return feats.iterable();
    }

    private boolean removeMissingValues(EditableFeature ef, JsonObject dataJson) {
        boolean hasMissingValues = false;
        try {
            FeatureType ftype = ef.getType();
            for (FeatureAttributeDescriptor attr : ftype) {
                if (dataJson.containsKey((Object)attr.getName()) || !attr.allowNull() || !attr.isReadOnly() || attr.isPrimaryKey()) continue;
                ef.set(attr.getName(), null);
                hasMissingValues = true;
            }
            return hasMissingValues;
        }
        catch (Exception e) {
            LOGGER.debug("Can't remove missing values", (Throwable)e);
            return hasMissingValues;
        }
    }

    private void removeLocalDeleteIfExists(long relatedFeatureCode, FeatureStore changesStore) {
        try {
            changesStore.delete("\"WSCH_FEATURECODE\" = " + relatedFeatureCode + " AND " + "\"" + "WSCH_OPERATION" + "\" = " + 0);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't delete local-delete if exists", e);
        }
    }

    public int merge(String tableName, MutableLong localChangesCreated, SimpleTaskStatus status) {
        return this.update(tableName, true, localChangesCreated, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int synchronize(List<OnlineEntity> entities, Envelope workingArea, SimpleTaskStatus status) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Synchronizing"));
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        try {
            this.outdateAllSynch();
            for (OnlineEntity entity : entities) {
                status.setTitle(i18n.getTranslation("_Synchronizing") + " " + entity.getEntityName());
                int n = this.synchronizeEntity(entity, workingArea, status);
                if (n != 0) {
                    int n2 = n;
                    return n2;
                }
                this.synchTimes.put(entity.getEntityName(), System.currentTimeMillis());
            }
            status.terminate();
        }
        finally {
            status.pop();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int synchronizeEntity(final OnlineEntity entity, Envelope workingArea, SimpleTaskStatus theStatus) {
        int n;
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (theStatus == null) {
            theStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Synchronizing") + " " + entity.getEntityName());
            theStatus.setAutoremove(true);
            theStatus.add();
        } else {
            theStatus.push();
            theStatus.setTitle(i18n.getTranslation("_Synchronizing") + " " + entity.getEntityName());
        }
        final SimpleTaskStatus status = theStatus;
        status.setIndeterminate();
        status.message(entity.getEntityName());
        final WorkspaceChangesTable wct = new WorkspaceChangesTable();
        Iterator<Geometry> geoms = null;
        Iterator<Geometry> geoms2 = null;
        FeatureStore remoteStore = null;
        FeatureStore localStore = null;
        FeatureSet remoteSet = null;
        DisposableIterator remoteIt = null;
        FeatureSet localSet = null;
        DisposableIterator localIt = null;
        FeatureStore localChangesStore = null;
        FeatureStore remoteChangesStore = null;
        FeatureStore entitiesStore = null;
        final GeometryManager geomManager = GeometryLocator.getGeometryManager();
        File tmpRemote = null;
        final MutableObject localDeleteChangesSet = new MutableObject(null);
        DisposableIterator localDeleteChangesIt = null;
        int maxFeaturesPerTile = OnlineLocator.getOnlineManager().getMaxFeaturesPerTile();
        try {
            Object entity2;
            status.message(i18n.getTranslation("_Calculating_area"));
            final OnlineWorkspaceImpl wc = this;
            final DisposableFeatureSetIterable it = wct.getByEntityCodeAsIterator(this, entity.getEntityCode());
            long geoms1Size = it.size64();
            geoms = new Iterator<Geometry>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Geometry next() {
                    status.incrementCurrentValue();
                    Feature f = (Feature)it.next();
                    WorkspaceChangesTable.WorkspaceChangeRow row = new WorkspaceChangesTable.WorkspaceChangeRow(wc, f);
                    if (row.getOperation() == 0) {
                        return null;
                    }
                    return row.getRelatedFeature().getDefaultGeometry();
                }
            };
            final DisposableFeatureSetIterable it2 = wct.getByEntityCodeAsIterator(this, entity.getEntityCode());
            long geoms2Size = it2.size64();
            geoms2 = new Iterator<Geometry>(){

                @Override
                public boolean hasNext() {
                    return it2.hasNext();
                }

                @Override
                public Geometry next() {
                    try {
                        status.incrementCurrentValue();
                        Feature f = (Feature)it2.next();
                        WorkspaceChangesTable.WorkspaceChangeRow row = new WorkspaceChangesTable.WorkspaceChangeRow(wc, f);
                        JsonObject dataAsJson = row.getDataAsJson();
                        if (dataAsJson == null) {
                            return null;
                        }
                        String geom_wkb = dataAsJson.getString(entity.getGeometryFieldName());
                        if (geom_wkb == null) {
                            return null;
                        }
                        return geomManager.createFrom(geom_wkb);
                    }
                    catch (GeometryException ex) {
                        LOGGER.warn("Can't get geometry of workspace change", (Throwable)ex);
                        return null;
                    }
                }
            };
            final OnlineLayer layer = this.project.getLayer(t -> StringUtils.equals((CharSequence)t.getName(), (CharSequence)entity.getEntityName()), SimpleTaskStatus.FAKE_STATUS);
            TilesCalculator tilesCalculator = new TilesCalculator();
            if (entity.getTileSize() <= 0) {
                status.message(i18n.getTranslation("_Preparing_tiles"));
                DisposableFeatureSetIterable it3 = wct.getByEntityCodeAsIterator(this, entity.getEntityCode());
                status.setRangeOfValues(0L, it3.size64());
                status.setCurValue(0L);
                final Envelope env = geomManager.createEnvelope(0);
                final MutableLong countElements = new MutableLong(0L);
                while (it3.hasNext()) {
                    String geom_wkb;
                    if (status.isCancellationRequested()) {
                        throw new UserCancelTaskException();
                    }
                    status.incrementCurrentValue();
                    Feature f = (Feature)it3.next();
                    WorkspaceChangesTable.WorkspaceChangeRow row = new WorkspaceChangesTable.WorkspaceChangeRow(wc, f);
                    JsonObject dataAsJson = row.getDataAsJson();
                    if (dataAsJson == null || (geom_wkb = dataAsJson.getString(entity.getGeometryFieldName())) == null) continue;
                    Geometry geom = geomManager.createFrom(geom_wkb);
                    env.add(geom);
                    countElements.increment();
                }
                TilesCalculator.CalculatorData tileData = new TilesCalculator.CalculatorData(){

                    @Override
                    public Envelope getEnvelope() {
                        return env;
                    }

                    @Override
                    public double getWidth() {
                        double w = env.getLength(0);
                        return w;
                    }

                    @Override
                    public double getHeight() {
                        double h = env.getLength(1);
                        return h;
                    }

                    @Override
                    public long getElements(Envelope envelope) {
                        return countElements.getValue();
                    }
                };
                status.message(i18n.getTranslation("_Calculating_tile_size"));
                Dimension cellSize = tilesCalculator.calculateCellSize(tileData, maxFeaturesPerTile, status);
                EntitiesTable.EntityRow wsEntity = this.getWorkspaceEntity(entity.getEntityName());
                wsEntity.setTileSize(cellSize.height);
                wsEntity.update();
                this.reloadWorkspaceEntities();
                entity2 = wsEntity;
            } else {
                entity2 = entity;
            }
            status.message(i18n.getTranslation("_Calculating_areas"));
            status.setRangeOfValues(0L, geoms1Size + geoms2Size);
            status.setCurValue(0L);
            List<Envelope> envs = tilesCalculator.calculateEnvelopes(entity2.getTileSize(), (Iterator<Geometry>)new ChainedIterator(new Iterator[]{geoms, geoms2, workingArea == null ? Collections.EMPTY_LIST.iterator() : Collections.singletonList(workingArea.getGeometry()).iterator()}));
            if (!CollectionUtils.isEmpty(envs)) {
                status.message(i18n.getTranslation("_Downloading_data"));
                File f = ((HasAFile)this.getExplorerParameters()).getFile();
                String tmpPathname = H2SpatialUtils.removeH2FileNameExtension((String)f.getAbsolutePath()) + "_tmp_" + entity2.getEntityName();
                tmpRemote = ToolsLocator.getFoldersManager().getUniqueFile(new String[]{tmpPathname});
                DataManager dataManager = DALLocator.getDataManager();
                DataServerExplorerParameters expParameters = DALLocator.getDataManager().createServerExplorerParameters("H2Spatial");
                ((HasAFile)expParameters).setFile(tmpRemote);
                DataServerExplorer explorer = dataManager.openServerExplorer("H2Spatial", expParameters);
                JDBCNewStoreParameters params = (JDBCNewStoreParameters)explorer.getAddParameters(entity2.getEntityName());
                EditableFeatureType ft = params.getDefaultFeatureType();
                ft.add(layer.getFeatureCodeFieldName(), layer.getFeatureCodeType()).setIsPrimaryKey(true);
                ft.add("feat_version_gvol", 4);
                ft.add("feature", 8, 4096);
                explorer.add("H2Spatial", (NewDataStoreParameters)params, true);
                DataStoreParameters storeParams = explorer.get(entity2.getEntityName());
                remoteStore = (FeatureStore)dataManager.openStore("H2Spatial", storeParams);
                remoteStore.edit(2, 2);
                String geometryName = entity2.getFeatureType().getDefaultGeometryAttributeName();
                IProjection layerProj = entity2.getCRSAsProjection();
                int countEnv = 1;
                for (Envelope env : envs) {
                    status.message(i18n.getTranslation("_Downloading_area") + " (" + countEnv++ + "/" + envs.size() + ")");
                    Iterator data = layer.getData(env, 1000, status);
                    while (data.hasNext()) {
                        if (status.isCancellationRequested()) {
                            throw new UserCancelTaskException();
                        }
                        JsonObject json = (JsonObject)data.next();
                        JsonObject properties_json = json.getJsonObject("properties");
                        EditableFeature feat = remoteStore.createNewFeature();
                        feat.set(layer.getFeatureCodeFieldName(), Json.toObject((JsonValue)((JsonValue)properties_json.get((Object)layer.getFeatureCodeFieldName()))));
                        feat.set("feat_version_gvol", (Object)properties_json.getInt("feat_version_gvol", 0));
                        feat.set("feature", (Object)this.convertOnlineToDesktopFeature(json, geometryName, geomManager, layerProj).toString());
                        remoteStore.insert(feat);
                    }
                }
                remoteStore.finishEditing();
            }
            status.message(i18n.getTranslation("_Cleaning_remote_changes"));
            status.setIndeterminate();
            localChangesStore = this.openFeatureStore("ONLINE_WSCHANGES", true);
            remoteChangesStore = this.openFeatureStore("ONLINE_REMOTECHANGES", true);
            entitiesStore = this.openFeatureStore("ONLINE_ENTITIES", true);
            this.removeRemoteChanges(remoteChangesStore, localChangesStore, entitiesStore, (EntitiesTable.EntityRow)entity2);
            if (remoteStore != null) {
                status.message(i18n.getTranslation("_Generating_remote_changes_list"));
                final FeatureStore finalLocalChangesStore = localChangesStore;
                final FeatureStore finalRemoteChangesStore = remoteChangesStore;
                remoteChangesStore.edit(2);
                localChangesStore.edit(3);
                PatchGenerator.PatchHandler<Feature> handler = new PatchGenerator.PatchHandler<Feature>(){
                    WorkspaceChangesTable.WorkspaceChangeRow lastLocalChange = null;

                    @Override
                    public int compareId(Feature r, Feature l) {
                        return Integer.compare(r.getInt(layer.getFeatureCodeFieldName()), l.getInt(layer.getFeatureCodeFieldName()));
                    }

                    @Override
                    public boolean isNew(Feature l) {
                        return OnlineWorkspaceImpl.this.isNewCode(l.get(layer.getFeatureCodeFieldName()));
                    }

                    @Override
                    public boolean isLocalChange(Feature l) {
                        this.lastLocalChange = wct.find(wc, finalLocalChangesStore, entity2.getEntityCode(), l.get(layer.getFeatureCodeFieldName()));
                        return this.lastLocalChange != null;
                    }

                    @Override
                    public boolean isDeleteLocalChange(Feature r) {
                        this.lastLocalChange = wct.find(wc, finalLocalChangesStore, entity2.getEntityCode(), r.get(layer.getFeatureCodeFieldName()));
                        if (this.lastLocalChange == null) {
                            return false;
                        }
                        return this.lastLocalChange.getOperation() == 0;
                    }

                    @Override
                    public boolean isRemoteChange(Feature r, Feature l) {
                        return r.getInt("feat_version_gvol") != l.getInt("feat_version_gvol");
                    }

                    @Override
                    public void addRemoteChangeDelete(Feature l, boolean conflict) {
                        RemoteChangesTable.RemoteChangeRow row = new RemoteChangesTable.RemoteChangeRow(wc);
                        row.setData(l.toJson().toString());
                        row.setEntityCode(entity2.getEntityCode());
                        row.setOperation(0);
                        row.setRevisionNumber(l.getInt("feat_version_gvol"));
                        row.setSelected(true);
                        row.setStatus(conflict ? 16 : 1);
                        row.setRelatedFeatureCode(l.get(layer.getFeatureCodeFieldName()));
                        row.setCode(OnlineWorkspaceImpl.this.createUniqueCode());
                        row.insert(finalRemoteChangesStore);
                        if (conflict) {
                            if (this.lastLocalChange == null || !this.lastLocalChange.getEntityCode().equals(row.getEntityCode()) || this.lastLocalChange.getRelatedFeatureCode() != row.getRelatedFeatureCode()) {
                                this.lastLocalChange = wct.find(wc, finalLocalChangesStore, entity2.getEntityCode(), l.get(layer.getFeatureCodeFieldName()));
                            }
                            if (this.lastLocalChange != null && this.lastLocalChange.getStatus() != 16) {
                                this.lastLocalChange.setStatus(16);
                                this.lastLocalChange.update(finalLocalChangesStore);
                            }
                            ((EntitiesTable.EntityRow)entity2).setState(16);
                        }
                    }

                    @Override
                    public void addRemoteChangeModify(Feature r, boolean conflict) {
                        RemoteChangesTable.RemoteChangeRow row = new RemoteChangesTable.RemoteChangeRow(wc);
                        row.setData(r.getString("feature"));
                        row.setEntityCode(entity2.getEntityCode());
                        row.setOperation(1);
                        row.setRevisionNumber(r.getInt("feat_version_gvol"));
                        row.setSelected(true);
                        row.setStatus(conflict ? 16 : 1);
                        row.setRelatedFeatureCode(r.get(layer.getFeatureCodeFieldName()));
                        row.setCode(OnlineWorkspaceImpl.this.createUniqueCode());
                        row.insert(finalRemoteChangesStore);
                        if (conflict) {
                            if (this.lastLocalChange == null || !this.lastLocalChange.getEntityCode().equals(row.getEntityCode()) || this.lastLocalChange.getRelatedFeatureCode() != (long)r.getInt(layer.getFeatureCodeFieldName())) {
                                this.lastLocalChange = wct.find(wc, finalLocalChangesStore, entity2.getEntityCode(), r.get(layer.getFeatureCodeFieldName()));
                            }
                            if (this.lastLocalChange != null && this.lastLocalChange.getStatus() != 16) {
                                this.lastLocalChange.setStatus(16);
                                this.lastLocalChange.update(finalLocalChangesStore);
                            }
                            ((EntitiesTable.EntityRow)entity2).setState(16);
                        }
                    }

                    @Override
                    public void addRemoteChangeInsert(Feature r) {
                        RemoteChangesTable.RemoteChangeRow row = new RemoteChangesTable.RemoteChangeRow(wc);
                        row.setData(r.getString("feature"));
                        row.setEntityCode(entity2.getEntityCode());
                        row.setOperation(2);
                        row.setRevisionNumber(r.getInt("feat_version_gvol"));
                        row.setSelected(true);
                        row.setStatus(1);
                        row.setCode(OnlineWorkspaceImpl.this.createUniqueCode());
                        row.insert(finalRemoteChangesStore);
                    }
                };
                PatchGenerator patchGenerator = PatchGenerator.create();
                localStore = this.openFeatureStore((OnlineEntity)entity2);
                remoteSet = remoteStore.getFeatureSet((String)null, layer.getFeatureCodeFieldName());
                remoteIt = remoteSet.fastIterator();
                GeometryExpressionBuilder expBuilder = (GeometryExpressionBuilder)localStore.createExpressionBuilder();
                FeatureType localStoreFt = localStore.getDefaultFeatureTypeQuietly();
                String geomName = localStoreFt.getDefaultGeometryAttributeName();
                IProjection localStoreProj = localStoreFt.getDefaultSRS();
                for (Envelope env : envs) {
                    expBuilder.or((ExpressionBuilder.Value)expBuilder.ST_Intersects((ExpressionBuilder.Value)expBuilder.column(geomName), (ExpressionBuilder.Value)expBuilder.envelope(env, localStoreProj)));
                }
                localSet = localStore.getFeatureSet(expBuilder.build(), layer.getFeatureCodeFieldName());
                localIt = localSet.fastIterator();
                long remoteSetSize = remoteSet.getSize();
                status.setRangeOfValues(0L, localSet.getSize() + remoteSetSize);
                status.setCurValue(0L);
                patchGenerator.generate(handler, remoteIt, localIt, status);
                DisposeUtils.dispose((Disposable)remoteIt);
                status.message(i18n.getTranslation("_Fixing_local_changes_list"));
                status.setIndeterminate();
                remoteIt = remoteSet.fastIterator();
                PatchGenerator.FixLocalDeleteChangesHandler<Feature> fixHandler = new PatchGenerator.FixLocalDeleteChangesHandler<Feature>(){

                    @Override
                    public int compareId(Feature r, Feature l) {
                        return Integer.compare(r.getInt(layer.getFeatureCodeFieldName()), l.getInt("WSCH_FEATURECODE"));
                    }

                    @Override
                    public void removeLocalChange(Feature l) {
                        try {
                            ((FeatureSet)localDeleteChangesSet.getValue()).delete(l);
                        }
                        catch (DataException ex) {
                            throw new RuntimeException("Can't remove local change", ex);
                        }
                    }
                };
                localDeleteChangesSet.setValue((Object)wct.getDeleteChanges(entity2.getEntityCode(), localChangesStore));
                localDeleteChangesIt = ((FeatureSet)localDeleteChangesSet.getValue()).fastIterator();
                status.setRangeOfValues(0L, ((FeatureSet)localDeleteChangesSet.getValue()).getSize() + remoteSetSize);
                status.setCurValue(0L);
                patchGenerator.fixLocalDeleteChanges(fixHandler, localDeleteChangesIt, remoteIt, status);
                status.setIndeterminate();
                status.message(i18n.getTranslation("_Finishing_synchronization"));
                remoteChangesStore.finishEditing();
                localChangesStore.finishEditing();
            }
            status.setIndeterminate();
            status.message(i18n.getTranslation("_Finishing_synchronization"));
            if (tmpRemote != null) {
                H2SpatialUtils.server_stop();
                H2SpatialUtils.removeH2db((File)tmpRemote);
            }
            status.terminate();
            n = 0;
            status.pop();
        }
        catch (UserCancelTaskException ex) {
            FeatureStore.cancelEditingQuietly(remoteStore);
            FeatureStore.cancelEditingQuietly(remoteChangesStore);
            FeatureStore.cancelEditingQuietly(localChangesStore);
            status.cancel();
            int n2 = 17;
            return n2;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't synchronize", (Throwable)ex);
            FeatureStore.cancelEditingQuietly(remoteStore);
            FeatureStore.cancelEditingQuietly(remoteChangesStore);
            FeatureStore.cancelEditingQuietly(localChangesStore);
            status.abort();
            int n3 = 800;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            status.pop();
            DisposeUtils.disposeQuietly((Object)geoms);
            DisposeUtils.disposeQuietly(remoteChangesStore);
            DisposeUtils.disposeQuietly(localChangesStore);
            DisposeUtils.disposeQuietly(remoteIt);
            DisposeUtils.disposeQuietly(remoteSet);
            DisposeUtils.disposeQuietly(remoteStore);
            DisposeUtils.disposeQuietly(localDeleteChangesIt);
            DisposeUtils.disposeQuietly((Disposable)((Disposable)localDeleteChangesSet.getValue()));
            DisposeUtils.disposeQuietly(localIt);
            DisposeUtils.disposeQuietly(localSet);
            DisposeUtils.disposeQuietly(localStore);
            DisposeUtils.disposeQuietly(entitiesStore);
            return n3;
        }
        finally {
            status.pop();
            DisposeUtils.disposeQuietly(geoms);
            DisposeUtils.disposeQuietly(remoteChangesStore);
            DisposeUtils.disposeQuietly(localChangesStore);
            DisposeUtils.disposeQuietly(remoteIt);
            DisposeUtils.disposeQuietly(remoteSet);
            DisposeUtils.disposeQuietly(remoteStore);
            DisposeUtils.disposeQuietly(localDeleteChangesIt);
            DisposeUtils.disposeQuietly((Disposable)((Disposable)localDeleteChangesSet.getValue()));
            DisposeUtils.disposeQuietly(localIt);
            DisposeUtils.disposeQuietly(localSet);
            DisposeUtils.disposeQuietly(localStore);
            DisposeUtils.disposeQuietly(entitiesStore);
        }
        DisposeUtils.disposeQuietly((Object)geoms);
        DisposeUtils.disposeQuietly((Disposable)remoteChangesStore);
        DisposeUtils.disposeQuietly((Disposable)localChangesStore);
        DisposeUtils.disposeQuietly(remoteIt);
        DisposeUtils.disposeQuietly(remoteSet);
        DisposeUtils.disposeQuietly(remoteStore);
        DisposeUtils.disposeQuietly(localDeleteChangesIt);
        DisposeUtils.disposeQuietly((Disposable)((Disposable)localDeleteChangesSet.getValue()));
        DisposeUtils.disposeQuietly(localIt);
        DisposeUtils.disposeQuietly(localSet);
        DisposeUtils.disposeQuietly((Disposable)localStore);
        DisposeUtils.disposeQuietly((Disposable)entitiesStore);
        return n;
    }

    public WorkingArea getCurrentWorkingArea() {
        return this.currentWorkingArea;
    }

    public void setCurrentWorkingArea(WorkingArea workingArea) {
        this.currentWorkingArea = workingArea;
        VarsTable varsTable = new VarsTable();
        varsTable.set(this, CONFIG_CURRENT_WORKINGAREA, workingArea.toJson().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCodeGeneratorSequence(String entityName) {
        EntitiesTable.EntityRow entity = this.getWorkspaceEntity(entityName);
        long sequence = 0L;
        FeatureStore store = null;
        try {
            store = this.openFeatureStore((OnlineEntity)entity);
            FeatureQuery query = store.createFeatureQuery();
            query.addAggregate("MIN", entity.getFeatureIdFieldName());
            Feature f = store.findFirst(query);
            long l = f.getLong(entity.getFeatureIdFieldName());
            if (sequence > l) {
                sequence = l;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't refresh code generator sequence");
        }
        finally {
            DisposeUtils.dispose((Disposable)store);
        }
        this.codeGenerator.initSequence(entityName, sequence - 1L);
    }

    public boolean isSynchOutdated(OnlineEntity entity) {
        Long synchTime = this.synchTimes.get(entity.getEntityName());
        if (synchTime == null) {
            return true;
        }
        return System.currentTimeMillis() - synchTime > (long)(this.syncExpirationTimeInMinutes * 60000);
    }

    public void outdateAllSynch() {
        this.synchTimes = new HashMap<String, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int upload(List<String> entityNames, SimpleTaskStatus status) {
        int n;
        if (this.isOffline()) {
            return 10001;
        }
        MutableObject msg = new MutableObject();
        if (!this.canUpload((MutableObject<String>)msg, entityNames)) {
            if (status != null) {
                status.message((String)msg.getValue());
            }
            return 500;
        }
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Upload");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        FeatureStore entitiesStore = null;
        String logmsg = null;
        String errmsg = null;
        int errcode = 0;
        String firstlogmsg = logmsg;
        int firsterrcode = errcode;
        String firsterrmsg = errmsg;
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            status.setIndeterminate();
            WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
            entitiesStore = this.openFeatureStore("ONLINE_ENTITIES", true);
            entitiesStore.edit(1);
            this.addStoreIgnoreChanges(entitiesStore);
            status.message("Preparing upload");
            boolean continue_on_error = OnlineLocator.getOnlineManager().getContinueWhenUploadFails();
            for (String entityName : entityNames) {
                FeatureSet fset;
                DisposableFeatureSetIterable set;
                block53: {
                    if (status.isCancellationRequested()) break;
                    OnlineEntity entity = this.getEntity(entityName);
                    if (entity == null) {
                        throw new AbortException(240, "Don't exits table '" + entityName + "'");
                    }
                    OnlineLayerImpl layer = this.getLayer(entity, status);
                    if (layer == null) {
                        throw new AbortException(38, "Don't exits layer '" + entityName + "'");
                    }
                    FeatureStore userStore = null;
                    set = null;
                    fset = null;
                    try {
                        status.setIndeterminate();
                        status.message(i18n.getTranslation("_Preparing_upload") + " " + entityName);
                        userStore = this.getFeatureStore(entity);
                        userStore.edit(3);
                        set = changesTable.getSelectedsByEntityCodeAsIterator(this, entity.getEntityCode());
                        fset = set.getFeatureSet();
                        fset.getFeatureStore().edit(3);
                        this.addStoreIgnoreChanges(userStore);
                        status.setRangeOfValues(0L, fset.getSize());
                        status.message(i18n.getTranslation("_Sending") + " " + entityName);
                        block14: for (Feature feature : set) {
                            if (status.isCancellationRequested()) break;
                            status.incrementCurrentValue();
                            WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, feature);
                            long relatedFeatureCode = change.getRelatedFeatureCode();
                            JsonObject response_json = null;
                            int responseStatus = -1;
                            Feature userFeat = null;
                            JsonObject props = null;
                            EditableFeature editUserFeat = null;
                            errcode = 0;
                            switch (change.getOperation()) {
                                case 2: {
                                    JsonObject geom_json;
                                    userFeat = this.getRelatedFeature(userStore, entity, relatedFeatureCode);
                                    if (userFeat == null) {
                                        LOGGER.warn("Can't retrieve feature with " + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName());
                                        fset.delete(feature);
                                        break;
                                    }
                                    Geometry geom = null;
                                    response_json = layer.send_insert(userFeat);
                                    responseStatus = response_json.getInt("status", -1);
                                    if (responseStatus != 0) {
                                        logmsg = "Can't upload feature with " + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName() + ", status=" + responseStatus;
                                        errcode = 510;
                                        errmsg = response_json.getString("message") + " (" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + ")";
                                    } else {
                                        props = response_json.getJsonObject("feature").getJsonObject("properties");
                                        if (props == null) {
                                            logmsg = "Feature from server is invalid" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName() + ", status=" + responseStatus;
                                            errcode = 530;
                                            errmsg = "Feature from server is invalid (" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + ")";
                                        } else if (response_json.getJsonObject("feature").containsKey((Object)"geometry") && !response_json.getJsonObject("feature").isNull("geometry")) {
                                            geom_json = response_json.getJsonObject("feature").getJsonObject("geometry");
                                            geom = GeometryUtils.createFrom((Object)geom_json);
                                            if (geom == null) {
                                                logmsg = "Geometry from server is invalid" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName() + ", status=" + responseStatus;
                                                errcode = 530;
                                                errmsg = "Geometry from server is invalid (" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + ")";
                                            } else {
                                                IProjection geomProj = geom.getProjection();
                                                IProjection layerProj = layer.getProjection();
                                                if (geomProj != null && !layerProj.equals(geomProj)) {
                                                    logmsg = "Expected projection " + layerProj.getAbrev() + " found projection" + geomProj.getAbrev() + " (" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName() + ", status=" + responseStatus;
                                                    errcode = 530;
                                                    errmsg = "Expected projection " + layerProj.getAbrev() + " found projection" + geomProj.getAbrev() + " (" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + ")";
                                                }
                                            }
                                        }
                                    }
                                    if (errcode != 0) {
                                        LOGGER.warn(logmsg);
                                        if (continue_on_error) {
                                            if (firsterrcode != 0) continue block14;
                                            firstlogmsg = logmsg;
                                            firsterrcode = errcode;
                                            firsterrmsg = errmsg;
                                            break;
                                        }
                                        throw new AbortException(errcode, errmsg);
                                    }
                                    userStore.delete(userFeat);
                                    editUserFeat = userStore.createNewFeature(userFeat);
                                    editUserFeat.copyFrom(props);
                                    editUserFeat.setDefaultGeometry(geom);
                                    editUserFeat.set(layer.getFeatureCodeFieldName(), Json.toObject((JsonValue)((JsonValue)props.get((Object)layer.getFeatureCodeFieldName()))));
                                    editUserFeat.set("feat_version_gvol", (Object)props.getInt("feat_version_gvol"));
                                    editUserFeat.set("feat_date_gvol", (Object)props.getString("feat_date_gvol"));
                                    userStore.insert(editUserFeat);
                                    fset.delete(feature);
                                    break;
                                }
                                case 1: {
                                    JsonObject geom_json;
                                    userFeat = this.getRelatedFeature(userStore, entity, relatedFeatureCode);
                                    if (userFeat == null) {
                                        LOGGER.warn("Can't retrieve feature with " + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName());
                                        fset.delete(feature);
                                        break;
                                    }
                                    Geometry geom = null;
                                    response_json = layer.send_update(userFeat);
                                    responseStatus = response_json.getInt("status", -1);
                                    if (responseStatus != 0) {
                                        logmsg = "Can't upload feature with " + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName() + ", status=" + responseStatus;
                                        errcode = 510;
                                        errmsg = response_json.getString("message") + " (" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + ")";
                                        break;
                                    }
                                    props = response_json.getJsonObject("feature").getJsonObject("properties");
                                    if (props == null) {
                                        logmsg = "Feature from server is invalid" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName() + ", status=" + responseStatus;
                                        errcode = 530;
                                        errmsg = "Feature from server is invalid (" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + ")";
                                    } else if (response_json.getJsonObject("feature").containsKey((Object)"geometry") && !response_json.getJsonObject("feature").isNull("geometry")) {
                                        geom_json = response_json.getJsonObject("feature").getJsonObject("geometry");
                                        geom = GeometryUtils.createFrom((Object)geom_json);
                                        if (geom == null) {
                                            logmsg = "Geometry from server is invalid" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName() + ", status=" + responseStatus;
                                            errcode = 530;
                                            errmsg = "Geometry from server is invalid (" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + ")";
                                        } else if (geom.getProjection() != null && !layer.getProjection().equals(geom.getProjection())) {
                                            logmsg = "Expected projection " + layer.getProjection().getAbrev() + " found projection" + geom.getProjection().getAbrev() + " (" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName() + ", status=" + responseStatus;
                                            errcode = 530;
                                            errmsg = "Expected projection " + layer.getProjection().getAbrev() + " found projection" + geom.getProjection().getAbrev() + " (" + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + ")";
                                        }
                                    }
                                    if (errcode != 0) {
                                        LOGGER.warn(logmsg);
                                        if (continue_on_error) {
                                            if (firsterrcode != 0) continue block14;
                                            firstlogmsg = logmsg;
                                            firsterrcode = errcode;
                                            firsterrmsg = errmsg;
                                            break;
                                        }
                                        throw new AbortException(errcode, errmsg);
                                    }
                                    editUserFeat = userFeat.getEditable();
                                    editUserFeat.set("feat_version_gvol", (Object)props.getInt("feat_version_gvol"));
                                    editUserFeat.set("feat_date_gvol", (Object)props.getString("feat_date_gvol"));
                                    editUserFeat.setDefaultGeometry(geom);
                                    userStore.update(editUserFeat);
                                    fset.delete(feature);
                                    break;
                                }
                                case 0: {
                                    if (relatedFeatureCode < 0L) {
                                        LOGGER.warn("Can't delete feature with " + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName());
                                        fset.delete(feature);
                                        break;
                                    }
                                    responseStatus = layer.send_delete(relatedFeatureCode);
                                    if (responseStatus != 0) {
                                        logmsg = "Can't delete feature with " + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode + " of layer " + layer.getName();
                                        errcode = 520;
                                        errmsg = "Can't delete feature with " + layer.getFeatureCodeFieldName() + "=" + relatedFeatureCode;
                                    }
                                    if (errcode != 0) {
                                        LOGGER.warn(logmsg);
                                        if (continue_on_error) {
                                            if (firsterrcode != 0) continue block14;
                                            firstlogmsg = logmsg;
                                            firsterrcode = errcode;
                                            firsterrmsg = errmsg;
                                            break;
                                        }
                                        throw new AbortException(errcode, errmsg);
                                    }
                                    fset.delete(feature);
                                    break;
                                }
                                default: {
                                    logmsg = "Unexpected local change operation " + change.getOperation() + " for change " + change.getCode();
                                    errcode = 500;
                                    errmsg = null;
                                    LOGGER.warn(logmsg);
                                    if (continue_on_error) {
                                        if (firsterrcode != 0) continue block14;
                                        firstlogmsg = logmsg;
                                        firsterrcode = errcode;
                                        firsterrmsg = errmsg;
                                        break;
                                    }
                                    throw new AbortException(errcode, errmsg);
                                }
                            }
                        }
                        if (userStore == null) break block53;
                    }
                    catch (Throwable throwable) {
                        if (userStore != null) {
                            userStore.finishEditing();
                            this.removeStoreIgnoreChanges(userStore);
                        }
                        if (fset != null) {
                            fset.getFeatureStore().finishEditing();
                        }
                        DisposeUtils.dispose(set);
                        throw throwable;
                    }
                    userStore.finishEditing();
                    this.removeStoreIgnoreChanges(userStore);
                }
                if (fset != null) {
                    fset.getFeatureStore().finishEditing();
                }
                DisposeUtils.dispose((Disposable)set);
                EntitiesTable.EntityRow entityRow = this.getWorkspaceEntity(entityName);
                if (entityRow == null) continue;
                this.updateEntityState(entityRow, false);
                entityRow.update(entitiesStore);
            }
            entitiesStore.finishEditing();
            if (firsterrcode != 0) {
                throw new AbortException(firsterrcode, firsterrmsg);
            }
            status.message("Upload completed");
            status.terminate();
            n = 0;
        }
        catch (AbortException ex) {
            LOGGER.warn("Can't upload changes.", (Throwable)ex);
            FeatureStore.cancelEditingQuietly(entitiesStore);
            if (ex.message != null) {
                status.message(ex.message);
            }
            status.abort();
            int n2 = ex.err;
            this.removeStoreIgnoreChanges(entitiesStore);
            DisposeUtils.disposeQuietly((Disposable)entitiesStore);
            status.pop();
            return n2;
        }
        catch (Exception ex2) {
            LOGGER.warn("Can't upload changes.", (Throwable)ex2);
            FeatureStore.cancelEditingQuietly(entitiesStore);
            status.message("Can't upload changes");
            status.abort();
            int n3 = 500;
            this.removeStoreIgnoreChanges(entitiesStore);
            {
                catch (Throwable throwable) {
                    this.removeStoreIgnoreChanges(entitiesStore);
                    DisposeUtils.disposeQuietly(entitiesStore);
                    status.pop();
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)entitiesStore);
            status.pop();
            return n3;
        }
        this.removeStoreIgnoreChanges(entitiesStore);
        DisposeUtils.disposeQuietly((Disposable)entitiesStore);
        status.pop();
        return n;
    }

    public OnlineLayerImpl getLayer(OnlineEntity entity, SimpleTaskStatus status) {
        return this.getProject().getLayer(t -> StringUtils.equalsIgnoreCase((CharSequence)t.getName(), (CharSequence)entity.getEntityName()), status);
    }

    public long simpleSearchCount(String name, Expression filter, SimpleTaskStatus status) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Downloading_data"));
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        try {
            status.message(i18n.getTranslation("_Counting_data"));
            status.setIndeterminate();
            OnlineEntity entity = this.getEntity(name);
            OnlineLayerImpl layer = this.getLayer(entity, status);
            long count = layer.getCountElements(filter);
            status.terminate();
            long l = count;
            return l;
        }
        catch (UserCancelTaskException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("", (Throwable)ex);
            status.abort();
            throw new RuntimeException("", ex);
        }
        finally {
            status.pop();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FeaturePagingHelper simpleSearch(String name, Expression filter, SimpleTaskStatus status) {
        FeaturePagingHelper featurePagingHelper;
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Downloading_data"));
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        int maxFeaturesPerTile = OnlineLocator.getOnlineManager().getMaxFeaturesPerTile();
        DataManager dataManager = DALLocator.getDataManager();
        FeatureStore tmpStore = null;
        try {
            status.message(i18n.getTranslation("_Downloading_data"));
            status.setIndeterminate();
            OnlineEntity entity = this.getEntity(name);
            OnlineLayerImpl layer = this.getLayer(entity, status);
            String tmpPathname = "_tmp_" + entity.getEntityName();
            File tmpRemote = ToolsLocator.getFoldersManager().getUniqueTemporaryFile(new String[]{tmpPathname});
            DataServerExplorerParameters expParameters = DALLocator.getDataManager().createServerExplorerParameters("H2Spatial");
            ((HasAFile)expParameters).setFile(tmpRemote);
            DataServerExplorer explorer = dataManager.openServerExplorer("H2Spatial", expParameters);
            JDBCNewStoreParameters params = (JDBCNewStoreParameters)explorer.getAddParameters(entity.getEntityName());
            EditableFeatureType ft = params.getDefaultFeatureType();
            ft.addAll(entity.getFeatureType());
            explorer.add("H2Spatial", (NewDataStoreParameters)params, true);
            DataStoreParameters storeParams = explorer.get(entity.getEntityName());
            tmpStore = (FeatureStore)dataManager.openStore("H2Spatial", storeParams);
            tmpStore.edit(2, 2);
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            IProjection layerProjection = layer.getProjection();
            String geometryName = tmpStore.getDefaultFeatureTypeQuietly().getDefaultGeometryAttributeName();
            status.message(i18n.getTranslation("_Downloading_data") + " (" + filter.getPhrase() + ") ");
            Iterator it = layer.getData(filter, maxFeaturesPerTile, status);
            while (it.hasNext()) {
                if (status.isCancellationRequested()) {
                    status.cancel();
                    throw new UserCancelTaskException();
                }
                JsonObject feature_online_json = (JsonObject)it.next();
                JsonObject feature_desktop_json = this.convertOnlineToDesktopFeature(feature_online_json, geometryName, geomManager, layerProjection);
                if (feature_desktop_json == null) continue;
                EditableFeature feature = tmpStore.createNewFeature(feature_desktop_json);
                tmpStore.insert(feature);
            }
            status.setIndeterminate();
            status.message(i18n.getTranslation("_Writing_data"));
            tmpStore.finishEditing();
            FeatureQuery query = tmpStore.createFeatureQuery();
            FeaturePagingHelper pager = dataManager.createFeaturePagingHelper(tmpStore, query, 100);
            status.terminate();
            featurePagingHelper = pager;
        }
        catch (UserCancelTaskException ex) {
            try {
                FeatureStore.cancelEditingQuietly(tmpStore);
                throw ex;
                catch (Exception ex2) {
                    LOGGER.warn("", (Throwable)ex2);
                    status.abort();
                    FeatureStore.cancelEditingQuietly(tmpStore);
                    throw new RuntimeException("", ex2);
                }
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(tmpStore);
                status.pop();
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)tmpStore);
        status.pop();
        return featurePagingHelper;
    }

    public int getMinResultForAlert() {
        return this.minResultsForAlert;
    }

    public List getValues(OnlineEntity entity, String name, SimpleTaskStatus status) {
        OnlineLayerImpl layer = this.getLayer(entity, status);
        return layer.getValues(name);
    }

    public LocalDateTime getLastSync(OnlineEntity entity) {
        Long t = this.synchTimes.get(entity.getEntityName());
        if (t == null) {
            return LocalDateTime.MIN;
        }
        Instant instant = Instant.ofEpochMilli(t);
        return instant.atZone(ZoneOffset.systemDefault()).toLocalDateTime();
    }

    public boolean isShowHiddenTables() {
        return this.showHiddenTables;
    }

    public void setShowHiddenTables(boolean showHiddenTables) {
        this.showHiddenTables = showHiddenTables;
        VarsTable varsTable = new VarsTable();
        varsTable.set(this, CONFIG_SHOW_HIDDEN_TABLES, BooleanUtils.toStringTrueFalse((boolean)showHiddenTables));
    }

    private static class AbortException
    extends RuntimeException {
        private final int err;
        private final String message;

        public AbortException(int err, String message) {
            super(message);
            this.err = err;
            this.message = message;
        }
    }
}

