/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl.workspace;

import javax.json.JsonObject;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.online.lib.api.workingcopy.WorkingArea;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class WorkingAreaImpl
implements WorkingArea {
    private static final String WORKINGAREA_PERSISTENCE_DEFINITION_NAME = "Online_WorkingAreaImpl";
    private String label;
    private Envelope envelope;

    public WorkingAreaImpl() {
    }

    WorkingAreaImpl(String label, Envelope envelope) {
        this.label = label;
        this.envelope = envelope;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setValue(Envelope envelope) {
        this.envelope = envelope;
    }

    public String getLabel() {
        return this.label;
    }

    public Envelope getValue() {
        return this.envelope;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("label", this.label);
        state.set("envelope", (Persistent)this.envelope);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.label = (String)state.get("label");
        this.envelope = (Envelope)state.get("envelope");
    }

    public String toString() {
        return this.getLabel();
    }

    public void fromJson(JsonObject json) {
        this.label = json.getString("label");
        this.envelope = GeometryUtils.createFrom((String)json.getString("envelope")).getEnvelope();
    }

    public JsonObjectBuilder toJsonBuilder() {
        try {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add_class((Object)this);
            builder.add("label", this.label);
            builder.add("envelope", this.envelope.getGeometry().convertToHexWKB());
            return builder;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create JsonObject.", ex);
        }
    }

    public static void selfRegister() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(WORKINGAREA_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(WorkingAreaImpl.class, WORKINGAREA_PERSISTENCE_DEFINITION_NAME, "Online_WorkingAreaImpl persistent definition", null, null);
            definition.addDynFieldString("label");
            definition.addDynFieldObject("envelope").setClassOfValue(Envelope.class);
        }
        Json.registerSerializer(WorkingAreaImpl.class);
    }

    public Object clone() throws CloneNotSupportedException {
        WorkingAreaImpl other = (WorkingAreaImpl)super.clone();
        other.envelope = (Envelope)CloneableUtils.cloneQuietly((Cloneable)this.envelope);
        return other;
    }

    public boolean isEmpty() {
        return this.envelope == null || this.envelope.isEmpty();
    }
}

