/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl.workspace.tables;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractTable.class);
    private final String tableName;
    private final FeatureType featureType;

    public AbstractTable(String tableName, FeatureType featureType) {
        this.tableName = tableName;
        this.featureType = featureType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public static abstract class AbstractRow {
        protected final OnlineWorkingcopy workspace;
        private final String tableName;
        private final String codeName;
        private Map<String, Object> values;

        protected AbstractRow(OnlineWorkingcopy workspace, String tableName, String codeName) {
            this.tableName = tableName;
            this.codeName = codeName;
            this.workspace = workspace;
            this.values = new HashMap<String, Object>();
        }

        protected AbstractRow(OnlineWorkingcopy workspace, String tableName, String codeName, Feature feature) {
            this(workspace, tableName, codeName);
            if (feature != null) {
                FeatureType ft = feature.getType();
                for (FeatureAttributeDescriptor attrdesc : ft) {
                    String attrname = attrdesc.getName();
                    this.values.put(attrname, feature.get(attrname));
                }
            }
        }

        protected boolean isNull(String attrname) {
            return this.values.get(attrname) == null;
        }

        protected String getString(String attrname) {
            return (String)this.values.get(attrname);
        }

        protected Timestamp getTimestamp(String attrname) {
            return this.values.getOrDefault(attrname, null);
        }

        protected Object get(String attrname) {
            return this.values.get(attrname);
        }

        protected int getInt(String attrname) {
            return this.getInt(attrname, -1);
        }

        protected int getInt(String attrname, int defaultValue) {
            Integer n = (Integer)this.values.get(attrname);
            if (n == null) {
                return defaultValue;
            }
            return n;
        }

        protected long getLong(String attrname) {
            return this.getLong(attrname, -1L);
        }

        protected long getLong(String attrname, long defaultValue) {
            Long n = (Long)this.values.get(attrname);
            if (n == null) {
                return defaultValue;
            }
            return n;
        }

        protected boolean getBoolean(String attrname) {
            return this.getBoolean(attrname, false);
        }

        protected boolean getBoolean(String attrname, boolean defaultValue) {
            Boolean n = (Boolean)this.values.get(attrname);
            if (n == null) {
                return defaultValue;
            }
            return n;
        }

        protected String getLabelOfValue(String attrname) {
            FeatureType ft = this.workspace.getFeatureType(this.tableName);
            FeatureAttributeDescriptor attrdesc = ft.getAttributeDescriptor(attrname);
            String label = attrdesc.getLabelOfValue(this.values.get(attrname));
            return label;
        }

        protected void set(String attrname, Object value) {
            this.values.put(attrname, value);
        }

        protected void set(String attrname, String value) {
            this.values.put(attrname, value);
        }

        protected void set(String attrname, int value) {
            this.values.put(attrname, value);
        }

        protected void set(String attrname, long value) {
            this.values.put(attrname, value);
        }

        protected void set(String attrname, boolean value) {
            this.values.put(attrname, value);
        }

        protected void set(String attrname, Timestamp value) {
            this.values.put(attrname, value);
        }

        public void update() {
            FeatureStore store = null;
            boolean pendingFinishEditing = false;
            try {
                store = this.workspace.openFeatureStore(this.tableName, false);
                if (store.getMode() == 0) {
                    store.edit(3);
                    pendingFinishEditing = true;
                }
                this.update(store);
                if (pendingFinishEditing) {
                    store.finishEditing();
                }
            }
            catch (Exception ex) {
                try {
                    if (store != null && pendingFinishEditing) {
                        store.cancelEditingQuietly();
                    }
                    throw new RuntimeException("Can't update feature on '" + this.tableName + "'.", ex);
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(store);
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)store);
        }

        public void insert() {
            FeatureStore store = null;
            boolean pendingFinishEditing = false;
            try {
                store = this.workspace.openFeatureStore(this.tableName, false);
                if (!store.isEditing()) {
                    store.edit(1);
                    pendingFinishEditing = true;
                }
                this.insert(store);
                if (pendingFinishEditing) {
                    store.finishEditing();
                }
            }
            catch (Exception ex) {
                try {
                    if (store != null && pendingFinishEditing) {
                        store.cancelEditingQuietly();
                    }
                    throw new RuntimeException("Can't update feature on '" + this.tableName + "'.", ex);
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(store);
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)store);
        }

        public EditableFeature createFeature(FeatureStore store) throws DataException {
            EditableFeature f = store.createNewFeature();
            for (Map.Entry<String, Object> value : this.values.entrySet()) {
                if (!f.hasValue(value.getKey())) continue;
                f.set(value.getKey(), value.getValue());
            }
            return f;
        }

        public void insert(FeatureStore store) {
            try {
                store.insert(this.createFeature(store));
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't insert feature on '" + this.tableName + "'.", ex);
            }
        }

        public void update(FeatureStore store) {
            try {
                EditableFeature feature = this.createFeature(store);
                feature.setUpdatable(true);
                store.update(feature);
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't update feature on '" + this.tableName + "'.", ex);
            }
        }

        public void update(FeatureStore store, FeatureSet fSet) {
            try {
                EditableFeature feature = this.createFeature(store);
                feature.setUpdatable(true);
                fSet.update(feature);
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't update feature on '" + this.tableName + "'.", ex);
            }
        }

        public void delete(FeatureStore store) {
            try {
                store.delete("\"" + this.codeName + "\" = '" + this.getString(this.codeName) + "'");
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't delete feature on '" + this.tableName + "'.", ex);
            }
        }

        public String getCode() {
            return this.getString(this.codeName);
        }

        public void newCode() {
            this.set(this.codeName, this.workspace.createUniqueCode());
        }

        public void setCode(String code) {
            this.set(this.codeName, code);
        }
    }
}

