/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl.workspace.tables;

import java.util.Collection;
import java.util.List;
import javax.json.JsonObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineEntityEditable;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.lib.impl.OnlineCategories;
import org.gvsig.online.lib.impl.OnlineUtils;
import org.gvsig.online.lib.impl.workspace.tables.AbstractTable;
import org.gvsig.online.lib.impl.workspace.tables.RemoteChangesTable;
import org.gvsig.online.lib.impl.workspace.tables.WorkspaceChangesTable;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.Tags;

public class EntitiesTable
extends AbstractTable {
    public static final String TABLE_NAME = "ONLINE_ENTITIES";
    public static final String COD_ENTITY = "COD_ENTITY";
    public static final String ENTITY_NAME = "ENT_NAME";
    private static final String ENTITY_STATE = "ENT_STATE";
    private static final String FEATUREID_FIELD_NAME = "ENT_FEATURECODE";
    private static final String GEOMETRY_FIELD_NAME = "ENT_GEOMNAME";
    private static final String DESCRIPTION = "ENT_DESCRIPTION";
    private static final String FIELD_FOR_LABEL = "ENT_FIELDFORLABEL";
    private static final String FEATURETYPE = "ENT_FEATURETYPE";
    private static final String LABEL = "ENT_LABEL";
    private static final String DATA_MODELS = "ENT_DATA_MODELS";
    private static final String CATEGORY = "ENT_CATEGORY";
    private static final String ENT_PROJECTION = "ENT_PROJECTION";
    private static final String ENT_CUSTOMDATA = "ENT_CUSTOMDATA";
    private static final String ENT_TILESIZE = "ENT_TILESIZE";

    public EntitiesTable() {
        super(TABLE_NAME, EntitiesTable.featureType());
    }

    public EntityRow getByEntityName(OnlineWorkingcopy workspace, String entityName) {
        FeatureStore store = null;
        try {
            EntityRow row;
            store = workspace.getFeatureStore(TABLE_NAME);
            Feature f = store.findFirst("\"ENT_NAME\"='" + entityName + "'");
            if (f == null) {
                EntityRow entityRow = null;
                return entityRow;
            }
            EntityRow entityRow = row = new EntityRow(workspace, f);
            return entityRow;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve entity '" + entityName + "'.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public EntityRow getByEntityCode(OnlineWorkingcopy workspace, String entityCode) {
        FeatureStore store = null;
        try {
            EntityRow row;
            store = workspace.getFeatureStore(TABLE_NAME);
            Feature f = store.findFirst("\"COD_ENTITY\"='" + entityCode + "'");
            if (f == null) {
                EntityRow entityRow = null;
                return entityRow;
            }
            EntityRow entityRow = row = new EntityRow(workspace, f);
            return entityRow;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve entity '" + entityCode + "'.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public DisposableFeatureSetIterable getAll(OnlineWorkingcopy workspace) {
        FeatureStore store = null;
        try {
            DisposableFeatureSetIterable items;
            store = workspace.getFeatureStore(TABLE_NAME);
            DisposableFeatureSetIterable disposableFeatureSetIterable = items = store.getFeatureSet().iterable();
            return disposableFeatureSetIterable;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve all entities.", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("Online entities");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.add(COD_ENTITY, 8).setSize(60).setIsPrimaryKey(true).setLabel("Code");
        ft.add(ENTITY_NAME, 8).setIsIndexed(true).setAllowIndexDuplicateds(false).setSize(200).setLabel("Name");
        ft.add(FEATUREID_FIELD_NAME, 8).setSize(200).setLabel("Pk field name").setDescription("Name of the primary key of the table.");
        ft.add(ENTITY_STATE, 4).setLabel("State").setDescription("State of entity.");
        ft.add(GEOMETRY_FIELD_NAME, 8).setSize(200).setLabel("Geometry field name").setDescription("Name of the geometry attribute.");
        ft.add(FIELD_FOR_LABEL, 8).setSize(200).setLabel("Field for label");
        ft.add(LABEL, 8).setSize(200).setLabel("Label");
        ft.add(DESCRIPTION, 8).setSize(4096).setLabel("Description");
        ft.add(FEATURETYPE, 8).setSize(4096).setLabel("Feature type");
        ft.add(DATA_MODELS, 8).setSize(200).setLabel("Data models");
        ft.add(ENT_PROJECTION, 8).setSize(100).setLabel("Projection");
        ft.add(ENT_TILESIZE, 4).setLabel("Tile size");
        ft.add(ENT_CUSTOMDATA, 8).setTag("dynform.resizeWeight", (Object)60).setTag("dynform.label.empty", (Object)true).setDataProfileName("Text").setSize(4096).setLabel("Custom data").setGroup("Custom data").setOrder(10);
        return ft.getNotEditableCopy();
    }

    public static class EntityRow
    extends AbstractTable.AbstractRow
    implements OnlineEntityEditable {
        private FeatureType featureType;
        private OnlineCategories categories;

        public EntityRow(OnlineWorkingcopy workspace) {
            super(workspace, EntitiesTable.TABLE_NAME, EntitiesTable.COD_ENTITY);
        }

        public EntityRow(OnlineWorkingcopy workspace, Feature feature) {
            super(workspace, EntitiesTable.TABLE_NAME, EntitiesTable.COD_ENTITY, feature);
        }

        public String getEntityName() {
            return this.getString(EntitiesTable.ENTITY_NAME);
        }

        public String getFeatureIdFieldName() {
            return this.getString(EntitiesTable.FEATUREID_FIELD_NAME);
        }

        public String getGeometryFieldName() {
            return this.getString(EntitiesTable.GEOMETRY_FIELD_NAME);
        }

        public String getDescription() {
            return this.getString(EntitiesTable.DESCRIPTION);
        }

        public String getFieldForLabel() {
            return this.getString(EntitiesTable.FIELD_FOR_LABEL);
        }

        public String getEntityCode() {
            return this.getCode();
        }

        public String getCategory() {
            return this.getString(EntitiesTable.CATEGORY);
        }

        public OnlineCategories getCategoriesAsList() {
            if (this.categories == null) {
                this.categories = new OnlineCategories(this.getCategory());
            }
            return this.categories;
        }

        public Tags getCategoryTags(String category) {
            OnlineCategories l = this.getCategoriesAsList();
            if (l == null) {
                return Tags.EMPTY_TAGS;
            }
            return l.getTags(category);
        }

        public String getFirstCategory() {
            OnlineCategories l = this.getCategoriesAsList();
            if (CollectionUtils.isEmpty((Collection)l)) {
                return null;
            }
            return l.get(0);
        }

        public String getFirstDataModel() {
            List<String> l = this.getDataModelsAsList();
            if (CollectionUtils.isEmpty(l)) {
                return null;
            }
            return l.get(0);
        }

        public String getLabel() {
            return this.getString(EntitiesTable.LABEL);
        }

        public String getFeatureTypeAsJson() {
            return this.getString(EntitiesTable.FEATURETYPE);
        }

        public FeatureType getFeatureType() {
            if (this.featureType == null) {
                String s = this.getFeatureTypeAsJson();
                JsonObject json = Json.createObject((String)s);
                this.featureType = DALLocator.getDataManager().createFeatureType(json);
            }
            return this.featureType;
        }

        public EntityRow setEntityName(String entityName) {
            this.set(EntitiesTable.ENTITY_NAME, entityName);
            if (StringUtils.isBlank((CharSequence)this.getLabel())) {
                this.setLabel(entityName);
            }
            return this;
        }

        public EntityRow setFeatureIdFieldName(String name) {
            this.set(EntitiesTable.FEATUREID_FIELD_NAME, name);
            return this;
        }

        public EntityRow setGeometryFieldName(String name) {
            this.set(EntitiesTable.GEOMETRY_FIELD_NAME, name);
            return this;
        }

        public EntityRow setDescription(String description) {
            this.set(EntitiesTable.DESCRIPTION, description);
            return this;
        }

        public EntityRow setFieldForLabel(String fieldForLabel) {
            this.set(EntitiesTable.FIELD_FOR_LABEL, fieldForLabel);
            return this;
        }

        public EntityRow setFeatureTypeAsJson(String json) {
            this.set(EntitiesTable.FEATURETYPE, json);
            this.featureType = null;
            return this;
        }

        public EntityRow setFeatureType(FeatureType featureType) {
            this.set(EntitiesTable.FEATURETYPE, featureType.toJson().toString());
            return this;
        }

        public OnlineEntityEditable setLabel(String label) {
            if (label != null) {
                this.set(EntitiesTable.LABEL, label);
            }
            return this;
        }

        public long getCountLocalChanges() {
            return this.getCountLocalChanges(null);
        }

        public long getCountLocalChanges(DataTransaction transaction) {
            WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
            return changesTable.getCountLocalChangesOfEntity(this.workspace, transaction, this.getCode());
        }

        public long getCountRemoteChanges(DataTransaction transaction) {
            RemoteChangesTable changesTable = new RemoteChangesTable();
            return changesTable.getCountRemoteChangesOfEntity(this.workspace, transaction, this.getCode());
        }

        public boolean updateState() {
            return this.updateState(null);
        }

        public boolean updateState(DataTransaction transaction) {
            int prevstate = this.getInt(EntitiesTable.ENTITY_STATE, -1);
            int state = prevstate;
            if (state == -1) {
                state = 1;
                this.setState(state);
            }
            switch (state) {
                case 128: 
                case 256: {
                    return false;
                }
                case 1: {
                    long countChanges = this.getCountLocalChanges(transaction);
                    if (countChanges > 0L) {
                        state = 4;
                        if (this.isOutdated()) {
                            state = 8;
                        }
                        this.setState(state);
                        break;
                    }
                    if (!this.isOutdated()) break;
                    state = 6;
                    this.setState(state);
                    break;
                }
                case 6: {
                    if (!this.isOutdated()) {
                        long countChanges = this.getCountLocalChanges(transaction);
                        state = countChanges > 0L ? 4 : 1;
                    } else {
                        long countChanges = this.getCountLocalChanges(transaction);
                        if (countChanges > 0L) {
                            state = 8;
                            this.setState(state);
                        }
                    }
                    this.setState(state);
                    break;
                }
                case 4: {
                    long countChanges = this.getCountLocalChanges(transaction);
                    if (countChanges == 0L) {
                        state = 1;
                        if (this.isOutdated()) {
                            state = 6;
                        }
                    } else if (this.isOutdated()) {
                        state = 8;
                    }
                    this.setState(state);
                    break;
                }
                case 8: {
                    if (!this.isOutdated()) {
                        long countChanges = this.getCountLocalChanges(transaction);
                        if (countChanges > 0L) {
                            state = 4;
                            this.setState(state);
                        } else {
                            state = 1;
                        }
                    } else {
                        long countChanges = this.getCountLocalChanges(transaction);
                        if (countChanges > 0L) {
                            state = 8;
                            this.setState(state);
                        } else {
                            state = 6;
                        }
                    }
                    this.setState(state);
                    break;
                }
                case 2: {
                    long countChanges = this.getCountLocalChanges(transaction);
                    if (countChanges > 0L) {
                        state = 4;
                        if (this.isOutdated()) {
                            state = 8;
                        }
                    } else {
                        state = 1;
                    }
                    this.setState(state);
                    break;
                }
                case 16: {
                    long countLocalChanges = this.getCountLocalChanges(transaction);
                    long countRemoteChanges = this.getCountRemoteChanges(transaction);
                    if (countRemoteChanges < 1L && countLocalChanges < 1L) {
                        state = 1;
                    } else if (countRemoteChanges < 1L && countLocalChanges > 0L) {
                        state = 4;
                    } else if (countRemoteChanges > 0L && countLocalChanges < 1L) {
                        state = 6;
                    } else if (countRemoteChanges > 0L && countLocalChanges > 0L) {
                        state = 16;
                    } else {
                        AbstractTable.LOGGER.warn("Por aqui no deberia pasar");
                        state = 256;
                    }
                    this.setState(state);
                    break;
                }
                default: {
                    if (!this.isOutdated()) break;
                    state = 6;
                    this.setState(state);
                }
            }
            return prevstate != state;
        }

        public int getState() {
            int state = this.getInt(EntitiesTable.ENTITY_STATE);
            return state;
        }

        private boolean isOutdated() {
            return false;
        }

        public String getStateLabel() {
            return OnlineUtils.getStateLabel(this.getState());
        }

        public void setState(int state) {
            this.set(EntitiesTable.ENTITY_STATE, state);
        }

        @Override
        public void update() {
            super.update();
        }

        public OnlineEntityEditable getValue() {
            return this;
        }

        public String toString() {
            return OnlineUtils.getLabelOrName((OnlineEntity)this);
        }

        public EntityRow setEntityCode(String code) {
            this.setCode(code);
            return this;
        }

        public void copyfrom(OnlineEntity entity) {
            OnlineUtils.copy(entity, this, null);
        }

        public void copyto(OnlineEntityEditable entity) {
            OnlineUtils.copy((OnlineEntity)this, entity, null);
        }

        public JsonObject toJson() {
            return this.toJsonBuilder().build();
        }

        public JsonObjectBuilder toJsonBuilder() {
            return OnlineUtils.toJsonBuilder((OnlineEntity)this, null);
        }

        public void fromJson(JsonObject json) {
            OnlineUtils.fromJson(this, json);
        }

        public OnlineEntityEditable setDataModels(String dataModels) {
            this.set(EntitiesTable.DATA_MODELS, dataModels);
            return this;
        }

        public String getDataModels() {
            return this.getString(EntitiesTable.DATA_MODELS);
        }

        public List<String> getDataModelsAsList() {
            String s = this.getDataModels();
            return OnlineUtils.getAsList(s, false);
        }

        public String getLabelOrName() {
            return OnlineUtils.getLabelOrName((OnlineEntity)this);
        }

        public String getCRS() {
            return this.getString(EntitiesTable.ENT_PROJECTION);
        }

        public IProjection getCRSAsProjection() {
            String s = this.getString(EntitiesTable.ENT_PROJECTION);
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return CRSFactory.getCRS((String)s);
        }

        public String getCustomData() {
            return this.getString(EntitiesTable.ENT_CUSTOMDATA);
        }

        public int getTileSize() {
            return this.getInt(EntitiesTable.ENT_TILESIZE);
        }

        public OnlineEntityEditable setCRS(IProjection crs) {
            this.set(EntitiesTable.ENT_PROJECTION, crs.getAbrev());
            return this;
        }

        public OnlineEntityEditable setCRS(String crs) {
            this.set(EntitiesTable.ENT_PROJECTION, crs);
            return this;
        }

        public OnlineEntityEditable setCustomData(String customData) {
            this.set(EntitiesTable.ENT_CUSTOMDATA, customData);
            return this;
        }

        public OnlineEntityEditable setTileSize(int tileSize) {
            this.set(EntitiesTable.ENT_TILESIZE, tileSize);
            return this;
        }
    }
}

