/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl.workspace.tables;

import java.sql.Timestamp;
import java.util.List;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.json.Json;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineRemoteChange;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.lib.impl.OnlineUtils;
import org.gvsig.online.lib.impl.workspace.tables.AbstractTable;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.tools.util.GetItemWithSizeIsEmptyAndIterator64;

public class RemoteChangesTable
extends AbstractTable {
    public static final String TABLE_NAME = "ONLINE_REMOTECHANGES";
    private static final String COD_REMOTECHANGE = "COD_REMOTECHANGE";
    public static final String COD_ENTITY = "COD_ENTITY";
    public static final String SELECTED = "RCH_SELECTED";
    private static final String FEATUREID = "RCH_FEATURECODE";
    private static final String REVISION_NUMBER = "RCH_REVNUMBER";
    private static final String OPERATION = "RCH_OPERATION";
    private static final String REVISION_DATE = "RCH_DATE";
    private static final String FEATURE_DATA = "RCH_DATA";
    private static final String STATUS = "RCH_STATUS";

    public RemoteChangesTable() {
        super(TABLE_NAME, RemoteChangesTable.featureType());
    }

    public void deleteAll(OnlineWorkingcopy workspace) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            store.delete("TRUE");
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't delete all remote changes.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public void delete(OnlineWorkingcopy workspace, String entityCode) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            store.delete("\"COD_ENTITY\"='" + entityCode + "'");
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't delete remote changes of entity ENTITY[" + entityCode + "].", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public void delete(FeatureStore store, String entityCode) {
        try {
            boolean needFinish = false;
            if (store.getMode() == 0) {
                store.edit(3);
                needFinish = true;
            }
            store.delete("\"COD_ENTITY\"='" + entityCode + "'");
            if (needFinish) {
                store.finishEditing();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't delete changes.", ex);
        }
    }

    public void deleteSelecteds(OnlineWorkingcopy workspace) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            store.delete("\"RCH_SELECTED\"");
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't delete selected remote changes.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public DisposableFeatureSetIterable getByEntityCodeAsIterator(OnlineWorkingcopy workspace, String entityCode) {
        DisposableFeatureSetIterable disposableFeatureSetIterable;
        FeatureStore store = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, true);
            FeatureSet changes = StringUtils.isBlank((CharSequence)entityCode) ? store.getFeatureSet() : store.getFeatureSet("\"COD_ENTITY\"='" + entityCode + "'");
            disposableFeatureSetIterable = changes.iterable();
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve remote changes by entity code (ENTITY[" + entityCode + "]).", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return disposableFeatureSetIterable;
    }

    public boolean hasEntityChanges(OnlineWorkingcopy workspace, String entityCode) {
        boolean bl;
        FeatureStore store = null;
        FeatureSet changes = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, true);
            FeatureQuery query = store.createFeatureQuery();
            query.setLimit(1L);
            if (!StringUtils.isBlank((CharSequence)entityCode)) {
                query.addFilter("\"COD_ENTITY\"='" + entityCode + "'");
            }
            bl = !(changes = store.getFeatureSet(query)).isEmpty();
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't check if the entity has remote changes (ENTITY[" + entityCode + "]).", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(changes);
                DisposeUtils.disposeQuietly((Disposable)store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)changes);
        DisposeUtils.disposeQuietly((Disposable)store);
        return bl;
    }

    public DisposableFeatureSetIterable getSelectedsByEntityCodeAsIterator(OnlineWorkingcopy workspace, String entityCode) {
        DisposableFeatureSetIterable disposableFeatureSetIterable;
        FeatureStore store = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, true);
            FeatureSet changes = StringUtils.isBlank((CharSequence)entityCode) ? store.getFeatureSet("\"RCH_SELECTED\"") : store.getFeatureSet("\"RCH_SELECTED\" AND \"COD_ENTITY\"='" + entityCode + "'");
            disposableFeatureSetIterable = changes.iterable();
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve selected remote changes by entity code (ENTITY[" + entityCode + "]).", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return disposableFeatureSetIterable;
    }

    public DisposableFeatureSetIterable getNotSelectedsByEntityCodeAsIterator(OnlineWorkingcopy workspace, String entityCode) {
        DisposableFeatureSetIterable disposableFeatureSetIterable;
        FeatureStore store = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, true);
            FeatureSet changes = StringUtils.isBlank((CharSequence)entityCode) ? store.getFeatureSet("NOT \"RCH_SELECTED\"") : store.getFeatureSet("NOT \"RCH_SELECTED\" AND \"COD_ENTITY\"='" + entityCode + "'");
            disposableFeatureSetIterable = changes.iterable();
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve not selected remote changes by entity code (ENTITY[" + entityCode + "]).", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return disposableFeatureSetIterable;
    }

    public GetItemWithSize64<Feature> getByEntityCode(OnlineWorkingcopy workspace, String[] entityCodes) {
        GetItemWithSizeIsEmptyAndIterator64 getItemWithSizeIsEmptyAndIterator64;
        FeatureStore store = null;
        try {
            GetItemWithSizeIsEmptyAndIterator64 changes;
            store = workspace.openFeatureStore(TABLE_NAME, true);
            FeatureQuery query = store.createFeatureQuery();
            query.getOrder().add(REVISION_NUMBER, true);
            if (ArrayUtils.isNotEmpty((Object[])entityCodes)) {
                ExpressionBuilder builder = store.createExpressionBuilder();
                for (String entityCode : entityCodes) {
                    if (!StringUtils.isNotBlank((CharSequence)entityCode)) continue;
                    builder.or((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(COD_ENTITY), (ExpressionBuilder.Value)builder.constant((Object)entityCode)));
                }
                String expression = builder.toString();
                if (StringUtils.isNotBlank((CharSequence)expression)) {
                    query.setFilter(expression);
                }
            }
            query.retrievesAllAttributes();
            getItemWithSizeIsEmptyAndIterator64 = changes = store.getFeatures64(query, -1);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve remote changes by entity code (ENTITY[" + StringUtils.join((Object[])entityCodes, (String)",") + "]).", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return getItemWithSizeIsEmptyAndIterator64;
    }

    public GetItemWithSize64<Feature> getByEntityCodes(OnlineWorkingcopy workspace, List<String> entityCodes) {
        GetItemWithSizeIsEmptyAndIterator64 getItemWithSizeIsEmptyAndIterator64;
        FeatureStore store = null;
        try {
            GetItemWithSizeIsEmptyAndIterator64 changes;
            store = workspace.openFeatureStore(TABLE_NAME, true);
            if (entityCodes == null || entityCodes.isEmpty()) {
                changes = store.getFeatures64();
            } else {
                StringBuilder filter = new StringBuilder();
                for (String entityCode : entityCodes) {
                    if (filter.length() > 0) {
                        filter.append(" OR ");
                    }
                    filter.append("\"COD_ENTITY\"='").append(entityCode).append("'");
                }
                changes = store.getFeatures64(filter.toString());
            }
            getItemWithSizeIsEmptyAndIterator64 = changes;
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve remote changes by entity codes.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return getItemWithSizeIsEmptyAndIterator64;
    }

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("Online Remote changes");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.add(COD_REMOTECHANGE, 8).setSize(60).setIsPrimaryKey(true).setLabel("Code").setReadOnly(false);
        ft.add(COD_ENTITY, 8).setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(60).setLabel("Entity code");
        ft.add(SELECTED, 1).setIsIndexed(true).setAllowIndexDuplicateds(true).setLabel("Selected");
        ft.add(FEATUREID, 5).setIsIndexed(false).setLabel("Identifier").setDescription("Feature code");
        ft.add(OPERATION, 4).setLabel("Operation").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)2, "Insert"), new DynObjectValueItem((Object)1, "Update"), new DynObjectValueItem((Object)0, "Delete")});
        ft.add(STATUS, 4).setLabel("Status").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)1, "Unmodified"), new DynObjectValueItem((Object)4, "Modified"), new DynObjectValueItem((Object)16, "Conflict")});
        ft.add(REVISION_NUMBER, 5).setIsIndexed(true).setAllowIndexDuplicateds(true).setLabel("Revision number");
        ft.add(FEATURE_DATA, 8).setSize(4096).setLabel("Data");
        return ft.getNotEditableCopy();
    }

    public DisposableFeatureSetIterable getGroupedByEntity(OnlineWorkingcopy workspace) {
        DisposableFeatureSetIterable disposableFeatureSetIterable;
        FeatureStore store = null;
        try {
            DisposableFeatureSetIterable changes;
            store = workspace.openFeatureStore(TABLE_NAME, true);
            FeatureQuery query = store.createFeatureQuery();
            query.getOrder().add(COD_ENTITY, true);
            query.getGroupByColumns().add(COD_ENTITY);
            query.retrievesAllAttributes();
            disposableFeatureSetIterable = changes = store.getFeatureSet(query).iterable();
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve changes grouped by entity.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return disposableFeatureSetIterable;
    }

    public boolean updateNeedMerge(OnlineWorkingcopy workspace, String entityCode) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            FeatureQuery query = store.createFeatureQuery("NOT \"RCH_SELECTED\" AND \"COD_ENTITY\"='" + entityCode + "'");
            query.setLimit(1L);
            Feature f = store.findFirst(query);
            boolean bl = f != null;
            return bl;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve if need merge for entity code (ENTITY[" + entityCode + "]).", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public boolean updateStateFromLocalChanges(OnlineWorkingcopy workspace, int status) {
        String sql = String.format(OnlineUtils.getSqlTemplate(workspace.getExplorer().getProviderName(), "updateStateFromLocalChanges", new Object[0]), status);
        workspace.getExplorer().execute(sql);
        return true;
    }

    public long getCountRemoteChangesOfEntity(OnlineWorkingcopy workspace, DataTransaction transaction, String entityCode) {
        long l;
        FeatureStore store = null;
        FeatureSet changes = null;
        try {
            if (transaction == null) {
                store = workspace.getFeatureStore(TABLE_NAME);
            } else {
                store = transaction.getFeatureStore(TABLE_NAME);
                if (store == null) {
                    store = workspace.getFeatureStore(TABLE_NAME);
                } else {
                    DisposeUtils.bind((Disposable)store);
                }
            }
            if (StringUtils.isBlank((CharSequence)entityCode)) {
                throw new IllegalArgumentException("entityCode is required.");
            }
            changes = store.getFeatureSet("\"COD_ENTITY\"='" + entityCode + "'");
            l = changes.size64();
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve changes by entity.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(changes);
                DisposeUtils.disposeQuietly((Disposable)store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)changes);
        DisposeUtils.disposeQuietly((Disposable)store);
        return l;
    }

    public static class RemoteChangeRow
    extends AbstractTable.AbstractRow
    implements OnlineRemoteChange {
        protected OnlineEntity entity;

        public RemoteChangeRow(OnlineWorkingcopy workspace) {
            super(workspace, RemoteChangesTable.TABLE_NAME, RemoteChangesTable.COD_REMOTECHANGE);
        }

        public RemoteChangeRow(OnlineWorkingcopy workspace, Feature feature) {
            super(workspace, RemoteChangesTable.TABLE_NAME, RemoteChangesTable.COD_REMOTECHANGE, feature);
        }

        public String getEntityCode() {
            return this.getString(RemoteChangesTable.COD_ENTITY);
        }

        public long getRelatedFeatureCode() {
            if (this.isNull(RemoteChangesTable.FEATUREID)) {
                return 0L;
            }
            return this.getLong(RemoteChangesTable.FEATUREID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Feature getRelatedFeature() {
            Feature feature;
            FeatureStore store = null;
            try {
                String entityName = this.getEntity().getEntityName();
                long code = this.getRelatedFeatureCode();
                store = this.workspace.getFeatureStore(entityName);
                Feature f = store.findFirst("\"" + this.getEntity().getFeatureIdFieldName() + "\"=" + code);
                if (f == null) {
                    Feature feature2 = null;
                    DisposeUtils.disposeQuietly((Disposable)store);
                    return feature2;
                }
                feature = f;
                DisposeUtils.disposeQuietly((Disposable)store);
            }
            catch (Exception ex) {
                Feature feature3 = null;
                return feature3;
            }
            finally {
                DisposeUtils.disposeQuietly(store);
            }
            return feature;
        }

        public long getRevisionNumber() {
            return this.getLong(RemoteChangesTable.REVISION_NUMBER);
        }

        public Timestamp getRevisionDate() {
            return this.getTimestamp(RemoteChangesTable.REVISION_DATE);
        }

        public int getOperation() {
            return this.getInt(RemoteChangesTable.OPERATION);
        }

        public String getOperationLabel() {
            return OnlineUtils.getOperationLabel(this.getOperation());
        }

        public boolean isSelected() {
            return this.getBoolean(RemoteChangesTable.SELECTED);
        }

        public int getStatus() {
            return this.getInt(RemoteChangesTable.STATUS);
        }

        public String getRelatedFeatureData() {
            return this.getString(RemoteChangesTable.FEATURE_DATA);
        }

        public JsonObject getRelatedFeatureDataAsJson() {
            JsonObject json = Json.createObject((String)this.getString(RemoteChangesTable.FEATURE_DATA));
            return json;
        }

        public void setEntityCode(String code) {
            this.set(RemoteChangesTable.COD_ENTITY, code);
        }

        public void setData(String data) {
            this.set(RemoteChangesTable.FEATURE_DATA, data);
        }

        public void setRevisionNumber(long revnum) {
            this.set(RemoteChangesTable.REVISION_NUMBER, revnum);
        }

        public void setEfectiveDate(Timestamp date) {
            this.set(RemoteChangesTable.REVISION_DATE, date);
        }

        public void setRelatedFeatureCode(Object code) {
            this.set(RemoteChangesTable.FEATUREID, code);
        }

        public void setOperation(int op) {
            this.set(RemoteChangesTable.OPERATION, op);
        }

        public void setSelected(boolean selected) {
            this.set(RemoteChangesTable.SELECTED, selected);
        }

        public void setStatus(int status) {
            this.set(RemoteChangesTable.STATUS, status);
        }

        public OnlineEntity getEntity() {
            if (this.entity == null) {
                this.entity = this.workspace.getWorkspaceEntityByCode(this.getEntityCode());
            }
            return this.entity;
        }

        public String getLabel() {
            if (StringUtils.isBlank((CharSequence)this.getRelatedFeatureData())) {
                Feature f = this.getRelatedFeature();
                if (f == null) {
                    return null;
                }
                return f.getString(this.getEntity().getFieldForLabel());
            }
            JsonValue jsonValue = (JsonValue)this.getRelatedFeatureDataAsJson().get((Object)this.getEntity().getFieldForLabel());
            return RemoteChangeRow.convertJsonValueToString(jsonValue);
        }

        private static String convertJsonValueToString(JsonValue jsonValue) {
            if (jsonValue == null) {
                return "";
            }
            if (jsonValue instanceof JsonString) {
                String jsonString = jsonValue.toString();
                return jsonString.substring(1, jsonString.length() - 1);
            }
            return jsonValue.toString();
        }

        public String toString() {
            switch (this.getOperation()) {
                case 2: {
                    return "{ OP:'INSERT', ENTITYCODE:'" + this.getEntityCode() + "', FEATURECODE:'" + this.getRelatedFeatureCode() + "', DATA:'" + this.getRelatedFeatureData() + "' }";
                }
                case 1: {
                    return "{ OP:'UPDATE', ENTITYCODE:'" + this.getEntityCode() + "', FEATURECODE:'" + this.getRelatedFeatureCode() + "', DATA:'" + this.getRelatedFeatureData() + "' }";
                }
                case 0: {
                    return "{ OP:'DELETE', ENTITYCODE:'" + this.getEntityCode() + "', FEATURECODE:'" + this.getRelatedFeatureCode() + "' }";
                }
            }
            return "{ OP:'" + this.getOperation() + "', ENTITYCODE:'" + this.getEntityCode() + "', FEATURECODE:'" + this.getRelatedFeatureCode() + "' }";
        }

        public Geometry getGeometry() {
            Geometry geom = null;
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            String geometryFieldName = this.getEntity().getGeometryFieldName();
            String data = this.getRelatedFeatureData();
            if (!StringUtils.isBlank((CharSequence)data) && !StringUtils.isBlank((CharSequence)geometryFieldName)) {
                JsonObject dataJson = Json.createObject((String)data);
                geom = geometryManager.createFromQuietly(dataJson.getString(geometryFieldName, null));
            }
            return geom;
        }
    }
}

