/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.lib.impl.workspace.tables;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.json.Json;
import org.gvsig.online.lib.api.OnlineLayer;
import org.gvsig.online.lib.api.OnlineRuntimeException;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopyChange;
import org.gvsig.online.lib.impl.OnlineUtils;
import org.gvsig.online.lib.impl.workspace.tables.AbstractTable;
import org.gvsig.online.lib.impl.workspace.tables.RemoteChangesTable;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.tools.util.GetItemWithSizeIsEmptyAndIterator64;

public class WorkspaceChangesTable
extends AbstractTable {
    public static final String TABLE_NAME = "ONLINE_WSCHANGES";
    public static final String COD_CHANGE = "COD_WSCHANGE";
    public static final String COD_ENTITY = "COD_ENTITY";
    public static final String SELECTED = "WSCH_SELECTED";
    public static final String FEATUREID = "WSCH_FEATURECODE";
    public static final String OPERATION = "WSCH_OPERATION";
    public static final String PREVIOUS_OPERATION = "WSCH_PREVOPERATION";
    public static final String STATUS = "WSCH_STATUS";
    private static final String FEATURE_DATA = "WSCH_DATA";
    private static final String EDITING_SESSION = "WSCH_EDITINGSESSION";
    private static final String LABEL = "WSCH_LABEL";
    private static final int MAX_SIZE_LABEL = 40;

    public WorkspaceChangesTable() {
        super(TABLE_NAME, WorkspaceChangesTable.featureType());
    }

    public DisposableFeatureSetIterable getByOperation(OnlineWorkingcopy workspace, int op) {
        return this.getByOperation(workspace, null, op);
    }

    public DisposableFeatureSetIterable getByOperation(OnlineWorkingcopy workspace, String entityCode, int op) {
        FeatureStore store = null;
        try {
            DisposableFeatureSetIterable changes;
            store = workspace.getFeatureStore(TABLE_NAME);
            FeatureQuery query = store.createFeatureQuery();
            if (!StringUtils.isBlank((CharSequence)entityCode)) {
                query.addFilter("\"COD_ENTITY\" ='" + entityCode + "' AND \"" + OPERATION + "\"=" + op);
            } else {
                query.addFilter("\"WSCH_OPERATION\"=" + op);
            }
            query.retrievesAllAttributes();
            DisposableFeatureSetIterable disposableFeatureSetIterable = changes = store.getFeatureSet(query).iterable();
            return disposableFeatureSetIterable;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve changes for operation " + op + ".", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public FeatureSet getDeleteChanges(String entityCode, FeatureStore workspaceChangesStore) {
        try {
            String filter = !StringUtils.isBlank((CharSequence)entityCode) ? "\"COD_ENTITY\" ='" + entityCode + "' AND \"" + OPERATION + "\"=" + 0 : "\"WSCH_OPERATION\"=0";
            FeatureQuery query = workspaceChangesStore.createFeatureQuery(filter, FEATUREID, true);
            query.retrievesAllAttributes();
            FeatureSet changes = workspaceChangesStore.getFeatureSet(query);
            return changes;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve changes for delete operation.", ex);
        }
    }

    public DisposableFeatureSetIterable getGroupedByEntity(OnlineWorkingcopy workspace) {
        FeatureStore store = null;
        try {
            DisposableFeatureSetIterable changes;
            store = workspace.getFeatureStore(TABLE_NAME);
            FeatureQuery query = store.createFeatureQuery();
            query.getOrder().add(COD_ENTITY, true);
            query.getGroupByColumns().add(COD_ENTITY);
            query.getAggregateFunctions().put(SELECTED, "MAX");
            query.retrievesAllAttributes();
            DisposableFeatureSetIterable disposableFeatureSetIterable = changes = store.getFeatureSet(query).iterable();
            return disposableFeatureSetIterable;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve changes grouped by entity.", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public DisposableFeatureSetIterable getAll(OnlineWorkingcopy workspace) {
        FeatureStore store = null;
        try {
            DisposableFeatureSetIterable changes;
            store = workspace.getFeatureStore(TABLE_NAME);
            DisposableFeatureSetIterable disposableFeatureSetIterable = changes = store.getFeatureSet().iterable();
            return disposableFeatureSetIterable;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve all changes.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public GetItemWithSize64<Feature> getByEntityCode(OnlineWorkingcopy workspace, List<OnlineEntity> entities) {
        FeatureStore store = null;
        try {
            GetItemWithSizeIsEmptyAndIterator64 changes;
            store = workspace.getFeatureStore(TABLE_NAME);
            if (CollectionUtils.isEmpty(entities)) {
                GetItemWithSizeIsEmptyAndIterator64 changes2;
                GetItemWithSizeIsEmptyAndIterator64 getItemWithSizeIsEmptyAndIterator64 = changes2 = store.getFeatures64(null, "\"COD_ENTITY\",-\"WSCH_OPERATION\",\"COD_WSCHANGE\"", true);
                return getItemWithSizeIsEmptyAndIterator64;
            }
            ExpressionBuilder exprBuilder = ExpressionUtils.createExpressionBuilder();
            for (OnlineEntity entity : entities) {
                exprBuilder.or((ExpressionBuilder.Value)exprBuilder.eq((ExpressionBuilder.Value)exprBuilder.column(COD_ENTITY), (ExpressionBuilder.Value)exprBuilder.constant((Object)entity.getEntityCode())));
            }
            GetItemWithSizeIsEmptyAndIterator64 getItemWithSizeIsEmptyAndIterator64 = changes = store.getFeatures64(exprBuilder.value().toString(), "\"COD_ENTITY\",-\"WSCH_OPERATION\",\"COD_WSCHANGE\"", true);
            return getItemWithSizeIsEmptyAndIterator64;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve changes by entity.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public boolean hasLocalChangesByEntityCode(OnlineWorkingcopy workspace, List<OnlineEntity> entities) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            if (CollectionUtils.isEmpty(entities)) {
                Feature f = store.findFirst((FeatureQuery)null);
                boolean bl = f != null;
                return bl;
            }
            ExpressionBuilder exprBuilder = ExpressionUtils.createExpressionBuilder();
            for (OnlineEntity entity : entities) {
                exprBuilder.or((ExpressionBuilder.Value)exprBuilder.eq((ExpressionBuilder.Value)exprBuilder.column(COD_ENTITY), (ExpressionBuilder.Value)exprBuilder.constant((Object)entity.getEntityCode())));
            }
            Feature f = store.findFirst(exprBuilder.value().toString());
            boolean bl = f != null;
            return bl;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve changes by entity.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public long getCountLocalChangesOfEntity(OnlineWorkingcopy workspace, String entityCode) {
        return this.getCountLocalChangesOfEntity(workspace, null, entityCode);
    }

    public long getCountLocalChangesOfEntity(OnlineWorkingcopy workspace, DataTransaction transaction, String entityCode) {
        long l;
        FeatureStore store = null;
        FeatureSet changes = null;
        try {
            if (transaction == null) {
                store = workspace.getFeatureStore(TABLE_NAME);
            } else {
                store = transaction.getFeatureStore(TABLE_NAME);
                if (store == null) {
                    store = workspace.getFeatureStore(TABLE_NAME);
                } else {
                    DisposeUtils.bind((Disposable)store);
                }
            }
            if (StringUtils.isBlank((CharSequence)entityCode)) {
                throw new IllegalArgumentException("entityCode is required.");
            }
            changes = store.getFeatureSet("\"COD_ENTITY\"='" + entityCode + "'");
            l = changes.size64();
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve changes by entity.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(changes);
                DisposeUtils.disposeQuietly((Disposable)store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)changes);
        DisposeUtils.disposeQuietly((Disposable)store);
        return l;
    }

    public WorkspaceChangeRow getByEntityAndDataCode(OnlineWorkingcopy workspace, String entityCode, String featureCode, FeatureStore localChangesStore) {
        FeatureStore store = localChangesStore;
        try {
            WorkspaceChangeRow row;
            Feature f;
            if (store == null) {
                store = workspace.getFeatureStore(TABLE_NAME);
            }
            if ((f = store.findFirst("\"COD_ENTITY\"='" + entityCode + "' AND \"" + FEATUREID + "\"='" + featureCode + "'")) == null) {
                WorkspaceChangeRow workspaceChangeRow = null;
                return workspaceChangeRow;
            }
            WorkspaceChangeRow workspaceChangeRow = row = new WorkspaceChangeRow(workspace, f);
            return workspaceChangeRow;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve change for 'FEATURECODE[" + featureCode + "]'.", ex);
        }
        finally {
            if (localChangesStore == null) {
                DisposeUtils.disposeQuietly((Disposable)store);
            }
        }
    }

    public void deleteAll(OnlineWorkingcopy workspace) {
        FeatureStore store = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, true);
            store.edit(3);
            store.delete("TRUE");
            store.finishEditing();
        }
        catch (Exception ex) {
            FeatureStore.cancelEditingQuietly((FeatureStore)store);
            throw new RuntimeException("Can't delete all changes.", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public void deleteSelecteds(OnlineWorkingcopy workspace, List<String> entityCodes) {
        FeatureStore store = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, true);
            store.edit(3);
            ExpressionBuilder expBuilder = ExpressionUtils.createExpressionBuilder();
            if (CollectionUtils.isNotEmpty(entityCodes)) {
                for (String entityCode : entityCodes) {
                    expBuilder.or((ExpressionBuilder.Value)expBuilder.eq((ExpressionBuilder.Value)expBuilder.column(COD_ENTITY), (ExpressionBuilder.Value)expBuilder.constant((Object)entityCode)));
                }
            }
            expBuilder.and((ExpressionBuilder.Value)expBuilder.column(SELECTED));
            store.delete(expBuilder.value().toString());
            store.finishEditing();
        }
        catch (Exception ex) {
            FeatureStore.cancelEditingQuietly((FeatureStore)store);
            throw new RuntimeException("Can't delete selected changes.", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public void deleteByEntity(OnlineWorkingcopy workspace, String entityCode) {
        FeatureStore store = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, true);
            store.edit(3);
            store.delete("\"COD_ENTITY\"='" + entityCode + "'");
            store.finishEditing();
        }
        catch (Exception ex) {
            FeatureStore.cancelEditingQuietly((FeatureStore)store);
            throw new RuntimeException("Can't delete selected changes.", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public DisposableFeatureSetIterable getSelectedsByEntityCodeAsIterator(OnlineWorkingcopy workspace, String entityCode) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            FeatureSet changes = StringUtils.isBlank((CharSequence)entityCode) ? store.getFeatureSet("\"WSCH_SELECTED\"") : store.getFeatureSet("\"WSCH_SELECTED\" AND \"COD_ENTITY\"='" + entityCode + "'");
            DisposableFeatureSetIterable disposableFeatureSetIterable = changes.iterable();
            return disposableFeatureSetIterable;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve selected remote changes by entity code (ENTITY[" + entityCode + "]).", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public DisposableFeatureSetIterable getByEntityCodeAsIterator(OnlineWorkingcopy workspace, String entityCode) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            FeatureSet changes = StringUtils.isBlank((CharSequence)entityCode) ? store.getFeatureSet("") : store.getFeatureSet("\"COD_ENTITY\"='" + entityCode + "'");
            DisposableFeatureSetIterable disposableFeatureSetIterable = changes.iterable();
            return disposableFeatureSetIterable;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve selected remote changes by entity code (ENTITY[" + entityCode + "]).", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public void deleteSelectedsByEntity(OnlineWorkingcopy workspace, String entityCode) {
        FeatureStore store = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, true);
            store.edit(3);
            store.delete("\"COD_ENTITY\"='" + entityCode + "'" + " AND " + "\"" + SELECTED + "\"");
            store.finishEditing();
        }
        catch (Exception ex) {
            FeatureStore.cancelEditingQuietly((FeatureStore)store);
            throw new RuntimeException("Can't delete selected changes.", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public WorkspaceChangeRow find(OnlineWorkingcopy workspace, FeatureStore store, String entityCode, Object featureCode) {
        try {
            ExpressionBuilder builder = store.createExpressionBuilder();
            ExpressionBuilder.BinaryOperator value = builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(COD_ENTITY), (ExpressionBuilder.Value)builder.constant((Object)entityCode)), (ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(FEATUREID), (ExpressionBuilder.Value)builder.constant(featureCode)));
            Feature f = store.findFirst(value.toString());
            if (f == null) {
                return null;
            }
            return new WorkspaceChangeRow(workspace, f);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve change.", ex);
        }
    }

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("Online Local changes");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.add(COD_CHANGE, 8).setSize(60).setIsPrimaryKey(true).setLabel("Code").setReadOnly(false);
        ft.add(COD_ENTITY, 8).setAllowIndexDuplicateds(true).setSize(60).setLabel("Entity code");
        ft.add(SELECTED, 1).setAllowIndexDuplicateds(true).setLabel("Selected");
        ft.add(EDITING_SESSION, 8).setIsIndexed(true).setAllowIndexDuplicateds(true).setLabel("Editing session");
        ft.add(FEATUREID, 5).setIsIndexed(true).setLabel("Identifier").setDescription("The identifier of the feature");
        ft.add(OPERATION, 4).setIsIndexed(true).setLabel("Operation").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)2, "Insert"), new DynObjectValueItem((Object)1, "Update"), new DynObjectValueItem((Object)0, "Delete"), new DynObjectValueItem((Object)4, "Ignore")});
        ft.add(PREVIOUS_OPERATION, 4).setIsIndexed(true).setLabel("Operation").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)2, "Insert"), new DynObjectValueItem((Object)1, "Update"), new DynObjectValueItem((Object)-1, "Unknown")});
        ft.add(STATUS, 4).setLabel("Status").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)2, "New"), new DynObjectValueItem((Object)1, "Unmodified"), new DynObjectValueItem((Object)4, "Modified"), new DynObjectValueItem((Object)16, "Conflict")});
        ft.add(LABEL, 8).setIsIndexed(false).setSize(40).setLabel("Label").setDescription("The label of the feature");
        ft.add(FEATURE_DATA, 8).setSize(4096).setLabel("Data");
        return ft.getNotEditableCopy();
    }

    public void removeLocalChangesRelatedToSelectedRemoteChanges(OnlineWorkingcopy workspace, OnlineEntity lentity) {
        String sql = String.format(OnlineUtils.getSqlTemplate(workspace.getExplorer().getProviderName(), "removeLocalChangesRelatedToSelectedRemoteChanges", new Object[0]), lentity.getEntityCode());
        Object res = workspace.getExplorer().execute(sql);
    }

    public void removeLocalChanges(OnlineWorkingcopy workspace, OnlineEntity lentity, String editingSession) {
        FeatureStore store = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, true);
            store.edit(3);
            store.delete("\"WSCH_EDITINGSESSION\" = '" + editingSession + "'");
            store.finishEditingQuietly();
        }
        catch (Exception ex) {
            try {
                FeatureStore.cancelEditingQuietly((FeatureStore)store);
                throw new RuntimeException("Can't remove local changes.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
    }

    public void revertChangedLocalChanges(OnlineWorkingcopy workspace, OnlineEntity lentity, String editingSession) {
        FeatureStore store = null;
        FeatureSet features = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, true);
            store.edit(3);
            features = store.getFeatureSet("\"WSCH_EDITINGSESSION\" = '" + editingSession + "' and \"" + PREVIOUS_OPERATION + "\" <> " + -1);
            for (Feature feature : features) {
                EditableFeature eFeature = feature.getEditable();
                eFeature.set(OPERATION, eFeature.get(PREVIOUS_OPERATION));
                eFeature.set(PREVIOUS_OPERATION, (Object)-1);
                store.update(eFeature);
            }
            store.finishEditingQuietly();
        }
        catch (Exception ex) {
            try {
                FeatureStore.cancelEditingQuietly((FeatureStore)store);
                throw new RuntimeException("Can't remove local changes.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(features);
                DisposeUtils.disposeQuietly((Disposable)store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)features);
        DisposeUtils.disposeQuietly((Disposable)store);
    }

    public void removeIgnoredLocalChanges(OnlineWorkingcopy workspace, OnlineEntity lentity, String editingSession) {
        FeatureStore store = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, true);
            store.edit(3);
            store.delete("\"WSCH_EDITINGSESSION\" = '" + editingSession + "' and \"" + OPERATION + "\" = " + 4);
            store.finishEditingQuietly();
        }
        catch (Exception ex) {
            try {
                FeatureStore.cancelEditingQuietly((FeatureStore)store);
                throw new RuntimeException("Can't remove local changes.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
    }

    public DisposableIterable<WorkspaceChangeRow> getChangesWidthUserData(OnlineWorkingcopy workspace, OnlineEntity lentity, RemoteChangesTable.RemoteChangeRow remoteChange, FeatureStore localChangesStore, final DataTransaction transaction) {
        WorkspaceChangeRow row;
        String sql;
        FeatureType featType = lentity.getFeatureType();
        JsonObject data = remoteChange.getRelatedFeatureDataAsJson();
        ExpressionEvaluatorManager expManager = ExpressionEvaluatorLocator.getManager();
        ExpressionBuilder builder = expManager.createExpressionBuilder();
        builder.set(null);
        for (FeatureAttributeDescriptor attr : featType) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)lentity.getFeatureIdFieldName(), (CharSequence[])new CharSequence[]{attr.getName()}) || !attr.isIndexed() || attr.allowIndexDuplicateds()) continue;
            Object value = Json.toObject((JsonObject)data, (String)attr.getName());
            builder.or((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attr.getName()), (ExpressionBuilder.Value)builder.constant(value)));
        }
        ExpressionBuilder.Value value = builder.value();
        if (value == null) {
            return null;
        }
        final JDBCServerExplorer serverExplorer = workspace.getExplorer();
        final ResultSet rs = (ResultSet)serverExplorer.execute(sql = String.format(OnlineUtils.getSqlTemplate(workspace.getExplorer().getProviderName(), "getChangesWidthUserData", new Object[0]), lentity.getEntityName(), lentity.getFeatureIdFieldName(), remoteChange.getRelatedFeatureCode(), builder.toString()));
        if (rs == null) {
            return null;
        }
        try {
            row = new WorkspaceChangeRow(workspace, (Feature)localChangesStore.createNewFeature());
        }
        catch (DataException ex) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return null;
        }
        DisposableIterable<WorkspaceChangeRow> r = new DisposableIterable<WorkspaceChangeRow>(){

            public Iterator<WorkspaceChangeRow> iterator() {
                Iterator<WorkspaceChangeRow> it = new Iterator<WorkspaceChangeRow>(){

                    @Override
                    public boolean hasNext() {
                        try {
                            return rs.next();
                        }
                        catch (SQLException ex) {
                            return false;
                        }
                    }

                    @Override
                    public WorkspaceChangeRow next() {
                        try {
                            row.setCode(rs.getString(WorkspaceChangesTable.COD_CHANGE));
                            row.setEntityCode(rs.getString(WorkspaceChangesTable.COD_ENTITY));
                            row.setFeatureCode(rs.getLong(WorkspaceChangesTable.FEATUREID));
                            row.setLabel(rs.getString(WorkspaceChangesTable.LABEL));
                            row.setOperation(rs.getInt(WorkspaceChangesTable.OPERATION));
                            row.setSelected(rs.getBoolean(WorkspaceChangesTable.SELECTED));
                            row.setStatus(rs.getInt(WorkspaceChangesTable.STATUS));
                            return row;
                        }
                        catch (SQLException ex) {
                            return null;
                        }
                    }
                };
                return it;
            }

            public void dispose() {
                try {
                    Connection conn = rs.getStatement().getConnection();
                    rs.close();
                    if (transaction != null && transaction.contains((DataServerExplorer)serverExplorer) && transaction.isInProgress()) {
                        return;
                    }
                    conn.close();
                }
                catch (SQLException ex) {
                    AbstractTable.LOGGER.warn("Can't close resultSet.", (Throwable)ex);
                }
            }
        };
        return r;
    }

    public void changeState(FeatureStore localChangesStore, String entityCode, int searchState, int replaceState) {
        try {
            boolean needFinish = false;
            if (localChangesStore.getMode() == 0) {
                localChangesStore.edit(3);
                needFinish = true;
            }
            String filter = "\"COD_ENTITY\"='" + entityCode + "' AND \"" + STATUS + "\"=" + searchState;
            localChangesStore.update(new Object[]{STATUS, replaceState, filter});
            if (needFinish) {
                localChangesStore.finishEditing();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't change state.", ex);
        }
    }

    public static class WorkspaceChangeRow
    extends AbstractTable.AbstractRow
    implements OnlineWorkingcopyChange {
        protected OnlineEntity entity;

        public WorkspaceChangeRow(OnlineWorkingcopy workspace) {
            this(workspace, null);
            this.setStatus(1);
        }

        public WorkspaceChangeRow(OnlineWorkingcopy workspace, Feature feature) {
            super(workspace, WorkspaceChangesTable.TABLE_NAME, WorkspaceChangesTable.COD_CHANGE, feature);
        }

        public String getEntityCode() {
            return this.getString(WorkspaceChangesTable.COD_ENTITY);
        }

        public long getRelatedFeatureCode() {
            return this.getLong(WorkspaceChangesTable.FEATUREID);
        }

        public int getOperation() {
            return this.getInt(WorkspaceChangesTable.OPERATION);
        }

        public String getOperationLabel() {
            return this.getLabelOfValue(WorkspaceChangesTable.OPERATION);
        }

        public String getLabel() {
            return this.getString(WorkspaceChangesTable.LABEL);
        }

        public boolean isSelected() {
            return this.getBoolean(WorkspaceChangesTable.SELECTED);
        }

        public void setEntityCode(String code) {
            this.set(WorkspaceChangesTable.COD_ENTITY, code);
        }

        public void setFeatureCode(long code) {
            this.set(WorkspaceChangesTable.FEATUREID, code);
        }

        public void setOperation(int op) {
            this.set(WorkspaceChangesTable.OPERATION, op);
        }

        public void setStatus(int status) {
            this.set(WorkspaceChangesTable.STATUS, status);
        }

        public void setSelected(boolean selected) {
            this.set(WorkspaceChangesTable.SELECTED, selected);
        }

        public void setLabel(String label) {
            this.set(WorkspaceChangesTable.LABEL, StringUtils.abbreviate((String)label, (int)40));
        }

        public String getRelatedFeatureData() {
            String string;
            Feature f;
            FeatureStore store;
            long code;
            String entityName;
            block6: {
                entityName = "unknown";
                code = 0L;
                store = null;
                entityName = this.getEntity().getEntityName();
                code = this.getRelatedFeatureCode();
                store = this.workspace.getFeatureStore(entityName);
                f = store.findFirst("\"" + this.getEntity().getFeatureIdFieldName() + "\"=" + code);
                if (f != null) break block6;
                int op = this.getOperation();
                if (op == 2 || op == 1) {
                    AbstractTable.LOGGER.warn("Can't retrieve feature data for an insert or update operation (ENT/CODE='" + entityName + "/" + code + "')");
                    throw new RuntimeException("Feature ENT/CODE='" + entityName + "/" + code + "'not found.");
                }
                String string2 = "";
                DisposeUtils.disposeQuietly((Disposable)store);
                return string2;
            }
            try {
                String data;
                JsonObject json = f.toJson();
                string = data = json.toString();
            }
            catch (Exception ex) {
                try {
                    AbstractTable.LOGGER.warn("Can't retrieve feature data (ENT/ONLINECODE='" + entityName + "/" + code + "')");
                    throw new RuntimeException("Can't retrieve feature data of ENT/ONLINECODE='" + entityName + "/" + code + "'.", ex);
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(store);
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)store);
            return string;
        }

        public JsonObject getRelatedFeatureDataAsJson() {
            String s = this.getRelatedFeatureData();
            return Json.createObject((String)s);
        }

        public String toString() {
            switch (this.getOperation()) {
                case 2: {
                    return "{ OP:'INSERT', ENTITYCODE:'" + this.getEntityCode() + "', FEATURECODE:'" + this.getRelatedFeatureCode() + "', DATA:'" + this.getRelatedFeatureData() + "' }";
                }
                case 1: {
                    return "{ OP:'UPDATE', ENTITYCODE:'" + this.getEntityCode() + "', FEATURECODE:'" + this.getRelatedFeatureCode() + "', DATA:'" + this.getRelatedFeatureData() + "' }";
                }
                case 0: {
                    return "{ OP:'DELETE', ENTITYCODE:'" + this.getEntityCode() + "', FEATURECODE:'" + this.getRelatedFeatureCode() + "' }";
                }
            }
            return "{ OP:'" + this.getOperation() + "', ENTITYCODE:'" + this.getEntityCode() + "', FEATURECODE:'" + this.getRelatedFeatureCode() + "' }";
        }

        public Feature getRelatedFeature() {
            Feature f = this.workspace.getRelatedFeature(this.getEntity(), this.getRelatedFeatureCode());
            if (f == null) {
                throw new RuntimeException("Feature '" + this.getEntity().getEntityName() + "/" + this.getRelatedFeatureCode() + "'not found.");
            }
            return f;
        }

        public OnlineEntity getEntity() {
            if (this.entity == null) {
                this.entity = this.workspace.getWorkspaceEntityByCode(this.getEntityCode());
            }
            return this.entity;
        }

        public int getStatus() {
            return this.getInt(WorkspaceChangesTable.STATUS);
        }

        @Override
        public void update(FeatureStore store) {
            this.updateStatus();
            super.update(store);
        }

        @Override
        public void insert(FeatureStore store) {
            this.updateStatus();
            super.insert(store);
        }

        private void updateStatus() {
            if (this.getStatus() == 1) {
                switch (this.getOperation()) {
                    case 2: {
                        this.setStatus(2);
                        return;
                    }
                    case 0: 
                    case 1: {
                        this.setStatus(4);
                        return;
                    }
                }
            }
        }

        public void revert(FeatureStore userStore, FeatureStore changesStore) throws DataException {
            long code = this.getRelatedFeatureCode();
            OnlineLayer layer = OnlineUtils.getOnlineLayer(userStore);
            switch (this.getOperation()) {
                case 2: {
                    userStore.delete("\"" + layer.getFeatureCodeFieldName() + "\" = " + code);
                    changesStore.delete("\"COD_WSCHANGE\" = '" + this.getCode() + "'");
                    break;
                }
                case 1: {
                    Feature feat = userStore.findFirst("\"" + layer.getFeatureCodeFieldName() + "\" = " + code);
                    if (feat == null) {
                        throw new OnlineRuntimeException(1, "xxx");
                    }
                    EditableFeature editable = feat.getEditable();
                    editable.copyFrom(this.getDataAsJson());
                    userStore.update(editable);
                    changesStore.delete("\"COD_WSCHANGE\" = '" + this.getCode() + "'");
                    break;
                }
                case 0: {
                    EditableFeature editable = userStore.createNewFeature(this.getDataAsJson());
                    userStore.insert(editable);
                    changesStore.delete("\"COD_WSCHANGE\" = '" + this.getCode() + "'");
                }
            }
        }

        public void setData(String data) {
            this.set(WorkspaceChangesTable.FEATURE_DATA, data);
        }

        public String getData() {
            return this.getString(WorkspaceChangesTable.FEATURE_DATA);
        }

        public JsonObject getDataAsJson() {
            String s = this.getData();
            return Json.createObject((String)s);
        }

        public void setEditingSession(String editingSession) {
            this.set(WorkspaceChangesTable.EDITING_SESSION, editingSession);
        }

        public void setPreviousOperation(int operation) {
            this.set(WorkspaceChangesTable.PREVIOUS_OPERATION, operation);
        }
    }
}

