/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.patch;

import java.util.Iterator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.patch.PatchGenerator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.UserCancelTaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PatchGeneratorImpl<T>
implements PatchGenerator<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(PatchGeneratorImpl.class);

    PatchGeneratorImpl() {
    }

    @Override
    public void generate(PatchGenerator.PatchHandler handler, Iterator<T> r, Iterator<T> l, SimpleTaskStatus status) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Generating_patch"));
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        try {
            Object remoteItem = null;
            Object localItem = null;
            if (r.hasNext()) {
                remoteItem = r.next();
                status.incrementCurrentValue();
            }
            if (l.hasNext()) {
                localItem = l.next();
                status.incrementCurrentValue();
            }
            while (true) {
                if (status.isCancellationRequested()) {
                    throw new UserCancelTaskException();
                }
                if (localItem == null) {
                    if (remoteItem == null) break;
                    if (handler.isDeleteLocalChange(remoteItem)) {
                        if (r.hasNext()) {
                            remoteItem = r.next();
                            status.incrementCurrentValue();
                            continue;
                        }
                        remoteItem = null;
                        continue;
                    }
                    handler.addRemoteChangeInsert(remoteItem);
                    if (r.hasNext()) {
                        remoteItem = r.next();
                        status.incrementCurrentValue();
                        continue;
                    }
                    remoteItem = null;
                    continue;
                }
                if (handler.isNew(localItem)) {
                    if (l.hasNext()) {
                        localItem = l.next();
                        status.incrementCurrentValue();
                        continue;
                    }
                    localItem = null;
                    continue;
                }
                if (remoteItem == null || remoteItem != null && handler.compareId(remoteItem, localItem) > 0) {
                    if (handler.isLocalChange(localItem)) {
                        handler.addRemoteChangeDelete(localItem, true);
                    } else {
                        handler.addRemoteChangeDelete(localItem, false);
                    }
                    if (l.hasNext()) {
                        localItem = l.next();
                        status.incrementCurrentValue();
                        continue;
                    }
                    localItem = null;
                    continue;
                }
                if (remoteItem != null && handler.compareId(remoteItem, localItem) < 0) {
                    if (!handler.isLocalChange(remoteItem)) {
                        handler.addRemoteChangeInsert(remoteItem);
                    }
                    if (r.hasNext()) {
                        remoteItem = r.next();
                        status.incrementCurrentValue();
                        continue;
                    }
                    remoteItem = null;
                    continue;
                }
                if (remoteItem != null) {
                    if (handler.isLocalChange(localItem)) {
                        if (handler.isRemoteChange(remoteItem, localItem)) {
                            handler.addRemoteChangeModify(remoteItem, true);
                        }
                    } else if (handler.isRemoteChange(remoteItem, localItem)) {
                        handler.addRemoteChangeModify(remoteItem, false);
                    }
                    if (l.hasNext()) {
                        localItem = l.next();
                        status.incrementCurrentValue();
                    } else {
                        localItem = null;
                    }
                    if (r.hasNext()) {
                        remoteItem = r.next();
                        status.incrementCurrentValue();
                        continue;
                    }
                    remoteItem = null;
                    continue;
                }
                if (l.hasNext()) {
                    localItem = l.next();
                    status.incrementCurrentValue();
                } else {
                    localItem = null;
                }
                if (r.hasNext()) {
                    remoteItem = r.next();
                    status.incrementCurrentValue();
                    continue;
                }
                remoteItem = null;
            }
            status.terminate();
        }
        catch (UserCancelTaskException ex) {
            status.cancel();
            throw ex;
        }
        catch (Exception ex) {
            status.abort();
            throw ex;
        }
        finally {
            status.pop();
        }
    }

    @Override
    public void fixLocalDeleteChanges(PatchGenerator.FixLocalDeleteChangesHandler handler, Iterator<T> localDeleteChanges, Iterator<T> r, SimpleTaskStatus status) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Fixing_local_delete_changes"));
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        try {
            Object remoteItem = null;
            Object localItem = null;
            if (r.hasNext()) {
                remoteItem = r.next();
                status.incrementCurrentValue();
            }
            if (localDeleteChanges.hasNext()) {
                localItem = localDeleteChanges.next();
                status.incrementCurrentValue();
            }
            while (true) {
                if (status.isCancellationRequested()) {
                    throw new UserCancelTaskException();
                }
                if (localItem == null) break;
                if (remoteItem == null || remoteItem != null && handler.compareId(remoteItem, localItem) > 0) {
                    handler.removeLocalChange(localItem);
                    if (localDeleteChanges.hasNext()) {
                        localItem = localDeleteChanges.next();
                        status.incrementCurrentValue();
                        continue;
                    }
                    localItem = null;
                    continue;
                }
                if (remoteItem != null && handler.compareId(remoteItem, localItem) < 0) {
                    if (r.hasNext()) {
                        remoteItem = r.next();
                        status.incrementCurrentValue();
                        continue;
                    }
                    remoteItem = null;
                    continue;
                }
                if (remoteItem != null) {
                    if (localDeleteChanges.hasNext()) {
                        localItem = localDeleteChanges.next();
                        status.incrementCurrentValue();
                    } else {
                        localItem = null;
                    }
                    if (r.hasNext()) {
                        remoteItem = r.next();
                        status.incrementCurrentValue();
                        continue;
                    }
                    remoteItem = null;
                    continue;
                }
                if (localDeleteChanges.hasNext()) {
                    localItem = localDeleteChanges.next();
                    status.incrementCurrentValue();
                } else {
                    localItem = null;
                }
                if (r.hasNext()) {
                    remoteItem = r.next();
                    status.incrementCurrentValue();
                    continue;
                }
                remoteItem = null;
            }
            status.terminate();
        }
        catch (UserCancelTaskException ex) {
            status.cancel();
            throw ex;
        }
        catch (Exception ex) {
            status.abort();
            throw ex;
        }
        finally {
            status.pop();
        }
    }
}

