/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.BasePanel;
import org.gvsig.raster.swing.RasterSwingManager;
import org.gvsig.raster.swing.RasterWindowManager;
import org.gvsig.raster.swing.basepanel.IButtonsPanel;
import org.gvsig.raster.swing.buttonbar.ButtonBar;
import org.gvsig.raster.swing.gcanvas.GCanvas;
import org.gvsig.raster.swing.impl.FileNameManagementImpl;
import org.gvsig.raster.swing.impl.GenericBasePanel;
import org.gvsig.raster.swing.impl.basepanel.ButtonsPanel;
import org.gvsig.raster.swing.impl.buttonbar.ButtonBarContainerImpl;
import org.gvsig.raster.swing.impl.canvas.DefaultGCanvas;
import org.gvsig.raster.swing.impl.newlayer.CreateNewLayerPanelImpl;
import org.gvsig.raster.swing.impl.openfile.OpenFileContainerImpl;
import org.gvsig.raster.swing.impl.pagedtable.ModelLoaderImpl;
import org.gvsig.raster.swing.impl.pagedtable.PagedTableImpl;
import org.gvsig.raster.swing.impl.preview.PreviewBasePanel;
import org.gvsig.raster.swing.impl.preview.SinglePreviewPanel;
import org.gvsig.raster.swing.impl.roi.DefaultROIPanel;
import org.gvsig.raster.swing.impl.slider.SliderTextContainer;
import org.gvsig.raster.swing.impl.sumaryprocess.SummaryProcessDialog;
import org.gvsig.raster.swing.impl.tool.infobypoint.MainInfoByPointPanelImpl;
import org.gvsig.raster.swing.infobypoint.MainInfoByPointPanel;
import org.gvsig.raster.swing.newlayer.CreateNewLayerPanel;
import org.gvsig.raster.swing.newlayer.FileNameManagement;
import org.gvsig.raster.swing.openfile.OpenFileContainer;
import org.gvsig.raster.swing.pagedtable.ModelLoader;
import org.gvsig.raster.swing.pagedtable.PagedTable;
import org.gvsig.raster.swing.pagedtable.TableModel;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.raster.swing.preview.PreviewPanel;
import org.gvsig.raster.swing.preview.PreviewRenderProcess;
import org.gvsig.raster.swing.roi.ROIPanel;
import org.gvsig.raster.swing.slider.SliderText;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRasterSwingManager
implements RasterSwingManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRasterSwingManager.class);
    private RasterWindowManager rasterWindowManager;
    private I18nManager i18nmanager = ToolsLocator.getI18nManager();

    public String getTranslation(String key) {
        return this.i18nmanager.getTranslation(key);
    }

    public RasterWindowManager getWindowManager() {
        return this.rasterWindowManager;
    }

    public void registerWindowManager(RasterWindowManager windowManager) {
        this.rasterWindowManager = windowManager;
    }

    public static String getText(Object parent, String key) {
        if (key == null) {
            return null;
        }
        String translation = Messages.getText((String)key, (boolean)false);
        if (translation != null) {
            return translation;
        }
        logger.debug("Can't find translation for ''{1}''.", (Object)key);
        return key;
    }

    public BasePanel createGenericBasePanel() {
        return new GenericBasePanel();
    }

    public GCanvas createGraphicCanvas(Color backgroundColor) {
        return new DefaultGCanvas(backgroundColor);
    }

    public PreviewPanel createPreviewPanel(int buttons, ArrayList list, JPanel generalPanel, JPanel downPreviewPanel, PreviewRenderProcess renderProcess, DataSourcePreview dataSource) {
        return new PreviewBasePanel(buttons, list, generalPanel, downPreviewPanel, renderProcess, dataSource);
    }

    public PreviewPanel createSinglePreviewPanel(PreviewRenderProcess renderProcess, DataSourcePreview dataSource) {
        return new SinglePreviewPanel(renderProcess, dataSource);
    }

    public PreviewPanel createSinglePreviewPanel(PreviewRenderProcess renderProcess) {
        return new SinglePreviewPanel(renderProcess);
    }

    public MainInfoByPointPanel createInfoByPointPanel(HashMap<String, String> translations, HashMap<String, ImageIcon> icons, JPanel extended) {
        return new MainInfoByPointPanelImpl(translations, icons, extended);
    }

    public ButtonBar createButtonBar() {
        return new ButtonBarContainerImpl();
    }

    public CreateNewLayerPanel createNewLayerPanel(FileNameManagement fileNameManagement, String tittle) {
        return new CreateNewLayerPanelImpl(fileNameManagement, tittle);
    }

    public CreateNewLayerPanel createNewLayerPanel(FileNameManagement fileNameManagement) {
        return new CreateNewLayerPanelImpl(fileNameManagement);
    }

    public CreateNewLayerPanel createNewLayerPanel(String tittle) {
        FileNameManagementImpl fileNameManagement = new FileNameManagementImpl();
        return new CreateNewLayerPanelImpl(fileNameManagement, tittle);
    }

    public CreateNewLayerPanel createNewLayerPanel() {
        FileNameManagementImpl fileNameManagement = new FileNameManagementImpl();
        return new CreateNewLayerPanelImpl(fileNameManagement);
    }

    public OpenFileContainer createOpenFileContainer(boolean showBorder, String[] fileFilter, String defaultPath) {
        return new OpenFileContainerImpl(showBorder, fileFilter, defaultPath);
    }

    public ROIPanel createROIPanel() {
        return new DefaultROIPanel();
    }

    public PagedTable createPagedTable(ModelLoader modelLoader) {
        return new PagedTableImpl(modelLoader);
    }

    public ModelLoader createModelLoader(TableModel tableModel) {
        return new ModelLoaderImpl((DefaultTableModel)tableModel);
    }

    public IButtonsPanel createButtonsPanel(int buttons, JComponent parent) {
        return new ButtonsPanel(buttons, parent);
    }

    public SliderText createSliderText(int min, int max, int defaultValue, boolean border) {
        return new SliderTextContainer(min, max, defaultValue, border);
    }

    public FileNameManagement createFileNameManagement() {
        return new FileNameManagementImpl();
    }

    public void showSummaryProcessDialog(String fileName, long time) {
        SummaryProcessDialog.show(fileName, time);
    }
}

