/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.basepanel;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.basepanel.ButtonsPanelEvent;
import org.gvsig.raster.swing.basepanel.ButtonsPanelListener;
import org.gvsig.raster.swing.basepanel.IButtonsPanel;

public class ButtonsPanel
extends JPanel
implements IButtonsPanel {
    private static final long serialVersionUID = -1660559792086305063L;
    private ArrayList<ButtonsPanelListener> actionCommandListeners = new ArrayList();
    private ArrayList<JButton> buttonsList = new ArrayList();
    private JComponent parent = null;

    public ButtonsPanel() {
        this.initialize();
    }

    public ButtonsPanel(JComponent parent) {
        this.parent = parent;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new FlowLayout(2, 2, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
    }

    public ButtonsPanel(int items, JComponent parent) {
        this(items);
        this.parent = parent;
    }

    public ButtonsPanel(int items) {
        this.initialize();
        switch (items) {
            case 1: {
                this.addAccept();
                break;
            }
            case 2: {
                this.addAccept();
                this.addCancel();
                break;
            }
            case 3: {
                this.addApply();
                this.addAccept();
                this.addCancel();
                break;
            }
            case 9: {
                this.addApply();
                this.addClose();
                break;
            }
            case 4: {
                this.addCancel();
                break;
            }
            case 5: {
                this.addYes();
                this.addNo();
                break;
            }
            case 6: {
                this.addClose();
                break;
            }
            case 7: {
                this.addExit();
                break;
            }
        }
    }

    public void addButtonPressedListener(ButtonsPanelListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public Object[] getButtonPressedListeners() {
        return this.actionCommandListeners.toArray();
    }

    public void removeButtonPressedListener(ButtonsPanelListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void callActionCommandListeners(int buttonID) {
        for (ButtonsPanelListener listener : this.actionCommandListeners) {
            listener.actionButtonPressed(new ButtonsPanelEvent((Object)this.parent, buttonID));
        }
    }

    public void addAccept() {
        this.addButton(Messages.getText((String)"aceptar"), 1);
    }

    public void addSave() {
        this.addButton(Messages.getText((String)"guardar"), 12);
    }

    public void addCancel() {
        this.addButton(Messages.getText((String)"cancelar"), 2);
    }

    public void addYes() {
        this.addButton(Messages.getText((String)"si"), 4);
    }

    public void addNo() {
        this.addButton(Messages.getText((String)"no"), 5);
    }

    public void addApply() {
        this.addButton(Messages.getText((String)"aplicar"), 3);
    }

    public void addClose() {
        this.addButton(Messages.getText((String)"cerrar"), 6);
    }

    public void addExit() {
        this.addButton(Messages.getText((String)"salir"), 7);
    }

    public void addSeeDetails() {
        this.addButton(Messages.getText((String)"verdetalles"), 8);
    }

    public void addHideDetails() {
        this.addButton(Messages.getText((String)"ocultardetalles"), 9);
    }

    public void addPause() {
        this.addButton(Messages.getText((String)"pausar"), 10);
    }

    public void addRestart() {
        this.addButton(Messages.getText((String)"reanudar"), 11);
    }

    public void addButton(String text, int id) {
        JButton button = new JButton();
        button.setText(text);
        this.buttonsList.add(button);
        button.setActionCommand(id + "");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonsPanel.this.callActionCommandListeners(Integer.parseInt(e.getActionCommand()));
            }
        });
        this.add(button);
    }

    public JButton getButton(int id) {
        for (JButton button : this.buttonsList) {
            if (Integer.parseInt(button.getActionCommand()) != id) continue;
            return button;
        }
        return null;
    }

    public boolean removeButton(int id) {
        String b_text = this.getButtonText(id);
        for (JButton button : this.buttonsList) {
            if (button.getText().compareTo(b_text) != 0) continue;
            this.buttonsList.remove(button);
            return true;
        }
        return false;
    }

    public String getButtonText(int id) {
        switch (id) {
            case 1: {
                return Messages.getText((String)"aceptar");
            }
            case 2: {
                return Messages.getText((String)"cancelar");
            }
            case 3: {
                return Messages.getText((String)"aplicar");
            }
            case 4: {
                return Messages.getText((String)"si");
            }
            case 5: {
                return Messages.getText((String)"no");
            }
            case 6: {
                return Messages.getText((String)"cerrar");
            }
            case 7: {
                return Messages.getText((String)"salir");
            }
            case 8: {
                return Messages.getText((String)"verdetalles");
            }
            case 9: {
                return Messages.getText((String)"ocultardetalles");
            }
            case 10: {
                return Messages.getText((String)"pausar");
            }
            case 11: {
                return Messages.getText((String)"reanudar");
            }
            case 12: {
                return Messages.getText((String)"guardar");
            }
        }
        return null;
    }

    public boolean setEnabled(int id, boolean b) {
        String b_text = this.getButtonText(id);
        for (JButton button : this.buttonsList) {
            if (button.getText().compareTo(b_text) != 0) continue;
            button.setEnabled(b);
            return true;
        }
        return false;
    }

    public JComponent getComponent() {
        return this;
    }
}

