/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.canvas;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.gvsig.raster.swing.gcanvas.DensitySlicingLine;
import org.gvsig.raster.swing.gcanvas.DrawableElement;
import org.gvsig.raster.swing.gcanvas.GCanvas;
import org.gvsig.raster.swing.gcanvas.GCanvasEvent;
import org.gvsig.raster.swing.gcanvas.GraphicHistogram;
import org.gvsig.raster.swing.gcanvas.IGCanvasListener;
import org.gvsig.raster.swing.gcanvas.InfoLayer;
import org.gvsig.raster.swing.gcanvas.LogaritmicExponentialLine;
import org.gvsig.raster.swing.gcanvas.MinMaxLines;
import org.gvsig.raster.swing.gcanvas.SquareRootPowLine;
import org.gvsig.raster.swing.gcanvas.StraightLine;
import org.gvsig.raster.swing.impl.canvas.layer.Border;
import org.gvsig.raster.swing.impl.canvas.layer.DefaultGraphicHistogram;
import org.gvsig.raster.swing.impl.canvas.layer.DefaultInfoLayer;
import org.gvsig.raster.swing.impl.canvas.layer.DefaultMinMaxLines;
import org.gvsig.raster.swing.impl.canvas.layer.function.DefaultDensitySlicingLine;
import org.gvsig.raster.swing.impl.canvas.layer.function.DefaultLogaritmicExponentialLine;
import org.gvsig.raster.swing.impl.canvas.layer.function.DefaultSquareRootPowLine;
import org.gvsig.raster.swing.impl.canvas.layer.function.DefaultStraightLine;

public class DefaultGCanvas
extends JPanel
implements GCanvas {
    private static final long serialVersionUID = 5431466034535083594L;
    private Color backgroundColor = Color.WHITE;
    private List<IGCanvasListener> actionCommandListeners = new ArrayList<IGCanvasListener>();
    public static final int DEFAULT_CURSOR = 0;
    private boolean hasMouse = false;
    private int borderX1 = 0;
    private int borderX2 = 0;
    private int borderY1 = 0;
    private int borderY2 = 0;
    private List<DrawableElement> drawableElements = new ArrayList<DrawableElement>();

    public DefaultGCanvas(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.addMouseListener((MouseListener)((Object)this));
        this.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void addBorder(int x1, int y1, int x2, int y2) {
        this.borderX1 += x1;
        this.borderX2 += x2;
        this.borderY1 += y1;
        this.borderY2 += y2;
    }

    public void addValueChangedListener(IGCanvasListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeValueChangedListener(IGCanvasListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    public void callDataChanged(String key, Object value) {
        for (IGCanvasListener listener : this.actionCommandListeners) {
            listener.actionDataChanged(new GCanvasEvent((Object)this, key, value));
        }
    }

    public void callDataDragged(String key, Object value) {
        for (IGCanvasListener listener : this.actionCommandListeners) {
            listener.actionDataDragged(new GCanvasEvent((Object)this, key, value));
        }
    }

    public void addDrawableElement(DrawableElement element) {
        if (this.drawableElements.contains(element)) {
            return;
        }
        element.setCanvas((GCanvas)this);
        element.firstActions();
        this.drawableElements.add(element);
    }

    public void replaceDrawableElement(DrawableElement element) {
        for (int i = 0; i < this.drawableElements.size(); ++i) {
            if (!element.getClass().isAssignableFrom(this.drawableElements.get(i).getClass())) continue;
            this.drawableElements.set(i, element);
            element.setCanvas((GCanvas)this);
            break;
        }
    }

    public void replaceDrawableElement(DrawableElement element, Class<?> cl) {
        for (int i = 0; i < this.drawableElements.size(); ++i) {
            if (!cl.isInstance(this.drawableElements.get(i))) continue;
            this.drawableElements.set(i, element);
            element.setCanvas((GCanvas)this);
            break;
        }
    }

    public List<DrawableElement> getDrawableElements(Class<?> c1) {
        ArrayList<DrawableElement> elements = new ArrayList<DrawableElement>();
        for (int i = 0; i < this.drawableElements.size(); ++i) {
            if (!c1.isInstance(this.drawableElements.get(i))) continue;
            elements.add(this.drawableElements.get(i));
        }
        return elements;
    }

    public void removeDrawableElement(Class<?> cl) {
        for (int i = 0; i < this.drawableElements.size(); ++i) {
            if (!cl.isInstance(this.drawableElements.get(i))) continue;
            this.drawableElements.remove(i);
        }
    }

    public void setDrawableElements(List<DrawableElement> list) {
        this.drawableElements.clear();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof DrawableElement)) continue;
            this.drawableElements.add(list.get(i));
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < this.drawableElements.size(); ++i) {
            this.drawableElements.get(i).draw(g);
        }
    }

    public void execFirstDrawActions() {
        for (int i = 0; i < this.drawableElements.size(); ++i) {
            this.drawableElements.get(i).firstDrawActions();
        }
    }

    public int getCanvasMinX() {
        return this.borderX1;
    }

    public int getCanvasMinY() {
        return this.borderY1;
    }

    public int getCanvasMaxX() {
        return this.getWidth() - this.borderX2;
    }

    public int getCanvasMaxY() {
        return this.getHeight() - this.borderY2;
    }

    public int getCanvasWidth() {
        return this.getWidth() - (this.borderX1 + this.borderX2);
    }

    public int getCanvasHeight() {
        return this.getHeight() - (this.borderY1 + this.borderY2);
    }

    public void mousePressed(MouseEvent e) {
        for (int i = this.drawableElements.size() - 1; i >= 0; --i) {
            if (this.drawableElements.get(i).mousePressed(e)) continue;
            return;
        }
    }

    public void mouseReleased(MouseEvent e) {
        for (int i = this.drawableElements.size() - 1; i >= 0; --i) {
            if (this.drawableElements.get(i).mouseReleased(e)) continue;
            return;
        }
        this.mouseMoved(e);
    }

    public void mouseDragged(MouseEvent e) {
        for (int i = this.drawableElements.size() - 1; i >= 0; --i) {
            if (this.drawableElements.get(i).mouseDragged(e)) continue;
            return;
        }
    }

    public void mouseMoved(MouseEvent e) {
        for (int i = this.drawableElements.size() - 1; i >= 0; --i) {
            if (this.drawableElements.get(i).mouseMoved(e)) continue;
            return;
        }
        this.setCursor(new Cursor(0));
    }

    public void mouseEntered(MouseEvent e) {
        this.hasMouse = true;
        this.repaint();
        for (int i = this.drawableElements.size() - 1; i >= 0; --i) {
            if (this.drawableElements.get(i).mouseEntered(e)) continue;
            return;
        }
    }

    public void mouseExited(MouseEvent e) {
        this.hasMouse = false;
        this.repaint();
        for (int i = this.drawableElements.size() - 1; i >= 0; --i) {
            if (this.drawableElements.get(i).mouseExited(e)) continue;
            return;
        }
    }

    public boolean isMouse() {
        return this.hasMouse;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public DrawableElement createBorderLayerForGCanvas(Color color) {
        return new Border(color);
    }

    public InfoLayer createInfoLayerForGCanvas(Color colorLayer) {
        return new DefaultInfoLayer(colorLayer);
    }

    public GraphicHistogram createHistogramForGCanvas(double[] data, Color color) {
        return new DefaultGraphicHistogram(data, color);
    }

    public MinMaxLines createMinMaxLinesForGCanvas(Color color) {
        return new DefaultMinMaxLines(color);
    }

    public StraightLine createStraightLineForGCanvas(Color color) {
        return new DefaultStraightLine(color);
    }

    public LogaritmicExponentialLine createLogaritmicExponentialLineForGCanvas(Color color, double point) {
        return new DefaultLogaritmicExponentialLine(color, point);
    }

    public SquareRootPowLine createSquareRootPowLineForGCanvas(Color color, double point) {
        return new DefaultSquareRootPowLine(color, point);
    }

    public DensitySlicingLine createDensitySliceForGCanvas(Color color, int levels) {
        return new DefaultDensitySlicingLine(color, levels);
    }
}

