/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.canvas.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import org.gvsig.raster.swing.gcanvas.GraphicHistogram;

public class DefaultGraphicHistogram
extends GraphicHistogram {
    private int border = 2;
    private double[] histogramValues = null;
    private double[] valuesLineal = null;
    private double[] valuesAcummulated = null;
    private double[] valuesLogarithmic = null;
    private double[] valuesAcummulatedLog = null;
    private int typeViewed = 0;
    private int type = 1;

    public DefaultGraphicHistogram(Color c) {
        this.setColor(c);
    }

    public DefaultGraphicHistogram(double[] values, Color c) {
        this.setColor(c);
        this.setHistogramDrawed(values);
    }

    private int valueToPixelY(double value) {
        value = 1.0 - value;
        return (int)Math.round((double)(this.canvas.getCanvasMinY() + this.border) + (double)(this.canvas.getCanvasMaxY() - this.canvas.getCanvasMinY() - this.border * 2) * value);
    }

    protected void paint(Graphics g) {
        double[] valuesToDraw = this.recalcHistogram(this.typeViewed);
        if (valuesToDraw == null) {
            return;
        }
        g.setColor(this.color);
        switch (this.type) {
            case 2: {
                double width = this.canvas.getCanvasMaxX() - this.canvas.getCanvasMinX();
                for (int i = 0; i < valuesToDraw.length; ++i) {
                    int x1 = (int)Math.round(((double)i - 0.5) * (width / ((double)valuesToDraw.length - 1.0)));
                    int x2 = (int)Math.round(((double)i + 0.5) * (width / ((double)valuesToDraw.length - 1.0)));
                    x2 += this.canvas.getCanvasMinX();
                    int y1 = this.valueToPixelY(valuesToDraw[i]);
                    if ((x1 += this.canvas.getCanvasMinX()) < this.canvas.getCanvasMinX() + this.border) {
                        x1 = this.canvas.getCanvasMinX() + this.border;
                    }
                    if (x2 > this.canvas.getCanvasMaxX() - this.border) {
                        x2 = this.canvas.getCanvasMaxX() - this.border;
                    }
                    g.setColor(this.color);
                    g.fillRect(x1, y1, x2 - x1, this.canvas.getCanvasMaxY() - this.border - y1);
                }
                break;
            }
            default: {
                double width = this.canvas.getCanvasMaxX() - this.canvas.getCanvasMinX();
                for (int i = 1; i < valuesToDraw.length; ++i) {
                    int x1 = (int)Math.round((double)this.canvas.getCanvasMinX() + ((double)i - 1.0) * (width / ((double)valuesToDraw.length - 1.0)));
                    int x2 = (int)Math.round((double)this.canvas.getCanvasMinX() + (double)i * (width / ((double)valuesToDraw.length - 1.0)));
                    g.drawLine(x1, this.valueToPixelY(valuesToDraw[i - 1]), x2, this.valueToPixelY(valuesToDraw[i]));
                }
            }
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setTypeViewed(int type) {
        this.typeViewed = type;
    }

    private void convertToPercent(double[] values) {
        int i;
        double max = Double.NEGATIVE_INFINITY;
        for (i = 0; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        for (i = 0; i < values.length; ++i) {
            values[i] = values[i] / max;
        }
    }

    private double[] recalcHistogram(int type) {
        if (this.histogramValues == null) {
            this.histogramValues = new double[0];
        }
        switch (type) {
            case 1: {
                if (this.valuesAcummulated != null) {
                    return this.valuesAcummulated;
                }
                this.valuesAcummulated = new double[this.histogramValues.length];
                if (this.valuesAcummulated.length >= 1) {
                    this.valuesAcummulated[0] = this.histogramValues[0];
                    for (int i = 1; i < this.histogramValues.length; ++i) {
                        this.valuesAcummulated[i] = this.histogramValues[i] + this.valuesAcummulated[i - 1];
                    }
                }
                this.convertToPercent(this.valuesAcummulated);
                return this.valuesAcummulated;
            }
            case 2: {
                int i;
                if (this.valuesLogarithmic != null) {
                    return this.valuesLogarithmic;
                }
                double min = Double.MAX_VALUE;
                for (i = 0; i < this.histogramValues.length; ++i) {
                    if (!(this.histogramValues[i] < min)) continue;
                    min = this.histogramValues[i];
                }
                this.valuesLogarithmic = new double[this.histogramValues.length];
                for (i = 0; i < this.histogramValues.length; ++i) {
                    this.valuesLogarithmic[i] = Math.log(this.histogramValues[i] - min + 1.0);
                }
                this.convertToPercent(this.valuesLogarithmic);
                return this.valuesLogarithmic;
            }
            case 3: {
                int i;
                if (this.valuesAcummulatedLog != null) {
                    return this.valuesAcummulatedLog;
                }
                this.valuesAcummulatedLog = new double[this.histogramValues.length];
                if (this.valuesAcummulatedLog.length >= 1) {
                    this.valuesAcummulatedLog[0] = this.histogramValues[0];
                    for (i = 1; i < this.histogramValues.length; ++i) {
                        this.valuesAcummulatedLog[i] = this.histogramValues[i] + this.valuesAcummulatedLog[i - 1];
                    }
                }
                double min = Double.MAX_VALUE;
                for (i = 0; i < this.valuesAcummulatedLog.length; ++i) {
                    if (!(this.valuesAcummulatedLog[i] < min)) continue;
                    min = this.valuesAcummulatedLog[i];
                }
                for (i = 0; i < this.valuesAcummulatedLog.length; ++i) {
                    this.valuesAcummulatedLog[i] = Math.log(this.valuesAcummulatedLog[i] - min + 1.0);
                }
                this.convertToPercent(this.valuesAcummulatedLog);
                return this.valuesAcummulatedLog;
            }
        }
        if (this.valuesLineal != null) {
            return this.valuesLineal;
        }
        this.valuesLineal = new double[this.histogramValues.length];
        for (int i = 0; i < this.histogramValues.length; ++i) {
            this.valuesLineal[i] = this.histogramValues[i];
        }
        this.convertToPercent(this.valuesLineal);
        return this.valuesLineal;
    }

    public void setHistogramDrawed(double[] histogramDrawed) {
        this.histogramValues = histogramDrawed;
        this.valuesLineal = null;
        this.valuesAcummulated = null;
        this.valuesLogarithmic = null;
        this.valuesAcummulatedLog = null;
        if (histogramDrawed == null) {
            return;
        }
        if (this.canvas != null) {
            ((Component)this.canvas).repaint();
        }
    }

    public int getType() {
        return this.type;
    }

    public int getTypeViewed() {
        return this.typeViewed;
    }

    public double[] getHistogramValues() {
        return this.histogramValues;
    }

    public void firstActions() {
    }

    public void firstDrawActions() {
    }
}

