/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.canvas.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import org.gvsig.raster.swing.gcanvas.GCanvas;
import org.gvsig.raster.swing.gcanvas.MinMaxLines;
import org.gvsig.raster.swing.impl.canvas.DefaultGCanvas;
import org.gvsig.raster.swing.impl.canvas.layer.function.DefaultBaseFunction;

public class DefaultMinMaxLines
extends MinMaxLines {
    private int border = 2;
    private double minPos = 0.0;
    private double maxPos = 1.0;
    private boolean minSelected = false;
    private boolean maxSelected = false;

    public DefaultMinMaxLines(Color c) {
        this.setColor(c);
    }

    public void setMinimum(double min) {
        this.minPos = min;
    }

    public void setMaximum(double max) {
        this.maxPos = max;
    }

    private int valueToPixel(double value) {
        return (int)Math.round((double)(this.canvas.getCanvasMinX() + this.border) + (double)(this.canvas.getCanvasMaxX() - this.canvas.getCanvasMinX() - this.border * 2) * value);
    }

    private double pixelToValue(int pixel) {
        return (double)(pixel - this.canvas.getCanvasMinX() - this.border) / (double)(this.canvas.getCanvasMaxX() - this.canvas.getCanvasMinX() - this.border * 2);
    }

    public void paint(Graphics g) {
        g.setColor(this.color);
        int y = this.canvas.getCanvasMinY();
        int x1 = this.valueToPixel(this.minPos);
        int x2 = this.valueToPixel(this.maxPos);
        Graphics2D g2 = (Graphics2D)g;
        float[] dash1 = new float[]{10.0f};
        BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
        Stroke stroke2 = g2.getStroke();
        g2.setStroke(stroke);
        g2.drawLine(x1, y, x1, this.canvas.getCanvasMaxY());
        g2.drawLine(x2, y, x2, this.canvas.getCanvasMaxY());
        g2.setStroke(stroke2);
    }

    public void setCanvas(DefaultGCanvas canvas) {
        super.setCanvas((GCanvas)canvas);
    }

    public boolean mousePressed(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) == 0) {
            return true;
        }
        if (e.getY() > this.canvas.getCanvasMinY() && e.getY() < this.canvas.getCanvasMaxY()) {
            if (e.getX() >= this.valueToPixel(this.minPos) - 3 && e.getX() <= this.valueToPixel(this.minPos) + 3) {
                this.minSelected = true;
                return false;
            }
            if (e.getX() >= this.valueToPixel(this.maxPos) - 3 && e.getX() <= this.valueToPixel(this.maxPos) + 3) {
                this.maxSelected = true;
                return false;
            }
        }
        return true;
    }

    public boolean mouseReleased(MouseEvent e) {
        if (this.canvas != null && (this.minSelected || this.maxSelected)) {
            ((Component)this.canvas).repaint();
            this.canvas.callDataChanged("minmax", (Object)this);
        }
        this.minSelected = false;
        this.maxSelected = false;
        return true;
    }

    public boolean mouseDragged(MouseEvent e) {
        if (this.canvas == null) {
            return true;
        }
        if (this.minSelected) {
            this.minPos = this.pixelToValue(e.getX());
            if (this.minPos < 0.0) {
                this.minPos = 0.0;
            }
            if (this.minPos > 1.0) {
                this.minPos = 1.0;
            }
            if (this.minPos > this.maxPos) {
                this.maxPos = this.minPos;
            }
            this.updateDrawableElements();
            return false;
        }
        if (this.maxSelected) {
            this.maxPos = this.pixelToValue(e.getX());
            if (this.maxPos < 0.0) {
                this.maxPos = 0.0;
            }
            if (this.maxPos > 1.0) {
                this.maxPos = 1.0;
            }
            if (this.maxPos < this.minPos) {
                this.minPos = this.maxPos;
            }
            this.updateDrawableElements();
            return false;
        }
        return true;
    }

    private void updateDrawableElements() {
        List elements = this.canvas.getDrawableElements(DefaultBaseFunction.class);
        if (elements.size() > 0) {
            DefaultBaseFunction baseFunction = (DefaultBaseFunction)((Object)elements.get(0));
            baseFunction.setMinX(this.minPos);
            baseFunction.setMaxX(this.maxPos);
        }
        ((Component)this.canvas).repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultMinMaxLines.this.canvas.callDataDragged("minmax", (Object)this);
            }
        });
    }

    public boolean mouseMoved(MouseEvent e) {
        if (e.getY() > this.canvas.getCanvasMinY() && e.getY() < this.canvas.getCanvasMaxY()) {
            if (e.getX() >= this.valueToPixel(this.minPos) - 3 && e.getX() <= this.valueToPixel(this.minPos) + 3) {
                ((Component)this.canvas).setCursor(new Cursor(10));
                return false;
            }
            if (e.getX() >= this.valueToPixel(this.maxPos) - 3 && e.getX() <= this.valueToPixel(this.maxPos) + 3) {
                ((Component)this.canvas).setCursor(new Cursor(11));
                return false;
            }
        }
        return true;
    }

    public double getMinDistance() {
        return this.minPos;
    }

    public double getMaxDistance() {
        return this.maxPos;
    }

    public void firstActions() {
    }

    public void firstDrawActions() {
    }
}

