/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.canvas.layer.function;

import java.awt.Color;
import java.awt.event.MouseEvent;
import org.gvsig.raster.swing.gcanvas.DensitySlicingLine;
import org.gvsig.raster.swing.impl.canvas.layer.function.DefaultStraightLine;

public class DefaultDensitySlicingLine
extends DefaultStraightLine
implements DensitySlicingLine {
    public static final int DEFAULT_LEVELS = 6;
    private int levels = 6;

    public DefaultDensitySlicingLine(Color c) {
        this(c, 6);
    }

    public DefaultDensitySlicingLine(Color c, int levels) {
        super(c);
        if (levels < 0) {
            return;
        }
        this.setShowSquares(false);
        this.setShape(levels);
    }

    public void setShape(int levels) {
        this.levels = levels;
        this.listSquare.clear();
        if (levels <= 1) {
            return;
        }
        int nSquares = levels * 2;
        double posX = 0.0;
        double posY = 0.0;
        double contX = 0.0;
        double contY = 0.0;
        for (int i = 0; i < nSquares; ++i) {
            posX = contX / (double)levels;
            posY = contY / ((double)levels - 1.0);
            this.listSquare.add(new DefaultStraightLine.Square((DefaultStraightLine)this, posX, posY));
            if (i % 2 != 0) {
                contY += 1.0;
                continue;
            }
            contX += 1.0;
        }
    }

    public int getLevels() {
        return this.levels;
    }

    @Override
    public int getFunctionType() {
        return 3;
    }

    @Override
    public double getValueFunction() {
        return this.levels;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        return true;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        return true;
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        return true;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        return true;
    }

    @Override
    public void firstDrawActions() {
    }
}

