/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.canvas.layer.function;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.swing.gcanvas.GCanvas;
import org.gvsig.raster.swing.gcanvas.StraightLine;
import org.gvsig.raster.swing.impl.canvas.DefaultGCanvas;
import org.gvsig.raster.swing.impl.canvas.layer.DefaultInfoLayer;
import org.gvsig.raster.swing.impl.canvas.layer.function.DefaultBaseFunction;

public class DefaultStraightLine
extends DefaultBaseFunction
implements StraightLine {
    protected List<Square> listSquare = new ArrayList<Square>();
    private int pointDragged = -1;
    private Cursor transparentCursor = null;
    private boolean showSquares = true;
    private int border = 2;
    boolean last = false;

    public DefaultStraightLine(Color c) {
        int[] pixels = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, pixels, 0, 16));
        this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        this.setColor(c);
        this.clearSquares();
        this.addSquare(0.0, 0.0);
        this.addSquare(1.0, 1.0);
    }

    public void clearSquares() {
        this.listSquare.clear();
    }

    public void addSquare(double x, double y) {
        this.listSquare.add(new Square(x, y));
    }

    @Override
    protected void paint(Graphics g) {
        int i;
        super.paint(g);
        g.setColor(this.color);
        Square square = null;
        Square lastSquare = null;
        if (this.listSquare.size() > 0) {
            square = this.listSquare.get(0);
            g.drawLine(this.canvas.getCanvasMinX(), square.getPixelY(), square.getPixelX(), square.getPixelY());
        }
        for (i = 0; i < this.listSquare.size(); ++i) {
            lastSquare = square;
            square = this.listSquare.get(i);
            if (lastSquare == null) continue;
            g.drawLine(lastSquare.getPixelX(), lastSquare.getPixelY(), square.getPixelX(), square.getPixelY());
        }
        if (this.listSquare.size() > 0) {
            square = this.listSquare.get(this.listSquare.size() - 1);
            g.drawLine(square.getPixelX(), square.getPixelY(), this.canvas.getCanvasMaxX(), square.getPixelY());
        }
        if (this.showSquares) {
            for (i = 0; i < this.listSquare.size(); ++i) {
                square = this.listSquare.get(i);
                square.setColor(this.color);
                if (this.pointDragged != i) {
                    square.paint(g);
                    continue;
                }
                square.paintCursor(g);
            }
        }
        if (this.pointDragged != -1) {
            this.setInfoPoint(this.pointDragged);
        }
    }

    private void setInfoPoint(int point) {
        List list = this.canvas.getDrawableElements(DefaultInfoLayer.class);
        if (list.size() > 0) {
            DefaultInfoLayer infoLayer = (DefaultInfoLayer)((Object)list.get(0));
            if (point != -1) {
                Square square = this.listSquare.get(point);
                double value = this.minx + square.getX() * (this.maxx - this.minx);
                value = infoLayer.getMin() + value * (infoLayer.getMax() - infoLayer.getMin());
                infoLayer.setStatusLeft("In: " + this.clipDecimals(value, 1));
                infoLayer.setStatusRight("Out: " + Math.round(square.getY() * 255.0));
            } else {
                infoLayer.setStatusLeft(null);
                infoLayer.setStatusRight(null);
            }
        }
    }

    public double clipDecimals(double num, int n) {
        long m = (long)Math.pow(10.0, n);
        long aux = Math.round(num * (double)m);
        return (double)aux / (double)m;
    }

    public void setCanvas(DefaultGCanvas canvas) {
        super.setCanvas((GCanvas)canvas);
    }

    private int insert(Square element) {
        for (int i = 0; i < this.listSquare.size() - 1; ++i) {
            double sqX = this.listSquare.get(i).getX();
            double sqNextX = this.listSquare.get(i + 1).getX();
            if (!(element.getX() >= sqX) || !(element.getX() <= sqNextX)) continue;
            this.listSquare.add(i + 1, element);
            return i + 1;
        }
        return -1;
    }

    public boolean mousePressed(MouseEvent e) {
        for (int i = 0; i < this.listSquare.size(); ++i) {
            if (!this.listSquare.get(i).isInside(e.getPoint())) continue;
            if ((e.getModifiersEx() & 0x1000) != 0) {
                if (i == 0 || i + 1 == this.listSquare.size()) continue;
                this.pointDragged = -1;
                this.listSquare.remove(i);
                ((Component)this.canvas).repaint();
                return false;
            }
            if ((e.getModifiersEx() & 0x400) == 0) continue;
            this.pointDragged = i;
            this.mouseDragged(e);
            return false;
        }
        if ((e.getModifiersEx() & 0x400) == 0) {
            return true;
        }
        if (((Component)this.canvas).getCursor().getType() == 0) {
            this.pointDragged = this.insert(new Square(e.getX(), e.getY()));
            this.mouseDragged(e);
            return false;
        }
        return true;
    }

    public boolean mouseReleased(MouseEvent e) {
        this.pointDragged = -1;
        this.setInfoPoint(-1);
        ((Component)this.canvas).repaint();
        this.canvas.callDataChanged("line", (Object)this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseDragged(MouseEvent e) {
        if (this.pointDragged >= 0) {
            ((Component)this.canvas).setCursor(this.transparentCursor);
            int minX = this.canvas.getCanvasMinX();
            int minY = this.canvas.getCanvasMinY();
            int maxX = this.canvas.getCanvasMaxX();
            int maxY = this.canvas.getCanvasMaxY();
            int x = Math.min(Math.max(e.getX(), minX), maxX);
            int y = Math.min(Math.max(e.getY(), minY), maxY);
            Square point = this.listSquare.get(this.pointDragged);
            try {
                int j;
                int i;
                if (this.pointDragged == 0) {
                    point.setPosition(minX, y);
                    boolean bl = false;
                    return bl;
                }
                if (this.pointDragged == this.listSquare.size() - 1) {
                    point.setPosition(maxX, y);
                    boolean bl = false;
                    return bl;
                }
                point.setPosition(x, y);
                for (i = 0; i < this.pointDragged; ++i) {
                    Square lowPoint = this.listSquare.get(i);
                    if (lowPoint.getPixelX() < x) continue;
                    lowPoint.setPosition(x, lowPoint.getPixelY());
                    j = i + 1;
                    while (this.listSquare.get(j) != point) {
                        this.listSquare.remove(j);
                        --this.pointDragged;
                    }
                    break;
                }
                for (i = this.listSquare.size() - 1; i > this.pointDragged; --i) {
                    Square upperPoint = this.listSquare.get(i);
                    if (upperPoint.getPixelX() > x) continue;
                    upperPoint.setPosition(x, upperPoint.getPixelY());
                    j = i - 1;
                    while (this.listSquare.get(j) != point) {
                        this.listSquare.remove(j);
                        --j;
                    }
                    break;
                }
            }
            finally {
                ((Component)this.canvas).repaint();
                this.canvas.callDataDragged("line", (Object)this);
            }
            return false;
        }
        return true;
    }

    public boolean mouseMoved(MouseEvent e) {
        for (int i = 0; i < this.listSquare.size(); ++i) {
            if (!this.listSquare.get(i).isInside(e.getPoint())) continue;
            ((Component)this.canvas).setCursor(new Cursor(13));
            this.setInfoPoint(i);
            ((Component)this.canvas).repaint();
            this.last = true;
            return false;
        }
        if (this.last) {
            this.setInfoPoint(-1);
            ((Component)this.canvas).repaint();
            this.last = false;
        }
        return true;
    }

    public double[] getInValues(double min, double max) {
        double[] in = this.getPercentInValues();
        for (int i = 0; i < in.length; ++i) {
            in[i] = min + in[i] * (max - min);
        }
        return in;
    }

    public int[] getOutValues() {
        double[] values = this.getPercentOutValues();
        int[] out = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            out[i] = (int)Math.round(values[i] * 255.0);
        }
        return out;
    }

    public double[] getPercentInValues() {
        double[] in = new double[this.listSquare.size() + 2];
        for (int i = 0; i < this.listSquare.size(); ++i) {
            Square square = this.listSquare.get(i);
            in[i + 1] = this.minx + (this.maxx - this.minx) * square.getX();
        }
        in[0] = 0.0;
        in[in.length - 1] = 1.0;
        return in;
    }

    public double[] getPercentOutValues() {
        double[] out = new double[this.listSquare.size() + 2];
        for (int i = 0; i < this.listSquare.size(); ++i) {
            Square square = this.listSquare.get(i);
            out[i + 1] = square.getY();
        }
        out[0] = out[1];
        out[out.length - 1] = out[out.length - 2];
        return out;
    }

    public void firstActions() {
    }

    public void firstDrawActions() {
    }

    public void setShowSquares(boolean showSquares) {
        this.showSquares = showSquares;
    }

    protected double pixelToValueX(int pixel) {
        double value = (double)(pixel - this.canvas.getCanvasMinX() - this.border) / ((double)(this.canvas.getCanvasMaxX() - this.canvas.getCanvasMinX()) - (double)this.border * 2.0);
        value = (value - this.minx) / (this.maxx - this.minx);
        return value;
    }

    protected double pixelToValueY(int pixel) {
        double div = (double)(this.canvas.getCanvasMaxY() - this.canvas.getCanvasMinY()) - (double)this.border * 2.0;
        if (div == 0.0) {
            return 0.0;
        }
        return 1.0 - (double)(pixel - this.canvas.getCanvasMinY() - this.border) / div;
    }

    public int getFunctionType() {
        return 0;
    }

    public double getValueFunction() {
        return 0.0;
    }

    class Square {
        private double x = 0.0;
        private double y = 0.0;
        private int width = 6;
        private Color color = Color.WHITE;

        public Square(double x, double y) {
            this.setPosition(x, y);
        }

        public Square(int x, int y) {
            this.setPosition(x, y);
        }

        public void setPosition(double x, double y) {
            this.x = x;
            this.y = y;
            if (this.x > 1.0) {
                this.x = 1.0;
            }
            if (this.x < 0.0) {
                this.x = 0.0;
            }
            if (this.y > 1.0) {
                this.y = 1.0;
            }
            if (this.y < 0.0) {
                this.y = 0.0;
            }
        }

        public void setPosition(int x, int y) {
            this.setPosition(DefaultStraightLine.this.pixelToValueX(x), DefaultStraightLine.this.pixelToValueY(y));
        }

        public int getPixelX() {
            return this.valueToPixelX(this.x);
        }

        public int getPixelY() {
            return this.valueToPixelY(this.y);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        protected void paint(Graphics g) {
            g.setColor(this.color);
            g.drawRect(this.valueToPixelX(this.x) - (this.width >> 1), this.valueToPixelY(this.y) - (this.width >> 1), this.width, this.width);
        }

        protected void paintCursor(Graphics g) {
            g.setColor(Color.white);
            g.drawLine(this.valueToPixelX(this.x) - 6, this.valueToPixelY(this.y), this.valueToPixelX(this.x) + 6, this.valueToPixelY(this.y));
            g.drawLine(this.valueToPixelX(this.x), this.valueToPixelY(this.y) - 6, this.valueToPixelX(this.x), this.valueToPixelY(this.y) + 6);
        }

        public boolean isInside(Point p) {
            if (p.getX() < (double)(this.valueToPixelX(this.x) - (this.width >> 1))) {
                return false;
            }
            if (p.getX() > (double)(this.valueToPixelX(this.x) + (this.width >> 1))) {
                return false;
            }
            if (p.getY() < (double)(this.valueToPixelY(this.y) - (this.width >> 1))) {
                return false;
            }
            return !(p.getY() > (double)(this.valueToPixelY(this.y) + (this.width >> 1)));
        }

        public void setColor(Color c) {
            this.color = c;
        }

        private int valueToPixelX(double value) {
            value = DefaultStraightLine.this.minx + (DefaultStraightLine.this.maxx - DefaultStraightLine.this.minx) * value;
            return (int)Math.round((double)(DefaultStraightLine.this.canvas.getCanvasMinX() + DefaultStraightLine.this.border) + (double)(DefaultStraightLine.this.canvas.getCanvasMaxX() - DefaultStraightLine.this.canvas.getCanvasMinX() - DefaultStraightLine.this.border * 2) * value);
        }

        private int valueToPixelY(double value) {
            value = 1.0 - value;
            return (int)Math.round((double)(DefaultStraightLine.this.canvas.getCanvasMinY() + DefaultStraightLine.this.border) + (double)(DefaultStraightLine.this.canvas.getCanvasMaxY() - DefaultStraightLine.this.canvas.getCanvasMinY() - DefaultStraightLine.this.border * 2) * value);
        }
    }
}

