/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.newlayer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.impl.openfile.OpenFileContainerImpl;
import org.gvsig.raster.swing.newlayer.CreateNewLayerPanel;
import org.gvsig.raster.swing.newlayer.FileNameManagement;
import org.gvsig.raster.swing.openfile.OpenFileContainer;

public class CreateNewLayerPanelImpl
extends JPanel
implements CreateNewLayerPanel {
    private static final long serialVersionUID = -8569485642371687008L;
    private JRadioButton jRBFileGenerate = null;
    private JRadioButton jRBOpenMemory = null;
    private JTextField filenameTextField = null;
    private JLabel labelFilename = null;
    private JPanel panelNameFile = null;
    private List<String> extList = null;
    private FileNameManagement fileNameManagement = null;
    private OpenFileContainer openFileContainer = null;

    public CreateNewLayerPanelImpl(FileNameManagement fileNameManagement, String tittle) {
        this.fileNameManagement = fileNameManagement;
        this.extList = fileNameManagement.getPrefixSupported();
        this.initialize(tittle);
        this.translate();
        this.getFileSelectorPanel().setPath(fileNameManagement.getDefaultFilePath());
        this.updateNewLayerText();
    }

    public CreateNewLayerPanelImpl(FileNameManagement fileNameManagement) {
        this(fileNameManagement, "");
    }

    private void initialize(String tittle) {
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.getRadioFileGenerate());
        buttonGroup2.add(this.getRadioOpenMemory());
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(tittle));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 5, 2);
        this.add((Component)this.getRadioFileGenerate(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 25, 5, 2);
        this.add((Component)((JComponent)this.getFileSelectorPanel()), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getRadioOpenMemory(), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 25, 2, 2);
        this.add((Component)this.getFileNamePanel(), gridBagConstraints);
    }

    private void translate() {
        this.getRadioFileGenerate().setText(Messages.getText((String)"generar_fichero"));
        this.getRadioOpenMemory().setText(Messages.getText((String)"abrir_memoria"));
        this.getLabelFilename().setText(Messages.getText((String)"nombre_capa") + ":");
    }

    public JRadioButton getRadioFileGenerate() {
        if (this.jRBFileGenerate == null) {
            this.jRBFileGenerate = new JRadioButton();
            this.jRBFileGenerate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jRBFileGenerate.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.jRBFileGenerate;
    }

    public JRadioButton getRadioOpenMemory() {
        if (this.jRBOpenMemory == null) {
            this.jRBOpenMemory = new JRadioButton();
            this.jRBOpenMemory.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jRBOpenMemory.setMargin(new Insets(0, 0, 0, 0));
            this.jRBOpenMemory.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    CreateNewLayerPanelImpl.this.jRBOpenMemoryStateChanged(evt);
                }
            });
            this.jRBOpenMemory.setSelected(true);
        }
        return this.jRBOpenMemory;
    }

    private JTextField getFilenameTextField() {
        if (this.filenameTextField == null) {
            this.filenameTextField = new JTextField();
            this.filenameTextField.setPreferredSize(new Dimension(0, this.filenameTextField.getPreferredSize().height));
        }
        return this.filenameTextField;
    }

    public OpenFileContainer getFileSelectorPanel() {
        if (this.openFileContainer == null) {
            this.openFileContainer = new OpenFileContainerImpl(false, this.extList, this.fileNameManagement.getDefaultFilePath());
        }
        return this.openFileContainer;
    }

    public JPanel getFileNamePanel() {
        if (this.panelNameFile == null) {
            this.panelNameFile = new JPanel();
            this.panelNameFile.setLayout(new BorderLayout());
            this.panelNameFile.add((Component)this.getLabelFilename(), "West");
            this.panelNameFile.add((Component)this.getFilenameTextField(), "Center");
        }
        return this.panelNameFile;
    }

    private JLabel getLabelFilename() {
        if (this.labelFilename == null) {
            this.labelFilename = new JLabel();
        }
        return this.labelFilename;
    }

    public void setFilenameEnabled(boolean value) {
        this.getFilenameTextField().setEnabled(value);
        this.getLabelFilename().setEnabled(value);
    }

    protected void jRBOpenMemoryStateChanged(ItemEvent evt) {
        if (this.getRadioOpenMemory().getSelectedObjects() != null) {
            this.getFileSelectorPanel().setEnabled(false);
            this.setFilenameEnabled(true);
        } else {
            this.getFileSelectorPanel().setEnabled(true);
            this.setFilenameEnabled(false);
        }
    }

    public void setLabelFilename(String text) {
        this.getLabelFilename().setText(text);
    }

    public String getFileSelected() {
        boolean isDir = false;
        if (this.getRadioFileGenerate().isSelected()) {
            String path = this.getFileSelectorPanel().getFile().getAbsolutePath();
            if (new File(path).isDirectory()) {
                isDir = true;
            } else {
                return path.substring(path.lastIndexOf(File.separator) + 1, path.length());
            }
        }
        if (!this.getRadioFileGenerate().isSelected() || isDir) {
            String file = this.getFilenameTextField().getText();
            if (file.compareTo(this.fileNameManagement.getUniqueLayerName()) == 0) {
                this.fileNameManagement.usesUniqueLayerName();
            }
            this.updateNewLayerText();
            return file;
        }
        return null;
    }

    public String getDirectorySelected() {
        if (this.getRadioFileGenerate().isSelected()) {
            String path = this.getFileSelectorPanel().getFile().getAbsolutePath();
            if (new File(path).isDirectory()) {
                return path;
            }
            return new File(path).getParent();
        }
        return this.fileNameManagement.getDefaultFilePath();
    }

    public void updateNewLayerText() {
        this.getFilenameTextField().setText(this.fileNameManagement.getUniqueLayerName());
    }
}

