/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.openfile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.gui.beans.Messages;
import org.gvsig.raster.swing.impl.openfile.OpenFileListener;
import org.gvsig.raster.swing.openfile.OpenFileContainer;

public class OpenFileContainerImpl
extends JPanel
implements OpenFileContainer {
    private static final long serialVersionUID = 5823371652872582451L;
    private JButton jButton = null;
    private JTextField tOpen = null;
    private OpenFileListener listener = null;
    private boolean showBorder = true;
    private boolean isButtonVisible = true;

    public OpenFileContainerImpl(boolean showBorder, String[] fileFilter, String defaultPath) {
        this.showBorder = showBorder;
        this.listener = new OpenFileListener(this, fileFilter, defaultPath);
        this.initialize();
        this.listener.setButton(this.getJButton());
    }

    public OpenFileContainerImpl(boolean showBorder, List<String> fileFilter, String defaultPath) {
        this(showBorder, fileFilter.toArray(new String[0]), defaultPath);
        this.listener.setButton(this.getJButton());
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        if (this.showBorder) {
            this.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"open_file"), 0, 0, null, null));
        }
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.getTOpen(), gridBagConstraints1);
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.weightx = 0.0;
        this.add((Component)this.getJButton(), gridBagConstraints1);
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            ImageIcon icon = null;
            try {
                icon = IconThemeHelper.getImageIcon((String)"icon-folder-open");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (icon == null || icon.getIconWidth() <= 0 || icon.getIconHeight() <= 0) {
                icon = new ImageIcon(System.getProperty("user.dir") + "/src/main/resources/images/icon-folder-open.gif", "");
            }
            this.jButton = new JButton(icon);
            this.jButton.setPreferredSize(new Dimension(22, 22));
            this.jButton.addActionListener(this.listener);
            this.jButton.setVisible(this.isButtonVisible);
            this.getTOpen().setEnabled(this.isButtonVisible);
        }
        return this.jButton;
    }

    public JTextField getTOpen() {
        if (this.tOpen == null) {
            this.tOpen = new JTextField();
            this.tOpen.setPreferredSize(new Dimension(0, 22));
        }
        return this.tOpen;
    }

    public void setPath(String path) {
        this.getTOpen().setText(path);
    }

    public File getFile() {
        File fil = null;
        if (this.getTOpen().getText() != "") {
            try {
                fil = new File(this.getTOpen().getText());
            }
            catch (Exception exc) {
                System.err.println("Ruta o archivo no v\u00e1lido");
            }
        }
        return fil;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getTOpen().setEnabled(enabled);
        this.getJButton().setEnabled(enabled);
    }
}

