/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.pagedtable;

import javax.swing.JComponent;
import javax.swing.JTable;
import org.gvsig.raster.swing.impl.pagedtable.MoveRowsPanel;
import org.gvsig.raster.swing.impl.pagedtable.PagedTablePanel;
import org.gvsig.raster.swing.impl.pagedtable.Pager;
import org.gvsig.raster.swing.impl.pagedtable.PaginationBarPanel;
import org.gvsig.raster.swing.impl.pagedtable.TableControllerListener;
import org.gvsig.raster.swing.impl.pagedtable.TableEntryControllerPanel;
import org.gvsig.raster.swing.pagedtable.ModelLoader;
import org.gvsig.raster.swing.pagedtable.PagedTable;
import org.gvsig.raster.swing.pagedtable.PagedTableEvent;
import org.gvsig.raster.swing.pagedtable.PagedTableListener;
import org.gvsig.raster.swing.pagedtable.TableModel;

public class PagedTableImpl
implements PagedTable {
    private static final long serialVersionUID = 1L;
    private ModelLoader modelLoader = null;
    private PagedTablePanel panel = null;
    private PaginationBarPanel paginationBar = null;
    private TableEntryControllerPanel tableEntryController = null;
    private TableControllerListener tableListener = null;
    private MoveRowsPanel moveRowsPanel = null;
    private Pager pager = null;

    public PagedTableImpl(ModelLoader modelLoader) {
        this.modelLoader = modelLoader;
        this.tableListener = new TableControllerListener(this);
        this.getPager().addObserver(this.getTableEntryController());
        this.getPager().addObserver(this.getPaginationBar());
        this.getPager().addObserver(this.getMoveRowsPanel());
        this.getPager().addObserver(this.getPagedTablePanel());
    }

    public Pager getPager() {
        if (this.pager == null) {
            this.pager = new Pager(0, this);
        }
        return this.pager;
    }

    public TableEntryControllerPanel getTableEntryController() {
        if (this.tableEntryController == null) {
            this.tableEntryController = new TableEntryControllerPanel(this.tableListener);
        }
        return this.tableEntryController;
    }

    public PagedTablePanel getPagedTablePanel() {
        if (this.panel == null) {
            this.panel = new PagedTablePanel(this.modelLoader, this.getPager(), this.getPaginationBar(), this.getMoveRowsPanel(), this.getTableEntryController());
        }
        return this.panel;
    }

    public Object getValueAt(int row, int column) {
        Object[] entry = this.pager.getEntry(row);
        if (entry != null && column >= 0 && column < entry.length) {
            return entry[column];
        }
        return null;
    }

    public void setValueAt(Object obj, int row, int column) {
        Object[] entry = this.pager.getEntry(row);
        if (entry != null && column >= 0 && column < entry.length) {
            entry[column] = obj;
        }
        this.pager.throwEvent(PagedTableEvent.EVENT_MODIFY_ENTRY, new int[]{row});
    }

    public int getColumnCount() {
        return this.panel.getJTable().getModel().getColumnCount();
    }

    public int getRowCount() {
        return this.pager.getEntriesCount();
    }

    public MoveRowsPanel getMoveRowsPanel() {
        if (this.moveRowsPanel == null) {
            this.moveRowsPanel = new MoveRowsPanel(this.tableListener);
        }
        return this.moveRowsPanel;
    }

    public PaginationBarPanel getPaginationBar() {
        if (this.paginationBar == null) {
            this.paginationBar = new PaginationBarPanel(this.tableListener);
        }
        return this.paginationBar;
    }

    public void addRow(Object[] list) {
        this.pager.addEntry(list);
    }

    public void delRow(int i) {
        this.pager.removeEntry(i);
    }

    public void removeAllRows() {
        this.pager.removeAllEntries();
    }

    public void removeAllRowsWithoutAsk() {
        this.pager.removeAllEntriesWithoutAsk();
    }

    public int[] getSelectedRows() {
        return this.pager.getSelectedRows();
    }

    public void swapRow(int i, int j) {
        this.pager.swapRow(i, j);
    }

    public void setSelectedRows(int[] rows) {
        this.pager.setSelectedRows(rows);
    }

    public void setSelectedRow(int row) {
        if (row == -1) {
            this.pager.setSelectedRows(new int[]{this.pager.getEntriesCount() - 1});
        } else {
            this.pager.setSelectedRows(new int[]{row});
        }
    }

    public void addSelectedRow(int row) {
        this.pager.addSelectedRow(row);
    }

    public void increaseSelectedRows() {
        this.pager.increaseSelectedRows();
    }

    public void decreaseSelectedRows() {
        this.pager.decreaseSelectedRows();
    }

    public void nextPage() {
        this.pager.increaseSelectedPage();
    }

    public void prevPage() {
        this.pager.decreaseSelectedPage();
    }

    public void setSelectedPage(int pageNumber) {
        this.pager.setSelectedPage(pageNumber);
    }

    public TableModel getTableModel() {
        return this.modelLoader.getTableModel();
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public JTable getJTable() {
        return this.panel.getJTable();
    }

    public void showMoveRowsControls(boolean show) {
        this.getMoveRowsPanel().setVisible(false);
    }

    public void showControllerTable(boolean show) {
        this.getTableEntryController().setVisible(false);
    }

    public void addListener(PagedTableListener listener) {
        this.pager.addListener(listener);
    }

    public void setConfirmationMessageDeleteAllEntries(String message) {
        this.pager.setConfirmationMessageDeleteAllEntries(message);
    }

    public void setConfirmationMessageDeleteOneEntry(String message) {
        this.pager.setConfirmationMessageDeleteOneEntry(message);
    }
}

