/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.pagedtable;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.gui.util.StatusComponent;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.impl.pagedtable.Pager;
import org.gvsig.raster.swing.impl.pagedtable.TableControllerListener;
import org.gvsig.raster.swing.pagedtable.PagedTableEvent;

public class TableEntryControllerPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = -6442685244347917638L;
    private int HEIGHT_BUTTONS = 19;
    private JButton bPrev = null;
    private JComboBox cPoint = null;
    private JButton bNext = null;
    private JButton bFirst = null;
    private JButton bLast = null;
    private JLabel lPoints = null;
    private JLabel lNumberOfPoints = null;
    private JButton bNew = null;
    private JButton bDelPoint = null;
    private JButton bClear = null;
    private String pathToImagesForTest = "/src/main/resources/images/";
    private StatusComponent statusComponent = null;

    public TableEntryControllerPanel(TableControllerListener tableListener) {
        tableListener.setControlPanel(this);
        this.initialize(tableListener);
    }

    private void initialize(TableControllerListener tableListener) {
        this.statusComponent = new StatusComponent((JComponent)this);
        this.setLayout(new FlowLayout(1, 1, 0));
        this.setAlignmentX(0.0f);
        this.lPoints = new JLabel();
        this.lPoints.setText(Messages.getText((String)"registro") + " ");
        this.add(this.lPoints);
        this.add(this.getBFirst());
        this.add(this.getBPrev());
        this.add(this.getCPoint());
        this.add(this.getBNext());
        this.add(this.getBLast());
        this.add(this.getBNew());
        this.add(this.getLNumberOfPoints());
        this.add(this.getBDelPoint());
        this.add(this.getBClear());
        this.getBFirst().addActionListener(tableListener);
        this.getBPrev().addActionListener(tableListener);
        this.getCPoint().addActionListener(tableListener);
        this.getBNext().addActionListener(tableListener);
        this.getBLast().addActionListener(tableListener);
        this.getBNew().addActionListener(tableListener);
        this.getBDelPoint().addActionListener(tableListener);
        this.getBClear().addActionListener(tableListener);
    }

    public void disableAllControls() {
        this.statusComponent.setEnabled(false);
    }

    public void restoreControlsValue() {
        this.statusComponent.setEnabled(true);
    }

    private ImageIcon loadIcon(String iconName) {
        ImageIcon icon = null;
        try {
            icon = IconThemeHelper.getImageIcon((String)iconName);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (icon == null) {
            icon = new ImageIcon(System.getProperty("user.dir") + this.pathToImagesForTest + iconName + ".png", "");
        }
        if (icon == null) {
            icon = new ImageIcon(System.getProperty("user.dir") + this.pathToImagesForTest + iconName + ".gif", "");
        }
        return icon;
    }

    public JButton getBFirst() {
        if (this.bFirst == null) {
            this.bFirst = new JButton();
            this.bFirst.setPreferredSize(new Dimension(22, this.HEIGHT_BUTTONS));
            this.bFirst.setEnabled(false);
            this.bFirst.setIcon(this.loadIcon("first"));
            this.bFirst.setToolTipText(Messages.getText((String)"primero"));
        }
        return this.bFirst;
    }

    public JButton getBLast() {
        if (this.bLast == null) {
            this.bLast = new JButton();
            this.bLast.setPreferredSize(new Dimension(22, this.HEIGHT_BUTTONS));
            this.bLast.setEnabled(false);
            this.bLast.setIcon(this.loadIcon("last"));
            this.bLast.setToolTipText(Messages.getText((String)"ultimo"));
        }
        return this.bLast;
    }

    public JButton getBPrev() {
        if (this.bPrev == null) {
            this.bPrev = new JButton();
            this.bPrev.setText("");
            this.bPrev.setEnabled(false);
            this.bPrev.setPreferredSize(new Dimension(22, this.HEIGHT_BUTTONS));
            this.bPrev.setIcon(this.loadIcon("prev"));
            this.bPrev.setActionCommand("");
            this.bPrev.setToolTipText(Messages.getText((String)"anterior"));
        }
        return this.bPrev;
    }

    public JButton getBNext() {
        if (this.bNext == null) {
            this.bNext = new JButton("");
            this.bNext.setEnabled(false);
            this.bNext.setPreferredSize(new Dimension(22, this.HEIGHT_BUTTONS));
            this.bNext.setIcon(this.loadIcon("next"));
            this.bNext.setActionCommand("");
            this.bNext.setToolTipText(Messages.getText((String)"siguiente"));
        }
        return this.bNext;
    }

    public JComboBox getCPoint() {
        if (this.cPoint == null) {
            this.cPoint = new JComboBox();
            this.cPoint.setPreferredSize(new Dimension(64, this.HEIGHT_BUTTONS));
        }
        return this.cPoint;
    }

    public JLabel getLNumberOfPoints() {
        if (this.lNumberOfPoints == null) {
            this.lNumberOfPoints = new JLabel();
            this.lNumberOfPoints.setText(Messages.getText((String)"de") + " 0");
        }
        return this.lNumberOfPoints;
    }

    public JButton getBNew() {
        if (this.bNew == null) {
            this.bNew = new JButton();
            this.bNew.setPreferredSize(new Dimension(22, this.HEIGHT_BUTTONS));
            this.bNew.setIcon(this.loadIcon("newpoint"));
            this.bNew.setToolTipText(Messages.getText((String)"nuevo"));
        }
        return this.bNew;
    }

    public JButton getBDelPoint() {
        if (this.bDelPoint == null) {
            this.bDelPoint = new JButton();
            this.bDelPoint.setText("");
            this.bDelPoint.setEnabled(false);
            this.bDelPoint.setPreferredSize(new Dimension(22, this.HEIGHT_BUTTONS));
            this.bDelPoint.setIcon(this.loadIcon("delone"));
            this.bDelPoint.setToolTipText(Messages.getText((String)"borrar_uno"));
        }
        return this.bDelPoint;
    }

    public JButton getBClear() {
        if (this.bClear == null) {
            this.bClear = new JButton();
            this.bClear.setText("");
            this.bClear.setPreferredSize(new Dimension(22, this.HEIGHT_BUTTONS));
            this.bClear.setEnabled(false);
            this.bClear.setIcon(this.loadIcon("delall"));
            this.bClear.setActionCommand("");
            this.bClear.setToolTipText(Messages.getText((String)"borrar_todos"));
        }
        return this.bClear;
    }

    public void resetControls() {
        this.getCPoint().removeAllItems();
        this.getLNumberOfPoints().setText(Messages.getText((String)"de 0"));
        this.checkArrows();
    }

    public void setNItems(int n) {
        this.getCPoint().removeAllItems();
        for (int i = 1; i <= n; ++i) {
            try {
                this.getCPoint().addItem(String.valueOf(i));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.getLNumberOfPoints().setText(Messages.getText((String)"de") + " " + n);
        this.checkArrows();
    }

    public void setSelectedIndex(int index) {
        try {
            this.getCPoint().setSelectedIndex(index);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.checkArrows();
    }

    public int getSelectedIndex() {
        return this.getCPoint().getSelectedIndex();
    }

    public int getItemCount() {
        return this.getCPoint().getItemCount();
    }

    public String getSelectedItem() {
        return this.getCPoint().getSelectedItem().toString();
    }

    public void checkArrows() {
        if (!this.statusComponent.isEnabled()) {
            return;
        }
        if (this.getCPoint().getItemCount() <= 0) {
            this.getBClear().setEnabled(false);
            this.getBDelPoint().setEnabled(false);
        } else {
            this.getBClear().setEnabled(true);
            this.getBDelPoint().setEnabled(true);
        }
        if (this.getCPoint().getSelectedIndex() == -1) {
            this.getBPrev().setEnabled(false);
            this.getBNext().setEnabled(false);
            this.getBLast().setEnabled(false);
            this.getBFirst().setEnabled(false);
            return;
        }
        if (this.getCPoint().getSelectedIndex() == 0) {
            this.getBPrev().setEnabled(false);
            this.getBFirst().setEnabled(false);
        } else {
            this.getBPrev().setEnabled(true);
            this.getBFirst().setEnabled(true);
        }
        if (this.getCPoint().getSelectedIndex() == this.getCPoint().getItemCount() - 1) {
            this.getBNext().setEnabled(false);
            this.getBLast().setEnabled(false);
        } else {
            this.getBNext().setEnabled(true);
            this.getBLast().setEnabled(true);
        }
    }

    public void addPointToTable(int countPoints) {
        this.getCPoint().addItem("" + countPoints);
        this.getLNumberOfPoints().setText(Messages.getText((String)"de") + " " + countPoints);
        this.setSelectedIndex(this.getItemCount() - 1);
        this.checkArrows();
    }

    public void setPathToImages(String pathToImages) {
        this.pathToImagesForTest = pathToImages;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getBDelPoint().setEnabled(enabled);
        this.getBClear().setEnabled(enabled);
    }

    public boolean isDisableAllControls() {
        return !this.statusComponent.isEnabled();
    }

    @Override
    public void update(Observable o, Object arg) {
        Pager pager = (Pager)o;
        if (o instanceof Pager && arg instanceof Integer) {
            int[] selectedRows;
            int option = (Integer)arg;
            if (option == PagedTableEvent.EVENT_SELECTED_ROWS && (selectedRows = pager.getSelectedRows()) != null && selectedRows.length > 0) {
                this.setSelectedIndex(selectedRows[0]);
            }
            if (option == PagedTableEvent.EVENT_ADD_ENTRY) {
                this.addPointToTable(pager.getEntriesCount());
            }
            if (option == PagedTableEvent.EVENT_REMOVE_ENTRY) {
                this.setNItems(pager.getEntriesCount());
                selectedRows = pager.getSelectedRows();
                if (selectedRows != null && selectedRows.length >= 1) {
                    this.setSelectedIndex(selectedRows[0] % pager.getEntriesPerPage());
                }
            }
            if (option == PagedTableEvent.EVENT_REMOVE_ALL) {
                this.setNItems(0);
            }
        }
    }
}

