/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.preview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.gvsig.gui.beans.defaultbuttonspanel.DefaultButtonsPanel;
import org.gvsig.gui.beans.imagenavigator.IClientImageNavigator;
import org.gvsig.gui.beans.imagenavigator.ImageNavigator;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.impl.preview.PreviewRequestManager;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.raster.swing.preview.PreviewBasePanelTab;
import org.gvsig.raster.swing.preview.PreviewPanel;
import org.gvsig.raster.swing.preview.PreviewRenderProcess;

public class PreviewBasePanel
extends DefaultButtonsPanel
implements PreviewPanel {
    private static final long serialVersionUID = 6028780107787443656L;
    private ImageNavigator imageNavigator = null;
    private DataSourcePreview fLayer = null;
    private ArrayList<PreviewBasePanelTab> userPanel = new ArrayList();
    private JPanel generalPanel = null;
    private JPanel downPreviewPanel = null;
    private PreviewRenderProcess renderProcess = null;
    private JTabbedPane tabbedPane = null;
    private JPanel mainPanel = null;
    private JSplitPane jPanelRight = null;
    private JPanel jPanelPreview = null;
    private PreviewRequestManager previewRequestManager = null;

    public PreviewBasePanel(ArrayList<PreviewBasePanelTab> userPanel, JPanel generalPanel, JPanel downPreviewPanel, PreviewRenderProcess renderProcess, DataSourcePreview lyr) {
        this(3, userPanel, generalPanel, downPreviewPanel, renderProcess, lyr);
    }

    public PreviewBasePanel(int buttons, ArrayList<PreviewBasePanelTab> userPanel, JPanel generalPanel, JPanel downPreviewPanel, PreviewRenderProcess renderProcess, DataSourcePreview lyr) {
        super(buttons);
        this.userPanel = userPanel;
        this.generalPanel = generalPanel;
        this.downPreviewPanel = downPreviewPanel;
        this.renderProcess = renderProcess;
        this.setLayer(lyr);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(8, 8));
        JPanel panelLeft = new JPanel();
        panelLeft.setPreferredSize(new Dimension(390, 0));
        panelLeft.setLayout(new BorderLayout(8, 8));
        if (this.userPanel != null) {
            if (this.userPanel.size() == 1) {
                panelLeft.add((Component)this.getPanelWithoutTabs(), "Center");
            } else if (this.userPanel.size() > 1) {
                panelLeft.add((Component)this.getTabbedPane(), "Center");
            }
        }
        if (this.generalPanel != null) {
            panelLeft.add((Component)this.getGeneralPanel(), "South");
        }
        JSplitPane jSplitPane1 = new JSplitPane();
        jSplitPane1.setLeftComponent(panelLeft);
        jSplitPane1.setRightComponent(this.getPanelRight());
        jSplitPane1.setResizeWeight(1.0);
        jSplitPane1.setContinuousLayout(true);
        jSplitPane1.setUI(new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void setBorder(Border b) {
                    }
                };
            }
        });
        jSplitPane1.setBorder(null);
        this.add(jSplitPane1, "Center");
    }

    public void closePreviewLayer() {
        this.previewRequestManager.closePreviewLayer();
    }

    public void setUniquePanel(PreviewBasePanelTab panel) {
        this.userPanel.clear();
        this.userPanel.add(panel);
        this.mainPanel = (JPanel)panel;
        ((JSplitPane)this.getContent().getComponent(0)).setLeftComponent(this.mainPanel);
        this.getContent().updateUI();
    }

    public JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            for (int i = 0; i < this.userPanel.size(); ++i) {
                this.tabbedPane.addTab(this.userPanel.get(i).getTitle(), this.userPanel.get(i).getPanel());
            }
        }
        return this.tabbedPane;
    }

    public JPanel getPanelWithoutTabs() {
        if (this.mainPanel == null) {
            this.mainPanel = this.userPanel.get(0) instanceof JPanel ? this.userPanel.get(0).getPanel() : new JPanel();
        }
        return this.mainPanel;
    }

    public JPanel getGeneralPanel() {
        return this.generalPanel;
    }

    public JPanel getDownPreviewPanel() {
        return this.downPreviewPanel;
    }

    public ArrayList<PreviewBasePanelTab> getUserPanels() {
        return this.userPanel;
    }

    public IClientImageNavigator getPreviewManager() {
        return this.previewRequestManager;
    }

    public ImageNavigator getImageNavigator() {
        if (this.imageNavigator == null) {
            this.imageNavigator = new ImageNavigator(this.getPreviewManager());
            this.imageNavigator.setFocusable(true);
            this.imageNavigator.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        }
        return this.imageNavigator;
    }

    public JPanel getPanelPreview() {
        if (this.jPanelPreview == null) {
            this.jPanelPreview = new JPanel();
            JPanel jsubpanel2 = new JPanel();
            this.jPanelPreview.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"vista_previa"), 0, 0, null, null));
            this.jPanelPreview.setLayout(new BorderLayout());
            jsubpanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            jsubpanel2.setLayout(new BorderLayout());
            jsubpanel2.add((Component)this.getImageNavigator(), "Center");
            this.jPanelPreview.add((Component)jsubpanel2, "Center");
            this.jPanelPreview.setPreferredSize(new Dimension(237, 237));
            this.jPanelPreview.setMinimumSize(new Dimension(237, 237));
            this.jPanelPreview.setMaximumSize(new Dimension(237, 237));
        }
        return this.jPanelPreview;
    }

    private JSplitPane getPanelRight() {
        if (this.jPanelRight == null) {
            this.jPanelRight = new JSplitPane();
            this.jPanelRight.setOrientation(0);
            this.jPanelRight.setContinuousLayout(true);
            this.jPanelRight.setResizeWeight(0.0);
            this.jPanelRight.setPreferredSize(new Dimension(220, 0));
            this.jPanelRight.setMinimumSize(new Dimension(220, 0));
            if (this.getPanelPreview() != null) {
                this.jPanelRight.setTopComponent(this.getPanelPreview());
            } else {
                this.jPanelRight.setTopComponent(new JPanel());
            }
            if (this.getDownPreviewPanel() != null) {
                this.jPanelRight.setBottomComponent(this.getDownPreviewPanel());
            } else {
                this.jPanelRight.setBottomComponent(new JPanel());
            }
            this.jPanelRight.setUI(new BasicSplitPaneUI(){

                @Override
                public BasicSplitPaneDivider createDefaultDivider() {
                    return new BasicSplitPaneDivider(this){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void setBorder(Border b) {
                        }
                    };
                }
            });
            this.jPanelRight.setBorder(null);
        }
        return this.jPanelRight;
    }

    public void setLayer(DataSourcePreview fLayer) {
        this.fLayer = fLayer;
        this.previewRequestManager = new PreviewRequestManager(this.renderProcess, fLayer);
        this.previewInitializeSizes();
    }

    public void previewInitializeSizes() {
        if (this.fLayer == null) {
            return;
        }
        Rectangle2D extent2 = this.fLayer.getBBoxRectangle();
        this.getImageNavigator().setViewDimensions(extent2.getMinX(), extent2.getMaxY(), extent2.getMaxX(), extent2.getMinY());
        this.getImageNavigator().setZoom(1.0 / this.fLayer.getCellSize());
        this.getImageNavigator().setAutoAdjusted();
    }

    public DataSourcePreview getLayer() {
        return this.fLayer;
    }

    public void setPreviewSize(Dimension dimension) {
        this.getPanelPreview().setPreferredSize(dimension);
        this.getPanelPreview().setMinimumSize(dimension);
        this.getPanelPreview().setMaximumSize(dimension);
    }

    public void refreshPreview() {
        if (this.fLayer == null) {
            return;
        }
        this.getImageNavigator().updateBuffer();
    }

    public DataSourcePreview getDataSourcePreview() {
        return this.fLayer;
    }
}

