/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.sumaryprocess;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.basepanel.AbstractButtonsPanel;
import org.gvsig.utils.swing.JComboBox;

public class SummaryProcessPanel
extends AbstractButtonsPanel
implements ActionListener {
    private static final long serialVersionUID = -2280318605043767336L;
    private JPanel contentPane = null;
    private JComboBox comboBox = null;
    private String labelFilename = "File:";
    private String labelPath = "Path:";
    private String labelTime = "Time:";
    private String labelSize = "Size:";
    private String labelCompression = "Compression:";

    protected SummaryProcessPanel() {
        super(1);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.initialize();
        this.setTranslation();
    }

    private void setTranslation() {
        this.setLabelFilename(Messages.getText((String)"file") + ":");
        this.setLabelPath(Messages.getText((String)"path") + ":");
        this.setLabelSize(Messages.getText((String)"size") + ":");
        this.setLabelTime(Messages.getText((String)"time") + ":");
        this.setLabelCompression(Messages.getText((String)"compress") + ":");
    }

    protected void addFile(String fileName, long time) {
        File f = new File(fileName);
        String size = RasterLocator.getManager().getFileUtils().formatFileSize(f.length());
        String compression = fileName.endsWith("ecw") || fileName.endsWith("jp2") || fileName.endsWith("jpg") || fileName.endsWith("jpeg") ? "Yes" : "No";
        JPanel pContent = new JPanel();
        pContent.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        pContent.add((Component)this.newPanelFile(fileName), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        pContent.add((Component)this.newPanelTimeSize(RasterLocator.getManager().getRasterUtils().formatTime(time), size), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        pContent.add((Component)this.newPanelCompression(compression), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel emptyPanel = new JPanel();
        emptyPanel.setPreferredSize(new Dimension(0, 0));
        pContent.add((Component)emptyPanel, gridBagConstraints);
        pContent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 1), "Estadisticas", 0, 0, null, null));
        File file = new File(fileName);
        this.contentPane.add((Component)pContent, file.getName());
        if (this.comboBox.getItemCount() == 0) {
            this.comboBox.setVisible(false);
        } else {
            this.comboBox.setVisible(true);
        }
        this.comboBox.addItem((Object)file.getName());
    }

    private void initialize() {
        this.setLayout(new BorderLayout(5, 5));
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new CardLayout());
        this.comboBox = new JComboBox();
        this.comboBox.setVisible(false);
        this.comboBox.addActionListener((ActionListener)this);
        this.add(this.contentPane, "Center");
        this.add((Component)this.comboBox, "South");
    }

    private JPanel newPanelFile(String file) {
        JPanel pFile = new JPanel();
        JLabel lFileNameTag = new JLabel(this.labelFilename);
        JLabel lPathTag = new JLabel(this.labelPath);
        File fileorig = new File(file);
        JTextField tFile = new JTextField(fileorig.getName());
        tFile.setBackground(pFile.getBackground());
        tFile.setEditable(false);
        tFile.setHorizontalAlignment(2);
        tFile.setBorder(null);
        JTextField pathFile = new JTextField(fileorig.getParent() + File.separator);
        pathFile.setBackground(pFile.getBackground());
        pathFile.setEditable(false);
        pathFile.setHorizontalAlignment(2);
        pathFile.setBorder(null);
        pFile.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        pFile.add((Component)lFileNameTag, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        pFile.add((Component)tFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        pFile.add((Component)lPathTag, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        pFile.add((Component)pathFile, gridBagConstraints);
        return pFile;
    }

    private JPanel newPanelTimeSize(String time, String size) {
        JPanel pTime = new JPanel();
        pTime.setLayout(new GridBagLayout());
        JLabel lTimeTag = new JLabel(this.labelTime);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        pTime.add((Component)lTimeTag, gridBagConstraints);
        JLabel lTime = new JLabel(time);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 11);
        pTime.add((Component)lTime, gridBagConstraints);
        JLabel lSizeTag = new JLabel(this.labelSize);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 11);
        pTime.add((Component)lSizeTag, gridBagConstraints);
        JLabel lSize = new JLabel(size);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        pTime.add((Component)lSize, gridBagConstraints);
        return pTime;
    }

    private JPanel newPanelCompression(String compression) {
        JPanel pCompression = new JPanel();
        JLabel lCompressTag = new JLabel(this.labelCompression);
        JLabel lCompress = new JLabel(compression);
        pCompression.setLayout(new FlowLayout(0));
        pCompression.add(lCompressTag);
        pCompression.add(lCompress);
        return pCompression;
    }

    private void setLabelFilename(String labelFilename) {
        this.labelFilename = labelFilename;
    }

    private void setLabelPath(String labelPath) {
        this.labelPath = labelPath;
    }

    private void setLabelTime(String labelTime) {
        this.labelTime = labelTime;
    }

    private void setLabelSize(String labelSize) {
        this.labelSize = labelSize;
    }

    private void setLabelCompression(String labelCompression) {
        this.labelCompression = labelCompression;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.comboBox) {
            ((CardLayout)this.contentPane.getLayout()).show(this.contentPane, (String)this.comboBox.getSelectedItem());
        }
    }
}

