/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.tool.infobypoint;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.gvsig.raster.swing.impl.tool.infobypoint.DefaultInfoByPointDataModel;
import org.gvsig.raster.swing.infobypoint.InfoByPointDataModel;

public class InfoByPointPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private HashMap<String, String> tr = null;
    private JList jListBandValues = null;
    private JLabel jLabelHSLPoint = null;
    private JLabel jLabelCMKYPoint = null;
    private JLabel jLabelRGBPoint = null;
    private JLabel jLabelPixelPoint = null;
    private JLabel jLabelViewPoint = null;
    private JLabel jLabelLatitudePoint = null;
    private JLabel jLabelLongitudPoint = null;
    private JLabel jLabelNumberOfBands = null;
    private JTextField jTextBoxLayerSelected = null;
    private JComboBox jComboListLayer = null;
    private JPanel jPanelLayerNames = null;
    private JPanel jPanelCoordinates = null;
    private JPanel jPanelColors = null;
    private JPanel jPanelBands = null;
    private DefaultInfoByPointDataModel dataModel = null;

    public InfoByPointPanel(HashMap<String, String> translations, InfoByPointDataModel dataModel) {
        this.tr = translations;
        if (this.tr == null || this.tr.get("layer_list") == null) {
            this.tr = new HashMap();
            this.tr.put("layer_list", "layer_list");
            this.tr.put("band_values", "band_values");
            this.tr.put("pixel_point", "pixel_point");
            this.tr.put("view_point", "view_point");
            this.tr.put("world_point", "world_point");
            this.tr.put("bands", "bands");
            this.tr.put("colors", "colors");
            this.tr.put("coords", "coords");
            this.tr.put("lat", "lat");
            this.tr.put("long", "long");
        }
        this.dataModel = (DefaultInfoByPointDataModel)dataModel;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 2, 1, 2);
        this.add((Component)this.getJPanelLayerNames(), gbc);
        gbc.gridy = 1;
        this.add((Component)this.getJPanelCoordinates(), gbc);
        gbc.gridy = 2;
        this.add((Component)this.getJPanelBands(), gbc);
        gbc.gridy = 3;
        this.add((Component)this.getJPanelColors(), gbc);
    }

    public JPanel getJPanelLayerNames() {
        if (this.jPanelLayerNames == null) {
            this.jPanelLayerNames = new JPanel();
            this.jPanelLayerNames.setBorder(BorderFactory.createTitledBorder(this.tr.get("layer_list")));
            this.jPanelLayerNames.setLayout(new BorderLayout());
            this.jPanelLayerNames.add((Component)this.getJComboListLayer(), "Center");
        }
        return this.jPanelLayerNames;
    }

    public JPanel getJPanelBands() {
        if (this.jPanelBands == null) {
            this.jPanelBands = new JPanel();
            this.jPanelBands.setBorder(BorderFactory.createTitledBorder(this.tr.get("bands")));
            this.jPanelBands.setLayout(new BorderLayout());
            this.jPanelBands.add((Component)this.getJLabelNumberOfBands(), "North");
            JScrollPane listScroller = new JScrollPane(this.getJListValues());
            this.jPanelBands.add((Component)listScroller, "Center");
        }
        return this.jPanelBands;
    }

    public JPanel getJPanelColors() {
        if (this.jPanelColors == null) {
            this.jPanelColors = new JPanel();
            this.jPanelColors.setBorder(BorderFactory.createTitledBorder(this.tr.get("colors")));
            this.jPanelColors.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(1, 2, 2, 2);
            this.jPanelColors.add((Component)this.getJLabelRGBPoint(), gbc);
            gbc.gridy = 1;
            this.jPanelColors.add((Component)this.getJLabelCMKYPoint(), gbc);
            gbc.gridy = 2;
            this.jPanelColors.add((Component)this.getJLabelHSLPoint(), gbc);
        }
        return this.jPanelColors;
    }

    public JPanel getJPanelCoordinates() {
        if (this.jPanelCoordinates == null) {
            this.jPanelCoordinates = new JPanel();
            this.jPanelCoordinates.setLayout(new GridBagLayout());
            this.jPanelCoordinates.setBorder(BorderFactory.createTitledBorder(this.tr.get("coords")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(1, 2, 2, 2);
            gbc.gridy = 1;
            this.jPanelCoordinates.add((Component)this.getJLabelLatitudePoint(), gbc);
            gbc.gridy = 2;
            this.jPanelCoordinates.add((Component)this.getJLabelLongitudPoint(), gbc);
            gbc.gridy = 3;
            this.jPanelCoordinates.add((Component)this.getJLabelViewPoint(), gbc);
            gbc.gridy = 4;
            this.jPanelCoordinates.add((Component)this.getJLabelPixelPoint(), gbc);
        }
        return this.jPanelCoordinates;
    }

    private JList getJListValues() {
        if (this.jListBandValues == null) {
            this.jListBandValues = new JList();
        }
        return this.jListBandValues;
    }

    private JLabel getJLabelHSLPoint() {
        if (this.jLabelHSLPoint == null) {
            this.jLabelHSLPoint = new JLabel("HSL: ");
        }
        return this.jLabelHSLPoint;
    }

    private JLabel getJLabelCMKYPoint() {
        if (this.jLabelCMKYPoint == null) {
            this.jLabelCMKYPoint = new JLabel("CMYK: ");
        }
        return this.jLabelCMKYPoint;
    }

    private JLabel getJLabelRGBPoint() {
        if (this.jLabelRGBPoint == null) {
            this.jLabelRGBPoint = new JLabel("RGB: ");
        }
        return this.jLabelRGBPoint;
    }

    private JLabel getJLabelPixelPoint() {
        if (this.jLabelPixelPoint == null) {
            this.jLabelPixelPoint = new JLabel();
        }
        return this.jLabelPixelPoint;
    }

    private JLabel getJLabelViewPoint() {
        if (this.jLabelViewPoint == null) {
            this.jLabelViewPoint = new JLabel();
        }
        return this.jLabelViewPoint;
    }

    private JLabel getJLabelLatitudePoint() {
        if (this.jLabelLatitudePoint == null) {
            this.jLabelLatitudePoint = new JLabel();
        }
        return this.jLabelLatitudePoint;
    }

    private JLabel getJLabelLongitudPoint() {
        if (this.jLabelLongitudPoint == null) {
            this.jLabelLongitudPoint = new JLabel();
        }
        return this.jLabelLongitudPoint;
    }

    private JLabel getJLabelNumberOfBands() {
        if (this.jLabelNumberOfBands == null) {
            this.jLabelNumberOfBands = new JLabel();
        }
        return this.jLabelNumberOfBands;
    }

    private JTextField getJTextBoxLayerSelected() {
        if (this.jTextBoxLayerSelected == null) {
            this.jTextBoxLayerSelected = new JTextField();
        }
        return this.jTextBoxLayerSelected;
    }

    private JComboBox getJComboListLayer() {
        if (this.jComboListLayer == null) {
            this.jComboListLayer = new JComboBox();
            this.jComboListLayer.addActionListener(this);
        }
        return this.jComboListLayer;
    }

    public void updateDataModel() {
        String sep = " ";
        Double nanObj = new Double(Double.NaN);
        DecimalFormat df2 = new DecimalFormat("#.##");
        DecimalFormat df4 = new DecimalFormat("#.####");
        this.getJLabelNumberOfBands().setText(this.tr.get("bands") + ": " + this.dataModel.bands);
        String y = !new Double(this.dataModel.worldPoint.getY()).equals(nanObj) ? df2.format(this.dataModel.worldPoint.getY()) : "NaN";
        this.getJLabelLatitudePoint().setText(this.tr.get("lat") + "/Y: " + y);
        String x = !new Double(this.dataModel.worldPoint.getY()).equals(nanObj) ? df2.format(this.dataModel.worldPoint.getX()) : "NaN";
        this.getJLabelLongitudPoint().setText(this.tr.get("long") + "/X: " + x);
        y = !new Double(this.dataModel.viewPoint.getY()).equals(nanObj) ? df2.format(this.dataModel.viewPoint.getY()) : "NaN";
        x = !new Double(this.dataModel.viewPoint.getY()).equals(nanObj) ? df2.format(this.dataModel.viewPoint.getX()) : "NaN";
        this.getJLabelViewPoint().setText(this.tr.get("view_point") + ": (" + x + sep + y + ")");
        y = !new Double(this.dataModel.pixelPoint.getY()).equals(nanObj) ? df2.format(this.dataModel.pixelPoint.getY()) : "NaN";
        x = !new Double(this.dataModel.pixelPoint.getY()).equals(nanObj) ? df2.format(this.dataModel.pixelPoint.getX()) : "NaN";
        this.getJLabelPixelPoint().setText(this.tr.get("pixel_point") + ": (" + x + sep + y + ")");
        this.getJLabelRGBPoint().setText("RGB: " + this.dataModel.rgb[0] + sep + this.dataModel.rgb[1] + sep + this.dataModel.rgb[2]);
        this.getJLabelHSLPoint().setText("HSL: " + df4.format(this.dataModel.hsl[0]) + sep + df4.format(this.dataModel.hsl[1]) + sep + df4.format(this.dataModel.hsl[2]));
        this.getJLabelCMKYPoint().setText("CMYK: " + df4.format(this.dataModel.cmyk[0]) + sep + df4.format(this.dataModel.cmyk[1]) + sep + df4.format(this.dataModel.cmyk[2]) + sep + df4.format(this.dataModel.cmyk[3]));
        this.getJComboListLayer().removeAllItems();
        for (int i = 0; i < this.dataModel.layers.size(); ++i) {
            this.getJComboListLayer().addItem(this.dataModel.getFormatedLayerName(i));
        }
        DefaultListModel listModel = null;
        listModel = this.getJListValues().getModel() == null || !(this.getJListValues().getModel() instanceof DefaultListModel) ? new DefaultListModel() : (DefaultListModel)this.getJListValues().getModel();
        listModel.clear();
        for (int i = 0; i < this.dataModel.bandsValues.size(); ++i) {
            listModel.addElement("B" + i + ": " + this.dataModel.bandsValues.get(i));
        }
        if (this.getJListValues().getModel() == null || !(this.getJListValues().getModel() instanceof DefaultListModel)) {
            this.getJListValues().setModel(listModel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

