/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jvmpreferences.nativeprefs.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.jvmpreferences.nativeprefs.MemoryPreferences;
import org.gvsig.jvmpreferences.nativeprefs.NativePrefsLocator;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class MemoryPreferencesPage
extends AbstractPreferencePage {
    private ImageIcon icon = ToolsSwingLocator.getIconThemeManager().getCurrent().get("memory-preferences");
    private MemoryPreferences mempref = NativePrefsLocator.getManager().getMemoryPreferences();
    private JSlider slider;
    private int maxSafe;
    private JLabel lblHeader = null;
    private ButtonGroup btGroup = null;
    private JRadioButton rbSafeLimits = null;
    private JRadioButton rbCustomValue = null;
    private JNumberSpinner nfCustomValueFld = null;
    private JEditorPane lblWarning = null;
    private boolean enabled;
    private int initialValue;
    private JPanel pnlWarningContainer = null;
    private JPanel pnlSlider = null;
    private JLabel lblSliderValue = null;
    private static final int MIN_VALUE = 256;

    public MemoryPreferencesPage() {
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        Insets mainInsets = new Insets(4, 4, 4, 4);
        int gridy = 0;
        if (this.mempref.isConfigWritable()) {
            this.enabled = true;
            this.maxSafe = this.mempref.getSafeMemoryMaximum();
            Insets indentedInsets = new Insets(4, 22, 4, 4);
            c.gridx = 0;
            c.anchor = 21;
            c.gridwidth = 2;
            c.gridy = gridy++;
            c.insets = mainInsets;
            this.add(this.getRbSafeLimits(), c);
            c.fill = 2;
            c.gridy = gridy++;
            c.insets = indentedInsets;
            this.add(this.getPnlSlider(), c);
            c.gridx = 0;
            c.gridwidth = 2;
            c.gridy = gridy++;
            c.insets = mainInsets;
            c.fill = 0;
            this.add(this.getRbCustomValue(), c);
            c.gridwidth = 1;
            c.gridy = gridy++;
            c.fill = 0;
            c.insets = indentedInsets;
            this.add((Component)this.getNfCustomValueFld(), c);
            c.insets = mainInsets;
            c.gridx = 1;
            this.add(this.getLblMegabytes(), c);
            c.gridx = 0;
            c.gridwidth = 2;
            c.fill = 2;
            c.insets = new Insets(10, 10, 10, 10);
            c.gridy = gridy;
            this.add(this.getPnlWarningContainer(), c);
            this.enableSafeValue();
        } else {
            this.enabled = false;
            c.gridx = 0;
            c.gridy = gridy;
            c.anchor = 21;
            c.insets = mainInsets;
            this.add(this.getLblWarning(this.getPermissionsWarningText()), c);
        }
    }

    public String getID() {
        return MemoryPreferencesPage.class.getName();
    }

    public String getTitle() {
        return Messages.getText((String)"Memory");
    }

    public JPanel getPanel() {
        return this;
    }

    private JLabel getHeaderLabel() {
        if (this.lblHeader == null) {
            this.lblHeader = new JLabel(Messages.getText((String)"Maximum_memory_configuration_Requires_restart"));
        }
        return this.lblHeader;
    }

    public void initializeValues() {
        if (this.enabled) {
            int currentValue;
            this.initialValue = currentValue = this.mempref.readConfiguredMaximum();
            this.setValue(currentValue);
        }
    }

    public void setValue(int maxMemory) {
        if (this.enabled) {
            if (maxMemory > this.maxSafe) {
                this.enableCustomValue();
                this.getNfCustomValueFld().setInteger(maxMemory);
            } else {
                this.enableSafeValue();
                this.getSafeSlider().setValue(maxMemory);
            }
        }
    }

    public int getValue() {
        if (this.enabled) {
            if (this.getRbCustomValue().isSelected()) {
                return this.getNfCustomValueFld().getInteger();
            }
            return this.getSafeSlider().getValue();
        }
        return -1;
    }

    private void enableCustomValue() {
        this.getRbCustomValue().setSelected(true);
        this.getSafeSlider().setEnabled(false);
        this.getNfCustomValueFld().setEnabled(true);
    }

    private void enableSafeValue() {
        this.getRbSafeLimits().setSelected(true);
        this.getNfCustomValueFld().setEnabled(false);
        this.getSafeSlider().setEnabled(true);
    }

    public void initializeDefaults() {
        if (this.enabled) {
            int maxMem = this.mempref.getFactoryDefaultMaximum();
            this.setValue(maxMem);
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        return this.initialValue != this.getValue();
    }

    public void storeValues() throws StoreException {
        if (this.enabled) {
            this.mempref.saveConguredMaximum(this.getValue());
        }
    }

    public void setChangesApplied() {
    }

    private JRadioButton getRbSafeLimits() {
        if (this.rbSafeLimits == null) {
            this.rbSafeLimits = new JRadioButton(Messages.getText((String)"Safe_limits"));
            this.getButtonGroup().add(this.rbSafeLimits);
            this.rbSafeLimits.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == MemoryPreferencesPage.this.rbSafeLimits) {
                        int currentValue = MemoryPreferencesPage.this.getNfCustomValueFld().getInteger();
                        if (currentValue > MemoryPreferencesPage.this.maxSafe) {
                            MemoryPreferencesPage.this.getSafeSlider().setValue(MemoryPreferencesPage.this.maxSafe);
                        } else {
                            MemoryPreferencesPage.this.getSafeSlider().setValue(currentValue);
                        }
                        MemoryPreferencesPage.this.enableSafeValue();
                    }
                }
            });
        }
        return this.rbSafeLimits;
    }

    private JRadioButton getRbCustomValue() {
        if (this.rbCustomValue == null) {
            this.rbCustomValue = new JRadioButton(Messages.getText((String)"Custom_value"));
            this.getButtonGroup().add(this.rbCustomValue);
            this.rbCustomValue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == MemoryPreferencesPage.this.rbCustomValue) {
                        MemoryPreferencesPage.this.getNfCustomValueFld().setInteger(MemoryPreferencesPage.this.getSafeSlider().getValue());
                        MemoryPreferencesPage.this.enableCustomValue();
                    }
                }
            });
        }
        return this.rbCustomValue;
    }

    private ButtonGroup getButtonGroup() {
        if (this.btGroup == null) {
            this.btGroup = new ButtonGroup();
        }
        return this.btGroup;
    }

    private JSlider getSafeSlider() {
        if (this.slider == null) {
            this.slider = new JSlider(256, this.maxSafe);
            this.slider.setPaintLabels(true);
            Hashtable<Integer, JComponent> labels = this.slider.createStandardLabels(this.maxSafe - 256);
            labels.put(256, new JLabel(Messages.getText((String)"Min_value_MB", (String[])new String[]{Integer.toString(256)})));
            labels.put(this.maxSafe, new JLabel(Messages.getText((String)"Max_value_MB", (String[])new String[]{Integer.toString(this.maxSafe)})));
            this.slider.setLabelTable(labels);
            this.slider.setValue(this.maxSafe);
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider sl = (JSlider)e.getSource();
                    MemoryPreferencesPage.this.getLblSliderValue().setText(MemoryPreferencesPage.this.getSliderValue());
                }
            });
        }
        return this.slider;
    }

    private JNumberSpinner getNfCustomValueFld() {
        if (this.nfCustomValueFld == null) {
            this.nfCustomValueFld = new JNumberSpinner(256, 6, 256, 0x100000, 4);
        }
        return this.nfCustomValueFld;
    }

    private JLabel getLblMegabytes() {
        return new JLabel(Messages.getText((String)"MB"));
    }

    private String getSafeRangeWarningText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<p><b>").append(Messages.getText((String)"Warning_using_values_higher_than_safe_range_can_cause_gvSIG_doesnt_start")).append("</b></p>");
        buffer.append("<p><b>").append(Messages.getText((String)"In_this_case_you_will_need_to_edit_gvSIG_config_files_by_hand")).append("</b></p>");
        buffer.append("<p><b>").append(Messages.getText((String)"On_Windows_config_is_stored_in_file_gvsig-desktop.l4j.ini_On_Linux_edit_gvSIG.sh_directly")).append("</b></p>");
        return buffer.toString();
    }

    private String getPermissionsWarningText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<p><b>").append(Messages.getText((String)"You_need_to_execute_gvSIG_as_administrator_to_configure_memory")).append("</b></p>");
        buffer.append("<p><b>").append(Messages.getText((String)"On_Windows_right_click_gvSIG_icon_and_select_Run_as_administrator")).append("</b></p>");
        return buffer.toString();
    }

    private JPanel getPnlWarningContainer() {
        if (this.pnlWarningContainer == null) {
            this.pnlWarningContainer = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(0, 5, 0, 5);
            JEditorPane pane = this.getLblWarning(this.getSafeRangeWarningText());
            this.pnlWarningContainer.add((Component)pane, c);
            this.pnlWarningContainer.setBorder(BorderFactory.createLineBorder(Color.RED));
        }
        return this.pnlWarningContainer;
    }

    private String getSliderValue() {
        return Messages.getText((String)"Selected_value_MB", (String[])new String[]{Integer.toString(this.getSafeSlider().getValue())});
    }

    private JLabel getLblSliderValue() {
        if (this.lblSliderValue == null) {
            this.lblSliderValue = new JLabel(this.getSliderValue());
        }
        return this.lblSliderValue;
    }

    private JPanel getPnlSlider() {
        if (this.pnlSlider == null) {
            this.pnlSlider = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 19;
            c.fill = 2;
            this.pnlSlider.add((Component)this.getSafeSlider(), c);
            c.gridx = 1;
            c.fill = 0;
            this.pnlSlider.add((Component)this.getLblSliderValue(), c);
        }
        return this.pnlSlider;
    }

    private JEditorPane getLblWarning(String text) {
        if (this.lblWarning == null) {
            this.lblWarning = new JEditorPane();
            this.lblWarning.setBackground(this.getLblMegabytes().getBackground());
            this.lblWarning.setContentType("text/html");
            this.lblWarning.setText(text);
            Dimension size = new Dimension(400, 200);
            this.lblWarning.setPreferredSize(size);
        }
        return this.lblWarning;
    }
}

