/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic;

import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.plugins.IExtensionQueryByAction;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.prepareAction.PrepareDataStoreParameters;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.gui.ColorTablesFactory;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.fmap.FmapRasterLibrary;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.IConfiguration;
import org.gvsig.raster.mainplugin.config.Configuration;
import org.gvsig.raster.mainplugin.config.ConfigurationEvent;
import org.gvsig.raster.mainplugin.config.ConfigurationListener;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.raster.gui.preference.RasterPreferences;
import org.gvsig.raster.tools.app.basic.raster.gui.wizard.PrepareDataStoreParametersRaw;
import org.gvsig.raster.tools.app.basic.raster.gui.wizard.PrepareDataStoreParametersVTR;
import org.gvsig.raster.tools.app.basic.raster.gui.wizard.PrepareLayerAskWritableDirectory;
import org.gvsig.raster.tools.app.basic.raster.process.ClippingProcess;
import org.gvsig.raster.tools.app.basic.tool.analysisview.ViewRasterAnalysisTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.clip.ClippingTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.colortable.ColorTableTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.RasterColorTablesFactory;
import org.gvsig.raster.tools.app.basic.tool.enhanced.EnhancedTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.filter.FilterTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.geolocation.GeoLocationTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.histogram.HistogramTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.infobypoint.InfoByRasterPointTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.layerdatatype.LayerDatatypeTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.multiresolution.ZoomResolutionLevelTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.overview.OverviewsTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.EnhancedPanel;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.GeneralPanel;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.InfoPanel;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.TransparencyPanel;
import org.gvsig.raster.tools.app.basic.tool.rasterresolution.ZoomPixelCursorTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.roi.ROIManagerTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.saveas.SaveAsTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.saveviewtoraster.SaveViewToRasterTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.selectrasterlayer.SelectLayerTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.setviewprojection.SetViewProjectionTocMenuEntry;
import org.gvsig.raster.tools.app.basic.tool.viewexport.SaveViewToImageTocMenuEntry;
import org.gvsig.raster.tools.app.basic.toolbox.ToolboxRasterToolsLoader;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public class RasterExtension
extends Extension
implements ConfigurationListener,
IExtensionQueryByAction {
    public static final String CLIPPING_PROCESS_LABEL = "ClippingProcess";
    public static boolean autoRefreshView = true;
    private ExtensionPoint genericToolBarMenuExtensionPoint = null;

    public void execute(String actionCommand) {
        IWindow w;
        ExtensionBuilder ext = this.getGenericToolBarMenuExtensionPoint().get(actionCommand).getBuilder();
        if (ext != null && ext instanceof AbstractTocContextMenuAction && (w = PluginServices.getMDIManager().getActiveWindow()) instanceof AbstractViewPanel) {
            FLayers lyrs = ((AbstractViewPanel)w).getMapControl().getMapContext().getLayers();
            FLayer[] actives = lyrs.getActives();
            ((AbstractTocContextMenuAction)ext).execute(null, actives);
        }
    }

    public void initialize() {
        ExtensionPoint point;
        DefaultFLyrRaster.setConfiguration((IConfiguration)Configuration.getSingleton());
        Configuration.addValueChangedListener((ConfigurationListener)this);
        this.loadConfigurationValues();
        this.registerIcons();
        FmapRasterLibrary fmapRaster = new FmapRasterLibrary();
        fmapRaster.initialize();
        Preferences prefs = Preferences.userRoot().node("gvsig.foldering");
        prefs.put("DataFolder", System.getProperty("user.home"));
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        if (!extensionPoints.has("RasterSEPropertiesDialog")) {
            point = extensionPoints.add("RasterSEPropertiesDialog");
            point.setDescription("Raster Properties registrable panels (register instances of javax.swing.JPanel)");
        }
        point = extensionPoints.get("AplicationPreferences");
        point.append("RasterPreferences", "", RasterPreferences.class);
        point = extensionPoints.get("RasterSEPropertiesDialog");
        point.append("info", "", InfoPanel.class);
        point.append("general_panel", "", GeneralPanel.class);
        point.append("transparencia", "", TransparencyPanel.class);
        point.append("realce", "", EnhancedPanel.class);
        point = extensionPoints.get("View_TocActions");
        point.append("SaveAs", "Save as raster layer", (ExtensionBuilder)SaveAsTocMenuEntry.getSingleton());
        point.append("ZoomPixelCursor", "zoom to pixel resolution", (ExtensionBuilder)ZoomPixelCursorTocMenuEntry.getSingleton());
        point.append("ROI", "ROIs for a raster layer", (ExtensionBuilder)ROIManagerTocMenuEntry.getSingleton());
        point.append("Color table", "Color table for a raster layer", (ExtensionBuilder)ColorTableTocMenuEntry.getSingleton());
        point.append("Histogram", "Histogram of a raster layer", (ExtensionBuilder)HistogramTocMenuEntry.getSingleton());
        point.append("Overviews", "Build overviews", (ExtensionBuilder)OverviewsTocMenuEntry.getSingleton());
        ApplicationManager appGvSigMan = ApplicationLocator.getManager();
        appGvSigMan.registerPrepareOpenDataStoreParameters((PrepareDataStoreParameters)new PrepareLayerAskWritableDirectory());
        appGvSigMan.registerPrepareOpenDataStoreParameters((PrepareDataStoreParameters)new PrepareDataStoreParametersRaw());
        appGvSigMan.registerPrepareOpenDataStoreParameters((PrepareDataStoreParameters)new PrepareDataStoreParametersVTR());
        appGvSigMan.registerColorTablesFactory((ColorTablesFactory)new RasterColorTablesFactory());
        this.registerMenuElements();
        this.registerProcesses();
    }

    private void registerProcesses() {
        RasterBaseAlgorithmLibrary.register((String)CLIPPING_PROCESS_LABEL, ClippingProcess.class);
        ClippingProcess.registerParameters();
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"menu-layer-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"menu-process-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"menu-transgeo-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"menu-raster-export", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-modify-roi", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-histogram", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-color-table", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-modify-overviews", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-properties-raster", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-filter-raster", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-enhanced", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"view-raster-analysis", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"view-select-raster-layer", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-geolocalization", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"tools-raster-reproject", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"view-export-georeferenced-raster", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-saveas", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-clip-raster", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-zoom-res-level", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-info-by-pixel", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-vectorization", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"view-export-image", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"zoom-pixel-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"hor-arrow-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"ver-arrow-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"inclder-arrow-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"inclizq-arrow-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"shear-y-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"shear-x-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"rotate-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"rot-inf-der-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"rot-inf-izq-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"rot-sup-der-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"rot-sup-izq-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"point-select-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"hand-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"rectangle-select-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"not-valid-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"line-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"polygon-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"point-cursor", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"forward-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"backward-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"blank-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"addlayer-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"delall-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"back-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"next-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"undo-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"pixel-increase", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"pref-raster-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"back-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"next-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"undo-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"pixel-increase", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"pref-raster-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"reset-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"tfwload-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"centerraster-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"increase-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"decrease-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"selectzoomarea-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"prevzoom-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"fullview-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"exporttoascii-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"exporttocsv-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"importfromcsv-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"exit-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"options-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"add-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"centerpoint-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"selectrgb-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"focus-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"point-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"line-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"polygon-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"import-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"round-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"fullextent-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"selecttool-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"forward-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"backward-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"datatype-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"setviewprojection-raster-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"gvsig-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"gvsig-icon16x16", (Object)((Object)this));
    }

    public void registerMenuElements() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("GenericToolBarGroup");
        point.setDescription("Punto de extension para los grupos de menus del GenericToolBarPanel");
        point = extensionPoints.get("GenericToolBarMenu");
        point.setDescription("Punto de extension para los submenus del GenericToolBarPanel");
        point.append("SelectLayer", "", (ExtensionBuilder)SelectLayerTocMenuEntry.getSingleton());
        point.append("HistogramPanel", "", (ExtensionBuilder)HistogramTocMenuEntry.getSingleton());
        point.append("ViewColorTable", "", (ExtensionBuilder)ColorTableTocMenuEntry.getSingleton());
        if (RasterLocator.getManager().isOverviewBuilderSupported()) {
            point.append("Overviews", "", (ExtensionBuilder)OverviewsTocMenuEntry.getSingleton());
        }
        point.append("RoisManager", "", (ExtensionBuilder)ROIManagerTocMenuEntry.getSingleton());
        point.append("ViewRasterAnalysis", "", (ExtensionBuilder)ViewRasterAnalysisTocMenuEntry.getSingleton());
        point.append("ZoomResolutionLevel", "", (ExtensionBuilder)ZoomResolutionLevelTocMenuEntry.getSingleton());
        point.append("SaveAs", "", (ExtensionBuilder)SaveAsTocMenuEntry.getSingleton());
        point.append("ClippingPanel", "", (ExtensionBuilder)ClippingTocMenuEntry.getSingleton());
        point.append("SaveViewToRaster", "", (ExtensionBuilder)SaveViewToRasterTocMenuEntry.getSingleton());
        point.append("SaveViewToImageRaster", "", (ExtensionBuilder)SaveViewToImageTocMenuEntry.getSingleton());
        point.append("FilterPanel", "", (ExtensionBuilder)FilterTocMenuEntry.getSingleton());
        point.append("EnhancedPanel", "", (ExtensionBuilder)EnhancedTocMenuEntry.getSingleton());
        point.append("InfoByPoint", "", (ExtensionBuilder)InfoByRasterPointTocMenuEntry.getSingleton());
        point.append("LayerDatatype", "", (ExtensionBuilder)LayerDatatypeTocMenuEntry.getSingleton());
        point.append("GeoLocation", "", (ExtensionBuilder)GeoLocationTocMenuEntry.getSingleton());
        point.append("SetProjection", "", (ExtensionBuilder)SetViewProjectionTocMenuEntry.getSingleton());
    }

    public boolean isEnabled() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null) {
            return false;
        }
        if (f instanceof AbstractViewPanel) {
            FLayers lyrs = ((AbstractViewPanel)f).getMapControl().getMapContext().getLayers();
            for (int i = 0; i < lyrs.getLayersCount(); ++i) {
                if (!(lyrs.getLayer(i) instanceof FLyrRaster)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isVisible() {
        FLayers lyrs;
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null) {
            return false;
        }
        return f instanceof AbstractViewPanel && (lyrs = ((AbstractViewPanel)f).getMapControl().getMapContext().getLayers()).getLayersCount() > 0;
    }

    private void loadConfigurationValues() {
        autoRefreshView = Configuration.getValue((String)"general_auto_preview", (Boolean)Boolean.TRUE);
        RasterLibrary.defaultNumberOfClasses = Configuration.getValue((String)"general_defaultNumberOfClasses", (Integer)RasterLibrary.defaultNumberOfClasses);
        RasterLibrary.cacheSize = Configuration.getValue((String)"cache_size", (Long)RasterLibrary.cacheSize);
        RasterLibrary.pageSize = Configuration.getValue((String)"cache_pagesize", (Double)RasterLibrary.pageSize);
        RasterLibrary.pagsPerGroup = Configuration.getValue((String)"cache_pagspergroup", (Integer)RasterLibrary.pagsPerGroup);
        RasterLibrary.blockHeight = Configuration.getValue((String)"cache_blockheight", (Integer)RasterLibrary.blockHeight);
    }

    public void actionConfigurationChanged(ConfigurationEvent e) {
        if (e.getKey().equals("nodata_transparency_enabled")) {
            boolean noDataTransparent = (Boolean)e.getValue();
            IWindow[] f = PluginServices.getMDIManager().getAllWindows();
            if (f == null) {
                return;
            }
            for (int i = 0; i < f.length; ++i) {
                if (!(f[i] instanceof AbstractViewPanel)) continue;
                AbstractViewPanel vista = (AbstractViewPanel)f[i];
                ViewDocument model = vista.getModel();
                MapContext map = model.getMapContext();
                FLayers lyrs = map.getLayers();
                ArrayList<FLayer> list = RasterToolsUtil.getRasterLayerList(lyrs, null);
                for (int j = 0; j < list.size(); ++j) {
                    if (!(list.get(j) instanceof FLyrRaster)) continue;
                    ((FLyrRaster)list.get(j)).getDataStore().getNoDataValue().setNoDataTransparent(noDataTransparent);
                }
            }
            return;
        }
        if (e.getKey().equals("general_auto_preview")) {
            if (e.getValue() instanceof String) {
                autoRefreshView = new Boolean((String)e.getValue());
            }
            if (e.getValue() instanceof Boolean) {
                autoRefreshView = (Boolean)e.getValue();
            }
            return;
        }
        if (e.getKey().equals("general_defaultNumberOfClasses")) {
            if (e.getValue() instanceof String) {
                try {
                    RasterLibrary.defaultNumberOfClasses = new Integer((String)e.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (e.getValue() instanceof Integer) {
                RasterLibrary.defaultNumberOfClasses = (Integer)e.getValue();
            }
            return;
        }
        if (e.getKey().equals("cache_size")) {
            if (e.getValue() instanceof String) {
                try {
                    RasterLibrary.cacheSize = new Long((String)e.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (e.getValue() instanceof Long) {
                RasterLibrary.cacheSize = (Long)e.getValue();
            }
            return;
        }
        if (e.getKey().equals("cache_pagesize")) {
            if (e.getValue() instanceof String) {
                try {
                    RasterLibrary.pageSize = new Double((String)e.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (e.getValue() instanceof Double) {
                RasterLibrary.pageSize = (Double)e.getValue();
            }
            return;
        }
        if (e.getKey().equals("cache_pagspergroup")) {
            if (e.getValue() instanceof String) {
                try {
                    RasterLibrary.pagsPerGroup = new Integer((String)e.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (e.getValue() instanceof Integer) {
                RasterLibrary.pagsPerGroup = (Integer)e.getValue();
            }
            return;
        }
        if (e.getKey().equals("cache_blockheight")) {
            if (e.getValue() instanceof String) {
                try {
                    RasterLibrary.blockHeight = new Integer((String)e.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (e.getValue() instanceof Integer) {
                RasterLibrary.blockHeight = (Integer)e.getValue();
            }
            return;
        }
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        this.execute("SELECTIMAGE");
    }

    public void postInitialize() {
        super.postInitialize();
        new ToolboxRasterToolsLoader().registerTool();
    }

    public boolean canQueryByAction() {
        return true;
    }

    public boolean isEnabled(String action) {
        IWindow w;
        ExtensionBuilder ext;
        if (this.getGenericToolBarMenuExtensionPoint() != null && this.getGenericToolBarMenuExtensionPoint().get(action) != null && (ext = this.getGenericToolBarMenuExtensionPoint().get(action).getBuilder()) != null && ext instanceof AbstractTocContextMenuAction && (w = PluginServices.getMDIManager().getActiveWindow()) instanceof AbstractViewPanel) {
            FLayers lyrs = ((AbstractViewPanel)w).getMapControl().getMapContext().getLayers();
            FLayer[] actives = lyrs.getActives();
            return ((AbstractTocContextMenuAction)ext).isEnabled(null, actives);
        }
        return false;
    }

    public boolean isVisible(String action) {
        IWindow w;
        ExtensionBuilder ext;
        if (this.getGenericToolBarMenuExtensionPoint() != null && this.getGenericToolBarMenuExtensionPoint().get(action) != null && (ext = this.getGenericToolBarMenuExtensionPoint().get(action).getBuilder()) != null && ext instanceof AbstractTocContextMenuAction && (w = PluginServices.getMDIManager().getActiveWindow()) instanceof AbstractViewPanel) {
            FLayers lyrs = ((AbstractViewPanel)w).getMapControl().getMapContext().getLayers();
            FLayer[] actives = lyrs.getActives();
            return ((AbstractTocContextMenuAction)ext).isVisible(null, actives);
        }
        return false;
    }

    public ExtensionPoint getGenericToolBarMenuExtensionPoint() {
        if (this.genericToolBarMenuExtensionPoint == null) {
            ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
            this.genericToolBarMenuExtensionPoint = extensionPoints.get("GenericToolBarMenu");
        }
        return this.genericToolBarMenuExtensionPoint;
    }
}

