/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.cresques.cts.IProjection;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.prepareAction.PrepareContextView;
import org.gvsig.app.prepareAction.PrepareContextView_v1;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.toc.actions.LayerErrorsPanel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.coverage.datastruct.Param;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.gui.beans.propertiespanel.PropertiesComponent;
import org.gvsig.gui.beans.propertiespanel.PropertyStruct;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.util.RasterNotLoadException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.identitymanagement.UnauthorizedException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterToolsUtil {
    private static final Logger logger = LoggerFactory.getLogger(RasterToolsUtil.class);

    public static ArrayList<FLayer> getRasterLayerList(FLayers srcLyrs, ArrayList<FLayer> destLyrs) {
        if (destLyrs == null) {
            destLyrs = new ArrayList();
        }
        for (int i = 0; i < srcLyrs.getLayersCount(); ++i) {
            if (srcLyrs.getLayer(i) instanceof DefaultFLyrRaster) {
                destLyrs.add(srcLyrs.getLayer(i));
            }
            if (!(srcLyrs.getLayer(i) instanceof FLayers)) continue;
            destLyrs = RasterToolsUtil.getLayerList((FLayers)srcLyrs.getLayer(i), destLyrs);
        }
        return destLyrs;
    }

    public static ArrayList<FLayer> getLayerList(FLayers srcLyrs, ArrayList<FLayer> destLyrs) {
        if (srcLyrs == null) {
            return null;
        }
        if (destLyrs == null) {
            destLyrs = new ArrayList();
        }
        for (int i = 0; i < srcLyrs.getLayersCount(); ++i) {
            if (srcLyrs.getLayer(i) instanceof FLayers) {
                destLyrs = RasterToolsUtil.getLayerList((FLayers)srcLyrs.getLayer(i), destLyrs);
                continue;
            }
            destLyrs.add(srcLyrs.getLayer(i));
        }
        return destLyrs;
    }

    public static String getView(FLayer layer) {
        Project p = ProjectManager.getInstance().getCurrentProject();
        return p.getViewName(layer);
    }

    public static String getText(Object parent, String text) {
        return PluginServices.getText((Object)parent, (String)text);
    }

    public static ImageIcon getIcon(String ico) {
        return IconThemeHelper.getImageIcon((String)ico);
    }

    public static void addWindow(IWindow window) {
        PluginServices.getMDIManager().addWindow(window);
    }

    public static void closeWindow(IWindow window) {
        PluginServices.getMDIManager().closeWindow(window);
    }

    public static void loadPropertiesFromWriterParams(PropertiesComponent pComp, Params params, String[] notTakeIntoAccount) {
        block5: for (int i = 0; i < params.getNumParams(); ++i) {
            Param p = params.getParam(i);
            String name = RasterToolsUtil.getText(null, p.getId());
            String key = p.getId();
            if (notTakeIntoAccount != null && notTakeIntoAccount.length > 0) {
                boolean jump = false;
                for (int j = 0; j < notTakeIntoAccount.length; ++j) {
                    if (!key.equals(notTakeIntoAccount[j])) continue;
                    jump = true;
                }
                if (jump) continue;
            }
            Object[] types = null;
            int selectedValue = 0;
            switch (p.getType()) {
                case 1: {
                    pComp.addValue(name, key, p.getDefaultValue(), types);
                    continue block5;
                }
                case 2: {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int j = 0; j < p.getList().length; ++j) {
                        list.add(p.getList()[j]);
                        if (!(p.getDefaultValue() instanceof Integer) || (Integer)p.getDefaultValue() != j) continue;
                        selectedValue = j;
                    }
                    types = new Object[]{new Integer(3), list};
                    pComp.addValue(name, key, (Object)new Integer(selectedValue), types);
                    continue block5;
                }
                case 3: {
                    types = new Object[]{new Integer(2), new Integer(p.getList()[0]), new Integer(p.getList()[1])};
                    pComp.addValue(name, key, p.getDefaultValue(), types);
                    continue block5;
                }
                default: {
                    pComp.addValue(RasterToolsUtil.getText(null, params.getParam(i).getId()), params.getParam(i).getId(), params.getParam(i).getDefaultValue(), null);
                }
            }
        }
    }

    public static void loadWriterParamsFromPropertiesPanel(PropertiesComponent pComp, Params params) {
        ArrayList values = pComp.getValues();
        block7: for (int iParam = 0; iParam < params.getNumParams(); ++iParam) {
            Param p = params.getParam(iParam);
            for (int iValue = 0; iValue < values.size(); ++iValue) {
                PropertyStruct prop = (PropertyStruct)values.get(iValue);
                if (p.getId().compareTo(prop.getKey()) != 0) continue;
                switch (p.getType()) {
                    case 1: {
                        p.setDefaultValue((Object)((Boolean)prop.getNewValue()));
                        break;
                    }
                    case 2: {
                        p.setDefaultValue((Object)((Integer)prop.getNewValue()));
                        break;
                    }
                    case 3: {
                        try {
                            p.setDefaultValue((Object)((Integer)prop.getNewValue()));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                continue block7;
            }
        }
    }

    public static boolean canWrite(String path) {
        File f = new File(path);
        if (f.exists() && f.canWrite()) {
            return true;
        }
        JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), Messages.getText((String)"error_writing_raster_file"));
        return false;
    }

    public static void loadLayer(String viewName, String fileName, final String layerName) throws RasterNotLoadException {
        FilesystemServerExplorer explorer;
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        AbstractViewPanel theView = null;
        try {
            IWindow[] allViews = PluginServices.getMDIManager().getAllWindows();
            if (viewName != null) {
                for (int i = 0; i < allViews.length; ++i) {
                    if (!(allViews[i] instanceof AbstractViewPanel) || !((AbstractViewPanel)allViews[i]).getDocument().getName().equals(viewName) && !PluginServices.getMDIManager().getWindowInfo((IWindow)((AbstractViewPanel)allViews[i])).getTitle().equals(viewName)) continue;
                    theView = (AbstractViewPanel)allViews[i];
                }
            } else {
                int i;
                IWindow activeWindow = PluginServices.getMDIManager().getActiveWindow();
                for (i = 0; i < allViews.length; ++i) {
                    if (!(allViews[i] instanceof AbstractViewPanel) || (AbstractViewPanel)allViews[i] != activeWindow) continue;
                    theView = (AbstractViewPanel)allViews[i];
                }
                if (theView == null) {
                    for (i = 0; i < allViews.length; ++i) {
                        if (!(allViews[i] instanceof AbstractViewPanel)) continue;
                        theView = (AbstractViewPanel)allViews[i];
                    }
                }
            }
            if (theView == null) {
                throw new RasterNotLoadException("Imposible cargar la capa.");
            }
        }
        catch (ClassCastException ex) {
            throw new RasterNotLoadException("No se puede hacer un casting de esa IWindow a View.");
        }
        DataManager dm = DALLocator.getDataManager();
        try {
            FilesystemServerExplorerParameters param = (FilesystemServerExplorerParameters)dm.createServerExplorerParameters("FilesystemExplorer");
            explorer = (FilesystemServerExplorer)dm.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)param);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int mode = 4;
        try {
            final DataStoreParameters parameters = explorer.createStoreParameters(file);
            final MapControl mapControl = theView.getMapControl();
            final boolean b_isMapControlAvail = mapControl != null;
            final MapContext mapContext = mapControl.getMapContext();
            final ApplicationManager application = ApplicationLocator.getManager();
            final MapContextManager manager = MapContextLocator.getMapContextManager();
            logger.info("addLayer('{}',...)", (Object)layerName);
            Thread task = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    FLayer layer;
                    block12: {
                        layer = null;
                        FLayer preparedLayer = null;
                        try {
                            DataManager dataManager = DALLocator.getDataManager();
                            DataStore dataStore = dataManager.openStore(parameters.getDataStoreName(), parameters);
                            DataStoreProviderFactory factory = dataStore.getProviderFactory();
                            String name = layerName == null ? dataStore.getName() : layerName;
                            layer = manager.createLayer(name, dataStore);
                            DisposeUtils.disposeQuietly((Disposable)dataStore);
                            preparedLayer = application.prepareOpenLayer(layer, (PrepareContextView)new PrepareContextView_v1(){

                                public Window getOwnerWindow() {
                                    return null;
                                }

                                public MapControl getMapControl() {
                                    return mapControl;
                                }

                                public IProjection getViewProjection() {
                                    return mapContext.getProjection();
                                }

                                public MapContext getMapContext() {
                                    return mapContext;
                                }

                                public boolean isMapControlAvailable() {
                                    return b_isMapControlAvail;
                                }
                            });
                            if (preparedLayer != null) {
                                mapContext.getLayers().addLayer(preparedLayer);
                            }
                            if (preparedLayer == layer) break block12;
                        }
                        catch (UnauthorizedException e) {
                            block13: {
                                I18nManager i18nManager = ToolsLocator.getI18nManager();
                                ApplicationManager application2 = ApplicationLocator.getManager();
                                String resource = "";
                                if (e.getResource() instanceof FilesystemStoreParameters) {
                                    resource = ((FilesystemStoreParameters)e.getResource()).getFile().getPath();
                                }
                                application2.messageDialog(i18nManager.getTranslation("_User_0_is_not_authorized_to_1_on_resource_2_3", new String[]{e.getIdentity().getID(), e.getActionName(), e.getResourceName(), resource}), i18nManager.getTranslation("_Unauthorized_access"), 2);
                                logger.warn("Unauthorized access to layer '" + layerName + "'.", (Throwable)e);
                                if (preparedLayer == layer) break block13;
                                DisposeUtils.disposeQuietly((Disposable)preparedLayer);
                            }
                            DisposeUtils.disposeQuietly((Disposable)layer);
                        }
                        catch (Exception e2) {
                            block14: {
                                LayerErrorsPanel panel = new LayerErrorsPanel(layerName, e2);
                                if (preparedLayer != null) {
                                    panel.setLayer(preparedLayer);
                                } else if (layer != null) {
                                    panel.setLayer(layer);
                                }
                                I18nManager i18nManager = ToolsLocator.getI18nManager();
                                ToolsSwingLocator.getWindowManager().showWindow((JComponent)panel, i18nManager.getTranslation("_Problems_loading_the_layer"), WindowManager.MODE.WINDOW);
                                logger.warn("Can't load layer '" + layerName + "'.", (Throwable)e2);
                                if (preparedLayer == layer) break block14;
                                {
                                    catch (Throwable throwable) {
                                        if (preparedLayer != layer) {
                                            DisposeUtils.disposeQuietly(preparedLayer);
                                        }
                                        DisposeUtils.disposeQuietly(layer);
                                        throw throwable;
                                    }
                                }
                                DisposeUtils.disposeQuietly((Disposable)preparedLayer);
                            }
                            DisposeUtils.disposeQuietly((Disposable)layer);
                        }
                        DisposeUtils.disposeQuietly((Disposable)preparedLayer);
                    }
                    DisposeUtils.disposeQuietly((Disposable)layer);
                }
            });
            task.start();
            return;
        }
        catch (DataException e) {
            throw new RasterNotLoadException("Error al cargar la capa.");
        }
    }

    public static Point iwindowPosition(int widthWindow, int heightWindow) {
        int posWindowX = 0;
        int posWindowY = 0;
        Dimension dim = null;
        Point pos = null;
        if (PluginServices.getMainFrame() instanceof Component) {
            dim = ((Component)PluginServices.getMainFrame()).getSize();
            pos = ((Component)PluginServices.getMainFrame()).getLocation();
            if (dim != null && pos != null) {
                posWindowX = (dim.width >> 1) - (widthWindow >> 1);
                posWindowY = (dim.height >> 1) - (heightWindow >> 1) - 70;
                return new Point(posWindowX, posWindowY);
            }
        }
        return null;
    }
}

