/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.bean.stretchselector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.gvsig.andami.PluginServices;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.gui.beans.datainput.DataInputField;
import org.gvsig.raster.tools.app.basic.raster.bean.stretchselector.StretchSelectorData;
import org.gvsig.raster.util.BasePanel;
import org.gvsig.raster.util.GenericBasePanel;

public class StretchSelectorPanel
extends BasePanel
implements ActionListener,
DataInputContainerListener,
Observer {
    private static final long serialVersionUID = 1638303379491319120L;
    private boolean selectedCount = false;
    private ButtonGroup buttonGroup1 = null;
    private JLabel jLabelMinim = null;
    private JLabel jLabelMaxim = null;
    private BasePanel jPanel1 = null;
    private JRadioButton jRadioIntervalSize = null;
    private JRadioButton jRadioIntervalNumber = null;
    private DataInputField jTextMinim = null;
    private DataInputField jTextMaxim = null;
    private DataInputField jTextValue = null;
    private StretchSelectorData data = null;

    public StretchSelectorPanel() {
        this.init();
        this.translate();
    }

    public StretchSelectorPanel(StretchSelectorData data) {
        this.data = data;
        this.data.addObserver(this);
        this.init();
        this.translate();
    }

    protected void translate() {
        this.jLabelMinim.setText(this.getText(this, "minimo") + ":");
        this.jLabelMaxim.setText(this.getText(this, "maximo") + ":");
        this.getIntervalSize().setText(this.getText(this, "tamano_intervalo"));
        this.getIntervalNumber().setText(this.getText(this, "n_intervalos"));
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        this.jPanel1 = new GenericBasePanel();
        this.jPanel1.setLayout((LayoutManager)new GridBagLayout());
        this.jPanel1.setBorder((Border)BorderFactory.createTitledBorder(""));
        int y = 1;
        this.jLabelMinim = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.jLabelMinim, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add((Component)this.getMinimText(), gridBagConstraints);
        this.jLabelMaxim = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.jLabelMaxim, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add((Component)this.getMaximunText(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 0, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel panel2 = new JPanel();
        panel2.setPreferredSize(new Dimension(0, 0));
        this.add(panel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        this.jPanel1.add((Component)this.getIntervalSize(), (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel1.add((Component)this.getIntervalNumber(), (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.jPanel1.add((Component)this.getIntervalInputField(), (Object)gridBagConstraints);
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup1.add(this.getIntervalSize());
        this.buttonGroup1.add(this.getIntervalNumber());
    }

    public StretchSelectorData getData() {
        if (this.data == null) {
            this.data = new StretchSelectorData();
            this.data.addObserver(this);
        }
        return this.data;
    }

    public void setData(StretchSelectorData data) {
        this.data = data;
        data.addObserver(this);
    }

    private DataInputField getIntervalInputField() {
        if (this.jTextValue == null) {
            this.jTextValue = new DataInputField();
            this.jTextValue.setValue(Double.valueOf(255.0).toString());
            this.jTextValue.addValueChangedListener((DataInputContainerListener)this);
        }
        return this.jTextValue;
    }

    private DataInputField getMinimText() {
        if (this.jTextMinim == null) {
            this.jTextMinim = new DataInputField();
            this.jTextMinim.setValue(Double.valueOf("0").toString());
            this.jTextMinim.addValueChangedListener((DataInputContainerListener)this);
        }
        return this.jTextMinim;
    }

    private DataInputField getMaximunText() {
        if (this.jTextMaxim == null) {
            this.jTextMaxim = new DataInputField();
            this.jTextMaxim.setValue(Double.valueOf("255").toString());
            this.jTextMaxim.addValueChangedListener((DataInputContainerListener)this);
        }
        return this.jTextMaxim;
    }

    public JRadioButton getIntervalSize() {
        if (this.jRadioIntervalSize == null) {
            this.jRadioIntervalSize = new JRadioButton(PluginServices.getText((Object)this, (String)"tamano_intervalo"), true);
            this.jRadioIntervalSize.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jRadioIntervalSize.setMargin(new Insets(0, 0, 0, 0));
            this.jRadioIntervalSize.addActionListener(this);
        }
        return this.jRadioIntervalSize;
    }

    public JRadioButton getIntervalNumber() {
        if (this.jRadioIntervalNumber == null) {
            this.jRadioIntervalNumber = new JRadioButton(PluginServices.getText((Object)this, (String)"n_intervalos"));
            this.jRadioIntervalNumber.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jRadioIntervalNumber.setMargin(new Insets(0, 0, 0, 0));
            this.jRadioIntervalNumber.addActionListener(this);
        }
        return this.jRadioIntervalNumber;
    }

    private void updateData() {
        if (this.getIntervalNumber().isSelected()) {
            if (!this.selectedCount) {
                this.getData().setIntervalSize(this.getIntervalInputField().getValue());
                this.selectedCount = true;
            }
        } else if (this.selectedCount) {
            this.getData().setNumber(this.getIntervalInputField().getValue());
            this.selectedCount = false;
        }
        this.getData().setMin(this.getMinimText().getValue());
        this.getData().setMax(this.getMaximunText().getValue());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnableValueChangedEvent()) {
            return;
        }
        this.updateData();
    }

    public void actionValueChanged(EventObject e) {
        if (!this.isEnableValueChangedEvent()) {
            return;
        }
        this.getInterval();
    }

    public double getInterval() {
        double value;
        this.getData().setMin(this.getMinimText().getValue());
        this.getData().setMax(this.getMaximunText().getValue());
        if (this.getIntervalNumber().isSelected()) {
            this.getData().setNumber(this.getIntervalInputField().getValue());
        } else {
            this.getData().setIntervalSize(this.getIntervalInputField().getValue());
        }
        double value2 = value = Double.parseDouble(this.getIntervalInputField().getValue());
        if (this.getIntervalSize().isSelected()) {
            if (value > Math.abs(this.getData().getMaximum() - this.getData().getMinimum())) {
                value = Math.abs(this.getData().getMaximum() - this.getData().getMinimum());
            }
            if (value <= 0.0) {
                value = 1.0;
            }
        } else if (value < 1.0) {
            value = 1.0;
        }
        if ((value = Math.abs(value)) != value2) {
            if (this.getIntervalNumber().isSelected()) {
                this.getData().setNumber(Double.valueOf(value).toString());
            } else {
                this.getData().setIntervalSize(Double.valueOf(value).toString());
            }
        }
        return value;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(o instanceof StretchSelectorData)) {
            return;
        }
        StretchSelectorData data = (StretchSelectorData)o;
        this.setEnableValueChangedEvent(false);
        if (this.getIntervalNumber().isSelected()) {
            this.getIntervalInputField().setValue(data.getNumber());
        }
        if (this.getIntervalSize().isSelected()) {
            this.getIntervalInputField().setValue(data.getIntervalSize());
        }
        this.getMinimText().setValue(data.getMin());
        this.getMaximunText().setValue(data.getMax());
        this.setEnableValueChangedEvent(true);
    }
}

