/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.gui.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.prepareAction.PrepareContext;
import org.gvsig.app.prepareAction.PrepareDataStoreParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.mainplugin.beans.createlayer.WritableFolderPanel;
import org.gvsig.tools.exception.BaseException;

public class PrepareLayerAskWritableDirectory
implements PrepareDataStoreParameters,
ActionListener {
    private DataStoreParameters newParameters = null;
    private DataStoreParameters oldParameters = null;
    private String selectedPath = null;
    private boolean applyToAllLayers = false;

    public DataStoreParameters prepare(DataStoreParameters storeParameters, PrepareContext context) throws BaseException {
        if (!(storeParameters instanceof RasterDataParameters) || ((RasterDataParameters)storeParameters).isSourceTiled()) {
            return storeParameters;
        }
        this.oldParameters = storeParameters;
        URI uri = ((RasterDataParameters)storeParameters).getURI();
        File file = new File(uri);
        String folder = file.getParent();
        String layerName = file.getName();
        if (StringUtils.isEmpty((CharSequence)folder)) {
            folder = System.getProperty("user.home");
        }
        if (!this.isValidFolder(folder)) {
            if (this.applyToAllLayers) {
                this.setFolderToNewDataParameters(this.selectedPath);
            } else {
                WritableFolderPanel panel = new WritableFolderPanel(folder, (ActionListener)this, layerName);
                this.applyToAllLayers = panel.aplyAllFiles();
            }
        } else {
            return this.oldParameters;
        }
        return this.newParameters;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getID() == 0) {
            this.selectedPath = e.getActionCommand();
        }
        if (e.getID() == 1) {
            if (this.isValidFolder(this.selectedPath)) {
                this.setFolderToNewDataParameters(this.selectedPath);
            } else {
                JOptionPane.showMessageDialog(null, Messages.getText((String)"folder_not_writable"), "", 2);
                this.newParameters = null;
            }
        }
        if (e.getID() == 2) {
            this.newParameters = null;
        }
    }

    private void setFolderToNewDataParameters(String path) {
        this.newParameters = this.oldParameters;
        this.newParameters.setDynValue("rmf_folder", (Object)path);
    }

    private boolean isValidFolder(String folder) {
        File path = new File(folder);
        return path.exists() && path.isDirectory() && path.canWrite();
    }

    public void post(DataStoreParameters storeParameters, PrepareContext context) {
        this.applyToAllLayers = false;
    }

    public void pre(DataStoreParameters storeParameters, PrepareContext context) {
    }

    public void end(Object param) {
    }

    public String getDescription() {
        return "Detects folders with write permission";
    }

    public String getName() {
        return "PrepareLayerAskWritableDirectory";
    }

    public Object create() {
        return this;
    }

    public Object create(Object[] args) {
        return this;
    }

    public Object create(Map args) {
        return this;
    }

    public void interrupted() {
    }
}

