/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.process;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.filter.FilterLoader;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterListManager;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.raster.bean.previewbase.ParamStruct;
import org.gvsig.raster.tools.app.basic.raster.process.ProcessException;
import org.gvsig.raster.tools.app.basic.raster.process.RasterProcess;

public class FilterProcess
extends RasterProcess {
    private String filename = "";
    private RasterDataStore rasterDataSource = null;
    private ArrayList<ParamStruct> listFilterUsed = null;
    private RasterFilterList rasterFilterList = null;
    private RasterWriter geoRasterWriter = null;
    private FLyrRaster lyr = null;
    private RasterManager rManager = RasterLocator.getManager();

    @Override
    public void init() {
        this.filename = this.getStringParam("filename");
        this.listFilterUsed = (ArrayList)this.getParam("listfilterused");
        this.lyr = (FLyrRaster)this.getParam("layer");
        this.rasterDataSource = this.lyr.getDataStore();
    }

    private ColorInterpretation getColorIntepretation(Buffer buffer, RasterFilterList filterList) {
        ColorInterpretation colorInterpretation = null;
        if (filterList.isActive("colortable")) {
            colorInterpretation = this.rManager.getDataStructFactory().createColorInterpretation(new String[]{"Red", "Green", "Blue", "Alpha"});
        } else if (buffer.getBandCount() == this.rasterDataSource.getBandCount()) {
            colorInterpretation = this.rasterDataSource.getColorInterpretation();
        } else {
            String[] colorInterp = new String[this.rasterDataSource.getColorInterpretation().getValues().length];
            for (int i = 0; i < this.rasterDataSource.getColorInterpretation().getValues().length; ++i) {
                colorInterp[i] = this.rasterDataSource.getColorInterpretation().getValues()[i].equals("Undefined") ? "Gray" : this.rasterDataSource.getColorInterpretation().getValues()[i];
            }
            colorInterpretation = this.rManager.getDataStructFactory().createColorInterpretation(colorInterp);
        }
        return colorInterpretation;
    }

    @Override
    public void process() throws ProcessInterruptedException, ProcessException {
        DataServerWriter writerBufferServer = null;
        if (this.lyr != null) {
            this.lyr.setReadingData(Thread.currentThread().getId() + "");
        }
        RasterDataStore dstoreCopy = null;
        RasterQuery query = null;
        Buffer buffer = null;
        Buffer buff = null;
        Object alpha = null;
        try {
            this.insertLineLog(Messages.getText((String)"leyendo_raster"));
            dstoreCopy = this.rasterDataSource.newNotTiledDataStore();
            query = this.rManager.createQuery();
            query.setReadOnly(true);
            int[] renderBands = this.lyr.getRender().getRenderColorInterpretation().buildRenderBands();
            if (renderBands != null) {
                if (renderBands.length == 3 && renderBands[0] == renderBands[1] && renderBands[1] == renderBands[2]) {
                    renderBands = new int[]{renderBands[0]};
                }
                query.setDrawableBands(renderBands);
            } else {
                query.setAllDrawableBands();
            }
            query.setAreaOfInterest();
            buff = dstoreCopy.query(query);
            if (buff.isReadOnlyBuffer()) {
                buff.addDrawableBands(renderBands);
            }
            this.insertLineLog(Messages.getText((String)"aplicando_filtros"));
            Transparency processTransparency = dstoreCopy.getTransparency().cloneTransparency();
            processTransparency.setColorInterpretation(this.lyr.getRender().getRenderColorInterpretation().cloneColorInterpretation());
            List roi = null;
            try {
                IProjection proj = dstoreCopy.getProjection();
                if (proj == null) {
                    proj = this.lyr.getMapContext().getProjection();
                }
                roi = dstoreCopy.getRois(proj);
            }
            catch (ROIException proj) {
                // empty catch block
            }
            this.rasterFilterList = this.rManager.createEmptyFilterList(dstoreCopy.getDataType()[0]);
            FilterLoader filterLoader = RasterLocator.getManager().createFilterLoader(this.rasterFilterList);
            filterLoader.addSrcBandCount(dstoreCopy.getBandCount());
            filterLoader.addSrcDataType(dstoreCopy.getDataType()[0]);
            filterLoader.addSrcStatistics(dstoreCopy.getStatistics());
            filterLoader.addSrcROI(roi);
            filterLoader.addTransparency(processTransparency);
            filterLoader.addSrcHistogram(dstoreCopy.getHistogramComputer());
            this.addSelectedFilters(this.rasterFilterList, this.listFilterUsed);
            buffer = filterLoader.applyFilters(buff);
            this.insertLineLog(Messages.getText((String)"guardando_capa"));
            writerBufferServer = this.rManager.createDataServerWriter();
            writerBufferServer.setBuffer(buffer, -1);
            ColorInterpretation colorInterpretation = this.getColorInterpretation(buffer.getBandCount(), buffer.getDataType());
            this.geoRasterWriter = this.rManager.createWriter(writerBufferServer, this.filename, buffer.getBandCount(), this.rasterDataSource.getAffineTransform(), buffer.getWidth(), buffer.getHeight(), buffer.getDataType(), this.rManager.createWriter(this.filename).getParams(), null);
            if (this.lyr.getRender() == null) {
                colorInterpretation = this.getColorIntepretation(buffer, this.rasterFilterList);
            }
            this.geoRasterWriter.setColorBandsInterpretation(colorInterpretation.getValues());
            this.geoRasterWriter.dataWrite();
            this.geoRasterWriter.writeClose();
            this.geoRasterWriter = null;
            NoData nodataOrigin = this.rasterDataSource.getNoDataValue();
            NoData nodataBuffer = buffer.getNoDataValue();
            if (nodataBuffer != null && nodataBuffer.isDefined()) {
                nodataBuffer.setFileName(this.filename);
                nodataBuffer.save();
            } else if (nodataOrigin != null && nodataOrigin.isDefined()) {
                nodataOrigin.setFileName(this.filename);
                nodataOrigin.save();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (FilterProcess.this.externalActions != null) {
                        FilterProcess.this.externalActions.end(FilterProcess.this.filename);
                    }
                }
            });
        }
        catch (NotSupportedExtensionException e) {
            throw new ProcessException("error_writer_notsupportedextension", e);
        }
        catch (RasterDriverException e) {
            throw new ProcessException("error_writer", e);
        }
        catch (IOException e) {
            throw new ProcessException("error_writer", e);
        }
        catch (FilterTypeException e) {
            throw new ProcessException("error_adding_filters", e);
        }
        catch (QueryException e) {
            throw new ProcessException("error_loading_data", e);
        }
        catch (FilterManagerException e) {
            throw new ProcessException("error_adding_filters", e);
        }
        finally {
            if (writerBufferServer != null) {
                writerBufferServer.dispose();
            }
            if (buff != null) {
                buff.dispose();
            }
            if (this.rasterFilterList != null) {
                this.rasterFilterList.dispose();
            }
            if (alpha != null) {
                alpha.dispose();
            }
            if (dstoreCopy != null) {
                try {
                    dstoreCopy.close();
                }
                catch (CloseException closeException) {}
            }
            if (this.lyr != null) {
                this.lyr.setReadingData(null);
            }
            this.dispose();
        }
    }

    private ColorInterpretation getColorInterpretation(int nBands, int dataType) {
        if (this.lyr.existColorTable()) {
            return this.rManager.getDataStructFactory().createColorInterpretation(new String[]{"Red", "Green", "Blue", "Alpha"});
        }
        if (dataType == 0) {
            if (nBands == 3) {
                return this.rManager.getDataStructFactory().createColorInterpretation(new String[]{"Red", "Green", "Blue"});
            }
            if (nBands == 4) {
                return this.rManager.getDataStructFactory().createColorInterpretation(new String[]{"Red", "Green", "Blue", "Alpha"});
            }
            if (nBands == 2 || nBands > 4) {
                return this.lyr.getRender().getRenderColorInterpretation();
            }
        }
        if (nBands == 1) {
            return this.rManager.getDataStructFactory().createColorInterpretation(new String[]{"Gray"});
        }
        String[] ci = new String[nBands];
        for (int i = 0; i < ci.length; ++i) {
            ci[i] = "Undefined";
        }
        return this.rManager.getDataStructFactory().createColorInterpretation(ci);
    }

    public void addSelectedFilters(RasterFilterList filterList, ArrayList<ParamStruct> listFilterUsed) throws FilterManagerException, FilterTypeException {
        filterList.clear();
        for (int i = 0; i < listFilterUsed.size(); ++i) {
            ParamStruct aux = listFilterUsed.get(i);
            RasterFilterListManager filterManager = filterList.getManagerByFilterClass(aux.getFilterClass());
            filterManager.addFilter(aux.getFilterClass(), aux.getFilterParam());
        }
        filterList.resetPercent();
    }

    public int getPercent() {
        if (this.rasterFilterList == null) {
            return 0;
        }
        if (this.rasterFilterList.getPercent() < 100) {
            return this.rasterFilterList.getPercent();
        }
        if (this.geoRasterWriter == null) {
            return 0;
        }
        return this.geoRasterWriter.getPercent();
    }

    public String getTitle() {
        return Messages.getText((String)"aplicando_filtros");
    }

    @Override
    public void dispose() {
        this.rasterDataSource = null;
        if (this.listFilterUsed != null) {
            this.listFilterUsed.clear();
            this.listFilterUsed = null;
        }
        this.rasterFilterList = null;
        this.geoRasterWriter = null;
        this.lyr = null;
    }

    @Override
    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

