/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.process;

import javax.swing.SwingUtilities;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.raster.process.IProcessActions;
import org.gvsig.raster.tools.app.basic.raster.process.ProcessException;
import org.gvsig.raster.tools.app.basic.raster.process.RasterProcess;

public class StatisticsProcess
extends RasterProcess {
    private FLyrRaster lyr = null;
    private Statistics stats = null;
    private boolean force = false;
    private double scale = 1.0;

    public static void launcher(FLyrRaster lyr, IProcessActions actions) {
        StatisticsProcess process = new StatisticsProcess();
        process.addParam("layer", lyr);
        process.addParam("force", new Boolean(false));
        process.setActions(actions);
        process.start();
    }

    @Override
    public void init() {
        this.lyr = this.getLayerParam("layer");
        this.force = this.getBooleanParam("force");
        double s = this.getDoubleParam("scale");
        if (s > 0.0 && s < 1.0) {
            this.scale = s;
        }
    }

    @Override
    public void process() throws ProcessInterruptedException, ProcessException {
        this.insertLineLog(PluginServices.getText((Object)this, (String)"statistics_generation"));
        if (this.lyr == null || this.lyr.getDataStore() == null) {
            return;
        }
        this.stats = this.lyr.getDataStore().getStatistics();
        this.lyr.setReadingData(Thread.currentThread().getId() + "");
        if (this.force) {
            this.stats.forceToRecalc();
        }
        try {
            this.stats.calculate(this.scale);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (StatisticsProcess.this.externalActions != null) {
                        StatisticsProcess.this.externalActions.end(StatisticsProcess.this.lyr);
                    }
                }
            });
        }
        catch (FileNotOpenException e) {
            throw new ProcessException("No se ha podido escribir en el fichero rmf", e);
        }
        catch (RasterDriverException e) {
            throw new ProcessException("Error leyendo bloques de datos para calcular estad\u00edsticas", e);
        }
        finally {
            this.lyr.setReadingData(null);
        }
    }

    public int getPercent() {
        return this.stats != null ? this.stats.getPercent() : 0;
    }

    public String getTitle() {
        return PluginServices.getText((Object)this, (String)"increase_statistics");
    }
}

