/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.process;

import org.gvsig.raster.tools.app.basic.raster.process.IProcessActions;
import org.gvsig.raster.tools.app.basic.raster.process.RasterProcess;
import org.gvsig.raster.util.Queue;
import org.slf4j.LoggerFactory;

public class UniqueProcessQueue
implements IProcessActions {
    private static final int LAPSE_TIME = 1000;
    private Queue queue = new Queue();
    private RasterProcess executionProcess = null;
    private static UniqueProcessQueue singleton = new UniqueProcessQueue();

    private UniqueProcessQueue() {
    }

    public static UniqueProcessQueue getSingleton() {
        return singleton;
    }

    public synchronized void add(RasterProcess process) {
        this.queue.put((Object)process);
        process.setUniqueProcessActions(this);
        if (this.queue.size() >= 1 && this.executionProcess != null) {
            this.start();
        }
    }

    public void start() {
        this.nextProcess();
    }

    private void nextProcess() {
        this.executionProcess = (RasterProcess)this.queue.get();
        if (this.executionProcess != null) {
            this.executionProcess.start();
        }
    }

    @Override
    public void end(Object param) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(UniqueProcessQueue.class).debug("sleep Exception", (Throwable)e);
        }
        this.nextProcess();
    }

    public int size() {
        return this.queue.size();
    }

    @Override
    public void interrupted() {
    }
}

