/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.analysisview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.MapOverview;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.pixelincrease.PixelIncreaseDialog;

public class ViewRasterAnalysisTocMenuEntry
extends AbstractTocContextMenuAction
implements PropertyChangeListener,
IGenericToolBarMenuItem {
    private boolean onView = false;
    private String rasterNameInLoc = "";
    private static ViewRasterAnalysisTocMenuEntry singleton = null;

    private ViewRasterAnalysisTocMenuEntry() {
    }

    public static ViewRasterAnalysisTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new ViewRasterAnalysisTocMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "RasterLayer";
    }

    public int getGroupOrder() {
        return 10;
    }

    public int getOrder() {
        return 80;
    }

    public String getText() {
        if (!this.onView) {
            return RasterToolsUtil.getText(this, "analysisview");
        }
        return RasterToolsUtil.getText(this, "closeanalysisview");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof ILayerState)) {
            return false;
        }
        return ((ILayerState)selectedItems[0]).isOpen();
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        return selectedItems[0] instanceof FLyrRaster;
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        MapOverview mcCurrentLoc = null;
        ArrayList<MapOverview> mapControlListLoc = new ArrayList<MapOverview>();
        IWindow[] w = PluginServices.getMDIManager().getAllWindows();
        IWindow activeWindow = PluginServices.getMDIManager().getActiveWindow();
        FLayer lyr = selectedItems[0];
        for (int i = 0; i < w.length; ++i) {
            if (w[i] instanceof PixelIncreaseDialog) {
                RasterToolsUtil.closeWindow(w[i]);
            }
            if (w[i] instanceof AbstractViewPanel && w[i].equals(activeWindow)) {
                mcCurrentLoc = ((AbstractViewPanel)w[i]).getMapOverview();
            }
            if (!(w[i] instanceof AbstractViewPanel)) continue;
            mapControlListLoc.add(((AbstractViewPanel)w[i]).getMapOverview());
        }
        if (!this.onView) {
            PixelIncreaseDialog pIncrease = new PixelIncreaseDialog();
            RasterToolsUtil.addWindow(pIncrease);
            mcCurrentLoc.getMapContext().beginAtomicEvent();
            String path = null;
            if (lyr instanceof FLyrRaster) {
                path = new File(((FLyrRaster)lyr).getURI()).getAbsolutePath();
            }
            try {
                File f = new File(path);
                if (!f.exists()) {
                    RasterSwingLibrary.messageBoxError((String)"error_file_not_found", (Object)PluginServices.getMDIManager().getActiveWindow());
                    return;
                }
                lyr = DefaultFLyrRaster.createLayer((String)lyr.getName(), (File)f);
                this.rasterNameInLoc = lyr.getName();
                mcCurrentLoc.getMapContext().getLayers().addLayer(lyr);
            }
            catch (LoadLayerException e) {
                JOptionPane.showMessageDialog(null, RasterToolsUtil.getText(this, "coordenadas_erroneas"));
            }
            mcCurrentLoc.getMapContext().endAtomicEvent();
        } else {
            for (int nViews = 0; nViews < mapControlListLoc.size(); ++nViews) {
                MapControl mc = (MapControl)mapControlListLoc.get(nViews);
                FLayers lyrs = mc.getMapContext().getLayers();
                for (int i = 0; i < lyrs.getLayersCount(); ++i) {
                    if (lyrs.getLayer(i).getName().compareTo(this.rasterNameInLoc) != 0) continue;
                    lyrs.removeLayer(i);
                }
                if (!(mc instanceof MapOverview)) continue;
                ((MapOverview)mc).refreshExtent();
            }
        }
        this.onView = !this.onView;
    }

    public Icon getIcon() {
        return RasterToolsUtil.getIcon("view-raster-analysis");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public boolean isEnableEvents() {
        return true;
    }
}

